/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAOUtils;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AbstractUserType;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgRoPerm;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.UserTypeFactory;
import com.kingdee.eas.base.permission.app.AbstractPermissionControllerBean;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.config.SslUIConfiguration;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.base.permission.app.service.DelPermissionAfterDelOrg;
import com.kingdee.eas.base.permission.app.service.FieldPermissionService;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.base.permission.util.TimeCostUtil;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PermissionControllerBean
extends AbstractPermissionControllerBean {
    private static Logger logger = Logger.getLogger(PermissionControllerBean.class);

    @Override
    protected boolean _hasFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, permItemName});
        Boolean obj = (Boolean)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_hasFunctionPermission, key: " + key + ", hit: true");
            return obj;
        }
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        obj = service.hasPermission(userPK, orgPK, permItemName, true);
        if (obj.booleanValue() && orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, obj);
        }
        info.debug("_hasFunctionPermission, key: " + key + ", hit: false");
        return obj;
    }

    @Override
    protected boolean _hasFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, uiPK, actionPK});
        Boolean obj = (Boolean)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_hasFunctionPermission, key: " + key + ", hit: true");
            return obj;
        }
        obj = this.hasFunctionPermission(ctx, userPK, orgPK, uiPK, actionPK, true);
        if (obj.booleanValue() && orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, obj);
        }
        info.debug("_hasFunctionPermission, key: " + key + ", hit: false");
        return obj;
    }

    @Override
    protected boolean[] _hasFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK[] uiPKs, IMetaDataPK[] actionPKs) throws BOSException, EASBizException {
        return this._hasFunctionPermission_new(ctx, userPK, orgPK, uiPKs, actionPKs);
    }

    private boolean[] _hasFunctionPermission_new(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK[] uiPKs, IMetaDataPK[] actionPKs) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, CacheUtil.array2Str(uiPKs), actionPKs, "batch"});
        boolean[] obj = (boolean[])CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_hasFunctionPermission, key: " + key + ", hit: true");
            return obj;
        }
        boolean[] retValue = null;
        HashMap<Integer, String> permItemNames = new HashMap<Integer, String>();
        Map retPermItemMap = new HashMap();
        int lengOfArray = uiPKs.length;
        if (lengOfArray == actionPKs.length) {
            IServiceManager manager = ServiceManagerFactory.getServiceManager();
            IServiceBinder binder = manager.getServiceBinder(ctx);
            retValue = new boolean[lengOfArray];
            block0: for (int i = 0; i < lengOfArray; ++i) {
                ServiceBindItem[] bind;
                retValue[i] = true;
                IMetaDataPK uiPK = uiPKs[i];
                IMetaDataPK actionPK = actionPKs[i];
                if (uiPK == null || actionPK == null || (bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK)) == null) continue;
                int len = bind.length;
                for (int j = 0; j < len; ++j) {
                    if (bind[j].getType() != 0 || StringUtils.isEmpty((String)bind[j].getName())) continue;
                    permItemNames.put(new Integer(i), bind[j].getName());
                    continue block0;
                }
            }
            if (permItemNames != null && permItemNames.size() > 0) {
                FunctionPermissionService service = new FunctionPermissionService(ctx);
                retPermItemMap = service.hasBatchPermission(userPK, orgPK, permItemNames, true);
            }
        } else {
            logger.info((Object)" ui's length does not match action's length when invoking a batch of function permission!");
        }
        Set permIndexSet = retPermItemMap.keySet();
        for (Integer index : permIndexSet) {
            Boolean ret = (Boolean)retPermItemMap.get(index);
            retValue[index.intValue()] = ret;
        }
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, retValue);
        }
        info.debug("_hasFunctionPermission, key: " + key + ", hit: false");
        return retValue;
    }

    @Override
    protected boolean _isBindPermission(Context ctx, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        if (uiPK == null || actionPK == null) {
            return false;
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        return bind != null && bind.length > 0;
    }

    private boolean hasFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, boolean orgExtFromCtx) throws BOSException, EASBizException {
        if (uiPK == null || actionPK == null) {
            return true;
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName()) || service.hasPermission(userPK, orgPK, permItemName = bind[i].getName(), true)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean _hasDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName, IObjectPK bizDataPK) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.data";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, permItemName, bizDataPK});
        Boolean obj = (Boolean)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_hasDataPermission, key: " + key + ", hit: true");
            return obj;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        if (isEnableDataPermission) {
            DataPermissionService service = new DataPermissionService(ctx);
            obj = service.hasPermission(userPK, orgPK, permItemName, bizDataPK);
        } else {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            obj = service.hasPermission(userPK, orgPK, permItemName, true);
        }
        if (bizDataPK != null && obj.booleanValue() && orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, obj);
        }
        info.debug("_hasDataPermission, key: " + key + ", hit: false");
        return obj;
    }

    @Override
    protected boolean _hasDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, IObjectPK bizDataPK) throws BOSException, EASBizException {
        if (uiPK == null || actionPK == null) {
            return true;
        }
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.data";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, uiPK, actionPK, bizDataPK});
        Boolean obj = (Boolean)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_hasDataPermission, key: " + key + ", hit: true");
            return obj;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                Object service;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                String permItemName = bind[i].getName();
                boolean flag = false;
                if (isEnableDataPermission) {
                    service = new DataPermissionService(ctx);
                    flag = service.hasPermission(userPK, orgPK, permItemName, bizDataPK);
                } else {
                    service = new FunctionPermissionService(ctx);
                    flag = service.hasPermission(userPK, orgPK, permItemName, true);
                }
                if (flag) continue;
                return false;
            }
        }
        obj = true;
        if (bizDataPK != null && orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, obj);
        }
        info.debug("_hasDataPermission, key: " + key + ", hit: false");
        return obj;
    }

    @Override
    protected boolean _hasDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName, IObjectValue bizData) throws BOSException, EASBizException {
        String key;
        Boolean obj;
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.data";
        Object objId = null;
        if (bizData != null) {
            objId = bizData.get("id");
        }
        if ((obj = (Boolean)CacheUtil.getCacheValue(cacheType, key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, permItemName, objId}))) != null) {
            info.debug("_hasDataPermission, key: " + key + ", hit: true");
            return obj;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        if (isEnableDataPermission) {
            DataPermissionService service = new DataPermissionService(ctx);
            obj = service.hasPermission(userPK, orgPK, permItemName, bizData);
        } else {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            obj = service.hasPermission(userPK, orgPK, permItemName, true);
        }
        if (objId != null && obj.booleanValue() && orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, obj);
        }
        info.debug("_hasDataPermission, key: " + key + ", hit: false");
        return obj;
    }

    @Override
    protected boolean _hasDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, IObjectValue bizData) throws BOSException, EASBizException {
        String key;
        Boolean obj;
        if (uiPK == null || actionPK == null) {
            return true;
        }
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.data";
        Object objId = null;
        if (bizData != null) {
            objId = bizData.get("id");
        }
        if ((obj = (Boolean)CacheUtil.getCacheValue(cacheType, key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, uiPK, actionPK, objId}))) != null) {
            info.debug("_hasDataPermission, key: " + key + ", hit: true");
            return obj;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                Object service;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                String permItemName = bind[i].getName();
                boolean flag = false;
                if (isEnableDataPermission) {
                    service = new DataPermissionService(ctx);
                    flag = service.hasPermission(userPK, orgPK, permItemName, bizData);
                } else {
                    service = new FunctionPermissionService(ctx);
                    flag = service.hasPermission(userPK, orgPK, permItemName, true);
                }
                if (flag) continue;
                return false;
            }
        }
        obj = true;
        if (objId != null && orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, obj);
        }
        info.debug("_hasDataPermission, key: " + key + ", hit: false");
        return obj;
    }

    @Override
    protected void _checkFunctionPermission(Context ctx, IObjectPK userPK, OrgType orgType, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        service.checkPermission(userPK, orgPK, permItemName, true);
    }

    @Override
    protected void _checkFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, permItemName});
        Object obj = CacheUtil.getCacheValue(cacheType, key);
        if (obj != null && Boolean.parseBoolean(obj.toString())) {
            info.debug("_checkFunctionPermission, key: " + key + ", hit: true");
            return;
        }
        if (obj != null && !Boolean.parseBoolean(obj.toString())) {
            UserInfo user = UserFactory.getLocalInstance(ctx).getUserByID(userPK);
            String userName = user != null ? user.getNumber() : "";
            PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(ctx).getPermItem(ctx, permItemName);
            if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
                Object[] object = new Object[]{userName, permItemInfo.getAlias()};
                throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION_2, object);
            }
            IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK(ctx, permItemInfo.getOrgRelation(), orgPK, null, true);
            if (permissionOrgPK == null) {
                Object[] object = new Object[]{userName, permItemInfo.getAlias()};
                throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION_2, object);
            }
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(permissionOrgPK);
            Object[] object = new Object[]{userName, fullOrgUnitInfo.getName(), permItemInfo.getAlias()};
            throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION_2, object);
        }
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        service.checkPermission(userPK, orgPK, permItemName, true);
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, true);
        }
        info.debug("_checkFunctionPermission, key: " + key + ", hit: false");
    }

    @Override
    protected void _checkFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, uiPK, actionPK});
        Object obj = CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_checkFunctionPermission, key: " + key + ", hit: true");
            return;
        }
        this.checkFunctionPermission(ctx, userPK, orgPK, uiPK, actionPK, true);
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, true);
        }
        info.debug("_checkFunctionPermission, key: " + key + ", hit: false");
    }

    private void checkFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, boolean orgExtFromCtx) throws BOSException, EASBizException {
        if (uiPK == null || actionPK == null) {
            return;
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        this.checkBindPerm(ctx, userPK, orgPK, orgExtFromCtx, bind);
        ServiceBindItem[] webBind = binder.getServiceBindings(MetaDataTypeList.WEBUIOBJECT, uiPK, actionPK);
        this.checkBindPerm(ctx, userPK, orgPK, orgExtFromCtx, webBind);
        ServiceBindItem[] webBind1 = binder.getServiceBindings(MetaDataTypeList.WEBPAGEOBJECT, uiPK, actionPK);
        this.checkBindPerm(ctx, userPK, orgPK, orgExtFromCtx, webBind1);
    }

    private void checkBindPerm(Context ctx, IObjectPK userPK, IObjectPK orgPK, boolean orgExtFromCtx, ServiceBindItem[] bind) throws BOSException, EASBizException {
        if (bind != null) {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                String permItemName = bind[i].getName();
                service.checkPermission(userPK, orgPK, permItemName, orgExtFromCtx);
            }
        }
    }

    @Override
    protected void _checkDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, IObjectPK dataPK) throws BOSException, EASBizException {
        if (uiPK == null || actionPK == null) {
            return;
        }
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.data";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, uiPK, actionPK, dataPK});
        Object obj = CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_checkDataPermission, key: " + key + ", hit: true");
            return;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                Object service;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                String permItemName = bind[i].getName();
                if (isEnableDataPermission) {
                    service = new DataPermissionService(ctx);
                    service.checkPermission(userPK, orgPK, permItemName, dataPK);
                    continue;
                }
                service = new FunctionPermissionService(ctx);
                service.checkPermission(userPK, orgPK, permItemName, true);
            }
        }
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, true);
        }
        info.debug("_checkDataPermission, key: " + key + ", hit: false");
    }

    @Override
    protected void _checkDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, IObjectValue dataValue) throws BOSException, EASBizException {
        String key;
        Object obj;
        TimeCostUtil info = new TimeCostUtil(logger);
        if (uiPK == null || actionPK == null) {
            return;
        }
        String cacheType = "permission.data";
        Object objId = null;
        if (dataValue != null) {
            objId = dataValue.get("id");
        }
        if ((obj = CacheUtil.getCacheValue(cacheType, key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, uiPK, actionPK, objId}))) != null) {
            info.debug("_checkDataPermission, key: " + key + ", hit: true");
            return;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                Object service;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                String permItemName = bind[i].getName();
                if (isEnableDataPermission) {
                    service = new DataPermissionService(ctx);
                    service.checkPermission(userPK, orgPK, permItemName, dataValue);
                    continue;
                }
                service = new FunctionPermissionService(ctx);
                service.checkPermission(userPK, orgPK, permItemName, true);
            }
        }
        if (objId != null && orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, true);
        }
        info.debug("_checkDataPermission, key: " + key + ", hit: false");
    }

    @Override
    protected void _checkDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName, IObjectPK dataPK) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.data";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, permItemName, dataPK});
        Object obj = CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_checkDataPermission, key: " + key + ", hit: true");
            return;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        if (isEnableDataPermission) {
            DataPermissionService service = new DataPermissionService(ctx);
            service.checkPermission(userPK, orgPK, permItemName, dataPK);
        } else {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            service.checkPermission(userPK, orgPK, permItemName, true);
        }
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, true);
        }
        info.debug("_checkDataPermission, key: " + key + ", hit: false");
    }

    @Override
    protected void _checkDataPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName, IObjectValue dataValue) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        Object objId = null;
        String cacheType = "permission.data";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, permItemName, objId});
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        if (isEnableDataPermission) {
            DataPermissionService service = new DataPermissionService(ctx);
            service.checkPermission(userPK, orgPK, permItemName, dataValue);
        } else {
            Object obj;
            if (dataValue != null) {
                objId = dataValue.get("id");
            }
            if ((obj = CacheUtil.getCacheValue(cacheType, key)) != null) {
                info.debug("_checkDataPermission, key: " + key + ", hit: true");
                return;
            }
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            service.checkPermission(userPK, orgPK, permItemName, true);
        }
        if (objId != null && orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, true);
        }
        info.debug("_checkDataPermission, key: " + key + ", hit: false");
    }

    @Override
    protected String _getQueryPermissionSQL(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        DataPermissionService service = new DataPermissionService(ctx);
        return service.getQueryPermissionSQL(userPK, orgPK, permItemName);
    }

    @Override
    protected String _getPermissionWhereSQL(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName, String idFiledAlias) throws BOSException, EASBizException {
        DataPermissionService service = new DataPermissionService(ctx);
        return service.getPermissionWhereSQL(userPK, orgPK, permItemName, idFiledAlias);
    }

    @Override
    protected String _transformOQLToSQL(Context ctx, BOSObjectType bosObjectType, String oql) throws BOSException, EASBizException {
        try {
            return ORMappingDAOUtils.getSQLByOQL((BOSObjectType)bosObjectType, (String)oql, (Context)ctx);
        }
        catch (Exception e) {
            logger.error((Object)("oql:" + oql));
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
    }

    @Override
    protected Map _getAuthorizedOrgs(Context ctx, IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        FullOrgUnitCollection collection = this._getAuthorizedOrgOfCU(ctx, ctrlUnitPK, userPK, orgType, null, uiPK, actionPK);
        return this.transformToMap(collection);
    }

    @Override
    protected Map _getAuthorizedOrgs(Context ctx, IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        FullOrgUnitCollection collection = this._getAuthorizedOrgOfCU(ctx, ctrlUnitPK, userPK, orgType, orgTreePK, uiPK, actionPK);
        return this.transformToMap(collection);
    }

    @Override
    protected Map _getOrgsOfIncludeSubCU(Context ctx, IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        FullOrgUnitCollection collection = this._getAuthorizedOrgOfIncludeSubCU(ctx, ctrlUnitPK, userPK, orgType, null, uiPK, actionPK);
        return this.transformToMap(collection);
    }

    @Override
    protected Map _getAuthorizedOrgs(Context context, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        FullOrgUnitCollection collection = this.getAuthorizedOrgIds(context, userPK, orgType, orgTreePK, uiPK, actionPK);
        return this.transformToMap(collection);
    }

    private FullOrgUnitCollection getAuthorizedOrgIds(Context context, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrgIds(userPK, orgType, orgTreePK);
        }
        if (uiPK == null || actionPK == null) {
            return service.getOrgRangeIds(userPK, orgType, orgTreePK);
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
                if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
                    if (this.hasFunctionPermission(context, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                        return service.getOrgRangeIds(userPK, orgType, orgTreePK);
                    }
                    return new FullOrgUnitCollection();
                }
                return service.getAuthorizedOrgIds(userPK, orgTreePK, permItemName);
            }
        }
        return service.getOrgRangeIds(userPK, orgType, orgTreePK);
    }

    @Override
    protected FullOrgUnitCollection _getAuthorizedOrg(Context context, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrg(userPK, orgType, orgTreePK);
        }
        if (uiPK == null || actionPK == null) {
            return service.getOrgRange(userPK, orgType, orgTreePK);
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
                if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
                    if (this.hasFunctionPermission(context, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                        return service.getOrgRange(userPK, orgType, orgTreePK);
                    }
                    return new FullOrgUnitCollection();
                }
                return service.getAuthorizedOrg(userPK, orgTreePK, permItemName);
            }
        }
        return service.getOrgRange(userPK, orgType, orgTreePK);
    }

    @Override
    protected FullOrgUnitCollection _getAuthorizedOrg(Context context, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrg(userPK, orgType, orgTreePK);
        }
        if (StringUtils.isEmpty((String)permItemName)) {
            return service.getOrgRange(userPK, orgType, orgTreePK);
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
        if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            if (this.hasFunctionPermission(context, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                return service.getOrgRange(userPK, orgType, orgTreePK);
            }
            return new FullOrgUnitCollection();
        }
        return service.getAuthorizedOrg(userPK, orgTreePK, permItemName);
    }

    @Override
    protected Map _getAuthorizedOrg(Context context, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName, Set orgIds) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        HashMap result = new HashMap();
        if (orgIds.isEmpty()) {
            return result;
        }
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrg(userPK, orgType, orgTreePK, orgIds);
        }
        if (StringUtils.isEmpty((String)permItemName)) {
            return service.getOrgRange(userPK, orgType, orgTreePK, orgIds);
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
        if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            if (this.hasFunctionPermission(context, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                return service.getOrgRange(userPK, orgType, orgTreePK, orgIds);
            }
            return result;
        }
        return service.getAuthorizedOrg(userPK, orgTreePK, permItemName, orgIds);
    }

    protected Set _getAuthorizedOrgWithNoDetails(Context context, IObjectPK userPK, OrgType orgType, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null);
        OrgPermissionService service = new OrgPermissionService(context);
        return service.getAuthorizedOrgWithNoDetails(userPK, orgType, permItemName);
    }

    @Override
    protected FullOrgUnitCollection _getAuthorizedOrgOfCU(Context context, IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null);
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrgOfCU(ctrlUnitPK, orgType, orgTreePK);
        }
        if (uiPK == null || actionPK == null) {
            return service.getOrgRangeOfCU(ctrlUnitPK, userPK, orgType, orgTreePK);
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
                if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
                    if (this.hasFunctionPermission(context, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                        return service.getOrgRangeOfCU(ctrlUnitPK, userPK, orgType, orgTreePK);
                    }
                    return new FullOrgUnitCollection();
                }
                return service.getAuthorizedOrgOfCU(ctrlUnitPK, userPK, orgTreePK, permItemName);
            }
        }
        return service.getOrgRangeOfCU(ctrlUnitPK, userPK, orgType, orgTreePK);
    }

    @Override
    protected FullOrgUnitCollection _getAuthorizedOrgOfCU(Context context, IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null);
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrgOfCU(ctrlUnitPK, orgType, orgTreePK);
        }
        if (StringUtils.isEmpty((String)permItemName)) {
            return service.getOrgRangeOfCU(ctrlUnitPK, userPK, orgType, orgTreePK);
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
        if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            if (this.hasFunctionPermission(context, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                return service.getOrgRangeOfCU(ctrlUnitPK, userPK, orgType, orgTreePK);
            }
            return new FullOrgUnitCollection();
        }
        return service.getAuthorizedOrgOfCU(ctrlUnitPK, userPK, orgTreePK, permItemName);
    }

    @Override
    protected FullOrgUnitCollection _getAuthorizedOrgOfIncludeSubCU(Context context, IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null);
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrgOfIncludeSubCU(ctrlUnitPK, orgType, orgTreePK);
        }
        if (uiPK == null || actionPK == null) {
            return service.getOrgRangeOfIncludeSubCU(ctrlUnitPK, userPK, orgType, orgTreePK);
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
                if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
                    if (this.hasFunctionPermission(context, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                        return service.getOrgRangeOfIncludeSubCU(ctrlUnitPK, userPK, orgType, orgTreePK);
                    }
                    return new FullOrgUnitCollection();
                }
                return service.getAuthorizedOrgOfIncludeSubCU(ctrlUnitPK, userPK, orgTreePK, permItemName);
            }
        }
        return service.getOrgRangeOfIncludeSubCU(ctrlUnitPK, userPK, orgType, orgTreePK);
    }

    @Override
    protected FullOrgUnitCollection _getAuthorizedOrgOfIncludeSubCU(Context context, IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null);
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(context);
        if (Administrator.isAdmin(context, userPK)) {
            return service.getAdminOrgOfIncludeSubCU(ctrlUnitPK, orgType, orgTreePK);
        }
        if (StringUtils.isEmpty((String)permItemName)) {
            return service.getOrgRangeOfIncludeSubCU(ctrlUnitPK, userPK, orgType, orgTreePK);
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(context).getPermItem(context, permItemName);
        if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            if (this.hasFunctionPermission(context, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                return service.getOrgRangeOfIncludeSubCU(ctrlUnitPK, userPK, orgType, orgTreePK);
            }
            return new FullOrgUnitCollection();
        }
        return service.getAuthorizedOrgOfIncludeSubCU(ctrlUnitPK, userPK, orgTreePK, permItemName);
    }

    @Override
    protected Collection _getAuthorizedUsers(Context ctx, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        return service.getAuthorizedUsers(orgPK, permItemName);
    }

    @Override
    protected void _syncPermItems(Context ctx) throws BOSException, EASBizException {
        IPermItem iPermItem = PermItemFactory.getLocalInstance(ctx);
        iPermItem.syncPermItems();
    }

    @Override
    protected FullOrgUnitCollection _getOrgRanges(Context context, IObjectPK userPK) throws BOSException, EASBizException {
        assert (userPK != null);
        long startTime = System.currentTimeMillis();
        FullOrgUnitCollection collection = null;
        collection = OrgSwitchFacadeFactory.getLocalInstance((Context)context).getOrgRanges(userPK);
        if (collection == null) {
            collection = new FullOrgUnitCollection();
        }
        if (Administrator.isSuperAdmin(userPK) && collection.isEmpty()) {
            return this.initAdministratorOrgRange(context, userPK);
        }
        return collection;
    }

    private FullOrgUnitCollection initAdministratorOrgRange(Context context, IObjectPK userPK) throws EASBizException, BOSException {
        FullOrgUnitCollection fullOrgCol = new FullOrgUnitCollection();
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)context);
        CtrlUnitCollection ctrlUnitCol = iCtrlUnit.getCtrlUnitCollection();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userPK.toString()));
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance(context);
        if (ctrlUnitCol != null && !ctrlUnitCol.isEmpty()) {
            OrgRangeCollection orgRangeCol = new OrgRangeCollection();
            int size = ctrlUnitCol.size();
            for (int i = 0; i < size; ++i) {
                CtrlUnitInfo ctrlInfo = ctrlUnitCol.get(i);
                OrgRangeInfo orgRangeInfo = new OrgRangeInfo();
                FullOrgUnitInfo fullOrgInfo = ctrlInfo.castToFullOrgUnitInfo();
                orgRangeInfo.setOrg(fullOrgInfo);
                orgRangeInfo.setUser(userInfo);
                orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
                if (fullOrgInfo == null || fullOrgInfo.getId() == null || fullOrgInfo.getId().toString().equals("11111111-1111-1111-1111-111111111111CCE7AED4")) continue;
                orgRangeCol.add(orgRangeInfo);
                fullOrgCol.add(fullOrgInfo);
            }
            iOrgRange.addNewCol(orgRangeCol);
        }
        return fullOrgCol;
    }

    @Override
    protected void _syncUserRealName(Context ctx, UserType userType, IObjectPK objectPK) throws BOSException, EASBizException {
        assert (userType != null && objectPK != null);
        AbstractUserType iUserType = UserTypeFactory.getUserType(userType);
        String field = iUserType.getField();
        DataBaseInfo dataBaseInfo = (DataBaseInfo)iUserType.getData(ctx, objectPK);
        Locale[] locales = MultiLangHelper.getDefinedLocales(ctx);
        int length = locales.length;
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("UPDATE T_PM_User SET ");
        Object[] params = new Object[length + 1];
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                buffer.append(MultiLangHelper.getFieldName("FName", locales[i])).append(" = ? ");
            } else {
                buffer.append(MultiLangHelper.getFieldName("FName", locales[i])).append(" = ?, ");
            }
            params[i] = StringUtils.isEmpty((String)dataBaseInfo.getName(locales[i])) ? "" : dataBaseInfo.getName(locales[i]);
        }
        params[length] = objectPK.toString();
        buffer.append(" WHERE ").append(field).append(" = ? ");
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])params);
    }

    @Override
    protected Set _getFunctionPermissions(Context ctx) throws BOSException, EASBizException {
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        return service.getPermissions();
    }

    @Override
    protected RoleCollection _getRoles(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance(ctx);
        return iUserRoleOrgManager.getRoles(userPK, orgPK);
    }

    @Override
    protected void _updatePassword(Context ctx, String number, String oldPW, String newPW) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserInfo userInfo = iUser.getUser(number);
        if (userInfo == null) {
            throw new UserException(UserException.USER_NOT_EXIST);
        }
        oldPW = PermissionUtil.decrypt(userInfo.getNumber(), oldPW);
        newPW = PermissionUtil.decrypt(userInfo.getNumber(), newPW);
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            if (!PermissionUtil.matchPassword(userInfo, oldPW)) {
                throw new UserException(UserException.PASSWORD_NOT_MATCH);
            }
        } else {
            if (userInfo.isIsLocked()) {
                throw new UserException(UserException.UPDATE_PASSWORD_LATER);
            }
            if (PermissionUtil.matchPassword(userInfo, oldPW)) {
                userInfo.setPassword(newPW);
                SecurityValidator securityValidator = new SecurityValidator(ctx, userInfo);
                securityValidator.validate();
                if (StringUtils.isEmpty((String)newPW)) {
                    userInfo.setPassword(null);
                } else {
                    PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
                    userInfo.setPassword(PermissionUtil.encrypt(userInfo.getId().toString(), newPW, passwordType));
                    userInfo.setPasswordType(passwordType);
                }
                userInfo.setChangedPW(true);
                iUser.update((IObjectPK)new ObjectUuidPK(userInfo.getId()), (CoreBaseInfo)userInfo);
            } else {
                this.handleAfterUpdatePasswordFail(ctx, userInfo);
                throw new UserException(UserException.PASSWORD_NOT_MATCH);
            }
        }
    }

    private void handleAfterUpdatePasswordFail(Context ctx, UserInfo userInfo) throws BOSException {
        if (userInfo.getSecurity().isNeedLocked()) {
            if (userInfo.getSecurity().getLockCount() <= userInfo.getErrCount() + 1) {
                Object[] params = new Object[]{userInfo.getId().toString()};
                String sql = "UPDATE T_PM_User SET FLockedTime = now(), FIsLocked = 1, FErrCount =  FErrCount + 1 WHERE FID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            } else {
                Object[] params = new Object[]{userInfo.getId().toString()};
                String sql = "UPDATE T_PM_User SET FErrCount = FErrCount + 1 WHERE FID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            }
        }
    }

    @Override
    protected UserInfo _getUserInfo(Context ctx, String number) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        return iUser.getUser(number);
    }

    @Override
    protected void _removeUsers(Context ctx, IObjectPK[] userPKs) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        iUser.delete(userPKs);
    }

    private Map transformToMap(FullOrgUnitCollection collection) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            result.put(collection.get(i).getId().toString(), Boolean.FALSE);
        }
        return result;
    }

    @Override
    protected UserCollection _getUsers(Context ctx, IObjectPK orgPK, IObjectPK rolePK) throws BOSException, EASBizException {
        IUserRoleOrgManager manager = UserRoleOrgManagerFactory.getLocalInstance(ctx);
        return manager.getUsers(orgPK, rolePK);
    }

    @Override
    protected boolean _isRequireChangePassword(Context ctx, String userNumber, String password) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserInfo userInfo = iUser.getUser(userNumber);
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return false;
        }
        userInfo.setPassword(password);
        SecurityValidator validator = new SecurityValidator(ctx, userInfo);
        return validator.isRequireChangePassword();
    }

    @Override
    protected FieldPermission _getFieldPermission(Context ctx, BOSObjectType bizObjectType, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.field";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{bizObjectType, userPK, orgPK});
        FieldPermission obj = (FieldPermission)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_getFieldPermission, key: " + key + ", hit: true");
            return obj;
        }
        FieldPermissionService service = new FieldPermissionService(ctx);
        FieldPermission ret = service.getFieldPermission(bizObjectType, userPK, orgPK);
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, ret);
        }
        info.debug("_getFieldPermission, key: " + key + ", hit: false");
        return ret;
    }

    @Override
    protected FieldPermission _getQueryFieldPermission(Context ctx, IMetaDataPK queryPK, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.field";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{queryPK, userPK, orgPK});
        FieldPermission obj = (FieldPermission)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_getQueryFieldPermission, key: " + key + ", hit: true");
            return obj;
        }
        FieldPermissionService service = new FieldPermissionService(ctx);
        FieldPermission ret = service.getQueryFieldPermission(queryPK, userPK, orgPK);
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, ret);
        }
        info.debug("_getQueryFieldPermission, key: " + key + ", hit: false");
        return ret;
    }

    @Override
    protected Map _getQueryFieldPermission(Context ctx, IMetaDataPK queryPK, IObjectPK userPK, List orgIdStrList) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.field";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{queryPK, userPK, orgIdStrList});
        HashMap obj = (HashMap)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_getQueryFieldPermission, key: " + key + ", hit: true");
            return obj;
        }
        Map retMap = new HashMap();
        LowTimeHelper timeHelper = new LowTimeHelper();
        FieldPermissionService service = new FieldPermissionService(ctx);
        retMap = service.getQueryFieldPermission(queryPK, userPK, orgIdStrList);
        timeHelper.printTime2Last("allgetfieldpermissionbatchtime$$$$$$$$$$$$$$$$$$$$");
        if (orgIdStrList != null && !orgIdStrList.isEmpty()) {
            CacheUtil.putCacheValue(cacheType, key, retMap);
        }
        info.debug("_getQueryFieldPermission, key: " + key + ", hit: false");
        return retMap;
    }

    @Override
    protected ConfigurationInfo _getConfigurationInfo(Context ctx) throws BOSException {
        return ConfigurationLoader.getInstance().getConfigurationInfo();
    }

    @Override
    protected FullOrgUnitCollection _getAuthorizedOrg(Context ctx, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName, EntityViewInfo orgStructureView) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null);
        OrgPermissionService service = new OrgPermissionService(ctx);
        return service.getAuthorizedOrg(userPK, orgType, orgTreePK, permItemName, orgStructureView);
    }

    @Override
    protected OrgTreeCollection _getAllUnionTrees(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        OrgPermissionService orgPermissionService = new OrgPermissionService(ctx);
        return orgPermissionService.getUnionTree(userPK);
    }

    @Override
    protected OrgTreeCollection _getAllUnionTrees(Context ctx, IObjectPK userPK, Timestamp datePoint) throws BOSException, EASBizException {
        OrgPermissionService orgPermissionService = new OrgPermissionService(ctx);
        return orgPermissionService.getUnionTree(userPK, datePoint);
    }

    @Override
    protected Map _getUnionUnits(Context ctx, IObjectPK userPK, IObjectPK orgTreePK) throws BOSException, EASBizException {
        OrgPermissionService service = new OrgPermissionService(ctx);
        FullOrgUnitCollection collection = service.getUnionUnitOfTree(userPK, orgTreePK);
        return this.transformToMap(collection);
    }

    @Override
    protected Map _getUnionUnits(Context ctx, IObjectPK userPK, IObjectPK orgTreePK, Timestamp datePoint) throws BOSException, EASBizException {
        OrgPermissionService orgPermissionService = new OrgPermissionService(ctx);
        FullOrgUnitCollection collection = orgPermissionService.getUnionUnitOfTree(userPK, orgTreePK, datePoint);
        return this.transformToMap(collection);
    }

    @Override
    protected Map _getSSLConfiguration(Context ctx) throws BOSException {
        return SslUIConfiguration.getInstance().getSSLConfig();
    }

    @Override
    protected boolean _hasFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, String permItemName, boolean orgExtFromCtx) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, uiPK, actionPK, permItemName, orgExtFromCtx});
        Boolean obj = (Boolean)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_hasFunctionPermission, key: " + key + ", hit: true");
            return obj;
        }
        if (!StringUtils.isEmpty((String)permItemName)) {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            obj = service.hasPermission(userPK, orgPK, permItemName, orgExtFromCtx);
            if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
                CacheUtil.putCacheValue(cacheType, key, obj);
            }
            info.debug("_hasFunctionPermission, key: " + key + ", hit: false");
            return obj;
        }
        if (uiPK != null) {
            if (uiPK == null || actionPK == null) {
                obj = false;
                CacheUtil.putCacheValue(cacheType, key, obj);
                info.debug("_hasFunctionPermission, key: " + key + ", hit: false");
                return obj;
            }
            obj = this.hasFunctionPermission(ctx, userPK, orgPK, uiPK, actionPK, orgExtFromCtx);
            CacheUtil.putCacheValue(cacheType, key, obj);
            info.debug("_hasFunctionPermission, key: " + key + ", hit: false");
            return obj;
        }
        obj = true;
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, obj);
        }
        info.debug("_hasFunctionPermission, key: " + key + ", hit: false");
        return obj;
    }

    @Override
    protected void _checkFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK, String permItemName, boolean orgExtFromCtx) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, uiPK, actionPK, permItemName, orgExtFromCtx});
        Object obj = CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_checkFunctionPermission, key: " + key + ", hit: true");
            return;
        }
        if (!StringUtils.isEmpty((String)permItemName)) {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            service.checkPermission(userPK, orgPK, permItemName, true);
        }
        if (uiPK != null) {
            this.checkFunctionPermission(ctx, userPK, orgPK, uiPK, actionPK, orgExtFromCtx);
        }
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, true);
        }
        info.debug("_checkFunctionPermission, key: " + key + ", hit: false");
    }

    @Override
    protected String _getFunctionPermissionsByMenu(Context ctx) throws BOSException, EASBizException {
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        return service.getFunctionPermissionsByMenu();
    }

    @Override
    protected Set _checkBatchPermission(Context ctx, IObjectPK userPK, IObjectPK[] orgPKs, String permItemName) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, permItemName, CacheUtil.array2Str(orgPKs), "batch"});
        Set obj = (Set)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_checkBatchPermission, key: " + key + ", hit: true");
            return obj;
        }
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        Set ret = service.checkBatchPermission(userPK, orgPKs, permItemName);
        if (orgPKs != null && orgPKs.length > 0) {
            CacheUtil.putCacheValue(cacheType, key, ret);
        }
        info.debug("_checkBatchPermission, key: " + key + ", hit: false");
        return ret;
    }

    @Override
    protected List _getQueryPermissionSQL(Context ctx, List userOrgPermCollections) throws BOSException, EASBizException {
        LinkedList<String> list = new LinkedList<String>();
        DataPermissionService service = new DataPermissionService(ctx);
        for (int i = 0; i < userOrgPermCollections.size(); ++i) {
            ObjectUuidPK userPK = new ObjectUuidPK(((UserOrgRoPerm)userOrgPermCollections.get(i)).getUsInfo().getId());
            ObjectUuidPK orgPK = new ObjectUuidPK(((UserOrgRoPerm)userOrgPermCollections.get(i)).getOrgInfo().getId());
            String permItemName = ((UserOrgRoPerm)userOrgPermCollections.get(i)).getPmInfo().getName();
            list.add(service.getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, permItemName));
        }
        return list;
    }

    @Override
    protected void _delPermissoinAfterDelOrg(Context ctx, Set orgTypeSet, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        DelPermissionAfterDelOrg service = new DelPermissionAfterDelOrg(ctx);
        service.delPermissoinAfterDelOrg(orgTypeSet, unitInfo);
    }

    @Override
    protected UserCollection _getRefUersByPermisson(Context ctx, Set orgTypeSet, String ouID) throws BOSException, EASBizException {
        DelPermissionAfterDelOrg service = new DelPermissionAfterDelOrg(ctx);
        return service.getRefUersByPermisson(orgTypeSet, ouID);
    }

    @Override
    protected void _updatePassword4Novell(Context ctx, String userNumber, String newPassword) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserInfo userInfo = iUser.getUserInfoByNumber(userNumber);
        if (userInfo == null) {
            throw new UserException(UserException.USER_NOT_EXIST);
        }
        String newPW = PermissionUtil.decrypt(userInfo.getNumber(), newPassword);
        userInfo.setPassword(newPW);
        if (StringUtils.isEmpty((String)newPW)) {
            userInfo.setPassword(null);
        } else {
            PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
            userInfo.setPassword(PermissionUtil.encrypt(userInfo.getId().toString(), newPW, passwordType));
            userInfo.setPasswordType(passwordType);
        }
        userInfo.setChangedPW(true);
        iUser.update((IObjectPK)new ObjectUuidPK(userInfo.getId()), (CoreBaseInfo)userInfo);
    }

    @Override
    protected void _updateSelfInfo4Novell(Context ctx, String userNumber, String cellPhoneNumber, String homePhoneNumber, String officePhoneNumber, String extParam1, String extParam2, String extParam3) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserInfo userInfoInDb = iUser.getUserInfoByNumber(userNumber);
        if (userInfoInDb == null) {
            throw new UserException(UserException.USER_NOT_EXIST);
        }
        userInfoInDb.setCell(cellPhoneNumber);
        userInfoInDb.setHomePhone(homePhoneNumber);
        userInfoInDb.setOfficePhone(officePhoneNumber);
        iUser.update((IObjectPK)new ObjectUuidPK(userInfoInDb.getId()), (CoreBaseInfo)userInfoInDb);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo personInfoInDb = userInfoInDb.getPerson();
        if (personInfoInDb == null) {
            logger.info((Object)"userInfoInDb.getPerson() is null, return.");
            return;
        }
        if ((personInfoInDb = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personInfoInDb.getId()))).getCreateTime() == null) {
            logger.info((Object)"personInfoInDb.getCreateTime() is null, return.");
            return;
        }
        personInfoInDb.setCell(cellPhoneNumber);
        personInfoInDb.setHomePhone(homePhoneNumber);
        personInfoInDb.setOfficePhone(officePhoneNumber);
        iPerson.update((IObjectPK)new ObjectUuidPK(personInfoInDb.getId()), (CoreBaseInfo)personInfoInDb);
    }

    @Override
    protected boolean[] _hasFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String[] permitemNames) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.function";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, CacheUtil.array2Str(permitemNames), "batch"});
        boolean[] obj = (boolean[])CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_hasFunctionPermission, key: " + key + ", hit: true");
            return obj;
        }
        int size = permitemNames.length;
        boolean[] retValue = new boolean[size];
        HashMap<Integer, String> permItemNames = new HashMap<Integer, String>();
        Map retPermItemMap = new HashMap();
        for (int i = 0; i < size; ++i) {
            permItemNames.put(i, permitemNames[i]);
        }
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        retPermItemMap = service.hasBatchPermission(userPK, orgPK, permItemNames, true);
        Set permIndexSet = retPermItemMap.keySet();
        for (Integer index : permIndexSet) {
            Boolean ret = (Boolean)retPermItemMap.get(index);
            retValue[index.intValue()] = ret;
        }
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            CacheUtil.putCacheValue(cacheType, key, retValue);
        }
        info.debug("_hasFunctionPermission, key: " + key + ", hit: false");
        return retValue;
    }

    @Override
    protected OrgUnitCollection _getAuthorizedOrg(Context ctx, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName, SelectorItemCollection selector) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(ctx);
        if (Administrator.isAdmin(ctx, userPK)) {
            return service.getAdminOrg(userPK, orgType, orgTreePK, selector);
        }
        if (StringUtils.isEmpty((String)permItemName)) {
            return service.getOrgRange(userPK, orgType, orgTreePK, selector);
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(ctx).getPermItem(ctx, permItemName);
        if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            if (this.hasFunctionPermission(ctx, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                return service.getOrgRange(userPK, orgType, orgTreePK, selector);
            }
            return new OrgUnitCollection();
        }
        return service.getAuthorizedOrg(userPK, orgType, orgTreePK, permItemName, selector);
    }

    @Override
    protected Set _getAuthorizedOrgIds(Context ctx, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null);
        if (orgType != null && orgType.equals((Object)OrgType.NONE)) {
            throw new IllegalArgumentException("orgType can not be OrgType.NONE");
        }
        OrgPermissionService service = new OrgPermissionService(ctx);
        if (Administrator.isAdmin(ctx, userPK)) {
            return service.getAdminOrgIDSet(userPK, orgType, orgTreePK);
        }
        if (StringUtils.isEmpty((String)permItemName)) {
            return service.getOrgRangeIDSet(userPK, orgType, orgTreePK);
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(ctx).getPermItem(ctx, permItemName);
        if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            if (this.hasFunctionPermission(ctx, userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName)) {
                return service.getOrgRangeIDSet(userPK, orgType, orgTreePK);
            }
            return new HashSet();
        }
        return service.getAuthorizedOrgIDSet(userPK, orgType, orgTreePK, permItemName);
    }
}

