/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IMAGroup;
import com.kingdee.eas.base.message.IMAGroupEntry;
import com.kingdee.eas.base.message.IMAGroupResolventEntry;
import com.kingdee.eas.base.message.MAGroupEntryFactory;
import com.kingdee.eas.base.message.MAGroupEntryInfo;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupResolventEntryFactory;
import com.kingdee.eas.base.message.MAGroupResolventEntryInfo;
import com.kingdee.eas.base.message.MAGroupResolventFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSendRecordFactory;
import com.kingdee.eas.base.message.MsgSendRecordInfo;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.MsgUnreadCountFactory;
import com.kingdee.eas.base.message.app.ReceiversUtil;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.message.webservice.MCInvoke;
import com.kingdee.eas.base.message.webservice.WebServiceControlUtil;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeHelper;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.PermissionReqBillEntryCollection;
import com.kingdee.eas.base.permission.PermissionReqBillEntryInfo;
import com.kingdee.eas.base.permission.PermissionReqBillInfo;
import com.kingdee.eas.base.permission.PermissionReqException;
import com.kingdee.eas.base.permission.PermissionReqSensitiveOrgFactory;
import com.kingdee.eas.base.permission.PermissionReqSensitiveRoleFactory;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.StatuEnum;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.AbstractPermissionReqBillControllerBean;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.receiver.BasReceiverCollection;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PermissionReqBillControllerBean
extends AbstractPermissionReqBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.PermissionReqBillControllerBean");
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String procDefId;
        PermissionReqBillInfo info = (PermissionReqBillInfo)model;
        if (info.getEntrys().size() > 100000) {
            throw new PermissionReqException(PermissionReqException.CHECKENTRYOVERLINIT, new Object[]{100000});
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        if (model != null && StringUtils.isEmpty((String)(procDefId = service.findSubmitProcDef(ctx.getCaller().toString(), model, null, null)))) {
            throw new PermissionReqException(PermissionReqException.NO_AVAIL_PROCESS);
        }
        this.verifyInput(ctx, info);
        info.setStatu(StatuEnum.SUBMIT);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PermissionReqBillInfo info = (PermissionReqBillInfo)model;
        boolean notSupportRule = "true".equals(info.getString("notSupportRule"));
        if (!notSupportRule && StringUtils.isEmpty((String)info.getNumber())) {
            String codeNumber = this.addCodingRule((ObjectBaseInfo)info, ctx);
            info.setNumber(codeNumber);
        }
        this.verifyInput(ctx, info);
        info.setStatu(StatuEnum.DRAFT);
        return super._save(ctx, model);
    }

    private void verifyInput(Context ctx, PermissionReqBillInfo info) throws EASBizException, BOSException {
        boolean hasNotInRangeUser;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new PermissionReqException(PermissionReqException.CHECKNUMBLANK);
        }
        if (info.getNumber().length() > 80) {
            throw new PermissionReqException(PermissionReqException.CHECKNUMOVERLIMIT, new Object[]{80});
        }
        if (StringUtils.isEmpty((String)info.getDescription())) {
            throw new PermissionReqException(PermissionReqException.CHECKDESBLANK);
        }
        if (info.getNumber().length() > 80) {
            throw new PermissionReqException(PermissionReqException.CHECKDESOVERLIMIT, new Object[]{80});
        }
        if (info.getEntrys() == null || info.getEntrys().size() < 1) {
            throw new PermissionReqException(PermissionReqException.CHECKENTRYEMPTY);
        }
        if (info.getId() == null && this.exists(ctx, "where number='" + info.getNumber() + "'")) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
        HashSet<String> userIds = new HashSet<String>();
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> roleIds = new HashSet<String>();
        HashSet<String> adminOrgIds = new HashSet<String>();
        HashSet<Boolean> isIncludeSub = new HashSet<Boolean>();
        Boolean reqType = info.isReqType();
        PermissionReqBillEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            PermissionReqBillEntryInfo entryItem = entrys.get(i);
            if (entryItem.getUser() == null || entryItem.getUser().getId() == null) {
                throw new PermissionReqException(PermissionReqException.CHECKENTRYUSERSEMPTY);
            }
            if (reqType.booleanValue()) {
                if (entryItem.getAdminOrg() == null || entryItem.getAdminOrg().getId() == null) {
                    throw new PermissionReqException(PermissionReqException.CHECKENTRYORGSEMPTY);
                }
                userIds.add(entryItem.getUser().getId().toString());
                adminOrgIds.add(entryItem.getAdminOrg().getId().toString());
                isIncludeSub.add(entryItem.isIsIncludeSub());
                continue;
            }
            if (entryItem.getRole() == null || entryItem.getRole().getId() == null) {
                throw new PermissionReqException(PermissionReqException.CHECKENTRYROLESEMPTY);
            }
            if (entryItem.getOrg() == null || entryItem.getOrg().getId() == null) {
                throw new PermissionReqException(PermissionReqException.CHECKENTRYORGSEMPTY);
            }
            userIds.add(entryItem.getUser().getId().toString());
            orgIds.add(entryItem.getOrg().getId().toString());
            roleIds.add(entryItem.getRole().getId().toString());
        }
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (Administrator.isAdminType(currentUser.getType())) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", userIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)("select forgid from t_pm_orgrange where Fuserid ='" + currentUser.getId().toString() + "' and FType =10"), CompareType.NOTINNER));
            entityViewInfo.setFilter(filter);
            hasNotInRangeUser = UserFactory.getLocalInstance(ctx).exists(filter);
        } else if (Administrator.isBizAdmin(ctx, (IObjectPK)new ObjectUuidPK(currentUser.getId()))) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)("select forgid from t_pm_orgrange where Fuserid ='" + currentUser.getId().toString() + "' and FType =30"), CompareType.NOTINNER));
            filter.getFilterItems().add(new FilterItemInfo("id", userIds, CompareType.INCLUDE));
            hasNotInRangeUser = UserFactory.getLocalInstance(ctx).exists(filter);
        } else {
            boolean bl = hasNotInRangeUser = userIds.size() != 1 || !currentUser.getId().toString().equals(userIds.iterator().next());
        }
        if (hasNotInRangeUser) {
            throw new PermissionReqException(PermissionReqException.CHECKUSERRANGE);
        }
        FilterInfo orgFilter = new FilterInfo();
        if (reqType.booleanValue()) {
            orgFilter.getFilterItems().add(new FilterItemInfo("org.id", adminOrgIds, CompareType.INCLUDE));
        } else {
            orgFilter.getFilterItems().add(new FilterItemInfo("org.id", orgIds, CompareType.INCLUDE));
        }
        if (PermissionReqSensitiveOrgFactory.getLocalInstance(ctx).exists(orgFilter)) {
            throw new PermissionReqException(PermissionReqException.CHECKORGRANGE);
        }
        if (!reqType.booleanValue()) {
            FilterInfo roleFilter = new FilterInfo();
            roleFilter.getFilterItems().add(new FilterItemInfo("role.id", roleIds, CompareType.INCLUDE));
            if (PermissionReqSensitiveRoleFactory.getLocalInstance(ctx).exists(roleFilter)) {
                throw new PermissionReqException(PermissionReqException.CHECKROLERANGE);
            }
        }
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, StatuEnum.CHECKFAILED);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, StatuEnum.CHECKING);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        TableManager tm = null;
        String tableName = null;
        try {
            PermissionReqBillInfo info = this.getPermissionReqBillInfo(ctx, "where id='" + billId.toString() + "'");
            if (!info.isReqType()) {
                this.handleRoleReq(ctx, info, tm, tableName, auditorId);
            } else {
                this.handleAdminOrgReq(ctx, info, auditorId);
            }
            String resource = RESOURCE;
            String title = EASResource.getString((String)resource, (String)"PermReqPass");
            IUser iUser = UserFactory.getLocalInstance(ctx);
            IFullOrgUnit IOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            IRole iRole = RoleFactory.getLocalInstance(ctx);
            Locale locale = ctx.getLocale();
            String msgContent = null;
            PermissionReqBillEntryCollection entrys = info.getEntrys();
            if (entrys.size() > 0) {
                for (int i = 0; i < entrys.size(); ++i) {
                    PermissionReqBillEntryInfo entryInfo = entrys.get(i);
                    UserInfo user = iUser.getUserByID((IObjectPK)new ObjectUuidPK(entryInfo.getUser().getId()));
                    if (null == user || !UserType.PERSON.equals((Object)user.getType())) continue;
                    if (info.isReqType()) {
                        String adminOrg = IOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getAdminOrg().getId())).getName();
                        title = user.getName() + title;
                        msgContent = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"PermReqPassMsgForAdmin", (Locale)locale), adminOrg);
                        BMCMessageInfo bmcMsgInfo = new BMCMessageInfo();
                        IObjectPK msgPK = BMCMessageFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)bmcMsgInfo);
                        this.sendInstantMsg(user.getPerson().getId().toString(), "0", title, msgContent, msgPK.toString(), ctx);
                        continue;
                    }
                    String org = IOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getOrg().getId())).getName();
                    String role = iRole.getRoleInfo((IObjectPK)new ObjectUuidPK(entryInfo.getRole().getId())).getName();
                    title = user.getName() + title;
                    msgContent = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"PermReqPassMsg", (Locale)locale), org, role);
                    BMCMessageInfo bmcMsgInfo = new BMCMessageInfo();
                    IObjectPK msgPK = BMCMessageFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)bmcMsgInfo);
                    this.sendInstantMsg(user.getPerson().getId().toString(), "0", title, msgContent, msgPK.toString(), ctx);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tm != null && tableName != null) {
                tm.releaseTable(tableName);
            }
        }
    }

    public Map sendInstantMsg(String personIds, String priorty, String title, String content, String msgBosID, Context ctx) {
        HashMap resultMap = new HashMap();
        HashMap failMap = new HashMap();
        Locale locale = ProcessCenterUtil.getLocale((Context)ctx);
        try {
            priorty = URLDecoder.decode(priorty, "UTF-8");
            title = URLDecoder.decode(title, "UTF-8");
            content = URLDecoder.decode(content, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return failMap;
        }
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        int pritotyValue = Integer.parseInt(priorty);
        msgInfo.setPriority(MsgPriority.getEnum((int)pritotyValue));
        if (!StringUtils.isEmpty((String)title)) {
            title = title.trim();
        }
        msgInfo.setTitle(title, new Locale("l1"));
        msgInfo.setTitle(title, new Locale("l2"));
        msgInfo.setTitle(title, new Locale("l3"));
        if (!StringUtils.isEmpty((String)content)) {
            content = content.trim();
        }
        msgInfo.setBody(content, new Locale("l1"));
        msgInfo.setBody(content, new Locale("l2"));
        msgInfo.setBody(content, new Locale("l3"));
        msgInfo.setType(MsgType.ONLINE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        IUser iUser = null;
        IBMCMessage iBMCMessage = null;
        UserInfo userInfo = null;
        String receiverNames = "";
        BasReceiverCollection receivers = new BasReceiverCollection();
        int validCount = 0;
        int invalidCount = 0;
        StringBuffer validName = new StringBuffer();
        StringBuffer invalidName = new StringBuffer();
        try {
            iUser = UserFactory.getLocalInstance(ctx);
            iBMCMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
            userInfo = iUser.getUserInfo(ctx.getCaller());
            Map activeReceiverMap = ProcessCenterUtil.getUserByPerson((Context)ctx, (String)personIds);
            Iterator activeReceiverId = null;
            if (activeReceiverMap.isEmpty()) {
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.base.message.MessageCenter", (String)"sendFailedLog2", (Locale)locale));
                return failMap;
            }
            activeReceiverId = activeReceiverMap.keySet().iterator();
            Map receiverMap = ProcessCenterUtil.getReceiverMap((Context)ctx, (String)personIds);
            while (activeReceiverId.hasNext()) {
                String receiverId = activeReceiverId.next().toString();
                if (receiverMap.containsKey(receiverId)) {
                    ++validCount;
                    validName.append(receiverMap.get(receiverId)).append(",");
                    continue;
                }
                ++invalidCount;
                invalidName.append(receiverMap.get(receiverId)).append(",");
            }
            if (validName.length() > 0) {
                receiverNames = validName.substring(0, validName.length() - 1);
            }
            receivers = ProcessCenterUtil.getBasReceiverCollection((Map)activeReceiverMap);
            msgInfo.setSender(userInfo.getName());
            msgInfo.setNreceivers(receiverNames);
            this.addHandMsg(ctx, (IObjectValue)msgInfo, (IObjectCollection)receivers, iBMCMessage);
            return resultMap;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return failMap;
        }
    }

    protected void addHandMsg(Context ctx, IObjectValue msgInfo, IObjectCollection receiverCollection, IBMCMessage iBMCMessage) throws BOSException {
        Iterator ids;
        BMCMessageInfo mInfo = (BMCMessageInfo)msgInfo;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        mInfo.setReceiveTime(cuttentDate);
        mInfo.setSendTime(cuttentDate);
        mInfo.setBizType(MsgBizType.ONLINE);
        mInfo.setSenderId(ctx.getCaller().toString());
        BasReceiverCollection receivers = (BasReceiverCollection)receiverCollection;
        BasReceiverInfo info = null;
        HashMap userIdMap = new HashMap();
        ReceiversUtil util = new ReceiversUtil();
        util.setCtx(ctx);
        ArrayList list = null;
        MsgSendRecordInfo msrInfo = new MsgSendRecordInfo();
        ObjectUuidPK recordPk = new ObjectUuidPK(BOSUuid.create((BOSObjectType)msrInfo.getBOSType()));
        Locale l1 = new Locale("L1");
        Locale l2 = new Locale("L2");
        Locale l3 = new Locale("L3");
        if (receivers != null && receivers.size() > 0) {
            for (int i = 0; i < receivers.size(); ++i) {
                info = receivers.get(i);
                if (info.getType().equals("1") || info.getType().equals("3")) {
                    userIdMap.put(info.getValue(), null);
                    continue;
                }
                if (info.getType().equals("0") || info.getType().equals("5")) {
                    try {
                        list = util.getUserIDsByAdminOrgUnit(info.getValue());
                        for (int j = 0; j < list.size(); ++j) {
                            userIdMap.put((String)list.get(j), null);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (info.getType().equals("2")) {
                    IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
                    IMAGroupResolventEntry ire = MAGroupResolventEntryFactory.getLocalInstance((Context)ctx);
                    IMAGroup im = MAGroupFactory.getLocalInstance((Context)ctx);
                    IMAGroupEntry ime = MAGroupEntryFactory.getLocalInstance((Context)ctx);
                    String personid = "";
                    String sql1 = "select FID from T_PM_User where FPersonId=?";
                    StringBuffer sb = new StringBuffer();
                    try {
                        MAGroupResolventInfo mainfo = MAGroupResolventFactory.getLocalInstance((Context)ctx).getMAGroupResolventInfo("select * where id = '" + info.getValue() + "'");
                        for (int n = 0; n < mainfo.getEntries().size(); ++n) {
                            MAGroupResolventEntryInfo entryInfo = ire.getMAGroupResolventEntryInfo((IObjectPK)new ObjectUuidPK(mainfo.getEntries().get(n).getId().toString()));
                            MAGroupInfo magroupInfo = im.getMAGroupInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGroup().getId().toString()));
                            if (magroupInfo == null) continue;
                            for (int j = 0; j < magroupInfo.getEntries().size(); ++j) {
                                MAGroupEntryInfo magroupeinfo = ime.getMAGroupEntryInfo((IObjectPK)new ObjectUuidPK(magroupInfo.getEntries().get(j).getId().toString()));
                                if (magroupeinfo.getPersonnel() == null || magroupeinfo.getPersonnel().getId() == null || StringUtils.isEmpty((String)(personid = magroupeinfo.getPersonnel().getId().toString()))) continue;
                                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{personid});
                                try {
                                    while (rs.next()) {
                                        userIdMap.put(rs.getString("FID"), null);
                                    }
                                    continue;
                                }
                                catch (SQLException e) {
                                    logger.error((Object)"_addHandMsg SQLException failed!", (Throwable)e);
                                }
                            }
                        }
                        continue;
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"_addHandMsg EASBizException failed!", (Throwable)e);
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)"_addHandMsg BOSException failed!", (Throwable)e);
                        continue;
                    }
                }
                if (info.getType().equals("8")) {
                    UserCollection usercol = UserFactory.getLocalInstance(ctx).getUserCollection("select * where person = '" + info.getValue().toString() + "'");
                    Iterator userit = usercol.iterator();
                    while (userit.hasNext()) {
                        UserInfo userInfo = (UserInfo)userit.next();
                        if (userInfo == null) continue;
                        userIdMap.put(userInfo.getId().toString(), null);
                    }
                    continue;
                }
                if (!info.getType().equals("9")) continue;
                UserCollection uc = UserFactory.getLocalInstance(ctx).getUserCollection("select * where type <> 20 and isDelete = 0 and isLocked = 0 and isForbidden = 0 and cu = '" + info.getValue().toString() + "'");
                Iterator it1 = uc.iterator();
                UserInfo ui = null;
                while (it1.hasNext()) {
                    ui = (UserInfo)it1.next();
                    userIdMap.put(ui.getId().toString(), null);
                }
            }
        }
        String id = null;
        if (mInfo.getId() != null) {
            id = mInfo.getId().toString();
        }
        if ((ids = userIdMap.keySet().iterator()).hasNext()) {
            mInfo.setReceiver((String)ids.next());
            try {
                IObjectPK pk;
                if (id != null) {
                    pk = new ObjectUuidPK(id);
                    iBMCMessage.submit(pk, (CoreBaseInfo)mInfo);
                } else {
                    pk = iBMCMessage.submit((CoreBaseInfo)mInfo);
                    id = pk.toString();
                }
                msrInfo.setSenderID(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
                msrInfo.setSendTime(new Timestamp(new Date().getTime()));
                msrInfo.setTitle(mInfo.getTitle(), l1);
                msrInfo.setTitle(mInfo.getTitle(), l2);
                msrInfo.setTitle(mInfo.getTitle(), l3);
                msrInfo.setBody(mInfo.getBody(), l1);
                msrInfo.setBody(mInfo.getBody(), l2);
                msrInfo.setBody(mInfo.getBody(), l3);
                msrInfo.setReciever(mInfo.getNreceivers(), l1);
                msrInfo.setReciever(mInfo.getNreceivers(), l2);
                msrInfo.setReciever(mInfo.getNreceivers(), l3);
                msrInfo.setPriority(mInfo.getPriority());
                msrInfo.setSourceID(mInfo.getId());
                if (WebServiceControlUtil.isToOtherSys()) {
                    MCInvoke.getInstance().wsImplRead(MCInvoke.intoMessage((BMCMessageInfo)mInfo, (Context)ctx), ctx);
                }
                if (WebServiceControlUtil.isLetOtherSysGet()) {
                    MsgUnreadCountFactory.getLocalInstance((Context)ctx).unReadCount(mInfo.getReceiver(), mInfo.getReceiveTime());
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        AttachmentServerManager attmanager = AttachmentManagerFactory.getServerManager((Context)ctx);
        while (ids.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.create((BOSObjectType)mInfo.getBOSType()));
            mInfo.setReceiver((String)ids.next());
            try {
                iBMCMessage.addnew((IObjectPK)pk, (CoreBaseInfo)mInfo);
                attmanager.copyBizRelation(id, pk.toString());
                if (WebServiceControlUtil.isToOtherSys()) {
                    MCInvoke.getInstance().wsImplRead(MCInvoke.intoMessage((BMCMessageInfo)mInfo, (Context)ctx), ctx);
                }
                if (!WebServiceControlUtil.isLetOtherSysGet()) continue;
                MsgUnreadCountFactory.getLocalInstance((Context)ctx).unReadCount(mInfo.getReceiver(), mInfo.getReceiveTime());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            attmanager.copyBizRelation(id, recordPk.toString());
            MsgSendRecordFactory.getLocalInstance((Context)ctx).addnew((IObjectPK)recordPk, (CoreBaseInfo)msrInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_addHandMsg Exception failed!", (Throwable)e);
        }
    }

    private void handleAdminOrgReq(Context ctx, PermissionReqBillInfo info, BOSUuid auditorId) throws Exception {
        PermissionReqBillEntryCollection coll = info.getEntrys();
        PermissionReqBillEntryInfo entryInfo = null;
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        HashSet<IObjectPK> userPKs = new HashSet<IObjectPK>(coll.size());
        String insertSql = "insert into T_PM_OrgRangeIncludeSubOrg (fid, fuserid, forgid, ftype, fisincludesuborg) values(newbosid('4DC3DADF'),?,?,?,?)";
        String insertSql2 = "insert into T_PM_OrgRange (fid, fuserid, forgid, ftype) values(newbosid('FD3DC16D'),?,?,?)";
        ArrayList<Object[]> userAdminOrgSub = new ArrayList<Object[]>();
        ArrayList<Object[]> userAdminOrg = new ArrayList<Object[]>();
        StringBuilder logDetail = new StringBuilder(EASResource.getString((String)RESOURCE, (String)"PERMISSION_APPROVE_PASS") + "\uff1a\n");
        for (int i = 0; i < coll.size(); ++i) {
            entryInfo = coll.get(i);
            UserInfo user = entryInfo.getUser();
            String userIdStr = user.getId().toString();
            String adminOrgIdStr = entryInfo.getAdminOrg().getId().toString();
            boolean isIncludeSub = entryInfo.isIsIncludeSub();
            if (Administrator.isSuperAdmin(user.getId()) || UserType.SYSTEM.equals((Object)user.getType()) || UserType.SYSTEM.equals((Object)user.getType())) continue;
            userAdminOrgSub.add(new Object[]{userIdStr, adminOrgIdStr, 20, isIncludeSub});
            userAdminOrg.add(new Object[]{userIdStr, adminOrgIdStr, 20});
            userPKs.add((IObjectPK)new ObjectUuidPK(userIdStr));
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"USER1")).append(user.getNumber()).append(EASResource.getString((String)RESOURCE, (String)"ADMINI_ORG")).append(entryInfo.getAdminOrg().getDisplayName()).append("\n");
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"PERMISSION_APPROVE_PASS"), (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()), (String)logDetail.toString());
        DbUtil.executeBatch((Context)ctx, (String)insertSql, userAdminOrgSub);
        DbUtil.executeBatch((Context)ctx, (String)insertSql2, userAdminOrg);
        for (IObjectPK userPK : userPKs) {
            OrgRangeHelper.updateAdminOrgRange(ctx, userPK.toString());
        }
        info.setStatu(StatuEnum.CHECKED);
        UserInfo auditor = new UserInfo();
        auditor.setId(auditorId);
        info.setAuditor(auditor);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("statu"));
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        this.handleCallBack(ctx, userPKs);
    }

    private void handleRoleReq(Context ctx, PermissionReqBillInfo info, TableManager tm, String tableName, BOSUuid auditorId) throws Exception {
        PermissionReqBillEntryCollection coll = info.getEntrys();
        PermissionReqBillEntryInfo tmp = null;
        HashSet<IObjectPK> userPKs = new HashSet<IObjectPK>(coll.size());
        HashMap<String, ArrayList<String>> userRolesMap = new HashMap<String, ArrayList<String>>();
        StringBuilder logDetail = new StringBuilder(EASResource.getString((String)RESOURCE, (String)"PERMISSION_APPROVE_PASS") + ": \n");
        ArrayList<Object[]> userOrgRole = new ArrayList<Object[]>();
        for (int i = 0; i < coll.size(); ++i) {
            tmp = coll.get(i);
            UserInfo user = tmp.getUser();
            String userIdStr = user.getId().toString();
            String roleIdStr = tmp.getRole().getId().toString();
            userOrgRole.add(new Object[]{userIdStr, tmp.getOrg().getId().toString(), roleIdStr});
            userPKs.add((IObjectPK)new ObjectUuidPK(userIdStr));
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"USER1")).append(user.getNumber()).append(", " + EASResource.getString((String)RESOURCE, (String)"ROLE1") + "\uff1a").append(tmp.getRole().getDisplayName()).append(", " + EASResource.getString((String)RESOURCE, (String)"ORG")).append(tmp.getOrg().getDisplayName()).append("\n");
            if (Administrator.isSuperAdmin(user.getId()) || UserType.SYSTEM.equals((Object)user.getType()) || UserType.SYSTEM.equals((Object)user.getType())) continue;
            ArrayList<String> roles = (ArrayList<String>)userRolesMap.get(userIdStr);
            if (roles == null) {
                roles = new ArrayList<String>();
            }
            roles.add(roleIdStr);
            userRolesMap.put(userIdStr, roles);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"PERMISSION_APPROVE_PASS"), (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()), (String)logDetail.toString());
        tm = TableManager.getTableManager((Context)ctx);
        tableName = tm.getTableName("orgRangeAdd");
        String createSql = "create table " + tableName + " (fuserid varchar(44),forgid varchar(44),froleid varchar(44))";
        tm.createTable(createSql);
        String insertSql = "insert into " + tableName + "( fuserid,forgid,froleid) values(?,?,?)";
        DbUtil.executeBatch((Context)ctx, (String)insertSql, userOrgRole);
        StringBuilder sql1 = new StringBuilder();
        sql1.append("INSERT INTO T_PM_OrgRange (FID, FUserID, FOrgID, FType) ").append("select newbosid('FD3DC16D'),fuserid,forgid,10 from ").append(tableName).append(" tmp where not exists ").append("(select 1 from t_pm_orgrange where fuserid=tmp.fuserid and forgid=tmp.forgid and ftype=10)");
        DbUtil.execute((Context)ctx, (String)sql1.toString());
        StringBuilder sql2 = new StringBuilder();
        sql2.append("INSERT INTO T_PM_OrgRangeIncludeSubOrg (FID, FUserID, FOrgID, FType,FIsIncludeSubOrg) ").append("select newbosid('FD3DC16D'),fuserid,forgid,10,0 from ").append(tableName).append(" tmp where not exists ").append("(select 1 from T_PM_OrgRangeIncludeSubOrg where fuserid=tmp.fuserid and forgid=tmp.forgid and ftype=10)");
        DbUtil.execute((Context)ctx, (String)sql2.toString());
        StringBuilder sql3 = new StringBuilder();
        sql3.append("INSERT INTO t_pm_userroleorg (FUserID, FOrgID, FRoleID) ").append("select fuserid,forgid,FRoleID from ").append(tableName).append(" tmp where not exists ").append("(select 1 from t_pm_userroleorg where fuserid=tmp.fuserid and forgid=tmp.forgid and froleid=tmp.froleid)");
        DbUtil.execute((Context)ctx, (String)sql3.toString());
        info.setStatu(StatuEnum.CHECKED);
        UserInfo auditor = new UserInfo();
        auditor.setId(auditorId);
        info.setAuditor(auditor);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("statu"));
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        for (String userId : userRolesMap.keySet()) {
            List roleIds = (List)userRolesMap.get(userId);
            GroupLicenseUseInfoUtil.assignRoles(ctx, userId, roleIds);
        }
        this.handleCallBack(ctx, userPKs);
    }

    private void handleCallBack(Context ctx, Set<IObjectPK> userPKs) throws EASBizException, BOSException {
        if (userPKs == null || userPKs.isEmpty()) {
            return;
        }
        PermissionChangeHelper helper = new PermissionChangeHelper();
        Object[] objects = userPKs.toArray();
        IObjectPK[] userPKArr = new IObjectPK[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            userPKArr[i] = (IObjectPK)objects[0];
        }
        helper.setUserPKs(userPKArr);
        helper.exceChange(ctx);
    }

    @Override
    protected void _setSubmitState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, StatuEnum.SUBMIT);
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, StatuEnum.DRAFT);
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, StatuEnum.CLOSE);
    }

    @Override
    protected void _setStatu(Context ctx, BOSUuid bilId, StatuEnum statu) throws BOSException, EASBizException {
        PermissionReqBillInfo info = new PermissionReqBillInfo();
        info.setId(bilId);
        info.setStatu(statu);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("statu"));
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    private String addCodingRule(ObjectBaseInfo bgTpInfo, Context context) throws EASBizException, BOSException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)context);
        String strCurCompany = iCodingRuleManager.getCurrentAppOUID((IObjectValue)bgTpInfo);
        try {
            if (strCurCompany == null || strCurCompany.equals("")) {
                return null;
            }
            if (iCodingRuleManager.isExist((IObjectValue)bgTpInfo, strCurCompany)) {
                number = iCodingRuleManager.isUseIntermitNumber((IObjectValue)bgTpInfo, strCurCompany) ? iCodingRuleManager.readNumber((IObjectValue)bgTpInfo, strCurCompany) : iCodingRuleManager.getNumber((IObjectValue)bgTpInfo, strCurCompany);
                for (int i = 0; i < 10 && this.exists(context, "where number='" + number + "'"); ++i) {
                    number = iCodingRuleManager.getNumber((IObjectValue)bgTpInfo, strCurCompany);
                }
            }
        }
        catch (Exception e) {
            number = null;
        }
        return number;
    }
}

