/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.app.AbstractPermissionServiceProviderControllerBean;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.TimeCostUtil;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class PermissionServiceProviderControllerBean
extends AbstractPermissionServiceProviderControllerBean {
    private static final Logger logger = Logger.getLogger(PermissionServiceProviderControllerBean.class);
    private static final String NULL_RULE = "null";

    @Override
    protected String _getPermissionRule(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.rule";
        String key = CacheUtil.getCacheKey(cacheType, userPK, new Object[]{userPK, orgPK, permItemName});
        String obj = (String)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            if (NULL_RULE.equals(obj)) {
                obj = null;
            }
            info.debug("_getPermissionRule, key: " + key + ", hit: true");
            return obj;
        }
        DataPermissionService service = new DataPermissionService(ctx);
        obj = service.getPermissionRule(userPK, orgPK, permItemName);
        if (obj == null) {
            obj = NULL_RULE;
        }
        CacheUtil.putCacheValue(cacheType, key, obj);
        info.debug("_getPermissionRule, key: " + key + ", hit: false");
        if (NULL_RULE.equals(obj)) {
            obj = null;
        }
        return obj;
    }

    @Override
    protected boolean _isEnableDataPermission(Context ctx) throws BOSException, EASBizException {
        TimeCostUtil info = new TimeCostUtil(logger);
        String cacheType = "permission.data";
        String key = CacheUtil.getCacheKey(new Object[]{"enableDataPermission"});
        Boolean obj = (Boolean)CacheUtil.getCacheValue(cacheType, key);
        if (obj != null) {
            info.debug("_isEnableDataPermission, key: " + key + ", hit: true");
            return obj;
        }
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        boolean enableDataPermission = Boolean.valueOf(iParamControl.getParamValue(null, "enableDataPermission"));
        CacheUtil.putCacheValue(cacheType, key, enableDataPermission);
        info.debug("_isEnableDataPermission, key: " + key + ", hit: false");
        return enableDataPermission;
    }
}

