/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.SuccessInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RegUserTransmission
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(RegUserTransmission.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private Locale l2 = new Locale("L2");

    public void setContextParameter(Map param) {
        super.setContextParameter(param);
    }

    public Hashtable getContextParameter() {
        return super.getContextParameter();
    }

    public Map getContextMap() {
        return super.getContextMap();
    }

    public Object getContextParameter(Object key) {
        return super.getContextParameter(key);
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String number = rs.getString("NUMBER");
            String nameL2 = ctx.getLocale().equals(this.l2) ? rs.getString("NAME") : "";
            String cell = rs.getString("cell");
            String mail = rs.getString("email");
            result.put("FNumber", number);
            result.put("FName_l2", nameL2 == null ? "" : nameL2);
            result.put("FEmail", mail == null ? "" : mail);
            result.put("FCell", cell == null ? "" : cell);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return super.getExportQueryInfo(ctx);
    }

    public int getSubmitType() {
        return super.getSubmitType();
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return super.isSameBlock(firstData, currentData);
    }

    public boolean isSameBlock(Map firstData, Map currentData) {
        return super.isSameBlock(firstData, currentData);
    }

    public String getMainField() {
        return super.getMainField();
    }

    public Hashtable convertMap(Map hsData) {
        return super.convertMap(hsData);
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        UserInfo userInfo = this.getUserInfo(ctx, number);
        if (userInfo == null) {
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserInfo().getBOSType()).getAlias();
            Object[] params = new Object[]{objectName, number};
            String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"numberNotFound", (Locale)ctx.getLocale()), params);
            throw new TaskExternalException(msg);
        }
        String nameL2 = (String)((DataToken)hsData.get((Object)"FName_l2")).data;
        if (StringUtils.isEmpty((String)nameL2)) {
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserInfo().getBOSType()).getAlias();
            Object[] params = new Object[]{objectName, nameL2};
            String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"RealNameNotFound", (Locale)ctx.getLocale()), params);
            throw new TaskExternalException(msg);
        }
        userInfo.setName(nameL2, this.l2);
        String cell = (String)((DataToken)hsData.get((Object)"FCell")).data;
        userInfo.setCell(cell);
        if (!StringUtils.isEmpty((String)cell)) {
            String[] globalMap = ToolUtils.getGLObalMapCell(cell);
            userInfo.setGlobalRoaming(globalMap[0]);
            userInfo.setNCell(globalMap[1]);
        }
        String mail = (String)((DataToken)hsData.get((Object)"FEmail")).data;
        userInfo.setEmail(mail);
        return userInfo;
    }

    public void writeLog(int rowNum, Exception e) {
        super.writeLog(rowNum, e);
    }

    public boolean isAfterAllProcess() {
        return super.isAfterAllProcess();
    }

    public boolean isSkipMainProcess() {
        return super.isSkipMainProcess();
    }

    public void writeLog(RecordCollection col, List<SuccessInfo> successList) {
        super.writeLog(col, successList);
    }

    public void solutionOnFinished(Context ctx) throws TaskExternalException {
        super.solutionOnFinished(ctx);
    }

    public void importOnFinished(Context ctx, Map map) throws TaskExternalException {
        super.importOnFinished(ctx, map);
    }

    public String getEntryName() {
        return super.getEntryName();
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return UserFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getController():", (Throwable)e);
        }
    }

    private UserInfo getUserInfo(Context ctx, String number) throws TaskExternalException {
        try {
            IUser iUser = UserFactory.getLocalInstance(ctx);
            boolean hasNumber = iUser.haveThisNumber(number);
            if (!hasNumber) {
                return null;
            }
            String oql = "SELECT *, security.*, person.id, group.*, defOrgUnit.*, customerID, supplierID, orgRange.*, orgRange.org.*,orgRangeIncludeSubOrg.*, CU.* WHERE number = '" + number + "'";
            return iUser.getUserInfo(oql);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getUserInfo():", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getUserInfo():", (Throwable)e);
        }
    }
}

