/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.base.permission.ISignatureConfig;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.SignatureFieldInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SignatureConfiguration
implements ISignatureConfig {
    private static final Logger logger = Logger.getLogger(SignatureConfiguration.class);
    private ConfigDao dao = ConfigDao.getConfigDao();

    private SignatureConfiguration() {
    }

    public static ISignatureConfig getInstance() {
        return new SignatureConfiguration();
    }

    @Override
    public boolean isCanSignature() {
        return this.dao.isSignatureNeeded;
    }

    @Override
    public boolean isCansignature(BOSObjectType bosType) {
        boolean bResult = false;
        if (bosType == null) {
            return false;
        }
        SignatureFieldInfo signatureFieldInfo = this.getSignatureFieldInfo(bosType);
        if (signatureFieldInfo != null) {
            bResult = signatureFieldInfo.isSignatureNeeded();
        }
        return bResult;
    }

    @Override
    public SignatureFieldInfo getSignatureFieldInfo(BOSObjectType bosType) {
        SignatureFieldInfo signatureFieldInfo = (SignatureFieldInfo)this.dao.fieldConfigMap.get(bosType.toString());
        if (signatureFieldInfo == null) {
            signatureFieldInfo = new SignatureFieldInfo();
            signatureFieldInfo.setBosType(bosType);
        }
        return signatureFieldInfo;
    }

    public SignatureFieldInfo getNumberSignatureFieldInfo(BOSObjectType bosType) {
        SignatureFieldInfo signatureFieldInfo = (SignatureFieldInfo)this.dao.numberFieldConfigMap.get(bosType.toString());
        if (signatureFieldInfo == null) {
            signatureFieldInfo = new SignatureFieldInfo();
            signatureFieldInfo.setBosType(bosType);
        }
        return signatureFieldInfo;
    }

    public Collection getSignatureFieldCollection() {
        return this.dao.fieldConfigMap.values();
    }

    @Override
    public Map getSignatureConfiguration() {
        return this.dao.fieldConfigMap;
    }

    public static void main(String[] args) {
        SignatureConfiguration config = new SignatureConfiguration();
        logger.info((Object)("config.isCanSignature() = " + config.isCanSignature()));
        logger.info((Object)config.getSignatureFieldInfo(BOSObjectType.create((String)"bostype1")));
    }

    static class ConfigDao {
        private final String FILE = "SignatureConfiguration.xml";
        private static ConfigDao dao = null;
        private Map fieldConfigMap = new HashMap();
        private Map numberFieldConfigMap = new HashMap();
        private boolean isSignatureNeeded = false;

        private ConfigDao() {
            this.initConfig();
        }

        public static ConfigDao getConfigDao() {
            dao = new ConfigDao();
            return dao;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void initConfig() {
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(this.getConfigFile()));
                Element document = XMLParser.parseXML((InputStream)inputStream).getRootElement();
                this.loadConfigurationInfo(document);
                return;
            }
            catch (IOException e) {
                logger.error((Object)PermissionResUtil.getResource("res_44"), (Throwable)e);
                return;
            }
            catch (JDOMException e) {
                logger.error((Object)PermissionResUtil.getResource("res_45"), (Throwable)e);
                return;
            }
            finally {
                try {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        inputStream = null;
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                        inputStream = null;
                    }
                }
                catch (Throwable throwable) {
                    inputStream = null;
                    throw throwable;
                }
            }
        }

        private File getConfigFile() throws IOException {
            String ctrlFilePath = new StringBuffer().append(System.getProperty("EAS_HOME")).append(File.separator).append("server").append(File.separator).append("properties").append(File.separator).append("SignatureConfiguration.xml").toString();
            File configFile = new File(ctrlFilePath);
            if (!configFile.exists()) {
                throw new IllegalArgumentException("config file not found :" + configFile.toString());
            }
            return configFile;
        }

        private void loadConfigurationInfo(Element root) {
            this.isSignatureNeeded = root.getAttribute("isSignatureNeeded") != null ? "true".equalsIgnoreCase(root.getAttribute("isSignatureNeeded").getValue()) : true;
            List childrens = root.getChildren();
            int size = childrens.size();
            for (int i = 0; i < size; ++i) {
                Element element = (Element)childrens.get(i);
                String elementName = element.getName();
                SignatureFieldInfo fieldInfo = new SignatureFieldInfo();
                String bosType = null;
                boolean isSignNeeded = true;
                boolean isSignWhenApprove = false;
                boolean isSignatureNeeded4number = true;
                String strSettleTypeFieldName = "";
                if (element.getAttribute("bosType") == null) continue;
                bosType = element.getAttribute("bosType").getValue();
                if (element.getAttribute("isSignatureNeeded") != null) {
                    isSignNeeded = "true".equals(element.getAttribute("isSignatureNeeded").getValue());
                }
                if (element.getAttribute("isSignWhenApprove") != null) {
                    isSignWhenApprove = "true".equals(element.getAttribute("isSignWhenApprove").getValue());
                }
                if (element.getAttribute("isSignatureNeeded4number") != null) {
                    isSignatureNeeded4number = "true".equals(element.getAttribute("isSignatureNeeded4number").getValue());
                }
                if (element.getAttribute("SettleTypeFieldName") != null) {
                    strSettleTypeFieldName = element.getAttribute("SettleTypeFieldName").getValue().toString();
                }
                fieldInfo.setSettleTypeFieldName(strSettleTypeFieldName);
                fieldInfo.setBosType(BOSObjectType.create((String)bosType));
                fieldInfo.setSignatureNeeded(isSignNeeded);
                fieldInfo.setSignatureWhenApprove(isSignWhenApprove);
                if ("configitem".equalsIgnoreCase(elementName)) {
                    List fields = element.getChildren();
                    int fieldSize = fields.size();
                    for (int index = 0; index < fieldSize; ++index) {
                        boolean ignoreEmptyCheck;
                        Element fieldElement = (Element)fields.get(index);
                        String fieldName = null;
                        String fieldAlias = null;
                        String decimal = null;
                        if (fieldElement.getAttribute("fieldName") == null) continue;
                        fieldName = fieldElement.getAttribute("fieldName").getValue();
                        if (fieldElement.getAttribute("fieldAlias") != null) {
                            fieldAlias = fieldElement.getAttribute("fieldAlias").getValue();
                        }
                        if (fieldElement.getAttribute("decimal") != null && (decimal = fieldElement.getAttribute("decimal").getValue()) != null && decimal.length() > 0) {
                            fieldInfo.addFieldDecimal(fieldName, decimal);
                        }
                        if (fieldElement.getAttribute("ignoreEmptyCheck") != null && (ignoreEmptyCheck = Boolean.parseBoolean(fieldElement.getAttribute("ignoreEmptyCheck").getValue()))) {
                            fieldInfo.addIgnoreErrorWheEmptyField(fieldName);
                        }
                        fieldInfo.addField(fieldName, fieldAlias);
                    }
                }
                if (fieldInfo.getBosType() == null) continue;
                this.fieldConfigMap.put(fieldInfo.getBosType().toString(), fieldInfo);
                if (!isSignatureNeeded4number) continue;
                this.numberFieldConfigMap.put(fieldInfo.getBosType().toString(), fieldInfo);
            }
        }
    }
}

