/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.app.UserAssignRoleAuthenRecordAuthen;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserAssignGrantRoleAuthenRecordAuthen
extends UserAssignRoleAuthenRecordAuthen {
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserAssignGrantRoleAuthenRecordAuthenImpl");
    private int MAX_RECORD_COUNT = 8000;

    public UserAssignGrantRoleAuthenRecordAuthen(Context ctx) {
        super(ctx);
    }

    @Override
    protected String getDescription() {
        return EASResource.getString((String)RESOURCE, (String)"AUTHEN_CREATE_TASK");
    }

    @Override
    protected ResultSet queryNeedAuthenResultSet(Connection conn, String permChangeId) throws BOSException {
        PreparedStatement queryStatement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer queryAllCanAuthenRoleInfo = new StringBuffer();
            queryAllCanAuthenRoleInfo.append("select change.froleid roleid,change.fpermchangeid fpermitemid, snapview.fisrule isrule, ").append("snapview.fuserid userid ").append("from t_pm_grantuserroleorgchange as change ").append("inner join t_pm_authenschemesnapview as snapview on change.fpermchangeid = snapview.fpermchangerecordid and change.froleid = snapview.froleid ").append("inner join t_pm_authenrecord as record on record.fpermchangeid = change.fpermchangeid and record.fauthentorid = snapview.fuserid ").append("where change.fauthenstatus = ? and ").append("record.fauthenstatus = ? and ").append("snapview.fpermchangerecordid = ?");
            queryStatement = conn.prepareStatement(queryAllCanAuthenRoleInfo.toString());
            queryStatement.setString(1, "10");
            queryStatement.setString(2, "10");
            queryStatement.setString(3, permChangeId);
            resultSet = queryStatement.executeQuery();
            return resultSet;
        }
        catch (Exception e) {
            SQLUtils.cleanup(resultSet, queryStatement);
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void updatePassData(Connection conn, Set passSet, Map information, String permChangeId) throws BOSException {
        PreparedStatement insertStatement = null;
        PreparedStatement updateStatement = null;
        try {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_grantuserroleorg(fuserid, forgid, froleid) ").append("select change.fuserid, change.forgid, change.froleid ").append("from t_pm_grantuserroleorgchange as change ").append("where change.fpermchangeid = ? and ").append("not exists (").append("select 1 ").append("from t_pm_userroleorg uro ").append("where uro.fuserid = change.fuserid and ").append("uro.forgid = change.forgid and ").append("uro.froleid = change.froleid").append(") and ").append("change.froleid = ?");
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update t_pm_grantuserroleorgchange ").append("set fauthenstatus = ? ").append("where fpermchangeid = ? and ").append("froleid = ?");
            insertStatement = conn.prepareStatement(insertSql.toString());
            updateStatement = conn.prepareStatement(updateSql.toString());
            int count = 0;
            for (Object roleIdObject : passSet) {
                insertStatement.setString(1, permChangeId);
                insertStatement.setObject(2, roleIdObject);
                insertStatement.addBatch();
                updateStatement.setString(1, "20");
                updateStatement.setString(2, permChangeId);
                updateStatement.setObject(3, roleIdObject);
                updateStatement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                insertStatement.executeBatch();
                insertStatement.clearBatch();
                updateStatement.executeBatch();
                updateStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                insertStatement.executeBatch();
                insertStatement.clearBatch();
                updateStatement.executeBatch();
                updateStatement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertStatement);
                SQLUtils.cleanup(updateStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertStatement);
        SQLUtils.cleanup((Statement)updateStatement);
    }

    @Override
    protected void updateNoPassData(Connection conn, Set noPassSet, Map information, String permChangeId) throws BOSException {
        PreparedStatement updateAuthenStatusStatement = null;
        try {
            StringBuffer updateAuthenStatusSql = new StringBuffer();
            updateAuthenStatusSql.append("update t_pm_grantuserroleorgchange ").append("set fauthenstatus = ? ").append("where fpermchangeid = ? and ").append("froleid = ?");
            updateAuthenStatusStatement = conn.prepareStatement(updateAuthenStatusSql.toString());
            int count = 0;
            for (Object roleIdObj : noPassSet) {
                updateAuthenStatusStatement.setString(1, "30");
                updateAuthenStatusStatement.setString(2, permChangeId);
                updateAuthenStatusStatement.setObject(3, roleIdObj);
                updateAuthenStatusStatement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateAuthenStatusStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateAuthenStatusStatement);
    }
}

