/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.ErpUserStatusEnum;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.ILicenseSrv;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUsageInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.LoginAndLogout;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.AssembleCloudUserTypeEnum;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgMovePermissionInfo;
import com.kingdee.eas.base.permission.OrgMovePermissionParam;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLicenseGroupInfo;
import com.kingdee.eas.base.permission.UserMapEasXtInfo;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.AbstractUserFacadeControllerBean;
import com.kingdee.eas.base.permission.app.SyncUserResultInfo;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.base.permission.app.util.interior.ILicenseUseSrv;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupsInfo;
import com.kingdee.eas.base.permission.ldap.LdapProxy;
import com.kingdee.eas.base.permission.mutex.SynMutex;
import com.kingdee.eas.base.permission.service.UserLicenseGroupServiceFactory;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.UserInfoHelper;
import com.kingdee.eas.base.permission.util.cloud.SynShrUserToCloudUtils;
import com.kingdee.eas.base.permission.util.cloud.SynUserToCloudHelper;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.permission.util.cloud.kbc.CloudLicenseUtil;
import com.kingdee.eas.base.permission.util.file.LicenseSyncSrvFactory;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgMoveParam;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.util.CloudActiveParamsUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserFacadeControllerBean
extends AbstractUserFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    boolean isPersonToManyUser = false;
    RoleCollection roleCol = null;
    int successCount = 0;
    volatile int totalCount = 0;
    private String licenseFilePath = null;

    @Override
    protected void _forbidUsers(Context ctx, IObjectPK[] users, boolean forbidden) throws BOSException, EASBizException {
        UserFactory.getLocalInstance(ctx).forbidUsers(users, forbidden);
    }

    @Override
    protected UserInfo _getUserInfo4LoinModule(Context ctx, String userNumber) throws BOSException, EASBizException {
        return UserInfoUtils.getUserInfo4LoinModule(ctx, userNumber);
    }

    @Override
    protected boolean _isAuthenticateAdminEnabled(Context ctx) throws BOSException, EASBizException {
        return PermissionCommonUtil.isAuthenticateAdminEnabled(ctx);
    }

    @Override
    protected boolean _isMachineRegisterEnabled(Context ctx) throws BOSException, EASBizException {
        return PermissionCommonUtil.isMachineRegisterEnabled(ctx);
    }

    @Override
    protected OrgMovePermissionInfo _getOrgMovePermissionInfo(Context ctx, OrgMoveParam orgMoveParam) throws BOSException, EASBizException {
        OrgMovePermissionInfo info = new OrgMovePermissionInfo();
        try {
            List<UserInfo> shiftUserList = this.getShiftUserList(ctx, orgMoveParam);
            List<UserInfo> stayUserList = this.getStayUserList(ctx, orgMoveParam);
            info.setShiftUserList(shiftUserList);
            info.setStayUserList(stayUserList);
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        return info;
    }

    private List<UserInfo> getShiftUserList(Context ctx, OrgMoveParam orgMoveParam) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder().append("select a.fuserid ").append(" from t_pm_orgrange a join t_pm_user b on a.fuserid=b.fid ").append("join t_org_baseunit c on a.forgid=c.fid ").append(" where a.ftype=10 and b.fcontrolunitid=? ").append(" and (c.flongnumber like ? or c.flongnumber =?)");
        FullOrgUnitInfo movedOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgMoveParam.getMovedOrgId()));
        Object[] params = new Object[]{orgMoveParam.getOldCuId(), movedOrg.getLongNumber() + "!%", movedOrg.getLongNumber()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        HashSet<String> userIdSet = new HashSet<String>();
        while (rs.next()) {
            userIdSet.add(rs.getString("fuserid"));
        }
        return this.getUserList(ctx, userIdSet);
    }

    private List<UserInfo> getStayUserList(Context ctx, OrgMoveParam orgMoveParam) throws BOSException, SQLException, EASBizException {
        String movedOrgId = orgMoveParam.getMovedOrgId();
        String sql = "select distinct fuserid from t_pm_orgrange a  join t_org_baseunit b on a.forgid=b.fid  where a.ftype=10 and ( b.flongnumber like ? or b.flongnumber =?)";
        FullOrgUnitInfo movedOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(movedOrgId));
        Object[] params = new Object[]{movedOrg.getLongNumber() + "!%", movedOrg.getLongNumber()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        ArrayList<String> userIdList = new ArrayList<String>();
        while (rs.next()) {
            userIdList.add(rs.getString("fuserid"));
        }
        return this.getUserList(ctx, userIdList);
    }

    private List<UserInfo> getUserList(Context ctx, Collection<String> userIdList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo userIdItemInfo = new FilterItemInfo("id", (Object)ToolUtils.aryToStr(userIdList), CompareType.INNER);
        filter.getFilterItems().add(userIdItemInfo);
        view.setFilter(filter);
        view.setSelector(this.getUserSelectors());
        UserCollection userCol = UserFactory.getLocalInstance(ctx).getUserCollection(view);
        ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
        int size = userCol.size();
        for (int i = 0; i < size; ++i) {
            UserInfo userInfo = userCol.get(i);
            userList.add(userInfo);
        }
        return userList;
    }

    private SelectorItemCollection getUserSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("defOrgUnit.id"));
        selectors.add(new SelectorItemInfo("defOrgUnit.name"));
        selectors.add(new SelectorItemInfo("CU.id"));
        selectors.add(new SelectorItemInfo("CU.name"));
        return selectors;
    }

    @Override
    protected void _executeOrgMovePermissionTask(Context ctx, OrgMovePermissionParam orgMovePermissionParam) throws BOSException, EASBizException {
        this.handleShiftUsers(ctx, orgMovePermissionParam);
        this.handleShiftAndDeletePerm(ctx, orgMovePermissionParam);
        this.handleStayUsers(ctx, orgMovePermissionParam);
    }

    private void handleShiftAndDeletePerm(Context ctx, OrgMovePermissionParam orgMovePermissionParam) throws EASBizException, BOSException {
        List<String> shiftAndDeletePermUserList = orgMovePermissionParam.getShiftAndDeleteCuPermUserList();
        if (shiftAndDeletePermUserList == null || shiftAndDeletePermUserList.size() <= 0) {
            return;
        }
        this.deleteRelation(ctx, shiftAndDeletePermUserList, orgMovePermissionParam.getOrgMoveParam().getOldCuId());
        try {
            this.handleDefOrgUnitDeleted(ctx, shiftAndDeletePermUserList, orgMovePermissionParam.getOrgMoveParam().getNewCuId());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void handleDefOrgUnitDeleted(Context ctx, List<String> deletePermUserIdList, String newDefOrgUnitId) throws BOSException, SQLException {
        List<String> defOrgUserDeletedUserIdList = this.getDefUnitOrgDeletedUserIdList(ctx, deletePermUserIdList);
        String orgRangeInsertSql = "insert into t_pm_orgrange(fid,forgid,fuserid,ftype)  select newbosid('FD3DC16D'),?,fid,10 from t_pm_user u where  fid in (" + ToolUtils.aryToStr(defOrgUserDeletedUserIdList) + ") and not exists (select 1 from t_pm_orgrange where fuserid=u.fid and ftype=10 and forgid=?)";
        String orgRangeIncludeSubInsertSql = "insert into t_pm_orgrangeincludesuborg(fid,forgid,fuserid,ftype,FIsIncludeSubOrg)  select newbosid('4DC3DADF'),?,fid,10,0 from t_pm_user u where fid in (" + ToolUtils.aryToStr(defOrgUserDeletedUserIdList) + ")  and not exists (select 1 from t_pm_orgrangeincludesuborg where fuserid=u.fid and ftype=10 and forgid=?)";
        Object[] params = new Object[]{newDefOrgUnitId, newDefOrgUnitId};
        DbUtil.execute((Context)ctx, (String)orgRangeInsertSql, (Object[])params);
        DbUtil.execute((Context)ctx, (String)orgRangeIncludeSubInsertSql, (Object[])params);
        String updateDefOrgUnitSql = "update t_pm_user set FDefOrgUnitID=? where  fid in (" + ToolUtils.aryToStr(defOrgUserDeletedUserIdList) + ")";
        params = new Object[]{newDefOrgUnitId};
        DbUtil.execute((Context)ctx, (String)updateDefOrgUnitSql, (Object[])params);
    }

    private List<String> getDefUnitOrgDeletedUserIdList(Context ctx, List<String> deletePermUserIdList) throws BOSException, SQLException {
        String sql = "select a.fid from t_pm_user a left join (select * from t_pm_orgrange where ftype=10) b on a.fid=b.fuserid and a.fdeforgunitid=b.forgid  where b.fid is null and a.fid in (" + ToolUtils.aryToStr(deletePermUserIdList) + ")";
        ArrayList<String> ret = new ArrayList<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            ret.add(rs.getString("fid"));
        }
        return ret;
    }

    private void handleShiftUsers(Context ctx, OrgMovePermissionParam orgMovePermissionParam) throws BOSException, EASBizException {
        List<String> shiftUserList = orgMovePermissionParam.getShiftUserList();
        if (shiftUserList.size() <= 0) {
            return;
        }
        this.changeCu(ctx, orgMovePermissionParam);
    }

    private void handleStayUsers(Context ctx, OrgMovePermissionParam orgMovePermissionParam) throws BOSException, EASBizException {
        List<String> stayUserList = orgMovePermissionParam.getStayUserList();
        if (stayUserList.size() <= 0) {
            return;
        }
        this.deleteRelation(ctx, stayUserList, orgMovePermissionParam.getOrgMoveParam().getMovedOrgId());
        try {
            this.handleDefOrgUnitDeleted(ctx, stayUserList, orgMovePermissionParam.getOrgMoveParam().getOldCuId());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void changeCu(Context ctx, OrgMovePermissionParam orgMovePermissionParam) throws BOSException {
        List<String> changeCuUserIdList = orgMovePermissionParam.getShiftUserList();
        String sql = "update t_pm_user set FControlUnitID=? where fid in (" + ToolUtils.aryToStr(changeCuUserIdList) + ")";
        Object[] params = new Object[]{orgMovePermissionParam.getOrgMoveParam().getNewCuId()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void deleteRelation(Context ctx, List<String> toDeleteUserIdList, String orgId) throws EASBizException, BOSException {
        FullOrgUnitInfo movedOrgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        this.deleteOrgRange(ctx, toDeleteUserIdList, movedOrgInfo);
        this.deleteUserOrgPerm(ctx, toDeleteUserIdList, movedOrgInfo);
        this.deleteUserOrgRole(ctx, toDeleteUserIdList, movedOrgInfo);
    }

    private void deleteOrgRange(Context ctx, List<String> toDeleteUserIdList, FullOrgUnitInfo movedOrgInfo) throws EASBizException, BOSException {
        if (toDeleteUserIdList.size() <= 0) {
            return;
        }
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        FilterInfo orgFilter = this.getOrgFilter(movedOrgInfo, "org.id");
        FilterItemInfo userFilterItem = new FilterItemInfo("user.id", (Object)ToolUtils.aryToStr(toDeleteUserIdList), CompareType.INNER);
        FilterItemInfo orgRangeTypeFilterItem = new FilterItemInfo("type", (Object)10, CompareType.EQUALS);
        filter.getFilterItems().add(orgRangeTypeFilterItem);
        filter.getFilterItems().add(userFilterItem);
        filter.mergeFilter(orgFilter, "AND");
        iOrgRange.delete(filter);
        OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx).delete(filter);
    }

    private void deleteUserOrgPerm(Context ctx, List<String> toDeleteUserIdList, FullOrgUnitInfo movedOrgInfo) throws EASBizException, BOSException {
        if (toDeleteUserIdList.size() <= 0) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo userFilterInfo = new FilterItemInfo("owner.id", (Object)ToolUtils.aryToStr(toDeleteUserIdList), CompareType.INNER);
        filter.getFilterItems().add(userFilterInfo);
        FilterInfo orgFilter = this.getOrgFilter(movedOrgInfo, "org.id");
        filter.mergeFilter(orgFilter, "AND");
        UserOrgPermFactory.getLocalInstance(ctx).delete(filter);
    }

    private void deleteUserOrgRole(Context ctx, List<String> toDeleteUserIdList, FullOrgUnitInfo movedOrgInfo) throws EASBizException, BOSException {
        if (toDeleteUserIdList.size() <= 0) {
            return;
        }
        String sql = "delete from t_pm_userroleorg where fuserid in (" + ToolUtils.aryToStr(toDeleteUserIdList) + ") and  ( forgid =? or forgid in (select fid from t_org_baseunit where flongnumber like ?))";
        Object[] params = new Object[]{movedOrgInfo.getId().toString(), movedOrgInfo.getLongNumber() + "!%"};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private FilterInfo getOrgFilter(FullOrgUnitInfo orgInfo, String orgField) {
        FilterInfo orgFilter = new FilterInfo();
        FilterItemInfo orgFilterItem = new FilterItemInfo(orgField, (Object)orgInfo.getId(), CompareType.EQUALS);
        FilterItemInfo subFilterItem = new FilterItemInfo(orgField, (Object)("select fid from t_org_baseunit where flongnumber like '" + orgInfo.getLongNumber() + "!%'"), CompareType.INNER);
        orgFilter.getFilterItems().add(orgFilterItem);
        orgFilter.getFilterItems().add(subFilterItem);
        orgFilter.setMaskString("#0 or #1");
        return orgFilter;
    }

    private RoleCollection getRoleByIsDefRole(Context ctx, boolean isDefRole) throws BOSException {
        IRole iRole = RoleFactory.getLocalInstance(ctx);
        String oql = " WHERE isDefRole=" + (isDefRole ? 1 : 0);
        RoleCollection role = iRole.getRoleCollection(oql);
        return role;
    }

    private boolean isPersonCanReferenceManyUser(Context ctx) throws BOSException, EASBizException {
        String paramNumber = "PersonCanReferenceManyUser";
        String value = ParamManager.getParamValue((Context)ctx, null, (String)paramNumber);
        return "true".equalsIgnoreCase(value);
    }

    @Override
    protected String _importUserFromCloud(Context ctx, String userArrayStr) throws BOSException, EASBizException {
        return "1";
    }

    private Map<String, SyncUserResultInfo> getSyncUserResultMap(List<JSONArray> userArrays) {
        HashMap<String, SyncUserResultInfo> SyncUserResults = new HashMap<String, SyncUserResultInfo>();
        for (int i = 0; i < userArrays.size(); ++i) {
            JSONArray userArray = userArrays.get(i);
            if (userArray == null) continue;
            for (int j = 0; j < userArray.size(); ++j) {
                JSONObject object = (JSONObject)userArray.get(i);
                SyncUserResultInfo syncUserResultInfo = new SyncUserResultInfo();
                String userNumber = object.getString("erpNumber");
                syncUserResultInfo.setNumber(userNumber);
                syncUserResultInfo.setUid(object.getString("uid"));
                syncUserResultInfo.setCell(object.getString("phone"));
                SyncUserResults.put(userNumber, syncUserResultInfo);
            }
        }
        return SyncUserResults;
    }

    private Map<String, UserInfo> getSynUserMap(Context ctx, JSONArray userArray) {
        HashMap<String, UserInfo> synUserMap = new HashMap<String, UserInfo>();
        if (userArray == null || userArray.size() == 0) {
            return null;
        }
        HashMap<String, JSONObject> userMap = new HashMap<String, JSONObject>(512);
        for (int i = 0; i < userArray.size(); ++i) {
            JSONObject o = (JSONObject)userArray.get(i);
            String userNumber = (String)o.get((Object)"erpNumber");
            if (StringUtils.isEmpty((String)userNumber) || userMap.containsKey(userNumber)) continue;
            userMap.put(userNumber, o);
        }
        Set<String> userNumberSet = userMap.keySet();
        String userSql = "select lower(fnumber),fid from t_pm_user where lower(FNUMBER) in ";
        Map<String, String> userInDBMap = null;
        try {
            userInDBMap = this.getDataInDB(ctx, userSql, userNumberSet);
        }
        catch (Exception e) {
            logger.error((Object)"userInDBMap error{}", (Throwable)e);
        }
        Set<Map.Entry<String, String>> entrySet = userInDBMap.entrySet();
        for (Map.Entry<String, String> userIdEntry : entrySet) {
            JSONObject o = (JSONObject)userMap.get(userIdEntry.getKey());
            if (o == null) continue;
            String userNumber = (String)o.get((Object)"erpNumber");
            String userName = (String)o.get((Object)"cloudName");
            String uid = (String)o.get((Object)"uid");
            synUserMap.put(userNumber, this.createUserInfoExtra(userNumber, userName, uid));
        }
        return synUserMap;
    }

    private UserInfo createUserInfoExtra(String userNumber, String userName, String uid) {
        UserInfo userInfo = UserInfoHelper.createNewDefaultUserInfo();
        userInfo.setNumber(userNumber);
        userInfo.setName(userName);
        if (uid != null && uid.trim().length() > 0) {
            userInfo.setUid(uid);
        }
        return userInfo;
    }

    private synchronized void addSuccessCount() {
        ++this.successCount;
    }

    private synchronized void addTotalCount() {
        ++this.totalCount;
    }

    private Map<String, PersonInfo> getPersonInDB(Context ctx, String sql, Set<String> filterSet) throws BOSException {
        if (filterSet == null || filterSet.size() == 0) {
            return null;
        }
        HashMap<String, PersonInfo> dataMap = new HashMap<String, PersonInfo>(512);
        StringBuffer filterSb = new StringBuffer();
        IRowSet rs = null;
        for (String filter : filterSet) {
            filterSb.append("'").append(filter.toLowerCase()).append("'");
            filterSb.append(",");
        }
        filterSb.deleteCharAt(filterSb.length() - 1);
        StringBuffer sbSql = new StringBuffer(sql);
        sbSql.append(" (").append(filterSb).append(")");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
            while (rs.next()) {
                String number = rs.getString("number");
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)rs.getString("id")));
                person.setEmail(rs.getString("email"));
                person.setBackupEMail(rs.getString("backupemail"));
                person.setOfficePhone(rs.getString("officephone"));
                person.setHomePhone(rs.getString("homephone"));
                dataMap.put(number, person);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return dataMap;
    }

    private Map<String, String> getDataInDB(Context ctx, String sql, Set<String> filterSet) throws BOSException {
        if (filterSet == null || filterSet.size() == 0) {
            return null;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(512);
        StringBuffer filterSb = new StringBuffer();
        IRowSet rs = null;
        for (String filter : filterSet) {
            filterSb.append("'").append(filter.toLowerCase()).append("'");
            filterSb.append(",");
        }
        filterSb.deleteCharAt(filterSb.length() - 1);
        StringBuffer sbSql = new StringBuffer(sql);
        sbSql.append(" (").append(filterSb).append(")");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
            while (rs.next()) {
                dataMap.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return dataMap;
    }

    private List<UserInfo> getSynUserList(Context ctx, JSONArray userArray) {
        ArrayList<UserInfo> userInfoList = new ArrayList<UserInfo>();
        try {
            if (userArray == null || userArray.size() == 0) {
                return null;
            }
            HashMap<String, JSONObject> userMap = new HashMap<String, JSONObject>(512);
            for (int i = 0; i < userArray.size(); ++i) {
                JSONObject o = (JSONObject)userArray.get(i);
                String userNumber = (String)o.get((Object)"erpNumber");
                if (StringUtils.isEmpty((String)userNumber) || userMap.containsKey(userNumber)) continue;
                userMap.put(userNumber, o);
            }
            Set<String> userNumberSet = userMap.keySet();
            String userSql = "select lower(fnumber),fid from t_pm_user where lower(FNUMBER) in ";
            Map<String, String> userInDBMap = this.getDataInDB(ctx, userSql, userNumberSet);
            for (JSONObject o : userMap.values()) {
                String userNumber = (String)o.get((Object)"erpNumber");
                String userName = (String)o.get((Object)"cloudName");
                String phone = (String)o.get((Object)"phone");
                String fuid = (String)o.get((Object)"uid");
                PersonInfo person = null;
                String deptId = "00000000-0000-0000-0000-000000000000CCE7AED4";
                String cuId = "00000000-0000-0000-0000-000000000000CCE7AED4";
                userInfoList.add(this.createUserInfo(userInDBMap.get(userNumber), userNumber, userName, phone, person, deptId, cuId, fuid));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return userInfoList;
    }

    private List<UserInfo> getAddUserList(Context ctx, JSONArray userArray) {
        ArrayList<UserInfo> userInfoList = new ArrayList<UserInfo>();
        try {
            if (userArray == null || userArray.size() == 0) {
                return null;
            }
            HashMap<String, JSONObject> userMap = new HashMap<String, JSONObject>(512);
            HashSet<String> personNumberSet = new HashSet<String>(512);
            HashSet<String> deptNameSet = new HashSet<String>(512);
            for (int i = 0; i < userArray.size(); ++i) {
                String dept;
                JSONObject o = (JSONObject)userArray.get(i);
                String userNumber = (String)o.get((Object)"erpNumber");
                String personNumber = (String)o.get((Object)"erpStaffNumber");
                if (StringUtils.isEmpty((String)userNumber) || userMap.containsKey(userNumber) || !this.isPersonToManyUser && personNumberSet.contains(personNumber)) continue;
                userMap.put(userNumber, o);
                if (!StringUtils.isEmpty((String)personNumber)) {
                    personNumberSet.add(personNumber);
                }
                if (StringUtils.isEmpty((String)(dept = (String)o.get((Object)"dept")))) continue;
                deptNameSet.add(dept);
            }
            Set<String> userNumberSet = userMap.keySet();
            String userSql = "select lower(fnumber),fid from t_pm_user where lower(FNUMBER) in ";
            String personSql = "select lower(fnumber),fid,femail,fbackupemail ,fofficephone,fhomephone from t_bd_person where lower(FNUMBER) in ";
            String deptSql = "select fname_l2,fid||'##'||FCONTROLUNITID from t_org_baseunit where FName_l2 in ";
            Map<String, String> userInDBMap = this.getDataInDB(ctx, userSql, userNumberSet);
            Map<String, PersonInfo> personInDBMap = this.getPersonInDB(ctx, personSql, personNumberSet);
            Map<String, String> deptInDBMap = this.getDataInDB(ctx, deptSql, deptNameSet);
            for (JSONObject o : userMap.values()) {
                String userNumber = (String)o.get((Object)"erpNumber");
                String userName = (String)o.get((Object)"cloudName");
                String personNumber = (String)o.get((Object)"erpStaffNumber");
                String dept = (String)o.get((Object)"dept");
                String phone = (String)o.get((Object)"phone");
                PersonInfo person = null;
                String deptId = "00000000-0000-0000-0000-000000000000CCE7AED4";
                String cuId = "00000000-0000-0000-0000-000000000000CCE7AED4";
                String fuid = (String)o.get((Object)"uid");
                if (userInDBMap != null && !userInDBMap.isEmpty() && userInDBMap.containsKey(userNumber)) continue;
                if (personInDBMap != null && !personInDBMap.isEmpty() && personInDBMap.containsKey(personNumber)) {
                    person = personInDBMap.get(personNumber);
                }
                if (deptInDBMap != null && !deptInDBMap.isEmpty() && deptInDBMap.containsKey(dept)) {
                    String dept_cu = deptInDBMap.get(dept);
                    String[] dept_cuArray = dept_cu.split("##");
                    deptId = dept_cuArray[0];
                    cuId = dept_cuArray[1];
                }
                userInfoList.add(this.createUserInfo(userNumber, userName, phone, person, deptId, cuId, fuid));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return userInfoList;
    }

    private UserInfo createUserInfo(String fid, String userNumber, String userName, String phone, PersonInfo person, String deptId, String cuId) {
        return this.createUserInfo(fid, userNumber, userName, phone, person, deptId, cuId, null);
    }

    private UserInfo createUserInfo(String fid, String userNumber, String userName, String phone, PersonInfo person, String deptId, String cuId, String fuid) {
        UserInfo pmUserInfo = UserInfoHelper.createNewDefaultUserInfo();
        BOSUuid userID = null;
        userID = fid == null || fid.trim().length() <= 0 ? BOSUuid.create((String)"13B7DE7F") : BOSUuid.read((String)fid);
        pmUserInfo.setId(userID);
        pmUserInfo.setCell(phone);
        pmUserInfo.setChangedPW(true);
        pmUserInfo.setNumber(userNumber);
        SecurityInfo securityInfo = new SecurityInfo();
        securityInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000013EE2C673"));
        pmUserInfo.setSecurity(securityInfo);
        pmUserInfo.setName(userName);
        pmUserInfo.setPassword(null);
        pmUserInfo.setPwdHisStr(null);
        if (fuid != null && fuid.trim().length() > 0) {
            pmUserInfo.setUid(fuid);
        }
        if (person == null) {
            pmUserInfo.setPerson(null);
            pmUserInfo.setType(UserType.OTHER);
        } else {
            pmUserInfo.setPerson(person);
            pmUserInfo.setEmail(person.getEmail());
            pmUserInfo.setBackupEMail(person.getBackupEMail());
            pmUserInfo.setHomePhone(person.getHomePhone());
            pmUserInfo.setOfficePhone(person.getOfficePhone());
        }
        FullOrgUnitInfo org = new FullOrgUnitInfo();
        org.setId(BOSUuid.read((String)deptId));
        pmUserInfo.setDefOrgUnit(org);
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)cuId));
        pmUserInfo.setCU(cu);
        return pmUserInfo;
    }

    private UserInfo createUserInfo(String userNumber, String userName, String phone, PersonInfo person, String deptId, String cuId, String fuid) {
        return this.createUserInfo(null, userNumber, userName, phone, person, deptId, cuId, fuid);
    }

    @Override
    protected void _resetPass(Context ctx, String userId, String password) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("security.*"));
        UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId), sc);
        if (userInfo.getSecurity() == null) {
            throw new UserException(UserException.USER_NOT_SECURITY);
        }
        if (StringUtils.isEmpty((String)password)) {
            password = "";
        }
        userInfo.setPassword(password);
        try {
            ErpUserStatusEnum statu = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getErpUserStatus(userInfo.getNumber(), userInfo.getCell(), userInfo.getEmail());
            if (!ErpUserStatusEnum.NOT_ACTIVATED.equals((Object)statu)) {
                SecurityValidator securityValidator = new SecurityValidator(ctx, userInfo);
                securityValidator.validate();
            }
        }
        catch (LicenseException e) {
            throw new BOSException((Throwable)e);
        }
        if (StringUtils.isEmpty((String)userInfo.getPassword())) {
            userInfo.setPassword(null);
        } else {
            PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
            userInfo.setPassword(PermissionUtil.encrypt(userId, password, passwordType));
            userInfo.setPasswordType(passwordType);
        }
        userInfo.setPWEffectiveDate(new Date());
        userInfo.setChangedPW(true);
        iUser.update((IObjectPK)new ObjectUuidPK(userId), (CoreBaseInfo)userInfo);
        try {
            if (ControlPolicy.isBySubscriptionRegOnline((Context)ctx)) {
                CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).addActivedErpUser(userInfo.getNumber(), userInfo.getCell(), userInfo.getEmail());
            } else {
                CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).addActivedErpUser(userInfo.getNumber());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(userId, password);
    }

    @Override
    protected String _syncUserToCloud(Context ctx, List synUserList) throws BOSException, EASBizException {
        return SynShrUserToCloudUtils.syncShrUserToCloud(ctx, synUserList);
    }

    @Override
    protected List _assembleCloudUserInfo(Context ctx) throws BOSException, EASBizException {
        return GroupLicenseUseInfoUtil.getAssembleCloudUserInfo(ctx);
    }

    @Override
    protected List _assembleUserCloudInfoByType(Context ctx, int type) throws BOSException, EASBizException {
        if (2 == type) {
            return GroupLicenseUseInfoUtil.getAssembleCloudUserInfoNotIncludeGroups(ctx);
        }
        if (1 == type) {
            return GroupLicenseUseInfoUtil.getAssembleCloudUserInfoAll(ctx);
        }
        throw new BOSException("type is error!");
    }

    @Override
    protected List _assembleDisableCloudUserInfo(Context ctx) throws BOSException, EASBizException {
        String sql = SynUserToCloudHelper.assembleCloudDisableUserInfoByPageSql(ctx);
        return SynUserToCloudHelper.doAssembleCloudUserInfoByPage(ctx, sql);
    }

    @Override
    protected List _assembleEnableCloudUserInfo(Context ctx) throws BOSException, EASBizException {
        String sql = SynUserToCloudHelper.assembleCloudEnableUserInfoByPageSql(ctx);
        return SynUserToCloudHelper.doAssembleCloudUserInfoByPage(ctx, sql);
    }

    @Override
    protected String _getPagingSqlNoOptmize(Context ctx, String sourceSql, int start, int end) throws BOSException, EASBizException {
        PagingHelper pageHelper = new PagingHelper();
        return pageHelper.getPagingSqlNoOptmize(ctx, sourceSql, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _autoSynUserToCloud(Context ctx) throws BOSException, EASBizException {
        String result = EASResource.getString((String)RESOURCE, (String)"bgtransaction_faild");
        SynMutex synMutex = new SynMutex(ctx, ctx.getCaller());
        if (!synMutex.request()) {
            return EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale()) + " " + EASCommonResource.getString((String)RESOURCE, (String)"synMutexWarrning", (Locale)ctx.getLocale());
        }
        try {
            int licenseType;
            List synUserList = new ArrayList();
            try {
                licenseType = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo().getLicenseType();
            }
            catch (Exception e) {
                logger.error((Object)"get licenseType failed");
                throw new BOSException((Throwable)e);
            }
            synUserList = 2 == licenseType ? this._assembleUserCloudInfoByType(ctx, 2) : this._assembleCloudUserInfo(ctx);
            String res = SynShrUserToCloudUtils.syncShrUserToCloud(ctx, synUserList);
            if (res.toLowerCase().contains("access denied")) {
                String string = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale()) + " access denied!" + EASCommonResource.getString((String)RESOURCE, (String)"synInfoTip", (Locale)ctx.getLocale());
                return string;
            }
            if (0 != Integer.parseInt(SynShrUserToCloudUtils.getReturnErrcode(res))) {
                String string = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale()) + " " + SynShrUserToCloudUtils.getReturnErrcode(res);
                return string;
            }
            List<JSONObject> synResult = SynUserToCloudHelper.getSyncResultList(ctx);
            boolean isDownLoadFileSuccess = false;
            try {
                isDownLoadFileSuccess = this.downloadLicenseFile(ctx);
            }
            catch (Exception e1) {
                logger.error((Object)"permission.UserFacadeControllerBean._autoSynUserToCloud.downloadLicenseFile", (Throwable)e1);
                String string = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale()) + EASCommonResource.getString((String)RESOURCE, (String)"download_failed", (Locale)ctx.getLocale()) + e1;
                synMutex.release();
                return string;
            }
            if (!isDownLoadFileSuccess) {
                String e1 = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale()) + EASCommonResource.getString((String)RESOURCE, (String)"download_failed", (Locale)ctx.getLocale());
                return e1;
            }
            long current = System.currentTimeMillis();
            String fileId = String.valueOf(current);
            this.uploadLicenseFile(ctx, fileId);
            try {
                result = CloudRegistSrvAgentFactory.getLocalInstanceWithContext((Context)ctx).getRebelLicenseStatus(fileId);
            }
            catch (LicenseException e) {
                logger.error((Object)"permission.UserFacadeControllerBean._autoSynUserToCloud.getRebelLicenseStatus", (Throwable)e);
                String string = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale()) + ": " + (Object)((Object)e);
                synMutex.release();
                return string;
            }
            JSONObject o = JSONObject.parseObject((String)result);
            boolean success = o.getBoolean("success");
            if (!success) {
                logger.error((Object)("permission.UserFacadeControllerBean._autoSynUserToCloud.getRebelLicenseStatus" + o.getString("msg")));
                String string = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale());
                return string;
            }
            result = this._synResultUpdateToERP(ctx, synUserList);
            JSONObject o1 = JSONObject.parseObject((String)result);
            boolean success1 = o1.getBoolean("success");
            if (success1) {
                this._rebulidLicGroupUsageInfo(ctx);
                this._addSyncResultView(ctx, Integer.parseInt("0"), synUserList, synResult);
                String string = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_success", (Locale)ctx.getLocale());
                return string;
            }
            logger.error((Object)("permission.UserFacadeControllerBean._autoSynUserToCloud._synResultUpdateToERP" + o1.getString("error")));
            String string = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale());
            return string;
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            String string = EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale()) + " access denied!" + EASCommonResource.getString((String)RESOURCE, (String)"synInfoTip", (Locale)ctx.getLocale());
            return string;
        }
        finally {
            synMutex.release();
        }
    }

    private boolean downloadLicenseFile(Context ctx) throws Exception {
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            String prod_inst_code = baseInfo.getProductInstanceID();
            File file = File.createTempFile(System.currentTimeMillis() + "", ".zip");
            System.out.println("path=" + file.getPath());
            if (2 == baseInfo.getLicenseType()) {
                EasCloud.downloadLicenseKBC((String)prod_inst_code, (String)file.getPath());
            } else {
                EasCloud.downloadLicense((String)prod_inst_code, (String)file.getPath());
            }
            System.out.println("******download over***");
            this.licenseFilePath = file.getPath();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    private void uploadLicenseFile(Context ctx, String fileId) throws BOSException {
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(this.licenseFilePath));
            int position = 0;
            int readSize = 0x500000;
            int totalSize = input.available();
            readSize = readSize < totalSize ? readSize : totalSize;
            ICloudRegistSrv irs = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            while (position < totalSize) {
                byte[] bf = new byte[readSize];
                input.read(bf, 0, readSize);
                irs.uploadCloudLicenseFile(fileId, bf);
                readSize = totalSize - (position += readSize) < readSize ? totalSize - position : readSize;
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2);
                }
            }
        }
    }

    private List<String> getUserGroupListByUserorgperm(Context ctx, String userId) throws BOSException {
        ArrayList<String> lsUserGroup = new ArrayList<String>();
        String sqlUserorgperm = "select distinct pgm.fgroupnumber,pgm.fgroupName_l2 from t_pm_userorgperm up  inner join T_PM_PermItem pi on pi.fid = up.fpermitemid  inner join " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " pgm on pgm.FPERMITEMID= pi.fid  where up.fowner = '" + userId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlUserorgperm);
        try {
            while (rs.next()) {
                String group = rs.getString(1) + ";" + rs.getString(2);
                lsUserGroup.add(group);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lsUserGroup;
    }

    private List<String> getUserGroupListByUserroleorg(Context ctx, String userId) throws BOSException {
        ArrayList<String> lsUserGroup = new ArrayList<String>();
        String sqluserroleorg = "select distinct pgm.fgroupnumber,pgm.fgroupName_l2 from t_pm_userroleorg uroleorg  inner join t_pm_role urole on urole.fid = uroleorg.FRoleID   inner join t_pm_roleperm rp on rp.FRoleID = urole.fid   inner join T_PM_PermItem pi on pi.fid = rp.fpermitemid   inner join " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " pgm on pgm.FPERMITEMID= pi.fid  where uroleorg.fuserId ='" + userId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqluserroleorg);
        try {
            while (rs.next()) {
                String group = rs.getString(1) + ";" + rs.getString(2);
                lsUserGroup.add(group);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lsUserGroup;
    }

    @Override
    protected List _getUserGroupList(Context ctx, String userId) throws BOSException, EASBizException {
        UserLicenseGroupsInfo userLicGroups = UserLicenseGroupTool.getUserLicenseGroups(ctx, userId);
        List<UserLicenseGroupInfoEx> lsGroupInfoEx = userLicGroups.getLsLicGroups();
        if (lsGroupInfoEx == null) {
            return null;
        }
        ArrayList<UserLicenseGroupInfo> lsGroupInfo = new ArrayList<UserLicenseGroupInfo>();
        Map<String, String> moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(ctx);
        int size = lsGroupInfoEx.size();
        for (int i = 0; i < size; ++i) {
            String licenseGroupName = moduleAliasMap.get(lsGroupInfoEx.get(i).getGroupNumber());
            if (licenseGroupName == null) continue;
            lsGroupInfoEx.get(i).setName(licenseGroupName);
            lsGroupInfo.add(lsGroupInfoEx.get(i).getUserLicenseGroupInfo());
        }
        return lsGroupInfo;
    }

    @Override
    protected List _getUserChangeLog(Context ctx, List ids) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getUserGroupSynInfo(Context ctx, String userId) throws BOSException, EASBizException {
        Map mpUserGroupSynInfo = GroupLicenseUseInfoUtil.getUserGroupDiffInfo(ctx, userId);
        return mpUserGroupSynInfo;
    }

    @Override
    protected List _getLicenseGroup(Context ctx) throws BOSException {
        ArrayList<LicenseUsageInfo> lsLicenseUsageInfo = new ArrayList<LicenseUsageInfo>();
        try {
            lsLicenseUsageInfo.addAll(UserLicenseGroupTool.getValidLicenseUsagesMap(ctx).values());
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        if (lsLicenseUsageInfo == null) {
            return new ArrayList();
        }
        ArrayList<String> lsGroupNumberName = new ArrayList<String>();
        int len = lsLicenseUsageInfo.size();
        for (int i = 0; i < len; ++i) {
            LicenseUsageInfo lui = (LicenseUsageInfo)lsLicenseUsageInfo.get(i);
            lsGroupNumberName.add(lui.getModuleName() + ";" + lui.getModuleAlias());
        }
        return lsGroupNumberName;
    }

    @Override
    protected List _getCloudUserInfoFromLicense(Context ctx) throws BOSException, EASBizException {
        return GroupLicenseUseInfoUtil.getCloudUserInfoFromLicense(ctx);
    }

    @Override
    protected Map _initUserLicenseGroup(Context ctx) throws BOSException {
        try {
            return GroupLicenseUseInfoUtil.initUserLicenseGroup(ctx);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _isInternation(Context ctx) throws BOSException {
        Class<?> clz = null;
        boolean blag = false;
        try {
            clz = Class.forName("com.kingdee.eas.bs.ml.ResourceFacade");
            Object o = clz.newInstance();
            Method method = clz.getMethod("checkExistInitMLDB", null);
            blag = (Boolean)method.invoke(o, null);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return blag;
    }

    @Override
    protected List _getSynResult(Context ctx) throws BOSException, EASBizException {
        return SynUserToCloudHelper.getSyncResultList(ctx);
    }

    @Override
    protected Map _saveUserMapEasXtDataBatch(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append("fid fid").append(",FUserId userId").append(",FPersonId personId").append(",FXtId xtId").append(" from T_PM_EASXTUSERMAP ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashSet<String> stUsersId = new HashSet<String>();
        try {
            while (rs.next()) {
                stUsersId.add(rs.getString("userId"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        ArrayList<UserMapEasXtInfo> addInfos = new ArrayList<UserMapEasXtInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            UserMapEasXtInfo info = (UserMapEasXtInfo)coll.getObject(i);
            if (info.getUser() == null || stUsersId.contains(info.getUser().getId().toString())) continue;
            addInfos.add(info);
        }
        int paramsNum = 13;
        StringBuilder insb = new StringBuilder();
        insb.append("insert into T_PM_EASXTUSERMAP(").append("FcreateTime").append(",fid").append(",fuserid").append(",FPersonId").append(",fxtid").append(",FStatus").append(",FIsSynch").append(",FCell").append(",FEmail").append(",FUserNumber").append(",FUserName").append(",FForbidden").append(",FIsDelete").append(") values(now()");
        for (int i = 1; i < paramsNum; ++i) {
            insb.append(",?");
        }
        insb.append(")");
        logger.error((Object)("insert sql is:" + insb.toString()));
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (UserMapEasXtInfo info : addInfos) {
            Object[] params = new Object[paramsNum - 1];
            int pos = 0;
            UserInfo user = info.getUser();
            if (user == null) continue;
            params[pos++] = BOSUuid.create((String)"F4AF4F04").toString();
            params[pos++] = user.getId().toString();
            params[pos++] = user.getPerson() == null ? "" : user.getPerson().getId().toString();
            params[pos++] = info.getXtId();
            params[pos++] = user.isIsDelete() ? 0 : (user.isIsForbidden() ? 2 : 1);
            params[pos++] = 1;
            params[pos++] = user.getCell();
            params[pos++] = user.getEmail();
            params[pos++] = user.getNumber();
            params[pos++] = user.getName();
            params[pos++] = user.isIsForbidden() ? 1 : 0;
            params[pos++] = user.isIsDelete() ? 1 : 0;
            StringBuilder logsb = new StringBuilder();
            logsb.append("params : ");
            for (int i = 0; i < paramsNum - 1; ++i) {
                logsb.append("'").append(params[i]).append("'").append(",");
            }
            logger.error((Object)logsb.toString());
            paramList.add(params);
        }
        if (paramList.size() == 0) {
            return null;
        }
        DbUtil.executeBatch((Context)ctx, (String)insb.toString(), paramList);
        return null;
    }

    @Override
    protected String _getAuthPattern(Context ctx) throws BOSException, EASBizException {
        return CloudActiveParamsUtil.getAuthPattern();
    }

    @Override
    protected String _synResultUpdateToERP(Context ctx) throws BOSException, EASBizException {
        return "";
    }

    private Map<String, SyncUserResultInfo> getSyncUserResultMap2(JSONArray userArray) {
        HashMap<String, SyncUserResultInfo> SyncUserResults = new HashMap<String, SyncUserResultInfo>(500);
        for (int j = 0; j < userArray.size(); ++j) {
            JSONObject object = (JSONObject)userArray.get(j);
            String userNumber = object.getString("erpNumber");
            if (SyncUserResults.containsKey(userNumber)) continue;
            SyncUserResultInfo syncUserResultInfo = new SyncUserResultInfo();
            syncUserResultInfo.setNumber(userNumber);
            syncUserResultInfo.setUid(object.getString("uid"));
            syncUserResultInfo.setCell(object.getString("phone"));
            SyncUserResults.put(userNumber, syncUserResultInfo);
        }
        return SyncUserResults;
    }

    protected String _synResultUpdateToERP2(Context ctx, List<CloudUserInfo> assembleCloudUserInfo, JSONArray userArray) throws BOSException, EASBizException {
        if (userArray == null) {
            return "{'success':false,'error':'license is null'}";
        }
        long t1 = System.currentTimeMillis();
        Map<String, SyncUserResultInfo> syncUserResults = this.getSyncUserResultMap2(userArray);
        long t2 = System.currentTimeMillis();
        logger.error((Object)(">>>>>>>>>>>>>>>>>>>>the size of userArrays: " + userArray.size() + ">>>>>>>>>>>>>>>>>>>>>getSyncUserResultMap>>>>>>>>>>>>>>>>:cost: " + (t2 - t1)));
        return null;
    }

    @Override
    protected boolean _rebulidLicGroupUsageInfo(Context ctx) throws BOSException, EASBizException {
        try {
            logger.error((Object)"_rebulidLicGroupUsageInfo start");
            ILicenseUseSrv ilus = LicenseUseSrvFactory.getLocalInstance(ctx);
            ilus.dealLicenseGroupUsageInfo(ctx);
            logger.error((Object)"_rebulidLicGroupUsageInfo end");
        }
        catch (LicenseException e) {
            logger.error((Object)"_rebulidLicGroupUsageInfo exception {}", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected Map _resetAllUserSyncState(Context ctx) throws BOSException, EASBizException {
        return GroupLicenseUseInfoUtil.resetAllUserSyncState(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _callBackUsers(Context ctx, List userPKs) throws BOSException, EASBizException {
        for (Object userPK : userPKs) {
            UserInfo user = UserFactory.getLocalInstance(ctx).getUserInfo(userPK.toString());
            PersonInfo person = user.getPerson();
            user.setCU(person.getCU());
            user.setDefOrgUnit(person.getHrOrgUnit().castToFullOrgUnitInfo());
            user.setIsDelete(false);
            UserFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(user.getId().toString()), (CoreBaseInfo)user);
        }
        String deleteUserOrgPermSQL = "DELETE FROM T_PM_USERORGPERM WHERE FOWNER IN(" + ToolUtils.aryToStr(userPKs) + ")";
        String deleteUserOrgRoleSQL = "DELETE FROM T_PM_USERROLEORG WHERE FUSERID IN(" + ToolUtils.aryToStr(userPKs) + ")";
        String deleteUserOrgRangeSQL = "DELETE FROM T_PM_UserOrgRange WHERE Fuserid IN(" + ToolUtils.aryToStr(userPKs) + ") and ftype=10";
        String deleteUserOrgIncludeSQL = "DELETE FROM T_PM_ORGRANGEINCLUDESUBORG WHERE FUserid IN(" + ToolUtils.aryToStr(userPKs) + ") and Ftype =10";
        String deleteUserLicenseGroupSQL = "DELETE FROM T_PM_USERLICENSEGROUP WHERE FUSERID IN(" + ToolUtils.aryToStr(userPKs) + ")";
        Connection conn = this.getConnection(ctx);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.addBatch(deleteUserOrgPermSQL);
            stmt.addBatch(deleteUserOrgRoleSQL);
            stmt.addBatch(deleteUserOrgRangeSQL);
            stmt.addBatch(deleteUserOrgIncludeSQL);
            stmt.addBatch(deleteUserLicenseGroupSQL);
            stmt.executeBatch();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)("com.kingdee.eas.base.permission.app.UserFacadeControllerBean._callBackUsers.SQLException" + e));
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    @Override
    protected String _synResultUpdateToERP(Context ctx, List synData) throws BOSException, EASBizException {
        int licenseType = 0;
        try {
            licenseType = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo().getLicenseType();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (2 == licenseType) {
            return GroupLicenseUseInfoUtil.synResultUpdateToERP3(ctx, synData);
        }
        return GroupLicenseUseInfoUtil.synResultUpdateToERP2(ctx, synData);
    }

    private String getPath(String type) {
        String filePath = System.getProperty("EAS_HOME");
        if (!StringUtils.isEmpty((String)filePath)) {
            File file = new File(filePath);
            filePath = file.getAbsolutePath() + "/server/properties/license" + ("detail".equals(type) ? "/detail/" : "/result/");
        } else {
            filePath = "W:" + File.separator + "eas" + File.separator + "Server" + File.separator + "server" + File.separator + "properties" + File.separator + "license" + File.separator + ("detail".equals(type) ? "detail" : "result") + File.separator;
        }
        File file2 = new File(filePath);
        if (!file2.exists()) {
            file2.mkdir();
        }
        return filePath;
    }

    @Override
    protected void _addSyncResultView(Context ctx, int syncType, List synUserList, List synResult) throws BOSException, EASBizException {
        LicenseSyncSrvFactory.getLocalInstance(ctx).addSyncResultView(ctx, syncType, synUserList, synResult);
    }

    @Override
    protected List _getSyncResultData(Context ctx, Map dbMap) throws BOSException, EASBizException {
        List dataList = LicenseSyncSrvFactory.getLocalInstance(ctx).getSyncResultData(dbMap);
        return dataList;
    }

    @Override
    protected void _resetErpAndCloudPass(Context ctx, String userId, String pass, String vcode) throws BOSException, EASBizException {
        try {
            this.checkSecurity(ctx, userId, pass);
            UserInfo info = UserFactory.getLocalInstance(ctx).getUserInfo("select number,cell,email where id='" + userId + "'");
            JSONObject rs = EasCloud.modifyCloudPass((String)(info.getCell() == null ? "" : info.getCell()), (String)(info.getEmail() == null ? "" : info.getEmail()), (String)vcode, (String)pass);
            if ("0".equalsIgnoreCase(rs.getString("errcode"))) {
                this._resetPass(ctx, userId, pass);
                if (ControlPolicy.isBySubscriptionRegOnline((Context)ctx)) {
                    CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).addActivedErpUser(info.getNumber(), info.getCell(), info.getEmail());
                } else {
                    CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).addActivedErpUser(info.getNumber());
                }
            } else {
                String descKey = null;
                if ("l1".equalsIgnoreCase(ctx.getLocale().toString())) {
                    descKey = EasCloud.DESCRIPTION;
                    if (rs.getString(descKey) == null) {
                        descKey = EasCloud.DESCRIPTION_CN;
                    }
                } else {
                    descKey = EasCloud.DESCRIPTION_CN;
                }
                throw new BOSException(rs.getString(descKey));
            }
            this.logActive(ctx, info.getNumber());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw e;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    private void checkSecurity(Context ctx, String userId, String pass) throws BOSException, EASBizException, UserException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("security.*"));
        UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId), sc);
        if (userInfo.getSecurity() == null) {
            throw new UserException(UserException.USER_NOT_SECURITY);
        }
        if (StringUtils.isEmpty((String)pass)) {
            pass = "";
        }
        userInfo.setPassword(pass);
        SecurityValidator securityValidator = new SecurityValidator(ctx, userInfo);
        securityValidator.validate();
    }

    private void logActive(Context ctx, String username) {
        try {
            UserInfo userInfo4LoinModule = null;
            if (ctx.get((Object)"UserInfo") == null) {
                userInfo4LoinModule = UserInfoUtils.getUserInfo4LoinModule(ctx, username);
                ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo4LoinModule);
            }
            if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null) {
                if (userInfo4LoinModule == null) {
                    userInfo4LoinModule = UserInfoUtils.getUserInfo4LoinModule(ctx, username);
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)userInfo4LoinModule.getCU());
            }
            String description = ResourceBase.getString((String)RESOURCE, (String)"log_active", (Locale)ctx.getLocale());
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)description, (BOSObjectType)new LoginAndLogout().getType(), null, (String)description, (String)"UserLoginLog");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String _getActiveCode(Context ctx, String uid, String prod_inst_code, String phone, String email, String type) throws BOSException {
        JSONObject result = null;
        try {
            result = StringUtils.isEmpty((String)type) ? EasCloud.getActiveCode((String)uid, (String)prod_inst_code, (String)phone, (String)email) : EasCloud.getActiveCode((String)uid, (String)prod_inst_code, (String)phone, (String)email, (String)type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result == null ? "" : result.toJSONString();
    }

    @Override
    protected String _activeCloudOnly(Context ctx, String vcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            JSONObject verifyCode;
            ILicenseSrv agent = LicenseSrvFactory.getInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            paramMap.put("prod_inst_code", baseInfo.getProductInstanceID());
            CloudRegistUserInfo crui = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getCloudRegistUserInfo(ctx.getUserName());
            if (crui != null) {
                paramMap.put("uid", crui.getCloudUuId());
                paramMap.put("wholePhone", crui.getPhone());
                paramMap.put("wholeEmail", crui.getEmail());
            } else {
                paramMap.put("uid", "");
                paramMap.put("wholePhone", "");
                paramMap.put("wholeEmail", "");
            }
            String uid = (String)paramMap.get("uid");
            String prodInstId = (String)paramMap.get("prod_inst_code");
            String phone = (String)paramMap.get("wholePhone");
            String email = (String)paramMap.get("wholeEmail");
            if (phone != null && phone.contains("@")) {
                email = phone;
                phone = "";
            }
            return (verifyCode = EasCloud.verifyCode((String)uid, (String)prodInstId, (String)phone, (String)email, (String)vcode)) == null ? "" : verifyCode.toJSONString();
        }
        catch (Exception e) {
            logger.error((Object)"getActiveUrl error == ", (Throwable)e);
            return "";
        }
    }

    @Override
    protected String _getUserCloudActiveStatu(Context ctx, String userNumber) throws BOSException {
        try {
            JSONObject userCloudActiveStatu = EasCloud.getUserCloudActiveStatu((Context)ctx, (String)ctx.getUserName());
            return userCloudActiveStatu == null ? "" : userCloudActiveStatu.toJSONString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException();
        }
    }

    @Override
    protected String _autoOnLineUpdateLicense(Context ctx) throws BOSException, EASBizException {
        try {
            CloudLicenseUtil.batchOnLineUpdateLicense(ctx);
            UserLicenseGroupServiceFactory.getLocalInstance(ctx).noticLicenseUpdate();
            return EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_success", (Locale)ctx.getLocale());
        }
        catch (BOSException e) {
            e.printStackTrace();
            return EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale());
        }
    }

    @Override
    protected String _autoSyncUserGroup(Context ctx) throws BOSException, EASBizException {
        try {
            boolean kbcLicense = CloudLicenseUtil.isKBCLicense(ctx);
            if (!kbcLicense) {
                logger.error((Object)"licenseType is not KBC");
                return EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale());
            }
            boolean internalUseType = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).isInternalUseType();
            if (internalUseType) {
                logger.error((Object)"licenseType is internalUseType");
                return EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale());
            }
            List<CloudUserInfo> synUserList = SynUserToCloudHelper.assembleCloudUserInfoByType(ctx, AssembleCloudUserTypeEnum.ALL);
            CloudLicenseUtil.synUsersAndGroups(ctx, synUserList);
            return EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_success", (Locale)ctx.getLocale());
        }
        catch (BOSException | LicenseException e) {
            e.printStackTrace();
            return EASCommonResource.getString((String)RESOURCE, (String)"bgtransaction_faild", (Locale)ctx.getLocale());
        }
    }

    class AddUserThread
    extends Thread {
        private Context ctx;
        private UserInfo userInfo;

        public AddUserThread() {
        }

        public AddUserThread(Context ctx, UserInfo userInfo) {
            this.ctx = ctx;
            this.userInfo = userInfo;
        }

        @Override
        public void run() {
            try {
                UserFactory.getLocalInstance(this.ctx).addNewForCloud(this.userInfo, UserFacadeControllerBean.this.isPersonToManyUser, UserFacadeControllerBean.this.roleCol);
                UserFacadeControllerBean.this.addSuccessCount();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                UserFacadeControllerBean.this.addTotalCount();
            }
        }
    }
}

