/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormCacheService.ORMCacheUtil;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionLogHelper;
import com.kingdee.eas.base.permission.UserGroupGInfo;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.app.AbstractUserGroupGFacadeControllerBean;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserGroupGFacadeControllerBean
extends AbstractUserGroupGFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserGroupGFacadeControllerBean");
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addNew(Context ctx, IObjectPK userPK, Set groupIDs) throws BOSException, EASBizException {
        PreparedStatement state = null;
        Connection conn = null;
        try {
            String tmp_tableName = this.addNewData(ctx, userPK, groupIDs);
            String insertsql = "insert into t_pm_usergroupg(fuserid,fgroupid) select fuserid,fgroupid from " + tmp_tableName + " b where not exists(select 1 from t_pm_usergroupg a where a.fuserid =b.fuserid and a.fgroupid = b.fgroupid)";
            conn = this.getConnection(ctx);
            state = conn.prepareStatement(insertsql);
            state.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("usergorupg insert SQLException" + e));
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    logger.error((Object)("usergorupg insert SQLException" + e2));
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
    }

    private String addNewData(Context ctx, IObjectPK userPK, Set groupIDs) throws Exception {
        String tmp_tableName = "";
        PreparedStatement state = null;
        Connection conn = this.getConnection(ctx);
        try {
            TableManager manager = TableManager.getTableManager((Context)ctx);
            manager = TableManager.getTableManager((Context)ctx);
            tmp_tableName = manager.getTableName("usergroup");
            String createSql = "create table " + tmp_tableName + " (fuserid varchar(44),fgroupid varchar(44))";
            String insettempSql = "insert into " + tmp_tableName + " values(?,?)";
            manager.createTable(createSql);
            state = conn.prepareStatement(insettempSql);
            for (Object groupid : groupIDs) {
                state.setString(1, userPK.toString());
                state.setString(2, (String)groupid);
                state.addBatch();
            }
            state.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("usergorupg insert SQLException" + e));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
        return tmp_tableName;
    }

    @Override
    protected void _update(Context ctx, IObjectPK userid, Set groupIDs) throws BOSException, EASBizException {
        String deleteSql = "delete T_PM_UserGroupG where fuserid ='" + userid.toString() + "'";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        this._addNew(ctx, userid, groupIDs);
    }

    @Override
    protected Set _selectGroups(Context ctx, IObjectPK userId) throws BOSException, EASBizException {
        HashSet<String> groups = new HashSet<String>();
        String selectSql = "Select fgroupid from T_PM_UserGroupG where fuserid='" + userId + "'";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        try {
            while (result.next()) {
                groups.add(result.getString("fgroupid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return groups;
    }

    @Override
    protected boolean _hasThisResult(Context ctx, IObjectPK userId, IObjectPK groupId) throws BOSException, EASBizException {
        String selectSql = "Select * from T_PM_UserGroupG where fuserid ='" + userId + "' and fgroupid ='" + groupId + "'";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        try {
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected UserGroupGInfo _getUserGroupGInfo(Context ctx, IObjectPK userId, IObjectPK groupId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _addNewSimple(Context ctx, IObjectPK userId, IObjectPK groupId) throws BOSException, EASBizException {
        PreparedStatement state = null;
        Connection conn = this.getConnection(ctx);
        String insertsql = " insert into T_PM_UserGroupG (fuserid,fgroupid) values(?,?)";
        try {
            state = conn.prepareStatement(insertsql);
            state.setString(1, userId.toString());
            state.setString(2, groupId.toString());
            state.execute();
        }
        catch (SQLException e) {
            logger.info((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Statement)state, (Connection)conn);
        }
    }

    @Override
    protected void _deleteUser(Context ctx, List userIDs) throws BOSException, EASBizException {
        String deleteSQL = "delete from T_PM_UserGroupG where fuserid in (" + ToolUtils.aryToStr(userIDs) + ")";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
    }

    @Override
    protected void _deleteGroup(Context ctx, List groupIDs) throws BOSException, EASBizException {
        String getInfoSql = "select fnumber,fname_l2 from T_PM_UserGroup where fid in (" + ToolUtils.aryToStr(groupIDs) + ")";
        String deleteSQL = "delete from T_PM_UserGroup where fid in (" + ToolUtils.aryToStr(groupIDs) + ")";
        StringBuilder logSb = new StringBuilder();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)getInfoSql);
            while (iRowSet.next()) {
                logSb.append(iRowSet.getString("fnumber")).append(" ").append(iRowSet.getString("fname_l2")).append(";");
            }
            if (logSb.length() == 0) {
                return;
            }
            String logStr = logSb.substring(0, logSb.length() - 2);
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"delUserGroup"), (BOSObjectType)new BOSObjectType("57585F40"), null, (String)PermissionLogHelper.getLogInstanceDetail("logDeleteUserGroup", new Object[]{logStr}), (String)"bs_permission_userGroup_delete");
            DbUtil.execute((Context)ctx, (String)deleteSQL);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ORMCacheUtil.getInstance().removeInfosByBosType(ctx, new BOSObjectType("57585F40"));
    }

    @Override
    protected boolean _isExistRecord(Context ctx, List groupIDs) throws BOSException, EASBizException {
        for (Object groupObj : groupIDs) {
            if (this.hasThisGroup(ctx, groupObj)) continue;
            return false;
        }
        return true;
    }

    private boolean hasThisGroup(Context ctx, Object groupID) {
        String selectSQL = "select * from T_PM_UserGroupG where fgroupid ='" + groupID + "'";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void _deleteLeaf(Context ctx, List groupIDs) throws BOSException, EASBizException {
        ArrayList<String> groupIDList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_PM_UserGroup where ");
        for (Object group : groupIDs) {
            if (!(group instanceof UserGroupInfo)) continue;
            groupIDList.add(((UserGroupInfo)group).getId().toString());
            sql.append("flongnumber like '" + this.getLongNumber(ctx, ((UserGroupInfo)group).getId().toString()) + "!%'");
        }
        String leafSQL = "update T_PM_UserGroup set fisleaf = '1' where fid in (" + ToolUtils.aryToStr(groupIDList) + ") and not exists(" + sql + ")";
        DbUtil.execute((Context)ctx, (String)leafSQL);
    }

    private String getLongNumber(Context ctx, String id) throws BOSException {
        String sql = "select flongnumber from T_PM_UserGroup where fid ='" + id + "'";
        String longNumber = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                longNumber = rs.getString("flongnumber");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return longNumber;
    }

    @Override
    protected void _update(Context ctx, List userList, IObjectPK GroupID) throws BOSException, EASBizException {
        this._deleteUser(ctx, userList);
        this.addNew(ctx, userList, GroupID);
    }

    @Override
    protected boolean _hasThisUserRecord(Context ctx, List userList) throws BOSException, EASBizException {
        for (Object obj : userList) {
            if (this.hasThisUser(ctx, obj)) continue;
            return false;
        }
        return true;
    }

    private boolean hasThisUser(Context ctx, Object obj) {
        String selectSql = "select * from T_PM_UserGroupG where fuserid ='" + obj.toString() + "'";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void _addNew(Context ctx, List userList, IObjectPK groupID) throws BOSException, EASBizException {
        String insertSQL = "insert into T_PM_UserGroupG (fuserid,fgroupid) values(?,?)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Object userObj : userList) {
            Object[] params = new Object[]{userObj.toString(), groupID.toString()};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSQL, paramsList);
    }
}

