/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.app.AbstractXunTongFacadeControllerBean;
import com.kingdee.eas.base.weibo.EcaFacadeFactory;
import com.kingdee.eas.base.weibo.IEcaFacade;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class XunTongFacadeControllerBean
extends AbstractXunTongFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.XunTongFacadeControllerBean");
    private static final String MOBILE_PATH = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "properties" + File.separator + "mobile";
    private static final String LAST_UPDATE_TIME_FILE = MOBILE_PATH + File.separator + "lastupdatetime.txt";
    private static final String MOBILE_CONFIG_PATH = MOBILE_PATH + File.separator + "eas_server_config.properties";
    private static final String MID_KEY = "cust3gNo";

    @Override
    protected String _getMID(Context ctx) throws BOSException, EASBizException {
        IEcaFacade ecaFacade = EcaFacadeFactory.getLocalInstance((Context)ctx);
        HashMap hm = ecaFacade.getInitConfig();
        return StringUtils.cnulls(hm.get(MID_KEY));
    }

    @Override
    protected JSONArray _getPersonData(Context ctx) throws BOSException, EASBizException {
        return this.getPersonData(ctx, " where person.FDeletedStatus=1 ", new Object[0]);
    }

    private JSONArray getAddedPersonData(Context ctx, Date lastUpdateTime) throws BOSException, EASBizException {
        String filter = " where person.FDeletedStatus=1 and person.FCreateTime>? ";
        return this.getPersonData(ctx, filter, new Object[]{lastUpdateTime});
    }

    private JSONArray getUpdatedPersonData(Context ctx, Date lastUpdateTime) throws BOSException, EASBizException {
        String filter = " where person.FDeletedStatus=1 and person.FCreateTime<? and person.FLastUpdateTime>?";
        return this.getPersonData(ctx, filter, new Object[]{lastUpdateTime, lastUpdateTime});
    }

    private JSONArray getDeletedPersonData(Context ctx, Date lastUpdateTime) throws BOSException, EASBizException {
        String sql = "select fid from t_bd_person where FLastUpdateTime>? and FDeletedStatus=2";
        HashMap<String, String> keyFieldMap = new HashMap<String, String>();
        String key = "personId";
        keyFieldMap.put(key, "fid");
        Object[] params = new Object[]{lastUpdateTime};
        JSONArray deletedPersonArr = this.getArrFromDb(ctx, sql, params, keyFieldMap);
        JSONArray deletedPersonIdArr = new JSONArray();
        int size = deletedPersonArr.size();
        for (int i = 0; i < size; ++i) {
            deletedPersonIdArr.add((Object)deletedPersonArr.getJSONObject(i).getString(key));
        }
        return deletedPersonIdArr;
    }

    private JSONArray getPersonData(Context ctx, String filter, Object[] params) throws BOSException, EASBizException {
        String personSql = "select fid,FGender,fname_l2,FCell,FEmail from t_bd_person person " + filter;
        String personPositionSql = "select a.FPersonID,a.FPersonDep,b.fname_l2 from T_HR_PersonPosition a join T_ORG_Position b  on a.FPrimaryPositionID=b.fid join t_bd_person person on a.FPersonId=person.fid " + filter;
        IRowSet pprs = DbUtil.executeQuery((Context)ctx, (String)personPositionSql, (Object[])params);
        HashMap<String, JSONArray> idPositionsMap = new HashMap<String, JSONArray>();
        try {
            while (pprs.next()) {
                JSONObject positionJson = new JSONObject();
                positionJson.put("id", (Object)pprs.getString("FPersonDep"));
                positionJson.put("job", (Object)"fname_l2");
                String personId = pprs.getString("FPersonID");
                JSONArray positionArr = (JSONArray)idPositionsMap.get(personId);
                if (positionArr == null) {
                    positionArr = new JSONArray();
                }
                positionArr.add((Object)positionJson);
                idPositionsMap.put(personId, positionArr);
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)personSql, (Object[])params);
            JSONArray personArr = new JSONArray();
            while (rs.next()) {
                JSONObject personObj = new JSONObject();
                String id = rs.getString("fid");
                personObj.put("id", (Object)id);
                personObj.put("gender", (Object)rs.getString("FGender"));
                personObj.put("name", (Object)rs.getString("fname_l2"));
                personObj.put("phone", (Object)rs.getString("FCell"));
                personObj.put("email", (Object)rs.getString("FEmail"));
                personObj.put("orgJobs", idPositionsMap.get(id));
                personArr.add((Object)personObj);
            }
            return personArr;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected JSONArray _getUserData(Context ctx) throws BOSException, EASBizException {
        String userSql = "select fid,fname_l2,fpersonid,fpassword from t_pm_user where FIsDelete=0 and fpersonid is not null";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)userSql);
        JSONArray userArr = new JSONArray();
        try {
            while (rs.next()) {
                JSONObject userObj = new JSONObject();
                userObj.put("userId", (Object)rs.getString("fid"));
                String userName = rs.getString("fname_l2");
                userObj.put("userName", (Object)userName);
                userObj.put("personId", (Object)rs.getString("fpersonid"));
                userObj.put("saltType", (Object)"000000");
                userArr.add((Object)userObj);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return userArr;
    }

    @Override
    protected byte[] _getKey(Context ctx) throws BOSException, EASBizException {
        String keyPath = MOBILE_PATH + File.separator + this.getMID(ctx) + ".key";
        byte[] ret = new byte[]{};
        FileInputStream fileIs = null;
        try {
            fileIs = new FileInputStream(keyPath);
            ret = new byte[fileIs.available()];
            fileIs.read(ret);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fileIs != null) {
                try {
                    fileIs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    @Override
    protected Map _getAllUpdateData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, JSONArray> ret = new HashMap<String, JSONArray>();
        Date lastUpdateTime = this.getLastUpdateTime();
        if (lastUpdateTime == null) {
            return ret;
        }
        ret.put("addedorg", this.getAddedOrgArr(ctx, lastUpdateTime));
        ret.put("updatedorg", this.getUpdatedOrgArr(ctx, lastUpdateTime));
        ret.put("deletedorg", this.getDeletedOrgArr(ctx, lastUpdateTime));
        ret.put("addedperson", this.getAddedPersonData(ctx, lastUpdateTime));
        ret.put("updatedperson", this.getUpdatedPersonData(ctx, lastUpdateTime));
        ret.put("deletedperson", this.getDeletedPersonData(ctx, lastUpdateTime));
        ret.put("addeduser", this._getUserData(ctx));
        this.writeLastUpdateTime();
        return ret;
    }

    private JSONArray getAddedOrgArr(Context ctx, Date lastUpdateTime) throws BOSException {
        String sql = "select fid,fname_l2,fparentid from t_org_admin where fcreatetime > ? and FIsSealUp=0";
        HashMap<String, String> keyFieldMap = new HashMap<String, String>();
        keyFieldMap.put("id", "fid");
        keyFieldMap.put("name", "fname_l2");
        keyFieldMap.put("parentId", "fparentid");
        Object[] params = new Object[]{lastUpdateTime};
        return this.getArrFromDb(ctx, sql, params, keyFieldMap);
    }

    private JSONArray getUpdatedOrgArr(Context ctx, Date lastUpdateTime) throws BOSException {
        String sql = "select fid,fname_l2,fparentid from t_org_admin where fcreatetime < ? and FLastUpdateTime>? and FIsSealUp=0";
        HashMap<String, String> keyFieldMap = new HashMap<String, String>();
        keyFieldMap.put("id", "fid");
        keyFieldMap.put("name", "fname_l2");
        keyFieldMap.put("parentId", "fparentid");
        Object[] params = new Object[]{lastUpdateTime, lastUpdateTime};
        return this.getArrFromDb(ctx, sql, params, keyFieldMap);
    }

    private JSONArray getDeletedOrgArr(Context ctx, Date lastUpdateTime) throws BOSException {
        String sql = "select fid from t_org_admin where FLastUpdateTime>? and FIsSealUp=1";
        HashMap<String, String> keyFieldMap = new HashMap<String, String>();
        keyFieldMap.put("orgId", "fid");
        Object[] params = new Object[]{lastUpdateTime};
        JSONArray deletedOrgArr = this.getArrFromDb(ctx, sql, params, keyFieldMap);
        JSONArray deletedOrgIdArr = new JSONArray();
        int size = deletedOrgArr.size();
        for (int i = 0; i < size; ++i) {
            deletedOrgIdArr.add((Object)deletedOrgArr.getJSONObject(i).getString("orgId"));
        }
        return deletedOrgIdArr;
    }

    private JSONArray getArrFromDb(Context ctx, String sql, Object[] params, Map<String, String> keyFieldMap) throws BOSException {
        JSONArray ret = new JSONArray();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs.next()) {
                JSONObject obj = new JSONObject();
                for (Map.Entry<String, String> keyFieldEntry : keyFieldMap.entrySet()) {
                    obj.put(keyFieldEntry.getKey(), rs.getObject(keyFieldEntry.getValue()));
                }
                ret.add((Object)obj);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getLastUpdateTime() {
        File lastUpdateTimeFile = new File(LAST_UPDATE_TIME_FILE);
        if (!lastUpdateTimeFile.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(LAST_UPDATE_TIME_FILE);
            byte[] bs = new byte[fis.available()];
            fis.read(bs);
            String timeStr = new String(bs, "utf-8");
            if (StringUtils.isEmpty((String)timeStr)) {
                Date date = new Date(0L);
                return date;
            }
            long time = Long.parseLong(timeStr);
            Date date = new Date(time);
            return date;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            Date date = new Date(0L);
            return date;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLastUpdateTime() {
        File mobilePath = new File(MOBILE_PATH);
        if (!mobilePath.exists()) {
            return;
        }
        File lastUpdateTimeFile = new File(LAST_UPDATE_TIME_FILE);
        if (!lastUpdateTimeFile.exists()) {
            try {
                lastUpdateTimeFile.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(lastUpdateTimeFile, false);
            fw.write(String.valueOf(System.currentTimeMillis()));
            fw.flush();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
    }
}

