/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermClearScan;
import com.kingdee.eas.base.permission.PermClearScanCollection;
import com.kingdee.eas.base.permission.PermClearScanDetailCollection;
import com.kingdee.eas.base.permission.PermClearScanDetailFactory;
import com.kingdee.eas.base.permission.PermClearScanDetailInfo;
import com.kingdee.eas.base.permission.PermClearScanFactory;
import com.kingdee.eas.base.permission.PermClearScanInfo;
import com.kingdee.eas.base.permission.PermClearStrategyInfo;
import com.kingdee.eas.base.permission.ScanStatusEnum;
import com.kingdee.eas.base.permission.StrategyTypeEnum;
import com.kingdee.eas.base.permission.app.clear.PermClearScanTaskManager;
import com.kingdee.eas.base.permission.app.clear.PermClearStrategyManager;
import com.kingdee.eas.base.permission.app.clear.common.IPreCondition;
import com.kingdee.eas.base.permission.app.clear.common.PermClearUtils;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearStrategyScan;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearScan;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearScanResult;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearStrategyScanBean;
import com.kingdee.eas.base.permission.app.clear.strategy.PermClearStrategyBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class PermClearScanManager {
    public static synchronized boolean submitScan(Context ctx, List<String> clearStrategyIds) throws BOSException, EASBizException {
        boolean checkSubmitNewScan = PermClearScanManager.tryReqSubmitNewScan(ctx);
        if (checkSubmitNewScan) {
            PermClearScanManager.submitNewScan(ctx, clearStrategyIds);
            return true;
        }
        return false;
    }

    private static void submitNewScan(Context ctx, List<String> clearStrategyIds) throws EASBizException, BOSException {
        PermClearScanInfo permClearScanInfo = new PermClearScanInfo();
        permClearScanInfo.setScanStatus(ScanStatusEnum.UNSTARTED);
        PermClearScanResult bean = new PermClearScanResult();
        permClearScanInfo.setScanGatherResult(bean.serialize());
        IObjectPK scanPk = PermClearScanFactory.getLocalInstance(ctx).save((CoreBaseInfo)permClearScanInfo);
        List<PermClearStrategyBean> permClearStrategyDisplayList = PermClearStrategyManager.getPermClearStrategys(ctx, clearStrategyIds);
        PermClearScanManager.initSaveScanDetail(ctx, scanPk, permClearStrategyDisplayList);
        PermClearScanTaskManager.startScan(ctx, scanPk.toString());
    }

    private static void initSaveScanDetail(Context ctx, IObjectPK scanPk, List<PermClearStrategyBean> permClearStrategyBeans) throws EASBizException, BOSException {
        for (int i = 0; i < permClearStrategyBeans.size(); ++i) {
            PermClearScanDetailInfo detailInfo = new PermClearScanDetailInfo();
            PermClearScanInfo permClearScanInfo = new PermClearScanInfo();
            permClearScanInfo.setId(BOSUuid.read((String)scanPk.toString()));
            detailInfo.setScanId(permClearScanInfo);
            PermClearStrategyBean permClearStrategyBean = permClearStrategyBeans.get(i);
            PermClearScanManager.fillScanDetailFrom(permClearStrategyBean, detailInfo);
            PermClearScanDetailFactory.getLocalInstance(ctx).save((CoreBaseInfo)detailInfo);
        }
    }

    public static void fillScanDetailFrom(PermClearStrategyBean permClearStrategyBean, PermClearScanDetailInfo detailInfo) {
        IPreCondition preCondition = permClearStrategyBean.getPreCondition();
        StrategyTypeEnum strategyTypeEnum = preCondition.getStrategyTypeEnum();
        PermClearStrategyInfo permClearStrategyInfo = new PermClearStrategyInfo();
        permClearStrategyInfo.setId(BOSUuid.read((String)permClearStrategyBean.getId()));
        detailInfo.setStrategyId(permClearStrategyInfo);
        detailInfo.setScanStatus(ScanStatusEnum.UNSTARTED);
        IPermClearStrategyScan fromPreCodition = IPermClearStrategyScan.fromPreCodition(strategyTypeEnum.getValue(), preCondition);
        detailInfo.setPreConditionScanResult(fromPreCodition.serialize());
    }

    public static boolean tryReqSubmitNewScan(Context ctx) throws BOSException {
        try {
            PermClearScanInfo permClearScanInfo;
            IPermClearScan iPermClearScan = PermClearScanFactory.getLocalInstance(ctx);
            PermClearScanCollection permClearScanCollection = PermClearScanManager.queryAllNotFinished(ctx);
            for (int i = 0; i < permClearScanCollection.size(); ++i) {
                long waitTime;
                PermClearScanInfo permClearScanInfo2 = permClearScanCollection.get(i);
                if (ScanStatusEnum.UNSTARTED == permClearScanInfo2.getScanStatus() && (waitTime = new Date().getTime() - permClearScanInfo2.getCreateTime().getTime()) > 1000000L) {
                    permClearScanInfo2.setScanStatus(ScanStatusEnum.expire);
                    iPermClearScan.update((IObjectPK)new ObjectStringPK(permClearScanInfo2.getId().toString()), permClearScanInfo2);
                }
                if (ScanStatusEnum.SCANING != permClearScanInfo2.getScanStatus() || (waitTime = new Date().getTime() - permClearScanInfo2.getScanUpdateTime().getTime()) <= 1000000L) continue;
                iPermClearScan.update((IObjectPK)new ObjectStringPK(permClearScanInfo2.getId().toString()), permClearScanInfo2);
            }
            permClearScanCollection = PermClearScanManager.queryAllNotFinished(ctx);
            if (permClearScanCollection.size() > 0 && (ScanStatusEnum.UNSTARTED == (permClearScanInfo = permClearScanCollection.get(0)).getScanStatus() || ScanStatusEnum.SCANING == permClearScanInfo.getScanStatus())) {
                return false;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static PermClearScanCollection queryAllNotFinished(Context ctx) throws BOSException {
        IPermClearScan iPermClearScan = PermClearScanFactory.getLocalInstance(ctx);
        EntityViewInfo evInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        FilterInfo filterInfo = new FilterInfo();
        evInfo.setTopCount(1);
        evInfo.setSelector(selector);
        evInfo.setFilter(filterInfo);
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entries.*"));
        selector.add(new SelectorItemInfo("entries.strategyId.*"));
        selector.add(new SelectorItemInfo());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("10");
        hashSet.add("20");
        hashSet.add("30");
        filterInfo.getFilterItems().add(new FilterItemInfo("scanStatus", hashSet, CompareType.INCLUDE));
        try {
            SorterItemCollection sort = new SorterItemCollection("order by createTime desc");
            evInfo.setSorter(sort);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        PermClearScanCollection permClearScanCollection = iPermClearScan.getPermClearScanCollection(evInfo);
        return permClearScanCollection;
    }

    public static PermClearScanInfo getMostNewScanPermClearScan(Context ctx) throws BOSException, EASBizException {
        PermClearScanInfo permClearScanInfo = null;
        PermClearScanCollection permClearScanCollection = PermClearScanManager.queryAllNotFinished(ctx);
        long time = 0L;
        if (permClearScanCollection.size() == 1) {
            permClearScanInfo = permClearScanCollection.get(0);
        } else if (permClearScanCollection.size() > 1) {
            for (int i = 0; i < permClearScanCollection.size(); ++i) {
                long curtime;
                PermClearScanInfo CurPermClearScanInfo = permClearScanCollection.get(i);
                long l = curtime = permClearScanInfo == null ? 0L : permClearScanInfo.getCreateTime().getTime();
                if (curtime <= time) continue;
                permClearScanInfo = CurPermClearScanInfo;
            }
        }
        return permClearScanInfo;
    }

    public static PermClearScan queryMostScanInfo(Context ctx) throws BOSException, EASBizException {
        PermClearScanInfo PermClearScanInfo2 = PermClearScanManager.getMostNewScanPermClearScan(ctx);
        PermClearScan scanBean = null;
        if (PermClearScanInfo2 != null) {
            scanBean = PermClearScanManager.convertStrategyBean(PermClearScanInfo2);
        }
        return scanBean;
    }

    private static PermClearScan convertStrategyBean(PermClearScanInfo permClearScanInfo) {
        PermClearScan permClearScanBean = new PermClearScan();
        permClearScanBean.setScanId(permClearScanInfo.getId().toString());
        permClearScanBean.setScanStatus(permClearScanInfo.getScanStatus());
        permClearScanBean.setScanStartTime(PermClearUtils.getDateStr(permClearScanInfo.getScanStartTime()));
        permClearScanBean.setScanUpdateTime(PermClearUtils.getDateStr(permClearScanInfo.getScanUpdateTime()));
        permClearScanBean.setScanEndTime(PermClearUtils.getDateStr(permClearScanInfo.getScanEndTime()));
        PermClearScanResult scanGatherResult = new PermClearScanResult();
        scanGatherResult.unSerialize(permClearScanInfo.getScanGatherResult());
        permClearScanBean.setScanGatherResult(scanGatherResult);
        ArrayList<PermClearStrategyScanBean> strategyScanList = new ArrayList<PermClearStrategyScanBean>();
        PermClearScanDetailCollection entries = permClearScanInfo.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            PermClearScanDetailInfo permClearScanDetailInfo = entries.get(i);
            PermClearStrategyScanBean permClearStrategyScanBean = new PermClearStrategyScanBean();
            PermClearStrategyInfo strategy = permClearScanDetailInfo.getStrategyId();
            permClearStrategyScanBean.setId(permClearScanDetailInfo.getId().toString());
            permClearStrategyScanBean.setStrategyId(strategy.getId().toString());
            permClearStrategyScanBean.setName(strategy.getName());
            permClearStrategyScanBean.setType(strategy.getType());
            permClearStrategyScanBean.setNumber(strategy.getNumber());
            permClearStrategyScanBean.setDescrption(strategy.getDescription());
            permClearStrategyScanBean.setProccess(permClearScanDetailInfo.getProcess());
            permClearStrategyScanBean.setScanStatus(permClearScanDetailInfo.getScanStatus());
            String preConditionScanResult = permClearScanDetailInfo.getPreConditionScanResult();
            IPermClearStrategyScan permClearStrategyScan = IPermClearStrategyScan.unSerializeByType(strategy.getNumber(), preConditionScanResult);
            permClearStrategyScanBean.setPermClearStrategyScan(permClearStrategyScan);
            permClearStrategyScanBean.setScanUpdateTime(PermClearUtils.getDateStr(permClearScanDetailInfo.getScanUpdateTime()));
            strategyScanList.add(permClearStrategyScanBean);
        }
        permClearScanBean.setStrategyScanList(strategyScanList);
        return permClearScanBean;
    }
}

