/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.plunin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.app.plunin.PermChangeListener;
import com.kingdee.eas.base.permission.app.plunin.PermChangeListening;
import com.kingdee.eas.base.permission.app.plunin.RolePermissionChangedListener;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.utils.DbTransactionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class PermissionChangeHelper {
    private static Logger logger = Logger.getLogger((String)PermissionChangeHelper.class.getName());
    private IObjectPK userPK;
    private IObjectPK rolePK;
    private IObjectPK[] userPKs;
    private IObjectPK[] rolePKs;
    public static final String MenuPermChangeListener = "com.kingdee.eas.base.uiframe.MenuPermChangeListener";
    public static final String ChangeAuthenListener = "com.kingdee.eas.base.permission.app.ChangeAuthenListener";
    public static final String PortalListener = "com.kingdee.eas.portal.CallBackRolePermission";
    public static final String ClearCacheListener = "com.kingdee.eas.base.permission.app.ClearCacheListener";
    public static final String SHRUserPermChangeListener = "com.kingdee.shr.base.permission.listener.SHRUserPermChangeListener";
    private List permChangeListeningList = new ArrayList();

    public IObjectPK[] getRolePKs() {
        return this.rolePKs;
    }

    public void setRolePKs(IObjectPK[] rolePKs) {
        this.rolePKs = rolePKs;
    }

    public PermissionChangeHelper() {
        this.permChangeListeningList.add(MenuPermChangeListener);
        this.permChangeListeningList.add(ChangeAuthenListener);
        this.permChangeListeningList.add(PortalListener);
        this.permChangeListeningList.add(ClearCacheListener);
        this.permChangeListeningList.add(SHRUserPermChangeListener);
    }

    private PermChangeListening getPermChangeListening(String clzName) {
        try {
            Class<?> clz = PermissionChangeHelper.class.getClassLoader().loadClass(clzName);
            if (PermChangeListening.class.isAssignableFrom(clz)) {
                return (PermChangeListening)clz.newInstance();
            }
            if (RolePermissionChangedListener.class.isAssignableFrom(clz)) {
                return (RolePermissionChangedListener)clz.newInstance();
            }
            return null;
        }
        catch (InstantiationException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    public void exceMenuChange(Context ctx) throws EASBizException, BOSException {
        ArrayList<String> menuChangeList = new ArrayList<String>();
        menuChangeList.add(MenuPermChangeListener);
        this.exceChange(ctx, menuChangeList);
    }

    public void exceChange(Context ctx) throws EASBizException, BOSException {
        this.exceChange(ctx, this.permChangeListeningList);
    }

    public void exceChange(Context ctx, List clzList) throws EASBizException, BOSException {
        DbTransactionUtil.noTransactionInvoke((Object)this, (String)"exceChangeDo", (Class[])new Class[]{Context.class, List.class}, (Object[])new Object[]{ctx, clzList});
    }

    public void exceChangeDo(Context ctx, List clzList) throws EASBizException, BOSException {
        for (int i = 0; i < clzList.size(); ++i) {
            String clz = clzList.get(i).toString();
            PermChangeListening permChangeListening = this.getPermChangeListening(clz);
            if (permChangeListening == null) continue;
            if (permChangeListening instanceof PermChangeListener) {
                Collection roleUserPKCol;
                PermChangeListener permChangerListener = (PermChangeListener)permChangeListening;
                ArrayList<IObjectPK> userPKList = new ArrayList<IObjectPK>();
                if (this.getUserPK() != null) {
                    userPKList.add(this.getUserPK());
                }
                if (this.getUserPKs() != null) {
                    CollectionUtils.addAll(userPKList, (Object[])this.getUserPKs());
                }
                if (this.getRolePK() != null) {
                    roleUserPKCol = this.getUserIDListByRoleID(ctx, new IObjectPK[]{this.getRolePK()});
                    userPKList.addAll(roleUserPKCol);
                }
                if (this.getRolePKs() != null) {
                    roleUserPKCol = this.getUserIDListByRoleID(ctx, this.getRolePKs());
                    userPKList.addAll(roleUserPKCol);
                }
                IObjectPK[] userPKs = new IObjectPK[userPKList.size()];
                for (int j = 0; j < userPKList.size(); ++j) {
                    userPKs[j] = new ObjectStringPK(userPKList.get(j).toString());
                }
                permChangerListener.setUserPKs(userPKs);
            }
            try {
                permChangeListening.doChange(ctx);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"permChangeListening.doChange", (Throwable)e);
            }
        }
    }

    public IObjectPK getRolePK() {
        return this.rolePK;
    }

    public void setRolePK(IObjectPK rolePK) {
        this.rolePK = rolePK;
    }

    public IObjectPK getUserPK() {
        return this.userPK;
    }

    public void setUserPK(IObjectPK userPK) {
        this.userPK = userPK;
    }

    public IObjectPK[] getUserPKs() {
        return this.userPKs;
    }

    public void setUserPKs(IObjectPK[] userPKs) {
        this.userPKs = userPKs;
    }

    protected Collection getUserIDListByRoleID(Context ctx, IObjectPK[] rolePKs) throws BOSException, EASBizException {
        String sql = "select distinct fuserid from t_pm_userroleorg where froleid in (" + ToolUtils.aryToStr(rolePKs) + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> userIDList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                userIDList.add(rowSet.getString("fuserid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"ChangeAuthenListener.updateRoleUserRegister", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return userIDList;
    }
}

