/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.scheduler;

import com.kingdee.eas.base.permission.app.scheduler.JobConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class JobConfigsLoader {
    private static final Logger logger = Logger.getLogger(JobConfigsLoader.class);
    private static String configFileName = "permissionSchedulerJob.properites";
    private static File configFile = null;
    private static String classOfName = "class";
    private static String cronTriggerOfName = "cronTrigger";
    private static String stopProNameOfName = "stop";

    public static long fileLastModified() {
        if (configFile == null || !configFile.exists()) {
            return 0L;
        }
        return configFile.lastModified();
    }

    public static List<JobConfig> loadJobConfigs() throws IOException {
        Properties jobProperties = JobConfigsLoader.readJobProperties();
        HashMap<String, JobConfig> jobConfigs = new HashMap<String, JobConfig>();
        Iterator<String> it = jobProperties.stringPropertyNames().iterator();
        while (it.hasNext()) {
            try {
                String key = it.next();
                String proValue = jobProperties.getProperty(key);
                String[] split = key.split("\\.");
                String job = split[0];
                String pro = split[1];
                JobConfig jobConfig = (JobConfig)jobConfigs.get(job);
                if (jobConfig == null) {
                    jobConfig = new JobConfig();
                    jobConfigs.put(job, jobConfig);
                }
                if (classOfName.equalsIgnoreCase(pro)) {
                    jobConfig.setJobClass(proValue);
                }
                if (cronTriggerOfName.equalsIgnoreCase(pro)) {
                    String[] proValueArr = proValue.split(";");
                    jobConfig.setJobTrigger(proValueArr);
                }
                if (!stopProNameOfName.equalsIgnoreCase(pro)) continue;
                jobConfig.setStop("1".equals(proValue));
            }
            catch (Exception e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
        }
        return new ArrayList<JobConfig>(jobConfigs.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readJobProperties() throws IOException {
        if (configFile == null) {
            configFile = new File(JobConfigsLoader.getFilePath());
        }
        if (!configFile.exists()) {
            configFile.createNewFile();
            JobConfigsLoader.wirteDefaultConfig();
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(configFile));
            Properties prop = new Properties();
            prop.load(in);
            Properties properties = prop;
            return properties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void wirteDefaultConfig() throws IOException {
        Properties prop = new Properties();
        prop.setProperty("licenseAutoUpdate.class", "com.kingdee.eas.base.permission.app.scheduler.job.LicenseUpdateJob");
        prop.setProperty("licenseAutoUpdate.cronTrigger", "0 0 3 * * ?");
        prop.setProperty("licenseAutoUpdate.stop", "0");
        try (FileOutputStream oFile = null;){
            oFile = new FileOutputStream(configFile, true);
            prop.store(oFile, "license auto update config");
        }
    }

    private static String getFilePath() {
        return new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append(configFileName).toString();
    }
}

