/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.IDelPermissionAfterDelOrg;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class DelPermissionAfterDelOrg
implements IDelPermissionAfterDelOrg {
    private static Logger logger = Logger.getLogger((String)DelPermissionAfterDelOrg.class.getName());
    private Context context = null;

    public DelPermissionAfterDelOrg(Context context) {
        this.context = context;
    }

    @Override
    public UserCollection getRefUersByPermisson(Set orgTypeSet, String ouID) throws BOSException, EASBizException {
        assert (orgTypeSet != null);
        assert (ouID != null);
        UserCollection result = new UserCollection();
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        String orgTypeStr = ToolUtils.aryToStr(this.processOrgType(orgTypeSet), false);
        String orgRangeTypeStr = null;
        orgRangeTypeStr = orgTypeSet.contains(OrgType.Admin) && orgTypeSet.size() == 1 ? "20" : (orgTypeSet.contains(OrgType.Admin) && orgTypeSet.size() > 1 ? "20,10" : "10");
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT distinct puser.FID, puser.FNumber, ").append("puser.").append(nameField).append(" FROM T_PM_User puser ").append(" INNER JOIN T_PM_UserOrgPerm uop ON puser.FID = uop.FOwner ").append(" INNER JOIN T_PM_PermItem pitem ON pitem.FID = uop.FPermItemID ").append(" WHERE uop.FOrgID = ? ").append(" AND pitem.FOrgRelation in ( ").append(orgTypeStr).append(")");
        buffer.append(" UNION ");
        buffer.append(" SELECT puser.FID, puser.FNumber, ").append("puser.").append(nameField).append(" FROM T_PM_User puser ").append(" INNER JOIN T_PM_UserRoleOrg uro ON puser.FID = uro.FUserID ").append(" INNER JOIN T_PM_RolePerm rp ON rp.FRoleID = uro.FRoleID ").append(" INNER JOIN T_PM_PermItem pitem ON pitem.FID = rp.FPermItemID ").append(" WHERE uro.FOrgID = ? ").append(" AND pitem.FOrgRelation in ( ").append(orgTypeStr).append(")");
        buffer.append(" UNION ");
        buffer.append(" SELECT puser.FID, puser.FNumber, ").append("puser.").append(nameField).append(" FROM T_PM_User puser ").append(" INNER JOIN T_PM_OrgRange orgRange ON puser.FID = orgRange.FUserID ").append(" WHERE orgRange.FOrgID = ? ").append(" AND orgRange.FType in ( ").append(orgRangeTypeStr).append(")");
        Object[] params = new Object[]{ouID, ouID, ouID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)buffer.toString(), (Object[])params);
            while (rowSet.next()) {
                UserInfo info = new UserInfo();
                String ID = rowSet.getString("FID");
                String number = rowSet.getString("FNumber");
                String name = rowSet.getString(nameField);
                info.setId(BOSUuid.read((String)ID));
                info.setNumber(number);
                info.setName(name);
                if (result.contains(info)) continue;
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return result;
    }

    @Override
    public void delPermissoinAfterDelOrg(Set orgTypeSet, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        assert (orgTypeSet != null);
        assert (unitInfo != null);
        String orgTypeStr = ToolUtils.aryToStr(this.processOrgType(orgTypeSet), false);
        String ouID = unitInfo.getId().toString();
        Object[] params = new Object[]{ouID};
        try {
            OrgTypeHelper orgTypeHelper;
            Set u_orgTypeSet;
            StringBuffer delUops = new StringBuffer();
            delUops.append(" DELETE FROM T_PM_UserOrgPerm").append(" WHERE FOrgID = ? ").append(" AND FPermItemID in (SELECT FID FROM T_PM_PermItem WHERE FIsLeaf=1 AND FOrgRelation in ( ").append(orgTypeStr).append(" )) ");
            DbUtil.execute((Context)this.context, (String)delUops.toString(), (Object[])params);
            if (this.hasAdminOrgType(orgTypeSet)) {
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT org.FLongNumber ").append(" FROM t_org_admin org ").append(" INNER JOIN T_PM_OrgRangeIncludeSuborg oris ON org.FID = oris.FOrgID ").append(" WHERE oris.FIsIncludeSubOrg = 1 AND oris.FOrgID = ? ").append(" AND oris.FType = ").append(20);
                IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
                while (rowSet.next()) {
                    String longNumber = rowSet.getString("FLongNumber");
                    this.deleteAdminSubOrgFromOrgRange(longNumber);
                }
                this.delOrgRangeSelf(OrgRangeType.ADMIN_ORG_TYPE, ouID);
            }
            if ((u_orgTypeSet = (orgTypeHelper = new OrgTypeHelper(unitInfo.getOrgTypeStr())).getAllSelectOrgTypeSet()) == null || u_orgTypeSet.size() == 0 || orgTypeHelper.isOnlyThisOrgType(OrgType.Admin)) {
                this.delOrgRangeSelf(OrgRangeType.BIZ_ORG_TYPE, ouID);
                this.delUserRoleOrg(ouID);
            }
        }
        catch (Exception e) {
            logger.error((Object)"delPermissoinAfterDelOrg error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void deleteAdminSubOrgFromOrgRange(String longNumber) throws BOSException, EASBizException {
        assert (longNumber != null);
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            String whereSql = "where FType = 20 and forgid in (select fid from t_org_admin where FLongNumber like '" + longNumber + "!%')";
            String orgRangeDelete = "delete from t_pm_orgrange " + whereSql;
            String orgRangeIncludeSubOrgDelete = "delete from T_PM_OrgRangeIncludeSuborg " + whereSql;
            SQLUtils.execute((Connection)con, (String)orgRangeDelete);
            SQLUtils.execute((Connection)con, (String)orgRangeIncludeSubOrgDelete);
        }
        catch (SQLException e) {
            logger.error((Object)"deleteAdminSubOrgFromOrgRange error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void delOrgRangeSelf(OrgRangeType orgRangeType, String ouID) throws BOSException, EASBizException {
        assert (orgRangeType != null);
        assert (ouID != null);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            StringBuffer delSubs = new StringBuffer();
            delSubs.append(" DELETE FROM T_PM_OrgRangeIncludeSuborg").append(" WHERE FOrgID = ? ").append(" AND FType = ? ");
            ps = con.prepareStatement(delSubs.toString());
            ps.setString(1, ouID);
            ps.setInt(2, orgRangeType.getValue());
            ps.executeUpdate();
            StringBuffer delOrgs = new StringBuffer();
            delOrgs.append(" DELETE FROM T_PM_OrgRange").append(" WHERE FOrgID = ? ").append(" AND FType = ? ");
            ps = con.prepareStatement(delOrgs.toString());
            ps.setString(1, ouID);
            ps.setInt(2, orgRangeType.getValue());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"delOrgRangeSelf error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private void delUserRoleOrg(String ouID) throws BOSException, EASBizException {
        assert (ouID != null);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            StringBuffer delUros = new StringBuffer();
            delUros.append(" DELETE FROM T_PM_UserRoleOrg").append(" WHERE FOrgID = ? ");
            ps = con.prepareStatement(delUros.toString());
            ps.setString(1, ouID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"delUserRoleOrg error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private Set processOrgType(Set orgTypeSet) {
        HashSet<String> set = new HashSet<String>();
        Iterator orgTypeItr = orgTypeSet.iterator();
        while (orgTypeItr.hasNext()) {
            set.add("" + ((OrgType)orgTypeItr.next()).getValue());
        }
        return set;
    }

    private boolean hasAdminOrgType(Set orgTypeSet) {
        boolean ret = false;
        for (OrgType obj : orgTypeSet) {
            if (!obj.equals((Object)OrgType.Admin)) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

