/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.helper.PermCacheHelper;
import com.kingdee.eas.base.permission.app.service.IOrgPermissionService;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class OrgPermissionService
implements IOrgPermissionService {
    private static Logger logger = Logger.getLogger((String)OrgPermissionService.class.getName());
    private Context context = null;

    public OrgPermissionService(Context context) {
        this.context = context;
    }

    @Override
    public OrgTreeCollection getUnionTree(IObjectPK userPK) throws BOSException, EASBizException {
        assert (userPK != null);
        OrgTreeCollection result = new OrgTreeCollection();
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT Tree.FID, Tree.FNumber,Tree.FIsForBudget, ").append("Tree.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Tree Tree ON Tree.FId = Structure.FTreeId ").append(" WHERE BaseUnit.FIsUnion = 1 AND OrgRange.FUserID = ? ").append(" AND OrgRange.FType = ").append(10);
        Object[] params = new Object[]{userPK.toString()};
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(buffer.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                String ID = rs.getString("FID");
                String number = rs.getString("FNumber");
                String name = rs.getString(nameField);
                boolean isForBudget = rs.getBoolean("FIsForBudget");
                info.setId(BOSUuid.read((String)ID));
                info.setNumber(number);
                info.setName(name);
                info.setIsForBudget(isForBudget);
                result.add(info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public OrgTreeCollection getUnionTree(IObjectPK userPK, Timestamp datePoint) throws BOSException, EASBizException {
        assert (userPK != null);
        String[] idlist = UnionVersionControllerFacadeFactory.getLocalInstance((Context)this.context).getIDList(datePoint);
        String idStr = ToolUtils.aryToStr(idlist);
        OrgTreeCollection result = new OrgTreeCollection();
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT Tree.FID, Tree.FNumber,Tree.FIsForBudget, ").append("Tree.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Tree Tree ON Tree.FId = Structure.FTreeId ").append(" WHERE BaseUnit.FIsUnion = 1 AND OrgRange.FUserID = ? ").append(" AND OrgRange.FType = ").append(10).append(" AND Tree.FID in (" + idStr + ")");
        Object[] params = new Object[]{userPK.toString()};
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(buffer.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                String ID = rs.getString("FID");
                String number = rs.getString("FNumber");
                String name = rs.getString(nameField);
                boolean isForBudget = rs.getBoolean("FIsForBudget");
                info.setId(BOSUuid.read((String)ID));
                info.setNumber(number);
                info.setName(name);
                info.setIsForBudget(isForBudget);
                result.add(info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getUnionUnitOfTree(IObjectPK userPK, IObjectPK orgTreePK) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgTreePK != null);
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
            StringBuffer buffer = new StringBuffer();
            buffer.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, ").append("BaseUnit.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE BaseUnit.FIsUnion = 1 AND OrgRange.FUserID = ? AND Structure.FTreeId = ? ").append(" AND OrgRange.FType = ").append(10);
            Object[] params = new Object[]{userPK.toString(), orgTreePK.toString()};
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(buffer.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getAdminOrg(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String field = orgType.getAlias();
        List orgIds = (List)PermCacheHelper.getPermCacheValue(PermCacheHelper.ORGRANGECACHE, userPK.toString(), field);
        if (orgIds != null) {
            result = this.getFullOrgUnitCollectionByOrgIds(orgIds);
            return result;
        }
        orgIds = this.getAdminOrg_new(userPK, orgType, orgTreePK);
        result = this.getFullOrgUnitCollectionByOrgIds(orgIds);
        PermCacheHelper.putPermCacheValue(PermCacheHelper.ORGRANGECACHE, userPK.toString(), field, orgIds);
        return result;
    }

    @Override
    public Map getAdminOrg(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, Set orgIdSet) throws EASBizException, BOSException {
        List orgList;
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Object org : orgIdSet) {
            result.put(org.toString(), false);
        }
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? AND BaseUnit.fid in(" + ToolUtils.aryToStr(orgIdSet) + ")");
        if (Administrator.isCUAdmin(this.context, userPK) && (orgList = PermissionRangeHelper.getCUOrgRange(this.context)) != null && !orgList.isEmpty()) {
            sql.append(" AND BaseUnit.FControlUnitID in (" + ToolUtils.aryToStr(orgList, true) + ")");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])new Object[]{treeID});
            while (rowSet.next()) {
                result.put(rowSet.getString("fid"), true);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return result;
    }

    public List getAdminOrg_new(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        ArrayList<String> result = new ArrayList<String>();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        Object[] params = new Object[]{treeID};
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber,Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? ");
        if (Administrator.isCUAdmin(this.context, userPK)) {
            sql.append(" AND BaseUnit.FControlUnitID in (" + PermissionRangeHelper.getCUOrgRangeSQL(this.context) + ")");
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    public FullOrgUnitCollection getAdminOrg_old(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        Object[] params = new Object[]{treeID};
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber,Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? ");
        if (Administrator.isCUAdmin(this.context, userPK)) {
            sql.append(" AND BaseUnit.FControlUnitID in (" + PermissionRangeHelper.getCUOrgRangeSQL(this.context) + ")");
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                fullOrgUnitInfo.setLongNumber(rs.getString("FLongNumber"));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getAdminOrgIds(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        List orgList;
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        Object[] params = new Object[]{treeID};
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? ");
        if (Administrator.isCUAdmin(this.context, userPK) && (orgList = PermissionRangeHelper.getCUOrgRange(this.context)) != null && !orgList.isEmpty()) {
            sql.append(" AND BaseUnit.FControlUnitID in (" + ToolUtils.aryToStr(orgList, true) + ")");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return result;
    }

    @Override
    public FullOrgUnitCollection getAdminOrgOfIncludeSubCU(IObjectPK ctrlUnitPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        String cuLongNumber = PermissionUtil.getOrgLongNumber(this.context, orgType, ctrlUnitPK) + "!%";
        Object[] params = new Object[]{treeID};
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, ").append("BaseUnit.").append(nameField).append(" FROM T_ORG_Structure Structure ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = Structure.FUnitId ").append(" INNER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = BaseUnit.FControlUnitID ").append(" WHERE Structure.FTreeId = ? ");
        sql.append(" AND CtrlUnit.FLongNumber || N'!' LIKE N'").append(cuLongNumber).append("' ");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getAdminOrgOfCU(IObjectPK ctrlUnitPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        Object[] params = new Object[]{ctrlUnitPK.toString(), treeID};
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, ").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE BaseUnit.FControlUnitID = ? AND Structure.FTreeId = ? ");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getOrgRangeIds(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE OrgRange.FUserID = ? AND Structure.FTreeId = ? ").append(this.getOrgRangeFilter(orgType, "OrgRange.FType"));
        Object[] params = new Object[]{userPK.toString(), treeID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return result;
    }

    @Override
    public FullOrgUnitCollection getOrgRange(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String field = orgType.getAlias(LocaleUtils.getDefaultLocale());
        List orgIds = (List)PermCacheHelper.getPermCacheValue(PermCacheHelper.ORGRANGECACHE, userPK.toString(), field);
        if (orgIds != null) {
            result = this.getFullOrgUnitCollectionByOrgIds(orgIds);
            return result;
        }
        orgIds = this.getOrgRange_new(userPK, orgType, orgTreePK);
        result = this.getFullOrgUnitCollectionByOrgIds(orgIds);
        PermCacheHelper.putPermCacheValue(PermCacheHelper.ORGRANGECACHE, userPK.toString(), field, orgIds);
        return result;
    }

    @Override
    public Map getOrgRange(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, Set orgIdSet) throws EASBizException, BOSException {
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Object org : orgIdSet) {
            result.put(org.toString(), false);
        }
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT BaseUnit.FID FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE OrgRange.FUserID = ? AND Structure.FTreeId = ? AND OrgRange.Ftype = 10 AND OrgRange.forgid in(" + ToolUtils.aryToStr(orgIdSet) + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)buffer.toString(), (Object[])new Object[]{userPK.toString(), treeID});
        try {
            while (rowSet.next()) {
                result.put(rowSet.getString("fid"), true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List getOrgRange_new(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        ArrayList<String> result = new ArrayList<String>();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE OrgRange.FUserID = ? AND Structure.FTreeId = ? ").append(this.getOrgRangeFilter(orgType, "OrgRange.FType"));
        Object[] params = new Object[]{userPK.toString(), treeID};
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    public FullOrgUnitCollection getOrgRange_old(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE OrgRange.FUserID = ? AND Structure.FTreeId = ? ").append(this.getOrgRangeFilter(orgType, "OrgRange.FType"));
        Object[] params = new Object[]{userPK.toString(), treeID};
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                fullOrgUnitInfo.setLongNumber(rs.getString("FLongNumber"));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getOrgRangeOfIncludeSubCU(IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, ").append("BaseUnit.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = BaseUnit.FControlUnitID ").append(" WHERE OrgRange.FUserID = ? AND Structure.FTreeId = ? ");
        String longNumber = PermissionUtil.getOrgLongNumber(this.context, OrgType.ControlUnit, ctrlUnitPK) + "!%";
        sql.append(" AND CtrlUnit.FLongNumber || N'!' LIKE N'").append(longNumber).append("' ").append(this.getOrgRangeFilter(orgType, "OrgRange.FType"));
        Object[] params = new Object[]{userPK.toString(), treeID};
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getOrgRangeOfCU(IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws EASBizException, BOSException {
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, ").append("BaseUnit.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE OrgRange.FUserID = ? AND Structure.FTreeId = ? AND BaseUnit.FControlUnitID = ? ").append(this.getOrgRangeFilter(orgType, "OrgRange.FType"));
        Object[] params = new Object[]{userPK.toString(), treeID, ctrlUnitPK.toString()};
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getAuthorizedOrg(IObjectPK userPK, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String field = permItemName;
        List orgIdList = (List)PermCacheHelper.getPermCacheValue(PermCacheHelper.ORGPERMCACHE, userPK.toString(), field);
        if (orgIdList != null) {
            result = this.getFullOrgUnitCollectionByOrgIds(orgIdList);
            return result;
        }
        orgIdList = this.getAuthorizedOrgIds_new(userPK, orgTreePK, permItemName);
        result = this.getFullOrgUnitCollectionByOrgIds(orgIdList);
        PermCacheHelper.putPermCacheValue(PermCacheHelper.ORGPERMCACHE, userPK.toString(), field, orgIdList);
        return result;
    }

    @Override
    public Map getAuthorizedOrg(IObjectPK userPK, IObjectPK orgTreePK, String permItemName, Set orgIdSet) throws BOSException, EASBizException {
        long t21;
        long t2;
        assert (userPK != null && permItemName != null);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Object org : orgIdSet) {
            String orgId = org.toString();
            BOSUuid.read((String)orgId);
            result.put(orgId, false);
        }
        LowTimeHelper time = new LowTimeHelper();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String permItemID = permItemInfo.getId().toString();
        String treeID = null;
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            return result;
        }
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation()) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? AND BaseUnit.fid in(" + ToolUtils.aryToStr(orgIdSet) + ") AND EXISTS ( ").append(this.getAuthorizedOrgIdsSQL(this.context, permItemID)).append(") ").append(" AND  NOT  EXISTS ( ").append(this.getForbiddenOrgIdsSQL(this.context, permItemID)).append(")");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, treeID);
            String userID = userPK.toString();
            ps.setString(2, userID);
            ps.setString(3, userID);
            ps.setString(4, userID);
            ps.setString(5, userID);
            long t1 = System.currentTimeMillis();
            rs = ps.executeQuery();
            t2 = System.currentTimeMillis() - t1;
            t21 = System.currentTimeMillis();
            while (rs.next()) {
                result.put(rs.getString("FID"), true);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        long t3 = System.currentTimeMillis() - t21;
        logger.error((Object)"\u4e2d\u5347\u65b0\u63a5\u53e3\u65e5\u5fd7");
        logger.error((Object)("orgTreePK ===" + orgTreePK));
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<executeQuery sql:" + sql));
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<executeQuery cost:" + t2));
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<rs.next cost:" + t3));
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        return result;
    }

    public FullOrgUnitCollection getFullOrgUnitCollectionByOrgIds(List orgIds) throws BOSException {
        IFullOrgUnit iFoc = FullOrgUnitFactory.getLocalInstance((Context)this.context);
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filerInfo = new FilterInfo();
        env.setFilter(filerInfo);
        env.getFilter().getFilterItems().add(new FilterItemInfo("id in(" + ToolUtils.aryToStr(orgIds, true) + ")"));
        return iFoc.getFullOrgUnitCollection(env);
    }

    public List getAuthorizedOrgIds_new(IObjectPK userPK, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        long t21;
        long t2;
        assert (userPK != null && permItemName != null);
        LowTimeHelper time = new LowTimeHelper();
        ArrayList<String> result = new ArrayList<String>(1000);
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String permItemID = permItemInfo.getId().toString();
        String treeID = null;
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            result.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            return result;
        }
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation()) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? AND EXISTS ( ").append(this.getAuthorizedOrgIdsSQL(this.context, permItemID)).append(") ").append(" AND  NOT  EXISTS ( ").append(this.getForbiddenOrgIdsSQL(this.context, permItemID)).append(")");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, treeID);
            String userID = userPK.toString();
            ps.setString(2, userID);
            ps.setString(3, userID);
            ps.setString(4, userID);
            ps.setString(5, userID);
            long t1 = System.currentTimeMillis();
            rs = ps.executeQuery();
            t2 = System.currentTimeMillis() - t1;
            t21 = System.currentTimeMillis();
            while (rs.next()) {
                result.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        long t3 = System.currentTimeMillis() - t21;
        logger.error((Object)"getAuthorizedOrgIds_new222222222222222222222222222222");
        logger.error((Object)("orgTreePK ===" + orgTreePK));
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<executeQuery sql:" + sql));
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<executeQuery cost:" + t2));
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<rs.next cost:" + t3));
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        return result;
    }

    public FullOrgUnitCollection getAuthorizedOrg_old(IObjectPK userPK, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        long t1 = System.currentTimeMillis();
        logger.error((Object)"getAuthorizedOrg_old   \u67e5\u8be2\u5f00\u59cb---------------------");
        LowTimeHelper time = new LowTimeHelper();
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String permItemID = permItemInfo.getId().toString();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation()) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? AND EXISTS ( ").append(this.getAuthorizedOrgIdsSQL(this.context, permItemID)).append(") ").append("  AND NOT EXISTS ( ").append(this.getForbiddenOrgIdsSQL(this.context, permItemID)).append(")");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, treeID);
            String userID = userPK.toString();
            ps.setString(2, userID);
            ps.setString(3, userID);
            ps.setString(4, userID);
            ps.setString(5, userID);
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                String orgId = rs.getString("FID");
                fullOrgUnitInfo.setId(BOSUuid.read((String)orgId));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                fullOrgUnitInfo.setLongNumber(rs.getString("FLongNumber"));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        logger.error((Object)"getAuthorizedOrg_old\u67e5\u8be2\u7ed3\u675f---------------------");
        long t2 = System.currentTimeMillis();
        logger.error((Object)("getAuthorizedOrg_old\u67e5\u8be2\u8017\u65f6---------------------t=====" + (t2 - t1)));
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        return result;
    }

    @Override
    public FullOrgUnitCollection getAuthorizedOrgIds(IObjectPK userPK, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        LowTimeHelper time = new LowTimeHelper();
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String permItemID = permItemInfo.getId().toString();
        Set forbiddenOrgIds = this.getForbiddenOrgIds(this.context, userPK, permItemID);
        Set authorizedOrgIds = this.getAuthorizedOrgIds(this.context, userPK, permItemID);
        Collection hasPermOrgIds = CollectionUtils.subtract((Collection)authorizedOrgIds, (Collection)forbiddenOrgIds);
        for (String orgId : hasPermOrgIds) {
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            fullOrgUnitInfo.setId(BOSUuid.read((String)orgId));
            result.add(fullOrgUnitInfo);
        }
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        return result;
    }

    @Override
    public Set getAuthorizedOrgWithNoDetails(IObjectPK userPK, OrgType orgType, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgType != null || permItemName != null);
        LowTimeHelper time = new LowTimeHelper();
        HashSet<BOSUuid> result = new HashSet<BOSUuid>();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String permItemID = permItemInfo.getId().toString();
        Set forbiddenOrgIds = this.getForbiddenOrgIds(this.context, userPK, permItemID);
        Set authorizedOrgIds = this.getAuthorizedOrgIds(this.context, userPK, permItemID);
        Collection hasPermOrgIds = CollectionUtils.subtract((Collection)authorizedOrgIds, (Collection)forbiddenOrgIds);
        String treeID = null;
        if (OrgCommonUtils.isBasicOrgType((OrgType)orgType)) {
            treeID = PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        } else if (OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation())) {
            treeID = PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        } else {
            return ToolUtils.objAryToSet(hasPermOrgIds);
        }
        Object[] params = new Object[]{treeID};
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT Structure.FUnitId  FROM T_ORG_Structure Structure ").append(" WHERE Structure.FTreeId = ? AND Structure.FUnitId IN ( ").append(ToolUtils.aryToStr(hasPermOrgIds)).append(")");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String orgId = rs.getString("FUnitId");
                if (forbiddenOrgIds.contains(orgId)) continue;
                result.add(BOSUuid.read((String)orgId));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getAuthorizedOrgWithNoDetails");
        return result;
    }

    private Set getAuthorizedOrgIds(Context ctx, IObjectPK userPK, String permItemID) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        String userID = userPK.toString();
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ");
        sql.append(" UNION  ");
        sql.append(" SELECT distinct UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ");
        Object[] params = new Object[]{userID, permItemID, new Integer(10), userID, permItemID, new Integer(10)};
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString("FOrgID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"getForbiddenOrgIds", (Throwable)e);
                throw new BOSException();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return ret;
    }

    private String getAuthorizedOrgIdsSQL(Context ctx, String permItemID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM T_PM_UserOrgPerm USERORGPERM ").append(" WHERE UserOrgPerm.FOwner = ? AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(10).append(" AND USERORGPERM.Forgid = BaseUnit.fid ").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(10).append(" AND UserRoleOrg.Forgid = BaseUnit.fid ");
        return sql.toString();
    }

    private Set getForbiddenOrgIds(Context ctx, IObjectPK userPK, String permItemID) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        String userID = userPK.toString();
        Object[] params = new Object[]{userID, permItemID, new Integer(20), userID, permItemID, new Integer(20)};
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ").append(" UNION ALL ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString("FOrgID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"getForbiddenOrgIds", (Throwable)e);
                throw new BOSException();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return ret;
    }

    private String getForbiddenOrgIdsSQL(Context ctx, String permItemID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM T_PM_UserOrgPerm USERORGPERM ").append(" WHERE UserOrgPerm.FOwner = ? AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(20).append(" AND USERORGPERM.Forgid = BaseUnit.fid ").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(20).append(" AND UserRoleOrg.Forgid = BaseUnit.fid ");
        return sql.toString();
    }

    @Override
    public FullOrgUnitCollection getAuthorizedOrgOfIncludeSubCU(IObjectPK ctrlUnitPK, IObjectPK userPK, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null && userPK != null && permItemName != null);
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String userID = userPK.toString();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation()) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        String permItemID = permItemInfo.getId().toString();
        Object[] params = new Object[]{treeID, userID, permItemID, new Integer(10), userID, permItemID, new Integer(10), userID, permItemID, new Integer(20), userID, permItemID, new Integer(20)};
        String longNumber = PermissionUtil.getOrgLongNumber(this.context, OrgType.ControlUnit, ctrlUnitPK) + "!%";
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, ").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ");
        sql.append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ");
        sql.append(" INNER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = BaseUnit.FControlUnitID ");
        sql.append(" WHERE Structure.FTreeId = ? AND CtrlUnit.FLongNumber || N'!' LIKE '").append(longNumber).append("' ");
        sql.append(" AND BaseUnit.FID IN ( ");
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ");
        sql.append(" UNION ALL ");
        sql.append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ");
        sql.append(" ) AND BaseUnit.FID NOT IN ( ");
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ");
        sql.append(" UNION ALL ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ");
        sql.append(" ) ");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new UserException(UserException.GET_ORGRANGE_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public FullOrgUnitCollection getAuthorizedOrgOfCU(IObjectPK ctrlUnitPK, IObjectPK userPK, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null && userPK != null && permItemName != null);
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String userID = userPK.toString();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation()) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        String permItemID = permItemInfo.getId().toString();
        String ctrlUnitID = ctrlUnitPK.toString();
        Object[] params = new Object[]{treeID, ctrlUnitID, userID, permItemID, new Integer(10), userID, permItemID, new Integer(10), userID, permItemID, new Integer(20), userID, permItemID, new Integer(20)};
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, ").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ");
        sql.append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? AND BaseUnit.FControlUnitID = ? ");
        sql.append(" AND BaseUnit.FID IN ( ");
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ");
        sql.append(" UNION ALL ");
        sql.append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ");
        sql.append(" ) AND BaseUnit.FID NOT IN ( ");
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ");
        sql.append(" UNION ALL ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ");
        sql.append(" ) ");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new UserException(UserException.GET_ORGRANGE_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    private String getOrgRangeFilter(OrgType orgType, String field) {
        StringBuffer filter = new StringBuffer();
        filter.append(" AND ").append(field).append(" = ").append(OrgType.Admin.equals((Object)orgType) ? 20 : 10).append(" ");
        return filter.toString();
    }

    @Override
    public FullOrgUnitCollection getAuthorizedOrg(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName, EntityViewInfo orgStructureView) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance(this.context);
        FullOrgUnitCollection fullOrgCol = iPermission.getAuthorizedOrg(userPK, orgType, orgTreePK, permItemName);
        if (fullOrgCol == null || fullOrgCol.size() == 0) {
            return new FullOrgUnitCollection();
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < fullOrgCol.size(); ++i) {
            String fullOrgIdStr = fullOrgCol.get(i).getId().toString();
            idList.add(fullOrgIdStr);
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)this.context);
        if (orgStructureView != null) {
            if (orgStructureView.getFilter() == null) {
                FilterInfo filter = new FilterInfo();
                orgStructureView.setFilter(filter);
            }
            orgStructureView.getFilter().getFilterItems().add(new FilterItemInfo("unit.id in (" + ToolUtils.aryToStr(idList, true) + ")"));
            IOrgStructure iOrgStructure = OrgStructureFactory.getLocalInstance((Context)this.context);
            OrgStructureCollection orgCol = iOrgStructure.getOrgStructureCollection(orgStructureView);
            if (orgCol == null || orgCol.size() == 0) {
                return new FullOrgUnitCollection();
            }
            HashSet<String> orgStructureSet = new HashSet<String>();
            for (int i = 0; i < orgCol.size(); ++i) {
                orgStructureSet.add(orgCol.get(i).getUnit().getId().toString());
            }
            return iFullOrgUnit.getFullOrgUnitCollection("select * where id in (" + ToolUtils.aryToStr(orgStructureSet, true) + ")");
        }
        return iFullOrgUnit.getFullOrgUnitCollection("select * where id in (" + ToolUtils.aryToStr(idList, true) + ")");
    }

    @Override
    public FullOrgUnitCollection getUnionUnitOfTree(IObjectPK userPK, IObjectPK orgTreePK, Timestamp datePoint) throws BOSException, EASBizException {
        assert (userPK != null);
        assert (orgTreePK != null);
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String[] idlist = UnionVersionControllerFacadeFactory.getLocalInstance((Context)this.context).getIDList(datePoint);
            String idStr = ToolUtils.aryToStr(idlist);
            String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
            StringBuffer buffer = new StringBuffer();
            buffer.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, ").append("BaseUnit.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE BaseUnit.FIsUnion = 1 AND OrgRange.FUserID = ? AND Structure.FTreeId in(" + idStr + ") ").append(" AND OrgRange.FType = ").append(10);
            Object[] params = new Object[]{userPK.toString()};
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(buffer.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    public OrgUnitCollection getAuthorizedOrg(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName, SelectorItemCollection selector) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        LowTimeHelper time = new LowTimeHelper();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String permItemID = permItemInfo.getId().toString();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation()) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID forgid").append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = '" + treeID + "' AND EXISTS ( ").append(this.getAuthorizedOrgIdsSQL(this.context, permItemID)).append(") ").append(" AND NOT EXISTS ( ").append(this.getForbiddenOrgIdsSQL(this.context, permItemID)).append(") ");
        String userID = userPK.toString();
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])new Object[]{userID, userID, userID, userID});
        ArrayList<String> struList = new ArrayList<String>();
        try {
            while (rs.next()) {
                struList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        OrgUnitCollection orgUnitCollection = this.getOrgUnitCollection(1000, struList, orgType, selector);
        logger.error((Object)("\u4e1a\u52a1selectoor==================" + selector));
        logger.error((Object)("\u4e1a\u52a1result==================" + orgUnitCollection));
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        return orgUnitCollection;
    }

    @Override
    public OrgUnitCollection getOrgRange(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, SelectorItemCollection selector) throws EASBizException, BOSException {
        LowTimeHelper time = new LowTimeHelper();
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        OrgUnitCollection result = new OrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID forgid").append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE OrgRange.FUserID = '" + userPK.toString() + "' AND Structure.FTreeId = '" + treeID + "'").append(this.getOrgRangeFilter(orgType, "OrgRange.FType"));
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)sql.toString());
        ArrayList<String> struList = new ArrayList<String>();
        try {
            while (rs.next()) {
                struList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        OrgUnitCollection orgUnitCollection = this.getOrgUnitCollection(1000, struList, orgType, selector);
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        return orgUnitCollection;
    }

    @Override
    public OrgUnitCollection getAdminOrg(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, SelectorItemCollection selector) throws EASBizException, BOSException {
        LowTimeHelper time = new LowTimeHelper();
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID Forgid ").append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId =  '" + treeID + "'");
        if (Administrator.isCUAdmin(this.context, userPK)) {
            sql.append(" AND BaseUnit.FControlUnitID in (" + PermissionRangeHelper.getCUOrgRangeSQL(this.context) + ")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)sql.toString());
        ArrayList<String> struList = new ArrayList<String>();
        try {
            while (rs.next()) {
                struList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        OrgUnitCollection orgUnitCollection = this.getOrgUnitCollection(1000, struList, orgType, selector);
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getAdminOrg");
        return orgUnitCollection;
    }

    private Set getAuthorizedOrgIdsSet(Context ctx, IObjectPK userPK, String permItemID) throws BOSException, EASBizException {
        String userID = userPK.toString();
        String userPermSQL = "SELECT FPermType,FOrgID FROM T_PM_UserOrgPerm  WHERE FOwner = '" + userID + "' AND FPermItemID = '" + permItemID + "' AND FPermType in(10,20) ";
        String rolePermSQL = "SELECT FPermType,FRoleID FROM T_PM_RolePerm WHERE FPermItemID = '" + permItemID + "' AND FPermType in(10,20) ";
        String userRoleSQL = "SELECT FRoleID, FOrgID FROM T_PM_UserRoleOrg   WHERE FUserID = '" + userID + "'";
        HashSet result = new HashSet();
        HashSet<String> rolePerm_n = new HashSet<String>();
        HashSet<String> rolePerm_f = new HashSet<String>();
        HashSet<String> userPerm_n = new HashSet<String>();
        HashSet<String> userPerm_f = new HashSet<String>();
        HashMap mpRolePerm = new HashMap();
        HashMap mpUserRole = new HashMap();
        IRowSet set1 = DbUtil.executeQuery((Context)ctx, (String)rolePermSQL);
        IRowSet set2 = DbUtil.executeQuery((Context)ctx, (String)userRoleSQL);
        IRowSet set3 = DbUtil.executeQuery((Context)ctx, (String)userPermSQL);
        try {
            while (set3.next()) {
                if (set3.getInt(1) == 20) {
                    userPerm_f.add(set3.getString(2));
                }
                if (set3.getInt(1) != 10) continue;
                userPerm_n.add(set3.getString(2));
            }
            userPerm_n.removeAll(userPerm_f);
            while (set1.next()) {
                if (set1.getInt(1) == 20) {
                    rolePerm_f.add(set1.getString(2));
                }
                if (set1.getInt(1) != 10) continue;
                rolePerm_n.add(set1.getString(2));
            }
            rolePerm_n.removeAll(rolePerm_f);
            while (set2.next()) {
                if (mpUserRole.get(set2.getString(1)) == null) {
                    HashSet set = new HashSet();
                    mpUserRole.put(set2.getString(1), set);
                    continue;
                }
                ((Set)mpUserRole.get(set2.getString(1))).add(set2.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        for (String strRoleid : mpUserRole.keySet()) {
            if (!rolePerm_n.contains(strRoleid)) continue;
            result.addAll((Collection)mpUserRole.get(strRoleid));
        }
        result.addAll(userPerm_n);
        return result;
    }

    private OrgUnitCollection getOrgUnitCollection(int PERSIZE, List struList, OrgType orgType, SelectorItemCollection selector) throws BOSException {
        int totalSize = struList.size();
        int totalCount = (totalSize - 1) / PERSIZE + 1;
        int begin = 0;
        int end = 0;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterInfo = null;
        List subList = new ArrayList();
        HashSet subSet = new HashSet();
        OrgUnitCollection orgUnitCollection = new OrgUnitCollection();
        for (int i = 0; i < totalCount; ++i) {
            begin = i * PERSIZE;
            end = (i + 1) * PERSIZE > totalSize ? totalSize : (i + 1) * PERSIZE;
            subList = struList.subList(begin, end);
            subSet.addAll(subList);
            filterInfo = new FilterItemInfo("id", subSet, CompareType.INCLUDE);
            filter.getFilterItems().add(filterInfo);
            view.setFilter(filter);
            view.setSelector(selector);
            orgUnitCollection.addObjectCollection((IObjectCollection)this.getObjectCollection(this.context, orgType, view));
            view.getFilter().getFilterItems().clear();
            subSet.clear();
        }
        return orgUnitCollection;
    }

    private FullOrgUnitCollection getFullOrgUnitCollection(int PERSIZE, List struList, OrgType orgType, SelectorItemCollection selector) throws BOSException {
        int totalSize = struList.size();
        int totalCount = (totalSize - 1) / PERSIZE + 1;
        int begin = 0;
        int end = 0;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterInfo = null;
        List subList = new ArrayList();
        HashSet subSet = new HashSet();
        FullOrgUnitCollection fullOrgUnitCollection = new FullOrgUnitCollection();
        for (int i = 0; i < totalCount; ++i) {
            begin = i * PERSIZE;
            end = (i + 1) * PERSIZE > totalSize ? totalSize : (i + 1) * PERSIZE;
            subList = struList.subList(begin, end);
            subSet.addAll(subList);
            filterInfo = new FilterItemInfo("id", subSet, CompareType.INCLUDE);
            filter.getFilterItems().add(filterInfo);
            view.setFilter(filter);
            view.setSelector(selector);
            fullOrgUnitCollection.addObjectCollection((IObjectCollection)this.getObjectCollection(this.context, orgType, view));
            view.getFilter().getFilterItems().clear();
            subSet.clear();
        }
        return fullOrgUnitCollection;
    }

    private AbstractObjectCollection getObjectCollection(Context context, OrgType orgType, EntityViewInfo view) throws BOSException {
        Object orgCollection = null;
        orgCollection = OrgType.Company.equals((Object)orgType) ? CompanyOrgUnitFactory.getLocalInstance((Context)context).getCompanyOrgUnitCollection(view) : (OrgType.Sale.equals((Object)orgType) ? SaleOrgUnitFactory.getLocalInstance((Context)context).getSaleOrgUnitCollection(view) : (OrgType.Purchase.equals((Object)orgType) ? PurchaseOrgUnitFactory.getLocalInstance((Context)context).getPurchaseOrgUnitCollection(view) : (OrgType.Storage.equals((Object)orgType) ? StorageOrgUnitFactory.getLocalInstance((Context)context).getStorageOrgUnitCollection(view) : (OrgType.CostCenter.equals((Object)orgType) ? CostCenterOrgUnitFactory.getLocalInstance((Context)context).getCostCenterOrgUnitCollection(view) : (OrgType.ProfitCenter.equals((Object)orgType) ? ProfitCenterOrgUnitFactory.getLocalInstance((Context)context).getProfitCenterOrgUnitCollection(view) : (OrgType.Transport.equals((Object)orgType) ? TransportOrgUnitFactory.getLocalInstance((Context)context).getTransportOrgUnitCollection(view) : (OrgType.Quality.equals((Object)orgType) ? QualityOrgUnitFactory.getLocalInstance((Context)context).getQualityOrgUnitCollection(view) : (OrgType.Admin.equals((Object)orgType) ? AdminOrgUnitFactory.getLocalInstance((Context)context).getAdminOrgUnitCollection(view) : FullOrgUnitFactory.getLocalInstance((Context)context).getFullOrgUnitCollection(view)))))))));
        return orgCollection;
    }

    @Override
    public Set getAuthorizedOrgIDSet(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        long t2;
        assert (userPK != null && permItemName != null);
        HashSet<String> authorizedOrgIds = new HashSet<String>();
        LowTimeHelper time = new LowTimeHelper();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String permItemID = permItemInfo.getId().toString();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation()) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? AND EXISTS ( ").append(this.getAuthorizedOrgIdsSQL(this.context, permItemID)).append(") ").append(" AND NOT EXISTS ( ").append(this.getForbiddenOrgIdsSQL(this.context, permItemID)).append(")");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, treeID);
            String userID = userPK.toString();
            ps.setString(2, userID);
            ps.setString(3, userID);
            ps.setString(4, userID);
            ps.setString(5, userID);
            long t1 = System.currentTimeMillis();
            rs = ps.executeQuery();
            t2 = System.currentTimeMillis() - t1;
            while (rs.next()) {
                authorizedOrgIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        long t3 = System.currentTimeMillis() - t2;
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<executeQuery sql:" + sql));
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<executeQuery cost:" + t2));
        logger.error((Object)("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<rs.next cost:" + t3));
        time.printTime2Last("<<<<<<<<<<<<<<<<<<<<<<<getauthorizedOrgs");
        return authorizedOrgIds;
    }

    @Override
    public Set getAdminOrgIDSet(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws BOSException, EASBizException {
        HashSet<String> adminOrgIds = new HashSet<String>();
        if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType) && orgTreePK == null) {
            throw new IllegalArgumentException("Union's orgTreePK can not be null !");
        }
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        Object[] params = new Object[]{treeID};
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber,Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? ");
        if (Administrator.isCUAdmin(this.context, userPK)) {
            sql.append(" AND BaseUnit.FControlUnitID in (" + PermissionRangeHelper.getCUOrgRangeSQL(this.context) + ")");
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                adminOrgIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return adminOrgIds;
    }

    @Override
    public Set getOrgRangeIDSet(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK) throws BOSException, EASBizException {
        HashSet<String> orgRangeIds = new HashSet<String>();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)orgType) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, orgType);
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, Structure.FLongNumber,").append("BaseUnit.").append(nameField).append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" WHERE OrgRange.FUserID = ? AND Structure.FTreeId = ? ").append(this.getOrgRangeFilter(orgType, "OrgRange.FType"));
        Object[] params = new Object[]{userPK.toString(), treeID};
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                orgRangeIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return orgRangeIds;
    }
}

