/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service.multiorg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.DiscretePermException;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.service.multiorg.IMultiOrgDiscretePermissionService;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiOrgDiscretePermissionService
implements IMultiOrgDiscretePermissionService {
    private static Logger logger = Logger.getLogger(MultiOrgDiscretePermissionService.class);
    private Context context = null;

    private MultiOrgDiscretePermissionService(Context context) {
        this.context = context;
    }

    public static IMultiOrgDiscretePermissionService getService(Context context) {
        return new MultiOrgDiscretePermissionService(context);
    }

    @Override
    public String getDiscretePermissionRule(IObjectPK userPK, Collection orgCollection, String permItemName) throws BOSException, EASBizException {
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        if (!this.isDiscretePermItem(permItemInfo)) {
            return null;
        }
        String sql = this.getDiscretePermissionSQL(BOSObjectType.create((String)permItemInfo.getObjectType()), userPK, orgCollection, (IObjectPK)new ObjectUuidPK(permItemInfo.getId()));
        StringBuffer rule = new StringBuffer(100);
        if (OperationType.ADDNEW.equals((Object)permItemInfo.getOperationType())) {
            return rule.append("WHERE creator.id = '").append(userPK.toString()).append("' ").toString();
        }
        if (StringUtils.isEmpty((String)sql)) {
            return rule.append("WHERE creator.id = '").append(userPK.toString()).append("' ").toString();
        }
        return rule.append("WHERE creator.id = '").append(userPK.toString()).append("' OR id IN (").append(sql).append(") ").toString();
    }

    private boolean isDiscretePermItem(PermItemInfo permItemInfo) {
        Set permItems = (Set)ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityPermItems().get(permItemInfo.getObjectType());
        if (permItems == null) {
            return false;
        }
        return permItems.contains(permItemInfo.getName());
    }

    private String getDiscretePermissionSQL(BOSObjectType objectType, IObjectPK userPK, Collection orgCollection, IObjectPK permItemPK) throws DiscretePermException, BOSException {
        StringBuffer sql = new StringBuffer(100);
        String tableName = this.getTableName(objectType);
        String userID = userPK.toString();
        String orgIDs = ToolUtils.aryToStr(orgCollection);
        String permItemID = permItemPK.toString();
        sql.append("SELECT 1 WHERE EXISTS( ").append(" SELECT 1 FROM ").append(tableName).append(" DiscretePerm ").append(" WHERE DiscretePerm.FUserID = ? ").append(" AND ( DiscretePerm.FOrgID IN (").append(orgIDs).append(") OR DiscretePerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ").append(" AND DiscretePerm.FPermItemID = ? ").append(" UNION ALL ").append(" SELECT 1 FROM ").append(tableName).append(" DiscretePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = DiscretePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND UserRoleOrg.FOrgID IN (").append(orgIDs).append(") ").append(" AND DiscretePerm.FPermItemID = ? )");
        Object[] params = new Object[]{userID, permItemID, userID, permItemID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                sql = new StringBuffer(100);
                sql.append("SELECT FBizDataID FID FROM ").append(tableName).append(" DiscretePerm ").append(" WHERE DiscretePerm.FUserID = '").append(userID).append("' ").append(" AND ( DiscretePerm.FOrgID IN (").append(orgIDs).append(") OR DiscretePerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ").append(" AND DiscretePerm.FPermItemID = '").append(permItemID).append("' ").append(" UNION ").append(" SELECT FBizDataID FID FROM ").append(tableName).append(" DiscretePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = DiscretePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' ").append(" AND UserRoleOrg.FOrgID IN (").append(orgIDs).append(") ").append(" AND DiscretePerm.FPermItemID = '").append(permItemID).append("' ");
                return sql.toString();
            }
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new DiscretePermException(DiscretePermException.GET_DATA_FAIL, e);
        }
    }

    private String getTableName(BOSObjectType objectType) {
        return (String)ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityTables().get(objectType.toString());
    }
}

