/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service.multiorg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.SpecialDataPermInfo;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.base.permission.app.service.SpecialDataPermissionHandler;
import com.kingdee.eas.base.permission.app.service.multiorg.IMultiOrgSpecialDataPermissionService;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgDataPermissionMap;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgPermissionUtils;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiOrgSpecialDataPermissionService
implements IMultiOrgSpecialDataPermissionService {
    private static Logger logger = Logger.getLogger((String)MultiOrgSpecialDataPermissionService.class.getName());
    private Context context = null;

    private MultiOrgSpecialDataPermissionService(Context context) {
        this.context = context;
    }

    public static IMultiOrgSpecialDataPermissionService getService(Context context) {
        return new MultiOrgSpecialDataPermissionService(context);
    }

    private String getPermissionRule_old(IObjectPK userPK, Collection orgCollection, String orgFieldName, PermItemInfo permItemInfo, MultiOrgDataPermissionMap dataPermissionMap) throws BOSException, EASBizException {
        Map cuMap = PermissionUtil.getControlUnitMap(this.context, orgCollection);
        Iterator cuit = cuMap.keySet().iterator();
        String dataPermRule = null;
        SpecialDataPermissionHandler specialDataPermissionHandler = new SpecialDataPermissionHandler(this.context);
        while (cuit.hasNext()) {
            String cuID = (String)cuit.next();
            List bizOrgList = (List)cuMap.get(cuID);
            String commonRuleStr = dataPermissionMap.getDataPermissionRule(bizOrgList.iterator(), orgFieldName);
            SpecialDataPermInfo specialDataPermInfo = new DataPermissionService(this.context).getSpecialDataPermInfo(cuID, permItemInfo);
            String rule = null;
            if (specialDataPermInfo != null) {
                String specialRule = specialDataPermissionHandler.getSpecialDataPermissionRule(userPK, null, specialDataPermInfo, permItemInfo);
                try {
                    rule = RuleUtil.mergeOQL(commonRuleStr, specialRule, "and");
                }
                catch (ParserException e) {
                    logger.error((Object)"getPermissionRule error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            } else {
                rule = commonRuleStr;
            }
            dataPermRule = MultiOrgPermissionUtils.mergeOQL(dataPermRule, rule);
        }
        return dataPermRule;
    }

    private String getPermissionRule_new(IObjectPK userPK, Collection orgCollection, String orgFieldName, PermItemInfo permItemInfo, MultiOrgDataPermissionMap dataPermissionMap) throws BOSException, EASBizException {
        Map cuMap = PermissionUtil.getControlUnitMap(this.context, orgCollection);
        Iterator cuit = cuMap.keySet().iterator();
        String dataPermRule = null;
        SpecialDataPermissionHandler specialDataPermissionHandler = new SpecialDataPermissionHandler(this.context);
        String logic = "OR";
        String globalParamLogic = ParamManager.getParamValue((Context)this.context, null, (String)"LogicOfCommonAndSpecialRule");
        globalParamLogic = StringUtils.isEmpty((String)globalParamLogic) || "1".equals(globalParamLogic) ? "OR" : "AND";
        while (cuit.hasNext()) {
            String cuID = (String)cuit.next();
            List bizOrgList = (List)cuMap.get(cuID);
            SpecialDataPermInfo specialDataPermInfo = new DataPermissionService(this.context).getSpecialDataPermInfo(cuID, permItemInfo);
            String rule = null;
            String specialRule = null;
            String bizPermitemlogic = null;
            if (specialDataPermInfo != null && !StringUtils.isEmpty((String)(specialRule = specialDataPermissionHandler.getSpecialDataPermissionRule(userPK, null, specialDataPermInfo, permItemInfo)))) {
                bizPermitemlogic = this.getItemLogicPriority(cuID, specialDataPermInfo, permItemInfo);
            }
            logic = bizPermitemlogic == null || "DF".equalsIgnoreCase(bizPermitemlogic) ? globalParamLogic : bizPermitemlogic;
            rule = dataPermissionMap.getDataPermissionRule(bizOrgList.iterator(), orgFieldName, specialRule, logic);
            dataPermRule = MultiOrgPermissionUtils.mergeOQL(dataPermRule, rule);
        }
        return dataPermRule;
    }

    private String getPermissionRule_New(IObjectPK userPK, Collection orgCollection, String orgFieldName, PermItemInfo permItemInfo, MultiOrgDataPermissionMap dataPermissionMap) throws BOSException, EASBizException {
        Map cuMap = PermissionUtil.getControlUnitMap(this.context, orgCollection);
        Iterator cuit = cuMap.keySet().iterator();
        String dataPermRule = null;
        SpecialDataPermissionHandler specialDataPermissionHandler = new SpecialDataPermissionHandler(this.context);
        String logic = "OR";
        String globalParamLogic = ParamManager.getParamValue((Context)this.context, null, (String)"LogicOfCommonAndSpecialRule");
        globalParamLogic = StringUtils.isEmpty((String)globalParamLogic) || "1".equals(globalParamLogic) ? "OR" : "AND";
        String orgIds = "";
        while (cuit.hasNext()) {
            String cuID = (String)cuit.next();
            List bizOrgList = (List)cuMap.get(cuID);
            SpecialDataPermInfo specialDataPermInfo = new DataPermissionService(this.context).getSpecialDataPermInfo(cuID, permItemInfo);
            String rule = null;
            String specialRule = null;
            String bizPermitemlogic = null;
            if (specialDataPermInfo != null && !StringUtils.isEmpty((String)(specialRule = specialDataPermissionHandler.getSpecialDataPermissionRule(userPK, null, specialDataPermInfo, permItemInfo)))) {
                bizPermitemlogic = this.getItemLogicPriority(cuID, specialDataPermInfo, permItemInfo);
            }
            logic = bizPermitemlogic == null || "DF".equalsIgnoreCase(bizPermitemlogic) ? globalParamLogic : bizPermitemlogic;
            rule = dataPermissionMap.getDataPermissionRule_new(bizOrgList.iterator(), orgFieldName, specialRule, logic);
            if (StringUtils.isEmpty((String)rule)) continue;
            if (rule.indexOf("ids:") > -1) {
                rule = rule.substring(4);
                if (StringUtils.isEmpty((String)orgIds)) {
                    orgIds = rule;
                    continue;
                }
                orgIds = orgIds + "," + rule;
                continue;
            }
            if (StringUtils.isEmpty(dataPermRule)) {
                dataPermRule = rule;
                continue;
            }
            dataPermRule = this.mergeOQL(dataPermRule, rule, "OR");
        }
        if (StringUtils.isEmpty(dataPermRule)) {
            if (StringUtils.isEmpty((String)orgIds)) {
                return "";
            }
            return "WHERE " + orgFieldName + " IN (" + orgIds + ")";
        }
        if (StringUtils.isEmpty((String)orgIds)) {
            return dataPermRule;
        }
        return this.mergeOQL(dataPermRule, "WHERE " + orgFieldName + " IN (" + orgIds + ")", "OR");
    }

    private String mergeOQL(String dataPermRule, String rule2, String bLogic) throws BOSException, PermissionException {
        try {
            dataPermRule = RuleUtil.mergeOQL(dataPermRule, rule2, bLogic);
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
        return dataPermRule;
    }

    @Override
    public String getPermissionRule(IObjectPK userPK, Collection orgCollection, String orgFieldName, PermItemInfo permItemInfo, MultiOrgDataPermissionMap dataPermissionMap) throws BOSException, EASBizException {
        return this.getPermissionRule_New(userPK, orgCollection, orgFieldName, permItemInfo, dataPermissionMap);
    }

    private String getItemLogicPriority(String cuID, SpecialDataPermInfo specialDataPermInfo, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        String bizPermitemlogic = null;
        if (specialDataPermInfo != null) {
            SpecialDataPermissionHandler specialDataPermissionHandler = new SpecialDataPermissionHandler(this.context);
            bizPermitemlogic = specialDataPermissionHandler.getSpecialDataPermEntry(specialDataPermInfo, permItemInfo).getLogicTag().getValue();
        }
        return bizPermitemlogic;
    }
}

