/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.formula.engine.FormulaEngine;
import com.kingdee.bos.service.formula.engine.RunFormulaException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionConstant;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BizObjectOrgUtil {
    private static Logger logger = Logger.getLogger(BizObjectOrgUtil.class);

    public static boolean isSubFromCoreBillBase(Context context, BOSObjectType objectType) {
        return BizObjectOrgUtil.isSubFromCoreBillBase(context, objectType, PermissionConstant.CORE_BILL_BASE_TYPE);
    }

    public static boolean isSubFromCoreBillBase(Context context, BOSObjectType objectType, BOSObjectType mainObjectType) {
        return BizObjectOrgUtil.isSubFrom(context, objectType, mainObjectType);
    }

    public static boolean isSubFrom(Context context, BOSObjectType sonObjectType, BOSObjectType baseObjectType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)context);
        EntityObjectInfo baseEntity = loader.getEntity(baseObjectType);
        EntityObjectInfo entity = loader.getEntity(sonObjectType);
        return entity.isSubFrom((BusinessObjectInfo)baseEntity);
    }

    public static String[] getBizOrgCoopPropertyName(Context ctx, BOSObjectType objectType) throws EASBizException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)BizObjectOrgUtil.getCoreBaseInfo(ctx, objectType);
        return coreBillBaseInfo.getCooperatedOrgName();
    }

    public static String getBizOrgPropertyName(Context ctx, BOSObjectType objectType) throws EASBizException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)BizObjectOrgUtil.getCoreBaseInfo(ctx, objectType);
        return coreBillBaseInfo.getBizOrgPropertyName();
    }

    private static CoreBaseInfo getCoreBaseInfo(Context ctx, BOSObjectType objectType) throws EASBizException {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(objectType);
        String className = entity.getObjectValueClass();
        CoreBaseInfo objBaseInfo = null;
        try {
            Class<?> valueClass = Class.forName(className);
            objBaseInfo = (CoreBaseInfo)valueClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return objBaseInfo;
    }

    public static String[] getSubBizOrgCoopPropertyName(Context ctx, BOSObjectType objectType) throws EASBizException {
        CoreBillEntryBaseInfo coreBillEntryBaseInfo = (CoreBillEntryBaseInfo)BizObjectOrgUtil.getCoreBaseInfo(ctx, objectType);
        return coreBillEntryBaseInfo.getCooperatedOrgName();
    }

    public static String getSubBizOrgPropertyName(Context ctx, BOSObjectType objectType) throws EASBizException {
        CoreBillEntryBaseInfo coreBillEntryBaseInfo = (CoreBillEntryBaseInfo)BizObjectOrgUtil.getCoreBaseInfo(ctx, objectType);
        return coreBillEntryBaseInfo.getBizOrgPropertyName();
    }

    public static IObjectPK getCoreBillBaseBizOrgPK(Context context, BOSObjectType objectType, Object bizData) throws BOSException, EASBizException {
        if (bizData instanceof IObjectPK) {
            String orgPropertyName = BizObjectOrgUtil.getBizOrgPropertyName(context, objectType);
            if (StringUtils.isEmpty((String)orgPropertyName)) {
                return null;
            }
            IObjectValue bizValue = BizObjectOrgUtil.getBizValue(context, objectType, (IObjectPK)bizData, orgPropertyName);
            if (bizValue == null) {
                return null;
            }
            Object orgValue = bizValue.get(orgPropertyName);
            if (orgValue == null) {
                return null;
            }
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)orgValue;
            if (orgUnitInfo.getId() == null) {
                return null;
            }
            return new ObjectUuidPK(orgUnitInfo.getId());
        }
        if (bizData instanceof IObjectValue) {
            String orgPropertyName = ((CoreBillBaseInfo)bizData).getBizOrgPropertyName();
            if (StringUtils.isEmpty((String)orgPropertyName)) {
                return null;
            }
            AbstractObjectValue abstractObjectValue = (AbstractObjectValue)bizData;
            if (abstractObjectValue.containsKey(orgPropertyName)) {
                Object orgValue = abstractObjectValue.get(orgPropertyName);
                if (orgValue == null) {
                    return null;
                }
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)orgValue;
                if (orgUnitInfo.getId() == null) {
                    return null;
                }
                return new ObjectUuidPK(orgUnitInfo.getId());
            }
            String idPropertyName = abstractObjectValue.getPKField();
            if (abstractObjectValue.containsKey(idPropertyName)) {
                Object objBizDataID = abstractObjectValue.get(idPropertyName);
                if (objBizDataID == null) {
                    return null;
                }
                IObjectValue bizValue = BizObjectOrgUtil.getBizValue(context, objectType, (IObjectPK)new ObjectUuidPK((BOSUuid)objBizDataID), orgPropertyName);
                if (bizValue == null) {
                    return null;
                }
                Object orgValue = bizValue.get(orgPropertyName);
                if (orgValue == null) {
                    return null;
                }
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)orgValue;
                if (orgUnitInfo.getId() == null) {
                    return null;
                }
                return new ObjectUuidPK(orgUnitInfo.getId());
            }
            return null;
        }
        throw new IllegalArgumentException("bizData:" + bizData + " is error! ");
    }

    private static SelectorItemCollection getBizOrgSelectors(String orgPropertyName) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo(orgPropertyName + ".id"));
        return sic;
    }

    public static IObjectValue getBizValue(Context context, BOSObjectType objectType, IObjectPK bizDataPK, String orgPropertyName) throws BOSException, PermissionException {
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)context);
            ORMappingDAO dao = new ORMappingDAO(objectType, context, con);
            SelectorItemCollection sic = BizObjectOrgUtil.getBizOrgSelectors(orgPropertyName);
            IObjectValue iObjectValue = dao.getValue(bizDataPK, sic, true);
            return iObjectValue;
        }
        catch (ObjectNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            IObjectValue iObjectValue = null;
            return iObjectValue;
        }
        catch (SQLException se) {
            logger.error((Object)"sql is:", (Throwable)se);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, se);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    public static IObjectCollection getBizCollection(Context context, BOSObjectType objectType, String oql) throws BOSException, PermissionException {
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)context);
            ORMappingDAO dao = new ORMappingDAO(objectType, context, con);
            IObjectCollection iObjectCollection = dao.getCollection(oql);
            return iObjectCollection;
        }
        catch (ObjectNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            IObjectCollection iObjectCollection = null;
            return iObjectCollection;
        }
        catch (SQLException se) {
            logger.error((Object)"sql is:", (Throwable)se);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, se);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    public static String getBizValueByFormula(Context ctx, IObjectValue subValueInfo, String parentPropertyName) {
        String prefix = "value";
        String formulaStr = "formula_result=" + prefix + "." + parentPropertyName;
        HashMap<String, IObjectValue> personMap = new HashMap<String, IObjectValue>();
        personMap.put(prefix, subValueInfo);
        try {
            return StringUtils.cnulls((Object)FormulaEngine.runFormula((String)formulaStr, personMap, (Context)ctx));
        }
        catch (RunFormulaException e) {
            logger.error((Object)("formulaStr is:" + formulaStr), (Throwable)e);
            return null;
        }
    }
}

