/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermMutexExLockType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import java.util.Map;

public class PermMutexExLockManger {
    private static Map<String, MutexParameter> lockParams = new HashMap<String, MutexParameter>();
    private static String mutexName = "permission$exclusiveLock$";
    private static long preGet = System.currentTimeMillis();
    private static Map<String, Boolean> locks = new HashMap<String, Boolean>();

    private static MutexParameter getMutexParam(Context ctx, PermMutexExLockType lockType) {
        MutexParameter param = lockParams.get(lockType.getName());
        if (param == null) {
            param = new MutexParameter();
            param.setMutexName(mutexName + lockType.getName());
            param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
            param.setRequestId(Uuid.create());
            param.setDcName(SysContext.getSysContext().getDcName());
            param.setOrgUnitID(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            param.setActionName(lockType.getValue());
            param.setUserID(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            lockParams.put(lockType.getName(), param);
        }
        return param;
    }

    public static boolean tryLock(Context ctx, PermMutexExLockType lockType) throws BOSException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        return iMutex.requestMutex(PermMutexExLockManger.getMutexParam(ctx, lockType));
    }

    public static boolean nowIsLocked(Context ctx, PermMutexExLockType lockType) throws BOSException {
        MutexParameter lockParam;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean locallock = iMutex.requestMutex(lockParam = PermMutexExLockManger.getMutexParam(ctx, lockType));
        if (locallock) {
            iMutex.releaseMutex(lockParam.getRequestId());
        }
        return !locallock;
    }

    public static void releaseLock(Context ctx, PermMutexExLockType lockType) throws BOSException {
        MutexParameter lockParam;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter paramLock = iMutex.requestMutex3(lockParam = PermMutexExLockManger.getMutexParam(ctx, lockType));
        if (paramLock != null) {
            iMutex.releaseMutex(paramLock.getRequestId());
        } else {
            iMutex.releaseMutex(lockParam.getRequestId());
        }
    }

    public static boolean isUnLockedOfcache(Context ctx, PermMutexExLockType lockType, long validSpan) throws BOSException {
        Boolean nowisLocked = locks.get(lockType.getName());
        if (nowisLocked == null || System.currentTimeMillis() - preGet > validSpan) {
            nowisLocked = PermMutexExLockManger.nowIsLocked(ctx, lockType);
            locks.put(lockType.getName(), nowisLocked);
            preGet = System.currentTimeMillis();
        }
        return nowisLocked == false;
    }
}

