/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeParam;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.ldap.LdapProxy;
import com.kingdee.eas.base.permission.util.UserInfoHelper;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class UserImportCloudHelper {
    private static Logger logger = Logger.getLogger(UserImportCloudHelper.class);
    private ExecutorService es = null;
    private boolean isPersonToManyUser = false;
    private RoleCollection roleCol = null;
    private int successCount = 0;
    private volatile int totalCount = 0;

    public int importUser(Context ctx, String userArrayStr) throws BOSException, EASBizException {
        this.roleCol = this.getRoleByIsDefRole(ctx, true);
        this.isPersonToManyUser = this.isPersonCanReferenceManyUser(ctx);
        this.es = Executors.newFixedThreadPool(10);
        if (StringUtils.isEmpty((String)userArrayStr)) {
            return 0;
        }
        JSONArray userArray = JSONArray.parseArray((String)userArrayStr);
        List<UserInfo> userList = this.getAddUserList(ctx, userArray);
        int size = userList.size();
        this.insertUserInDB(ctx, userList);
        while (size > this.totalCount) {
        }
        return this.successCount;
    }

    private RoleCollection getRoleByIsDefRole(Context ctx, boolean isDefRole) throws BOSException {
        IRole iRole = RoleFactory.getLocalInstance(ctx);
        String oql = " WHERE isDefRole=" + (isDefRole ? 1 : 0);
        RoleCollection role = iRole.getRoleCollection(oql);
        return role;
    }

    private boolean isPersonCanReferenceManyUser(Context ctx) throws BOSException, EASBizException {
        String paramNumber = "PersonCanReferenceManyUser";
        String value = ParamManager.getParamValue((Context)ctx, null, (String)paramNumber);
        return "true".equalsIgnoreCase(value);
    }

    private void insertUserInDB(Context ctx, List<UserInfo> userList) {
        if (userList == null || userList.size() == 0) {
            return;
        }
        for (int i = 0; i < userList.size(); ++i) {
            AddUserThread thread = new AddUserThread(ctx, userList.get(i));
            this.es.execute(thread);
        }
    }

    private synchronized void addSuccessCount() {
        ++this.successCount;
    }

    private synchronized void addTotalCount() {
        ++this.totalCount;
    }

    private Map<String, PersonInfo> getPersonInDB(Context ctx, String sql, Set<String> filterSet) throws BOSException {
        if (filterSet == null || filterSet.size() == 0) {
            return null;
        }
        HashMap<String, PersonInfo> dataMap = new HashMap<String, PersonInfo>(512);
        StringBuffer filterSb = new StringBuffer();
        IRowSet rs = null;
        for (String filter : filterSet) {
            filterSb.append("'").append(filter.toLowerCase()).append("'");
            filterSb.append(",");
        }
        filterSb.deleteCharAt(filterSb.length() - 1);
        StringBuffer sbSql = new StringBuffer(sql);
        sbSql.append(" (").append(filterSb).append(")");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
            while (rs.next()) {
                String number = rs.getString("number");
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)rs.getString("fid")));
                person.setName(rs.getString("name"));
                person.setEmail(rs.getString("femail"));
                person.setBackupEMail(rs.getString("fbackupemail"));
                person.setOfficePhone(rs.getString("fofficephone"));
                person.setHomePhone(rs.getString("fhomephone"));
                dataMap.put(number, person);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return dataMap;
    }

    private Map<String, String> getDataInDB(Context ctx, String sql, Set<String> filterSet) throws BOSException {
        if (filterSet == null || filterSet.size() == 0) {
            return null;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(512);
        StringBuffer filterSb = new StringBuffer();
        IRowSet rs = null;
        for (String filter : filterSet) {
            filterSb.append("'").append(filter.toLowerCase()).append("'");
            filterSb.append(",");
        }
        filterSb.deleteCharAt(filterSb.length() - 1);
        StringBuffer sbSql = new StringBuffer(sql);
        sbSql.append(" (").append(filterSb).append(")");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
            while (rs.next()) {
                dataMap.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return dataMap;
    }

    private List<UserInfo> getAddUserList(Context ctx, JSONArray userArray) {
        ArrayList<UserInfo> userInfoList = new ArrayList<UserInfo>();
        try {
            if (userArray == null || userArray.size() == 0) {
                return null;
            }
            HashMap<String, JSONObject> userMap = new HashMap<String, JSONObject>(512);
            HashSet<String> personNumberSet = new HashSet<String>(512);
            HashSet<String> deptNameSet = new HashSet<String>(512);
            for (int i = 0; i < userArray.size(); ++i) {
                String dept;
                JSONObject o = (JSONObject)userArray.get(i);
                String userNumber = (String)o.get((Object)"erpNumber");
                String personNumber = (String)o.get((Object)"erpStaffNumber");
                if (StringUtils.isEmpty((String)userNumber) || userMap.containsKey(userNumber) || !this.isPersonToManyUser && personNumberSet.contains(personNumber)) continue;
                userMap.put(userNumber, o);
                if (!StringUtils.isEmpty((String)personNumber)) {
                    personNumberSet.add(personNumber);
                }
                if (StringUtils.isEmpty((String)(dept = (String)o.get((Object)"dept")))) continue;
                deptNameSet.add(dept);
            }
            Set<String> userNumberSet = userMap.keySet();
            String userSql = "select lower(fnumber),fid from t_pm_user where lower(FNUMBER) in ";
            String personSql = "select lower(fnumber) as number,fid,fname_l2 as name,femail,fbackupemail ,fofficephone,fhomephone from t_bd_person where lower(FNUMBER) in ";
            String deptSql = "select fname_l2,fid||'##'||FCONTROLUNITID from t_org_baseunit where FName_l2 in ";
            Map<String, String> userInDBMap = this.getDataInDB(ctx, userSql, userNumberSet);
            Map<String, PersonInfo> personInDBMap = this.getPersonInDB(ctx, personSql, personNumberSet);
            Map<String, String> deptInDBMap = this.getDataInDB(ctx, deptSql, deptNameSet);
            for (JSONObject o : userMap.values()) {
                String userNumber = (String)o.get((Object)"erpNumber");
                String userName = (String)o.get((Object)"cloudName");
                String personNumber = (String)o.get((Object)"erpStaffNumber");
                String dept = (String)o.get((Object)"dept");
                String phone = (String)o.get((Object)"phone");
                PersonInfo person = null;
                String deptId = "00000000-0000-0000-0000-000000000000CCE7AED4";
                String cuId = "00000000-0000-0000-0000-000000000000CCE7AED4";
                if (userInDBMap != null && !userInDBMap.isEmpty() && userInDBMap.containsKey(userNumber) || !StringUtils.isEmpty((String)personNumber) && (personInDBMap != null && personInDBMap.containsKey(personNumber) && !userName.equals((person = personInDBMap.get(personNumber)).getName()) || person == null)) continue;
                if (deptInDBMap != null && !deptInDBMap.isEmpty() && deptInDBMap.containsKey(dept)) {
                    String dept_cu = deptInDBMap.get(dept);
                    String[] dept_cuArray = dept_cu.split("##");
                    deptId = dept_cuArray[0];
                    cuId = dept_cuArray[1];
                }
                userInfoList.add(this.createUserInfo(userNumber, userName, phone, person, deptId, cuId));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return userInfoList;
    }

    private UserInfo createUserInfo(String userNumber, String userName, String phone, PersonInfo person, String deptId, String cuId) {
        UserInfo pmUserInfo = UserInfoHelper.createNewDefaultUserInfo();
        BOSUuid userID = BOSUuid.create((String)"13B7DE7F");
        pmUserInfo.setId(userID);
        pmUserInfo.setCell(phone);
        pmUserInfo.setChangedPW(true);
        pmUserInfo.setNumber(userNumber);
        SecurityInfo securityInfo = new SecurityInfo();
        securityInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000013EE2C673"));
        pmUserInfo.setSecurity(securityInfo);
        pmUserInfo.setName(userName);
        pmUserInfo.setPassword(null);
        pmUserInfo.setPwdHisStr(null);
        if (person == null) {
            pmUserInfo.setPerson(null);
            pmUserInfo.setType(UserType.OTHER);
        } else {
            pmUserInfo.setPerson(person);
            pmUserInfo.setEmail(person.getEmail());
            pmUserInfo.setBackupEMail(person.getBackupEMail());
            pmUserInfo.setHomePhone(person.getHomePhone());
            pmUserInfo.setOfficePhone(person.getOfficePhone());
        }
        FullOrgUnitInfo org = new FullOrgUnitInfo();
        org.setId(BOSUuid.read((String)deptId));
        pmUserInfo.setDefOrgUnit(org);
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)cuId));
        pmUserInfo.setCU(cu);
        return pmUserInfo;
    }

    private void addNewUser(Context ctx, IObjectValue model, boolean isPersonToManyUser, IObjectCollection roleCol) throws BOSException, EASBizException {
        UserInfo userInfo = (UserInfo)model;
        boolean isPersonType = UserType.PERSON.equals((Object)userInfo.getType());
        if (isPersonType) {
            this.addNewPersonUser(ctx, userInfo, isPersonToManyUser);
        } else {
            this.addNewSystemUser(ctx, userInfo);
        }
    }

    private void addNewPersonUser(Context ctx, UserInfo userInfo, boolean isPersonToManyUser) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        if (!isPersonToManyUser) {
            boolean result = iUser.exists("where person='" + userInfo.getPerson().getId().toString() + "' and isDelete=0");
            if (result) {
                logger.error((Object)("exist personUser*** " + userInfo.getPerson().getId() + " ***userNumber!=" + userInfo.getNumber()));
                return;
            }
        } else {
            String personId = userInfo.getPerson().getId().toString();
            AdminOrgUnitInfo adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("personId", personId);
            param.put("orgUnitId", adminOrgUnitInfo.getId().toString());
            param.put("userNumber", userInfo.getNumber());
            this.executeOSF(ctx, param, "generatetUserByAddPerson");
        }
    }

    private void addNewSystemUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        IObjectPK userPK = iUser.addnew((CoreBaseInfo)userInfo);
        userInfo.setId(BOSUuid.read((String)userPK.toString()));
        this.addOrgRangeOfNewUserForCloud(ctx, userInfo);
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(userPK.toString(), null);
    }

    private void addOrgRangeOfNewUserForCloud(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        String orgId = userInfo.getCU().getId().toString();
        ArrayList<String> orgIdCol = new ArrayList<String>();
        orgIdCol.add(orgId);
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, null, orgIdCol, null);
        iOrgRange.saveOrgRange(orgRangeParam);
    }

    private Object executeOSF(Context ctx, Map param, String serviceName) {
        Object rObj = null;
        try {
            Class<?> facadeClass = Class.forName("com.kingdee.shr.base.syssetting.IMSFServiceFacade");
            IBOSObject bosObject = null;
            bosObject = ctx == null ? BOSObjectFactory.createRemoteBOSObject((BOSObjectType)new BOSObjectType("95925689"), facadeClass) : BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("95925689"));
            Method method = facadeClass.getMethod("processService", String.class, Map.class);
            rObj = method.invoke((Object)bosObject, serviceName, param);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rObj;
    }

    class AddUserThread
    extends Thread {
        private Context ctx;
        private UserInfo userInfo;

        public AddUserThread() {
        }

        public AddUserThread(Context ctx, UserInfo userInfo) {
            this.ctx = ctx;
            this.userInfo = userInfo;
        }

        @Override
        public void run() {
            try {
                UserImportCloudHelper.this.addNewUser(this.ctx, (IObjectValue)this.userInfo, UserImportCloudHelper.this.isPersonToManyUser, (IObjectCollection)UserImportCloudHelper.this.roleCol);
                UserImportCloudHelper.this.addSuccessCount();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                UserImportCloudHelper.this.addTotalCount();
            }
        }
    }
}

