/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUsageInfo;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.permission.ActiveStateEnum;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserLicenseGroup;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLicenseGroupCollection;
import com.kingdee.eas.base.permission.UserLicenseGroupFactory;
import com.kingdee.eas.base.permission.UserLicenseGroupInfo;
import com.kingdee.eas.base.permission.app.GroupLicenseUseInfo;
import com.kingdee.eas.base.permission.app.LicenseGroupUsers;
import com.kingdee.eas.base.permission.app.helper.RolePermHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.app.util.PermThreadPool;
import com.kingdee.eas.base.permission.app.util.interior.ILicenseUseSrv;
import com.kingdee.eas.base.permission.app.util.interior.IUserLicenseGroupHelper;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseConstantHelper;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupActiveHelper;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper1;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper4User;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.DBUserBean;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupsInfo;
import com.kingdee.eas.base.permission.service.IValidateCommunicationService;
import com.kingdee.eas.base.permission.service.ValidateCommunicationFactory;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.permission.util.cloud.bean.ProductGroup;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.OptionalDataException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class LicenseUseManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.interior.LicenseUseManager");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static Context context = null;
    Map<String, String> userPermMap = null;
    static LicenseUseManager instance = null;
    List<LicenseUsageInfo> licenseUsages = null;
    List groupOverLoadList = null;
    UserLicenseGroupHelper1 groupHelper = null;

    private LicenseUseManager(Context ctx) {
        this.groupHelper = UserLicenseGroupHelper1.getInstance(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LicenseUseManager getInstance(Context ctx) {
        context = ctx;
        if (instance != null) return instance;
        Class<LicenseUseManager> clazz = LicenseUseManager.class;
        synchronized (LicenseUseManager.class) {
            if (instance != null) return instance;
            instance = new LicenseUseManager(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private ILicenseUseSrv getLicenseUseSev(Context ctx) throws BOSException {
        return LicenseUseSrvFactory.getLocalInstance(ctx);
    }

    public boolean disAssignUsersGroup(String groupNumber, int nums) throws BOSException, EASBizException {
        boolean success = false;
        success = this.getLicenseUseSev(context).disAssignUsersGroup(context, groupNumber, nums);
        return success;
    }

    public boolean disAssignUserGroup(String groupNumber) throws BOSException, EASBizException {
        return this.disAssignUsersGroup(groupNumber, 1);
    }

    public GroupLicenseUseInfo getGroupLicenseUsedInfo(String groupNumber) {
        return null;
    }

    public Map<String, GroupLicenseUseInfo> getLicenseUseInfoMap() throws BOSException, EASBizException {
        try {
            return (Map)UserLicenseGroupTool.deepClone(this.getLicenseUseSev(context).getGroupsUseInfo(context));
        }
        catch (OptionalDataException e) {
            logger.error((Object)"LicenseUseManager.getLicenseUseInfoMap():error-1:");
        }
        catch (IOException e) {
            logger.error((Object)"LicenseUseManager.getLicenseUseInfoMap():error-2:");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"LicenseUseManager.getLicenseUseInfoMap():error-3:");
        }
        return null;
    }

    @Deprecated
    private boolean disAssignUserGroup(Context ctx, String userId, String groupNumber) throws BOSException, EASBizException {
        return true;
    }

    public boolean removeUsersLicenseGroupInfo(Context ctx, List<String> licneseGroupIds) throws BOSException, EASBizException {
        UserLicenseGroupCollection userGroups = UserLicenseGroupFactory.getLocalInstance(ctx).getUserLicenseGroupCollection("where id in (" + ToolUtils.aryToStr(licneseGroupIds) + ")");
        UserLicenseGroupHelper userLGHelper = new UserLicenseGroupHelper(ctx);
        int size = userGroups.size();
        for (int i = 0; i < size; ++i) {
            userLGHelper.addDelUserLicenseGroupInfo(new UserLicenseGroupInfoEx(userGroups.get(i)));
        }
        userLGHelper.exec();
        return true;
    }

    public boolean disAssignUsersGroup(Context ctx, List<String> userIds, String groupNumber) throws BOSException, EASBizException {
        if (userIds == null || userIds.size() <= 0 || groupNumber == null || groupNumber.trim().length() <= 0) {
            return false;
        }
        ArrayList<String> realDisassignUserIds = new ArrayList<String>();
        String sql = "select FuserId from T_PM_UserLicenseGroup where FGroupNumber ='" + groupNumber + "'";
        ArrayList<String> ownGroupUserIds = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                ownGroupUserIds.add(rs.getString("FuserId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD", (Locale)ctx.getLocale()));
        }
        catch (BOSException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD", (Locale)ctx.getLocale()));
        }
        realDisassignUserIds.addAll(userIds);
        realDisassignUserIds.retainAll(ownGroupUserIds);
        UserLicenseGroupHelper userlicHelper = new UserLicenseGroupHelper(ctx);
        for (String userId : realDisassignUserIds) {
            UserLicenseGroupsInfo userLicenseGroups = this.getUserLicenseGroups(ctx, userId);
            UserLicenseGroupHelper4User ulgh4user = new UserLicenseGroupHelper4User(ctx, userLicenseGroups.getUser(), userLicenseGroups);
            UserLicenseGroupInfoEx userNewGroup = userLicenseGroups.getLicGroup(groupNumber);
            ulgh4user.addDelUserLicenseGroupInfo(userNewGroup);
            userlicHelper.addUserLicenseGroupHelper4User(ulgh4user);
        }
        userlicHelper.exec();
        return true;
    }

    private boolean assignUserGroup(Context ctx, String userId, String groupNumber) throws BOSException, EASBizException {
        return true;
    }

    public boolean assignUsersGroup(Context ctx, List<String> userIds, String groupNumber) throws BOSException, EASBizException {
        if (userIds == null || userIds.size() <= 0 || groupNumber == null || groupNumber.trim().length() <= 0) {
            return false;
        }
        ArrayList<String> realAssignUserIds = new ArrayList<String>();
        HashMap userGroupMap = new HashMap();
        HashMap<String, Boolean> groupMap = new HashMap<String, Boolean>();
        String sql = "select FuserId from T_PM_UserLicenseGroup where FGroupNumber =? ";
        ArrayList<String> ownGroupUserIds = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{groupNumber});
            while (rs.next()) {
                ownGroupUserIds.add(rs.getString("FuserId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD", (Locale)ctx.getLocale()));
        }
        catch (BOSException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD", (Locale)ctx.getLocale()));
        }
        realAssignUserIds.addAll(userIds);
        realAssignUserIds.removeAll(ownGroupUserIds);
        int remainNum = 0;
        try {
            remainNum = this.getLicenseUseSev(ctx).getGroupRemainNum(ctx, groupNumber);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        UserLicenseGroupHelper userlicHelper = new UserLicenseGroupHelper(ctx);
        Map<String, String> mpUsageInfo = UserLicenseGroupTool.getModuleAliasMap(ctx);
        for (String userId : realAssignUserIds) {
            UserLicenseGroupsInfo userLicenseGroups = this.getUserLicenseGroups(ctx, userId);
            UserLicenseGroupHelper4User ulgh4user = new UserLicenseGroupHelper4User(ctx, userLicenseGroups.getUser(), userLicenseGroups);
            UserLicenseGroupInfoEx userNewGroup = new UserLicenseGroupInfoEx();
            userNewGroup.setUser(ulgh4user.getUser());
            userNewGroup.setGroupNumber(groupNumber);
            userNewGroup.setSynUser(SynStateEnum.SYN_NO);
            if (mpUsageInfo.get(groupNumber) != null) {
                userNewGroup.setName(mpUsageInfo.get(groupNumber));
            }
            if (remainNum > 0 && !userLicenseGroups.getUser().isIsForbidden()) {
                userNewGroup.setIsActive(true);
                --remainNum;
            } else {
                userNewGroup.setIsActive(false);
            }
            ulgh4user.addAddUserLicenseGroupInfo(userNewGroup);
            userlicHelper.addUserLicenseGroupHelper4User(ulgh4user);
            groupMap.put(groupNumber, userNewGroup.isIsActive());
            userGroupMap.put(ulgh4user.getUser().getNumber(), groupMap);
        }
        userlicHelper.exec();
        return true;
    }

    public boolean assignUserGroup(String groupNumber) throws BOSException, EASBizException {
        return this.assignUsersGroup(groupNumber, 1);
    }

    public boolean assignUsersGroup(String groupNumber, int nums) throws BOSException, EASBizException {
        boolean success = false;
        success = this.getLicenseUseSev(context).assignUsersGroup(context, groupNumber, nums);
        return success;
    }

    private boolean checkAssignUserGroup(Context ctx, String groupNumber) throws BOSException, EASBizException {
        return this.checkAssignUsersGroup(ctx, groupNumber, 1);
    }

    private boolean checkAssignUsersGroup(Context ctx, String groupNumber, int nums) throws BOSException, EASBizException {
        int remainNum;
        if (ctx == null) {
            ctx = ContextUtils.getContextFromSession();
        }
        return (remainNum = this.getLicenseUseSev(ctx).getGroupRemainNum(ctx, groupNumber)) >= nums;
    }

    public List<String> getUserGroupName(Context ctx, String useId) throws BOSException, EASBizException {
        return this.groupHelper.getUserGroupName(ctx, useId);
    }

    public Map<String, String> getUserGroupDiffInfo(Context ctx, String useId) throws BOSException {
        return UserLicenseGroupTool.getUserGroupDiffInfo(ctx, useId);
    }

    private List<String> getPermitemsGroupStr(Context ctx, List<String> permitemIds) throws BOSException {
        return UserLicenseGroupTool.getPermitemsGroupStr(ctx, permitemIds);
    }

    public boolean disAssignRole2Users(Context ctx, List<String> usersId, String roleId) throws BOSException, EASBizException {
        if (usersId == null || usersId.size() <= 0) {
            return true;
        }
        ArrayList<String> rolePermids = new ArrayList<String>();
        RolePermCollection rc = RolePermFactory.getLocalInstance(ctx).getRolePermCollection("select permItem.id where role.id ='" + roleId + "'");
        Iterator it = rc.iterator();
        while (it.hasNext()) {
            rolePermids.add(((RolePermInfo)it.next()).getPermItemId());
        }
        List<String> permitemGroupStr = this.getPermitemsGroupStr(ctx, rolePermids);
        if (permitemGroupStr == null || permitemGroupStr.size() <= 0) {
            return true;
        }
        HashSet<String> userIdSet = new HashSet<String>(usersId);
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(5);
        ArrayList<DelUserGroupsThread> tasks = new ArrayList<DelUserGroupsThread>();
        int size = userIdSet.size();
        for (int i = 0; i < size; ++i) {
            DelUserGroupsThread delUserGroupsThread = new DelUserGroupsThread(ctx, usersId.get(i), new ArrayList<String>(permitemGroupStr), roleId);
            tasks.add(delUserGroupsThread);
        }
        try {
            fixedThreadPool.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        fixedThreadPool.shutdown();
        return true;
    }

    public boolean assignRole2Users(Context ctx, List<String> usersId, String roleId) throws BOSException, EASBizException {
        if (usersId == null || usersId.size() <= 0) {
            return true;
        }
        ArrayList<String> rolePermids = new ArrayList<String>();
        RolePermCollection rc = RolePermFactory.getLocalInstance(ctx).getRolePermCollection("select permItem.id where role.id ='" + roleId + "'");
        Iterator it = rc.iterator();
        while (it.hasNext()) {
            rolePermids.add(((RolePermInfo)it.next()).getPermItemId());
        }
        List<String> permitemGroupStr = this.getPermitemsGroupStr(ctx, rolePermids);
        if (permitemGroupStr == null || permitemGroupStr.size() <= 0) {
            return true;
        }
        UserLicenseGroupHelper userLGHelper = new UserLicenseGroupHelper(ctx);
        Map<String, String> mpUsageInfo = UserLicenseGroupTool.getModuleAliasMap(ctx);
        for (String userId : usersId) {
            UserLicenseGroupsInfo userLicenseGroups = this.getUserLicenseGroups(ctx, userId);
            Set<String> userGroupset = userLicenseGroups.getGroupsNumberSet();
            if (permitemGroupStr.size() <= 0 || userGroupset.containsAll(permitemGroupStr)) continue;
            UserLicenseGroupHelper4User ulgh4user = new UserLicenseGroupHelper4User(ctx, userLicenseGroups.getUser(), userLicenseGroups);
            int size = permitemGroupStr.size();
            for (int i = 0; i < size; ++i) {
                if (userGroupset.contains(permitemGroupStr.get(i))) continue;
                UserLicenseGroupInfoEx userNewGroup = new UserLicenseGroupInfoEx();
                userNewGroup.setUser(userLicenseGroups.getUser());
                userNewGroup.setGroupNumber(permitemGroupStr.get(i));
                userNewGroup.setSynUser(SynStateEnum.SYN_NO);
                userNewGroup.setName(mpUsageInfo.get(permitemGroupStr.get(i)));
                if (userLicenseGroups.getUser().isIsForbidden() || !this.checkAssignUsersGroup(ctx, permitemGroupStr.get(i), usersId.size())) {
                    userNewGroup.setIsActive(false);
                } else {
                    userNewGroup.setIsActive(true);
                }
                ulgh4user.addAddUserLicenseGroupInfo(userNewGroup);
            }
            userLGHelper.addUserLicenseGroupHelper4User(ulgh4user);
        }
        userLGHelper.exec();
        return true;
    }

    public boolean assignRoles(Context ctx, String userId, List<String> roles) throws BOSException, EASBizException {
        if (roles == null || roles.size() <= 0) {
            return true;
        }
        UserLicenseGroupsInfo userLicenseGroups = this.getUserLicenseGroups(ctx, userId);
        List<String> rolePermids = RolePermHelper.getPermIdsByRoleids(ctx, new HashSet<String>(roles));
        List<String> permitemGroupStr = this.getPermitemsGroupStr(ctx, rolePermids);
        IUserLicenseGroupHelper ihelper = this.getUserLicenseGroupHelper4Add(ctx, userLicenseGroups, permitemGroupStr);
        ihelper.exec();
        return true;
    }

    public boolean assignUsersRoles(Context ctx, List<IObjectPK> userIds, List<String> roles) throws BOSException, EASBizException {
        if (roles == null || roles.size() <= 0) {
            return true;
        }
        List<String> rolePermids = RolePermHelper.getPermIdsByRoleids(ctx, new HashSet<String>(roles));
        List<String> permitemGroupStr = this.getPermitemsGroupStr(ctx, rolePermids);
        if (permitemGroupStr == null || permitemGroupStr.size() <= 0) {
            return true;
        }
        UserLicenseGroupHelper userLGHelper = new UserLicenseGroupHelper(ctx);
        HashMap<String, Boolean> groupMap = new HashMap<String, Boolean>();
        Map<String, String> mpUsageInfo = UserLicenseGroupTool.getModuleAliasMap(ctx);
        for (IObjectPK userId : userIds) {
            UserLicenseGroupsInfo userLicenseGroups = this.getUserLicenseGroups(ctx, userId.toString());
            Set<String> userGroupset = userLicenseGroups.getGroupsNumberSet();
            if (permitemGroupStr.size() <= 0 || userGroupset.containsAll(permitemGroupStr)) continue;
            UserLicenseGroupHelper4User ulgh4user = new UserLicenseGroupHelper4User(ctx, userLicenseGroups.getUser(), userLicenseGroups);
            int size = permitemGroupStr.size();
            for (int i = 0; i < size; ++i) {
                if (userGroupset.contains(permitemGroupStr.get(i))) continue;
                UserLicenseGroupInfoEx userNewGroup = new UserLicenseGroupInfoEx();
                userNewGroup.setUser(userLicenseGroups.getUser());
                userNewGroup.setGroupNumber(permitemGroupStr.get(i));
                userNewGroup.setSynUser(SynStateEnum.SYN_NO);
                userNewGroup.setName(mpUsageInfo.get(permitemGroupStr.get(i)));
                if (userLicenseGroups.getUser().isIsForbidden() || !this.checkAssignUsersGroup(ctx, permitemGroupStr.get(i), userIds.size())) {
                    userNewGroup.setIsActive(false);
                } else {
                    userNewGroup.setIsActive(true);
                }
                groupMap.put(permitemGroupStr.get(i), userNewGroup.isIsActive());
                ulgh4user.addAddUserLicenseGroupInfo(userNewGroup);
            }
            userLGHelper.addUserLicenseGroupHelper4User(ulgh4user);
        }
        userLGHelper.exec();
        return true;
    }

    private List<String> getUserGroupStr(Context ctx, String userId, boolean isActive) throws BOSException {
        return UserLicenseGroupTool.getUserGroupStr(ctx, userId, isActive);
    }

    public List<String> getUserGroupStr(Context ctx, String userId) throws BOSException {
        return UserLicenseGroupTool.getUserGroupStr(ctx, userId);
    }

    private UserLicenseGroupsInfo getUserLicenseGroups(Context ctx, String userId) throws BOSException {
        return UserLicenseGroupTool.getUserLicenseGroups(ctx, userId);
    }

    private UserLicenseGroupsInfo assignGroups(UserLicenseGroupsInfo userLicenseGroups, List<String> addGroupStr) throws UserException {
        return null;
    }

    private IUserLicenseGroupHelper getUserLicenseGroupHelper4Del(Context ctx, UserLicenseGroupsInfo userLicenseGroups, List<String> delGroupStr) throws BOSException {
        UserLicenseGroupHelper userlicHelper = new UserLicenseGroupHelper(ctx);
        if (userLicenseGroups == null || delGroupStr == null) {
            return userlicHelper;
        }
        Set<String> userGroupset = userLicenseGroups.getGroupsNumberSet();
        delGroupStr.retainAll(userGroupset);
        if (delGroupStr.size() > 0) {
            UserLicenseGroupHelper4User ulgh4user = new UserLicenseGroupHelper4User(ctx, userLicenseGroups.getUser(), userLicenseGroups);
            int size = delGroupStr.size();
            for (int i = 0; i < size; ++i) {
                if (!userGroupset.contains(delGroupStr.get(i))) continue;
                UserLicenseGroupInfoEx ulgex = userLicenseGroups.getLicGroup(delGroupStr.get(i));
                ulgh4user.addDelUserLicenseGroupInfo(ulgex);
            }
            userlicHelper.addUserLicenseGroupHelper4User(ulgh4user);
        }
        return userlicHelper;
    }

    IUserLicenseGroupHelper getUserLicenseGroupHelper4Add(Context ctx, UserLicenseGroupsInfo userLicenseGroups, List<String> addGroupStr) throws BOSException, EASBizException {
        UserLicenseGroupHelper userlicHelper = new UserLicenseGroupHelper(ctx);
        if (userLicenseGroups == null || addGroupStr == null) {
            return userlicHelper;
        }
        Map<String, String> mpUsageInfo = UserLicenseGroupTool.getModuleAliasMap(ctx);
        Set<String> userGroupset = userLicenseGroups.getGroupsNumberSet();
        if (addGroupStr.size() > 0 && !userGroupset.containsAll(addGroupStr)) {
            UserLicenseGroupHelper4User ulgh4user = new UserLicenseGroupHelper4User(ctx, userLicenseGroups.getUser(), userLicenseGroups);
            int size = addGroupStr.size();
            for (int i = 0; i < size; ++i) {
                if (userGroupset.contains(addGroupStr.get(i))) continue;
                UserLicenseGroupInfoEx userNewGroup = new UserLicenseGroupInfoEx();
                if (userLicenseGroups.getUser().isIsForbidden() || !this.checkAssignUserGroup(ctx, addGroupStr.get(i))) {
                    userNewGroup.setIsActive(false);
                } else {
                    userNewGroup.setIsActive(true);
                }
                userNewGroup.setUser(userLicenseGroups.getUser());
                userNewGroup.setGroupNumber(addGroupStr.get(i));
                userNewGroup.setSynUser(SynStateEnum.SYN_NO);
                userNewGroup.setName(mpUsageInfo.get(userNewGroup.getGroupNumber()));
                ulgh4user.addAddUserLicenseGroupInfo(userNewGroup);
            }
            userlicHelper.addUserLicenseGroupHelper4User(ulgh4user);
        }
        return userlicHelper;
    }

    private List<String> assignGroups(List<String> userGroupStr, List<String> permitemGroupStr) throws UserException {
        ArrayList<String> addUserGroupStr = new ArrayList<String>();
        return addUserGroupStr;
    }

    public boolean assignPermitem(Context ctx, String userId, List<String> permitemIds) throws BOSException, EASBizException {
        if (permitemIds == null || permitemIds.size() <= 0) {
            return true;
        }
        UserLicenseGroupsInfo userLicenseGroups = this.getUserLicenseGroups(ctx, userId);
        List<String> permitemGroupStr = this.getPermitemsGroupStr(ctx, permitemIds);
        IUserLicenseGroupHelper ihelper = this.getUserLicenseGroupHelper4Add(ctx, userLicenseGroups, permitemGroupStr);
        ihelper.exec();
        return true;
    }

    private List<String> getUserGroupListByRoles(Context ctx, List<String> roleIds) throws BOSException, EASBizException {
        return this.groupHelper.getUserGroupListByRoles(ctx, roleIds);
    }

    private boolean delUserGroups(Context ctx, String userId, List<String> preDelGroups) throws BOSException, EASBizException {
        if (preDelGroups == null || preDelGroups.size() == 0) {
            return true;
        }
        List<String> userGroupStr = this.getUserGroupStr(ctx, userId);
        preDelGroups.retainAll(userGroupStr);
        if (preDelGroups == null || preDelGroups.size() == 0) {
            return true;
        }
        List<String> realUserPerm = this.getUserLicenseGroupByUser(ctx, userId);
        List<String> realUserGroup = this.getPermitemsGroupStr(ctx, realUserPerm);
        preDelGroups.removeAll(realUserGroup);
        if (preDelGroups.size() == 0) {
            return true;
        }
        UserLicenseGroupsInfo userLicenseGroups = this.getUserLicenseGroups(ctx, userId);
        IUserLicenseGroupHelper ihelper = this.getUserLicenseGroupHelper4Del(ctx, userLicenseGroups, preDelGroups);
        ihelper.exec();
        return true;
    }

    public boolean disAssignRoles(Context ctx, String userId, List<String> roles) throws BOSException, EASBizException {
        if (roles == null || roles.size() <= 0) {
            return true;
        }
        List<String> rolePerms = this.getUserGroupListByRoles(ctx, roles);
        List<String> preDelroleGroupStr = this.getPermitemsGroupStr(ctx, rolePerms);
        return this.delUserGroups(ctx, userId, preDelroleGroupStr);
    }

    private boolean disAssignUserGroups(Context ctx, Set<String> groupset) {
        return true;
    }

    private boolean disAssignUserGroups(Context ctx, List<String> groups) {
        boolean success = false;
        return success;
    }

    public boolean disAssignPermitems(Context ctx, String userId, List<String> permitemIds) throws BOSException, EASBizException {
        if (permitemIds == null || permitemIds.size() <= 0) {
            return true;
        }
        List<String> preDelPermitemGroupStr = this.getPermitemsGroupStr(ctx, permitemIds);
        return this.delUserGroups(ctx, userId, preDelPermitemGroupStr);
    }

    private UserInfo getUserInfo(Context ctx, String userId) {
        return null;
    }

    private List<String> getUserLicenseGroupByUser(Context ctx, String userId) {
        List<String> lsUserGroup = null;
        try {
            lsUserGroup = GroupLicenseUseInfoUtil.getUserLicenseGroupByUser(ctx, userId);
        }
        catch (BOSException e) {
            logger.error((Object)"LicenseUseManager.getUserLicenseGroupByUser error1. ");
        }
        catch (EASBizException e) {
            logger.error((Object)"LicenseUseManager.getUserLicenseGroupByUser error2. ");
        }
        return lsUserGroup;
    }

    private List<String> getUserRoleLicenseGroupByUser(Context ctx, String userId, String roleId) {
        List<String> lsUserGroup = null;
        try {
            lsUserGroup = GroupLicenseUseInfoUtil.getUserLicenseGroupByUser(ctx, userId);
        }
        catch (BOSException e) {
            logger.error((Object)"LicenseUseManager.getUserLicenseGroupByUser error1. ");
        }
        catch (EASBizException e) {
            logger.error((Object)"LicenseUseManager.getUserLicenseGroupByUser error2. ");
        }
        return lsUserGroup;
    }

    public boolean rebuildUserLicGroup(Context ctx, String userId) throws BOSException, EASBizException {
        return this.groupHelper.rebuildUserLicenseGroupInfo(ctx, userId);
    }

    public void changeUserInfo(Context ctx, UserInfo newUserInfo, UserInfo oldUserInfo) throws BOSException, EASBizException {
        this.groupHelper.changeUserInfo(ctx, newUserInfo, oldUserInfo);
    }

    public boolean changeRolePermitem(Context ctx, RoleInfo role, RolePermCollection addPerms, RolePermCollection delPerms) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        boolean flag = this.groupHelper.changeRolePermitem(ctx, role, addPerms, delPerms);
        long cost = System.currentTimeMillis() - start;
        if (cost > 10000L) {
            logger.error((Object)("\u672c\u6b21\u89d2\u8272\u6743\u9650\u53d8\u66f4license\u5206\u7ec4\u66f4\u65b0\u8017\u65f6\u8fc7\u957f>>>>>cost:" + (System.currentTimeMillis() - start) + "ms>>>roleId=" + role.getId().toString()));
        }
        return flag;
    }

    public void callBackUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        this.groupHelper.callBackUsers(ctx, usersId);
    }

    public void unForbidUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        this.groupHelper.unForbidUsers(ctx, usersId);
    }

    public void forbidUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        this.groupHelper.forbidUsers(ctx, usersId);
    }

    public void addUser(Context ctx, UserInfo userInfo) throws BOSException {
        this.groupHelper.addUser(ctx, userInfo);
    }

    public void deleteUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        this.groupHelper.deleteUsers(ctx, usersId);
    }

    private void recycleGroupNumbyUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        List<String> userGroupStr = this.getUserGroupStr(ctx, userInfo.getId().toString(), true);
        for (String groupStr : userGroupStr) {
            this.disAssignUserGroup(groupStr);
        }
    }

    public void deleteUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        Map<String, Boolean> groupMap = null;
        HashMap<String, Map<String, Boolean>> userGroupMap = new HashMap<String, Map<String, Boolean>>();
        DBUserBean dbUserBean = new DBUserBean();
        userInfo.setIsDelete(true);
        groupMap = this.groupHelper.deleteUser(ctx, userInfo);
        if (groupMap != null) {
            userGroupMap.put(userInfo.getNumber(), groupMap);
        }
        ArrayList<String> userNumbers = new ArrayList<String>();
        userNumbers.add(userInfo.getNumber());
        dbUserBean.setState(true);
        dbUserBean.setUserNumbers(userNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergCouldUserGroupNumberByOtherDatasource(List<CloudUserInfo> cloudUsers, String dataSourceAIS, Set userNumbers) {
        Connection conn = null;
        Statement state = null;
        ResultSet rs = null;
        Statement userState = null;
        ResultSet userRs = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select licGroup.Fuserid fid,licGroup.Fgroupnumber groupnumber ,pmUser.Fnumber userNumber,pmUser.Fuid fuid from t_pm_user pmUser ");
        sql.append(" inner join T_PM_UserLicenseGroup licGroup  on pmUser.Fid = licGroup.Fuserid where licGroup.fisactive = 1 ").append(" and lower(pmUser.Fnumber) in(?)");
        String userStatusSql = "select fnumber number,fforbidden forbidden,Fisdelete isdelete from T_PM_USER where lower(fnumber) in(?)";
        HashMap<String, String> mpOtherDatasourceNumberGroup = new HashMap<String, String>();
        HashSet<String> unremoveUserSet = new HashSet<String>();
        int PERSIZE = 450;
        int totalSize = userNumbers.size();
        int totalCount = 0;
        int begin = 0;
        int end = 0;
        List subList = null;
        ArrayList userList = new ArrayList(userNumbers);
        try {
            conn = DbConnector.getConnection((String)dataSourceAIS);
            state = conn.createStatement();
            userState = conn.createStatement();
            totalCount = (totalSize - 1) / PERSIZE + 1;
            String groupStr = "";
            for (int i = 0; i < totalCount; ++i) {
                begin = i * PERSIZE;
                end = (i + 1) * PERSIZE > totalSize ? totalSize : (i + 1) * PERSIZE;
                subList = userList.subList(begin, end);
                rs = state.executeQuery(sql.toString().replace("?", ToolUtils.aryToStr(subList, true)));
                while (rs.next()) {
                    String group = rs.getString("groupnumber");
                    String userNumber = rs.getString("userNumber").toLowerCase();
                    groupStr = group;
                    if (mpOtherDatasourceNumberGroup.containsKey(userNumber)) {
                        groupStr = (String)mpOtherDatasourceNumberGroup.get(userNumber) + ";" + groupStr;
                    }
                    mpOtherDatasourceNumberGroup.put(userNumber, groupStr);
                    String string = rs.getString("fuid");
                }
                userRs = userState.executeQuery(userStatusSql.replace("?", ToolUtils.aryToStr(subList, true)));
                while (userRs.next()) {
                    String userNumber = userRs.getString("number");
                    Boolean isForbidden = userRs.getBoolean("forbidden");
                    Boolean isDelete = userRs.getBoolean("isdelete");
                    if (isForbidden.booleanValue() || isDelete.booleanValue()) continue;
                    unremoveUserSet.add(userNumber.toLowerCase());
                }
            }
        }
        catch (SQLException e1) {
            logger.error((Object)"==================mergCouldUserGroupNumberByOtherDatasource.SQLException===============", (Throwable)e1);
        }
        catch (BOSException e) {
            logger.error((Object)"==================mergCouldUserGroupNumberByOtherDatasource.BOSException===============", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)state, (Connection)conn);
            SQLUtils.cleanup(userRs, (Statement)userState, (Connection)conn);
        }
        for (CloudUserInfo cui : cloudUsers) {
            String groupStr = (String)mpOtherDatasourceNumberGroup.get(cui.getErp_account());
            if (unremoveUserSet.contains(cui.getErp_account())) {
                cui.setStatus(1);
                cui.setIs_delete(0);
            }
            cui.mergeGroupName(groupStr);
        }
    }

    public Map<String, CloudRegistUserInfo> getRegistUserMapFromLicense(Context ctx) {
        return this.groupHelper.getRegistUserMapFromLicense(ctx);
    }

    public Map initUserLicenseGroup(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("success", "false");
        ILicenseUseSrv ilic = this.getLicenseUseSev(ctx);
        if (ilic == null) {
            return mp;
        }
        ilic.initUserLicenseGroup(ctx);
        mp.put("success", "true");
        return mp;
    }

    public Map resetAllUserSyncState(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("success", "false");
        ILicenseUseSrv ilic = this.getLicenseUseSev(ctx);
        if (ilic == null) {
            return mp;
        }
        ilic.resetAllUserSyncState(ctx);
        mp.put("success", "true");
        return mp;
    }

    public List<CloudUserInfo> getCloudUserInfoFromLicense(Context ctx) {
        return this.groupHelper.getCloudUserInfoFromLicense(ctx);
    }

    public List<CloudUserInfo> getAssembleCloudUserInfoIncludeAll(Context ctx) {
        ArrayList<CloudUserInfo> cloudUsers = new ArrayList<CloudUserInfo>();
        IValidateCommunicationService ivalidataCommunicationService = null;
        try {
            ivalidataCommunicationService = ValidateCommunicationFactory.getLocalInstance(ctx);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        String CUFilter = "";
        try {
            if (Administrator.isBizAdmin(ctx, ctx.getCaller())) {
                CUFilter = " and exists(select 1 from t_pm_orgrange where pmuser.fcontrolunitid = forgid and fuserid='" + ctx.getCaller() + "' and ftype = 30) ";
            } else if (!Administrator.isSuperAdmin(ctx.getCaller()) && Administrator.isCUAdmin(ctx, ctx.getCaller())) {
                CUFilter = " and exists(select 1 from t_pm_orgrange where pmuser.fcontrolunitid = forgid and fuserid='" + ctx.getCaller() + "' and ftype = 10) ";
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"com.kingdee.eas.base.permission.app.util.interior.LicenseUseManager.getAssembleCloudUserInfoIncludeAll.Administrator.error", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"com.kingdee.eas.base.permission.app.util.interior.LicenseUseManager.getAssembleCloudUserInfoIncludeAll.Administrator.error", (Throwable)e);
        }
        Map<String, Map<String, ProductGroup>> mpUserLicGroup = this.getMpUserLicGroup(ctx, true);
        String sql = "select pmuser.FId FuserId,pmuser.Fname_l2 Fname,pmuser.Fnumber Fnumber,pmuser.FCell FCell,pmuser.FEMail FEMail,pmuser.FForbidden FForbidden,pmuser.FIsDelete FisDelete,pmuser.FUid FUid,person.Fnumber pnumber,person.FBirthday pbirthday,person.FidCardNO pidcardNO,person.fGender pgender ,org.fname_" + ctx.getLocale() + " CU  from t_pm_user pmuser  inner join t_org_baseunit org on pmuser.fcontrolunitid =org.fid  left outer join t_bd_person person on person.fid = pmuser.fpersonid where lower(pmuser.Fnumber) not in('administrator','user','authenadmin','sscadmin','auditadmin','virtualuser') and pmuser.Ftype != 10 " + CUFilter;
        Map<String, List<String>> mpUserAdminOrgAndPosition = this.getUserAdminOrgAndPosition(ctx);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String pgender;
                Map<String, ProductGroup> mpGroups;
                String birthday;
                String fuserId = rs.getString("FuserId");
                if (fuserId == null || UserLicenseConstantHelper.IGNORE_SYNTOCLOUD_USERS.contains(fuserId)) continue;
                String cell = rs.getString("FCell");
                String email = rs.getString("FEMail");
                if (cell == null || cell.trim().length() <= 0 || "null".equals(cell.trim())) {
                    cell = "";
                }
                String CU = rs.getString("CU");
                CloudUserInfo cloudUserInfo = new CloudUserInfo();
                cloudUserInfo.setPhone(cell);
                cloudUserInfo.setCU(CU);
                cloudUsers.add(cloudUserInfo);
                String mid = rs.getString("pnumber");
                String string = mid = mid == null ? null : mid.toLowerCase();
                if (mid != null && mid.trim().length() > 0 && !"null".equalsIgnoreCase(mid)) {
                    cloudUserInfo.setMid(mid);
                }
                if (mpUserAdminOrgAndPosition.get(fuserId) != null) {
                    cloudUserInfo.setDepartment(mpUserAdminOrgAndPosition.get(rs.getString("FuserId")).get(0));
                    cloudUserInfo.setPosition(mpUserAdminOrgAndPosition.get(rs.getString("FuserId")).get(1));
                }
                if ((birthday = rs.getString("pBirthday")) != null && birthday.trim().length() > 0 && !"null".equals(birthday)) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date date = formatter.parse(birthday);
                        cloudUserInfo.setBirthday(formatter.format(date));
                    }
                    catch (ParseException e) {
                        logger.error((Object)("birthday:" + birthday));
                    }
                }
                if (email != null && email.trim().length() > 0 && !"null".equals(email)) {
                    cloudUserInfo.setEmail(email);
                }
                cloudUserInfo.setErp_account(rs.getString("Fnumber") == null ? null : rs.getString("Fnumber").toLowerCase());
                String name = rs.getString("Fname");
                if (name != null && name.trim().length() > 0 && !"null".equals(name)) {
                    cloudUserInfo.setName(name);
                }
                if ((mpGroups = mpUserLicGroup.get(rs.getString("FuserId"))) != null) {
                    cloudUserInfo.setMpGroups(mpGroups);
                }
                cloudUserInfo.setStatus(rs.getInt("FForbidden") == 1 ? 0 : 1);
                cloudUserInfo.setIs_delete(rs.getInt("FIsDelete"));
                String fuid = rs.getString("FUid");
                if (fuid != null && fuid.trim().length() > 0) {
                    try {
                        cloudUserInfo.setUid(Integer.parseInt(fuid));
                    }
                    catch (NumberFormatException e) {
                        cloudUserInfo.setUid(0);
                    }
                }
                int gender = "1".equalsIgnoreCase(pgender = rs.getString("pgender")) ? 0 : ("2".equalsIgnoreCase(pgender) ? 1 : 2);
                cloudUserInfo.setGender(gender);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"LicenseUseManager.getAssembleCloudUserInfoIncludeAll error1. ");
        }
        catch (SQLException e) {
            logger.error((Object)"LicenseUseManager.getAssembleCloudUserInfoIncludeAll error2. ");
        }
        return cloudUsers;
    }

    private Map<String, Map<String, ProductGroup>> getMpUserLicGroup(Context ctx, boolean isAll) {
        String sqlUserLicGroup = "select fuserid fuserid,fgroupnumber fgroupnumber,fname_l2 fname,fisactive fisactive from T_PM_UserLicenseGroup";
        HashMap<String, Map<String, ProductGroup>> mpUserLicGroup = new HashMap<String, Map<String, ProductGroup>>();
        try {
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sqlUserLicGroup);
            while (rs1.next()) {
                ProductGroup pgoup;
                String fuserId = rs1.getString("fuserid");
                String fgroupnumber = rs1.getString("fgroupnumber");
                String fisactive = rs1.getString("fisactive");
                if (!isAll && !"1".equals(fisactive)) continue;
                HashMap<String, ProductGroup> mpGroups = (HashMap<String, ProductGroup>)mpUserLicGroup.get(fuserId);
                if (mpGroups == null) {
                    mpGroups = new HashMap<String, ProductGroup>();
                    pgoup = new ProductGroup(fgroupnumber);
                    pgoup.setValid("1".equals(fisactive));
                    mpGroups.put(fgroupnumber, pgoup);
                    mpUserLicGroup.put(fuserId, mpGroups);
                    continue;
                }
                pgoup = (ProductGroup)mpGroups.get(fgroupnumber);
                if (pgoup != null) continue;
                pgoup = new ProductGroup(fgroupnumber);
                pgoup.setValid("1".equals(fisactive));
                mpGroups.put(fgroupnumber, pgoup);
            }
        }
        catch (BOSException e1) {
            logger.error((Object)"LicenseUseManager.getAssembleCloudUserInfoIncludeAll error3. ");
        }
        catch (SQLException e) {
            logger.error((Object)"LicenseUseManager.getAssembleCloudUserInfoIncludeAll error4. ");
        }
        return mpUserLicGroup;
    }

    private Map<String, List<String>> getUserAdminOrgAndPosition(Context ctx) {
        String sqlUserAdminOrg = "select puser.fid fuserid, tadmin.fname_l2 fadmin, tposition.fname_l2 fposition from t_pm_user puser  LEFT OUTER JOIN T_ORG_PositionMember  tpositionmeb  ON puser.FPersonId = tpositionmeb.FPersonID  LEFT OUTER JOIN T_ORG_Position  tposition  ON tpositionmeb.FPositionID = tposition.FID  LEFT OUTER JOIN T_ORG_Admin  tadmin  ON tposition.FAdminOrgUnitID = tadmin.FID WHERE tpositionmeb.FISPrimary = 1";
        HashMap<String, List<String>> mpUserAdminOrgAndPosition = new HashMap<String, List<String>>();
        try {
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sqlUserAdminOrg);
            while (rs1.next()) {
                ArrayList<String> adminOrgAndPositionList = new ArrayList<String>();
                adminOrgAndPositionList.add(rs1.getString("fadmin"));
                adminOrgAndPositionList.add(rs1.getString("fposition"));
                mpUserAdminOrgAndPosition.put(rs1.getString("fuserid"), adminOrgAndPositionList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return mpUserAdminOrgAndPosition;
    }

    private CloudUserInfo getCloudUserByRowSet(RowSet rs, Map<String, Map<String, ProductGroup>> mpUserLicGroup) throws SQLException {
        String pgender;
        Map<String, ProductGroup> mpGroups;
        String email;
        String birthday;
        CloudUserInfo cloudUserInfo = new CloudUserInfo();
        cloudUserInfo.setPhone(rs.getString("FCell"));
        String mid = rs.getString("pnumber");
        if (mid != null && mid.trim().length() > 0 && !"null".equals(mid)) {
            cloudUserInfo.setMid(mid);
        }
        if ((birthday = rs.getString("pBirthday")) != null && birthday.trim().length() > 0 && !"null".equals(birthday)) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = formatter.parse(birthday);
                cloudUserInfo.setBirthday(formatter.format(date));
            }
            catch (ParseException e) {
                logger.error((Object)("birthday:" + birthday));
            }
        }
        if ((email = rs.getString("FEMail")) != null && email.trim().length() > 0 && !"null".equals(email)) {
            cloudUserInfo.setEmail(email);
        }
        cloudUserInfo.setErp_account(rs.getString("Fnumber") == null ? null : rs.getString("Fnumber").toLowerCase());
        String name = rs.getString("Fname");
        if (name != null && name.trim().length() > 0 && !"null".equals(name)) {
            cloudUserInfo.setName(name);
        }
        Map<String, ProductGroup> map = mpGroups = mpUserLicGroup == null ? null : mpUserLicGroup.get(rs.getString("FuserId"));
        if (mpGroups != null) {
            cloudUserInfo.setMpGroups(mpGroups);
        }
        cloudUserInfo.setStatus(rs.getInt("FForbidden") == 1 ? 0 : 1);
        cloudUserInfo.setIs_delete(rs.getInt("FIsDelete"));
        String fuid = rs.getString("FUid");
        if (fuid != null && fuid.trim().length() > 0) {
            try {
                cloudUserInfo.setUid(Integer.parseInt(fuid));
            }
            catch (NumberFormatException e) {
                cloudUserInfo.setUid(0);
            }
        }
        int gender = "1".equalsIgnoreCase(pgender = rs.getString("pgender")) ? 0 : ("2".equalsIgnoreCase(pgender) ? 1 : 0);
        cloudUserInfo.setGender(gender);
        return cloudUserInfo;
    }

    public List<CloudUserInfo> getAssembleCloudUserInfo(Context ctx, boolean isIncludeGroups, boolean inSyncAll) {
        StringBuilder sql = new StringBuilder();
        sql.append("select pmuser.FId FuserId,pmuser.Fname_l2 Fname,pmuser.Fnumber Fnumber,pmuser.FCell FCell,").append(" pmuser.FEMail FEMail,pmuser.FForbidden FForbidden,pmuser.FIsDelete FisDelete,pmuser.FUid FUid,").append(" person.Fnumber pnumber,person.FBirthday pbirthday,person.FidCardNO pidcardNO,person.fGender pgender ").append(" from t_pm_user pmuser ").append(" left outer join t_bd_person person on person.fid = pmuser.fpersonid ").append(" where lower(pmuser.Fnumber) not in('administrator','user','authenadmin','sscadmin','auditadmin','virtualuser')");
        if (!inSyncAll) {
            sql.append(" and pmuser.fissyntocloud <> 1");
        }
        Map<String, Map<String, ProductGroup>> mpUserLicGroup = null;
        if (isIncludeGroups) {
            mpUserLicGroup = this.getMpUserLicGroup(ctx, false);
        }
        HashSet<String> userNumber = new HashSet<String>();
        ArrayList<CloudUserInfo> cloudUsers = new ArrayList<CloudUserInfo>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String fuserId = rs.getString("FuserId");
                if (fuserId == null || UserLicenseConstantHelper.IGNORE_SYNTOCLOUD_USERS.contains(fuserId) || userNumber.contains(rs.getString("Fnumber") == null ? null : rs.getString("Fnumber").toLowerCase())) continue;
                userNumber.add(rs.getString("Fnumber") == null ? null : rs.getString("Fnumber").toLowerCase());
                CloudUserInfo cloudUserInfo = this.getCloudUserByRowSet((RowSet)rs, mpUserLicGroup);
                cloudUsers.add(cloudUserInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"LicenseUseManager.getAssembleCloudUserInfo error1. ");
        }
        catch (SQLException e) {
            logger.error((Object)"LicenseUseManager.getAssembleCloudUserInfo error2. ");
        }
        if (isIncludeGroups) {
            this.mergeDataCentersUserGroup(ctx, cloudUsers, userNumber);
        } else {
            LicenseUseManager.mergeUserStatus(ctx, cloudUsers);
        }
        return cloudUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeUserStatus(Context ctx, List<CloudUserInfo> cloudUsers) {
        ArrayList dcList = null;
        try {
            DCRegister dcRegister = new DCRegister();
            dcList = dcRegister.getDCList();
        }
        catch (Exception e1) {
            logger.error((Object)"======================get dclist error:", (Throwable)e1);
        }
        if (dcList == null || dcList.size() < 2) {
            return;
        }
        String curAis = ctx.getAIS();
        if (StringUtils.isEmpty((String)curAis)) {
            return;
        }
        HashMap<String, CloudUserInfo> cloudUsersCacheMap = new HashMap<String, CloudUserInfo>();
        for (CloudUserInfo info : cloudUsers) {
            if (info.getIs_delete() != 1 && info.getStatus() != 0) continue;
            cloudUsersCacheMap.put(info.getErp_account(), info);
        }
        Connection conn = null;
        Statement state = null;
        ResultSet rs = null;
        Iterator it = dcList.iterator();
        while (it.hasNext()) {
            String dataSourceAIS;
            block13: {
                dataSourceAIS = ((DCInfo)it.next()).getNumber();
                if (!curAis.equals(dataSourceAIS)) break block13;
                SQLUtils.cleanup(rs, state, conn);
                continue;
            }
            try {
                conn = DbConnector.getConnection((String)dataSourceAIS);
                state = conn.createStatement();
                rs = state.executeQuery("select fnumber from t_pm_user where fisDelete = 0 and FForbidden = 0");
                while (rs.next()) {
                    String fnumber = rs.getString("fnumber").toLowerCase();
                    CloudUserInfo cloudUserInfo = (CloudUserInfo)cloudUsersCacheMap.get(fnumber);
                    if (cloudUserInfo == null) continue;
                    cloudUserInfo.setStatus(1);
                    cloudUserInfo.setIs_delete(0);
                }
            }
            catch (Throwable e) {
                try {
                    logger.error((Object)e);
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SQLUtils.cleanup(rs, state, conn);
                    continue;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)state, (Connection)conn);
        }
    }

    private void mergeDataCentersUserGroup(Context ctx, List<CloudUserInfo> cloudUsers, Set userNumbers) {
        DCRegister dcRegister = new DCRegister();
        ArrayList dcList = null;
        try {
            dcList = dcRegister.getDCList();
        }
        catch (Exception e1) {
            logger.error((Object)"======================get dclist error:", (Throwable)e1);
        }
        String dataSourceAIS = "";
        String currentDBAIS = ctx.getAIS();
        Iterator it = dcList.iterator();
        while (it.hasNext()) {
            dataSourceAIS = ((DCInfo)it.next()).getNumber();
            if ("".equals(dataSourceAIS) || dataSourceAIS.equalsIgnoreCase(currentDBAIS)) continue;
            this.mergCouldUserGroupNumberByOtherDatasource(cloudUsers, dataSourceAIS, userNumbers);
        }
    }

    public List<String> getLicenseModule() throws BOSException, EASBizException {
        return this.getLicenseUseSev(context).getLicenseModuleList(context);
    }

    public boolean hasGroupPerm(Context ctx, List<String> userGroupLicenses) throws BOSException {
        boolean hasGroupPerm = false;
        String sql = "Select A.FUserId as userId ,B.FPermItemID as permItemId from  (select FUserId,FGroupNumber from T_PM_UserLicenseGroup where FID in(" + ToolUtils.aryToStr(userGroupLicenses) + "))A INNER JOIN " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " B  ON A.fGroupNumber = B.FGroupNumber ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        this.userPermMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                this.userPermMap.put(rs.getString("userId"), rs.getString("permItemId"));
                hasGroupPerm = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("hasGroupPerm sql error-------------" + e));
        }
        return hasGroupPerm;
    }

    public void removeGroupUserPerm(Context ctx, Map<String, String> userPermMapp) {
        if (userPermMapp == null || userPermMapp.size() == 0) {
            return;
        }
        String delSql = "delete from T_PM_UserOrgPerm where FOWNER = ? AND FPermItemId =?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Map.Entry<String, String> entry : userPermMapp.entrySet()) {
            Object[] params = new Object[]{entry.getKey(), entry.getValue()};
            paramsList.add(params);
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)delSql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)("removeGroupUserPerm error------------" + (Object)((Object)e)));
        }
    }

    public List getGroupUsers(Context ctx, String groupNumber) throws BOSException {
        return UserLicenseGroupTool.getGroupUsers(ctx, groupNumber);
    }

    public boolean removeUserGroups(String userId, String[] groups) throws BOSException {
        String delSql = "delete from T_PM_UserLicenseGroup where fuserId =? and fgroupNumber =?";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String groupNumber : groups) {
            Object[] param = new Object[]{userId, groupNumber};
            params.add(param);
        }
        DbUtil.executeBatch((Context)context, (String)delSql, params);
        return true;
    }

    public boolean activeUserGroups(Map userData, String groupNumber, int count) throws BOSException, EASBizException {
        UserLicenseGroupActiveHelper userLicenseGroupActiveHelper = new UserLicenseGroupActiveHelper();
        userLicenseGroupActiveHelper.addActiveData(context, userData, groupNumber, count, true);
        return userLicenseGroupActiveHelper.exec();
    }

    public boolean unActiveUserGroups(List userIds, String groupNumber) throws BOSException, EASBizException {
        UserLicenseGroupActiveHelper userLicenseGroupActiveHelper = new UserLicenseGroupActiveHelper();
        userLicenseGroupActiveHelper.addActiveData(context, userIds, groupNumber, false);
        return userLicenseGroupActiveHelper.exec();
    }

    public boolean unActiveUserGroups(Map userData, String groupNumber, int count) throws BOSException, EASBizException {
        UserLicenseGroupActiveHelper userLicenseGroupActiveHelper = new UserLicenseGroupActiveHelper();
        userLicenseGroupActiveHelper.addActiveData(context, userData, groupNumber, count, false);
        return userLicenseGroupActiveHelper.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String importUserGroups(Context ctx, Map<String, Map<String, Boolean>> userGroupMap, Map<String, List<String>> groupRetainMap) throws EASBizException, BOSException {
        Map<String, Boolean> result = new HashMap<String, Object>();
        if (userGroupMap == null || groupRetainMap == null) {
            result.put("SUCCESS", false);
            result.put("msg", (Boolean)((Object)EASResource.getString((String)RESOURCE, (String)"PARSE_EXCEL_FAIL")));
            return new JSONObject(result).toString();
        }
        int MAX_DATA = 1000;
        boolean flag1 = false;
        boolean userStateflag = false;
        boolean ulicInsertState = false;
        boolean ulicDiffInsertState = false;
        String updateUserStateSQL = "update t_pm_user set fissyntocloud =0 where lower(fnumber) = ?";
        String deleteUserLicenseSQL = "DELETE from t_pm_userlicensegroup where fuserid = ?";
        String insertUserLicenseSQL = "insert into t_pm_userlicensegroup(fuserid,fgroupnumber,fsynuser,fid,fisactive,fname_l2) values(?,?,?,?,?,?)";
        String deleteDiffSQL = "DELETE from t_Pm_Userlicgroupdiff where fuserid = ?";
        String insertDiffSQL = "insert into  t_Pm_Userlicgroupdiff(fgroupstr,fname,fcell,femail,fuid,fisdelete,fforbidden,fnumber,fuserid) values(?,?,?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement userUpdatePs = null;
        PreparedStatement ulicDeletePs = null;
        PreparedStatement ulicDiffDeletePs = null;
        PreparedStatement ulicInsertPs = null;
        PreparedStatement ulicDiffInsertPs = null;
        int count = 0;
        ArrayList<String> userNumberList = new ArrayList<String>(userGroupMap.keySet());
        Map<String, UserInfo> userInfoMap = this.getUserMap(ctx, userNumberList);
        Map<String, String> moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(ctx);
        Iterator<Map.Entry<String, UserInfo>> userInfoEntry = userInfoMap.entrySet().iterator();
        result = this.getOverLoadGroupMap(ctx, result, groupRetainMap);
        long t1 = System.currentTimeMillis();
        int isActive = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
            userUpdatePs = conn.prepareStatement(updateUserStateSQL);
            ulicDeletePs = conn.prepareStatement(deleteUserLicenseSQL);
            ulicDiffDeletePs = conn.prepareStatement(deleteDiffSQL);
            while (userInfoEntry.hasNext()) {
                Map.Entry<String, UserInfo> userEntry = userInfoEntry.next();
                userUpdatePs.setString(1, userEntry.getKey());
                ulicDeletePs.setString(1, userEntry.getValue().getId().toString());
                ulicDiffDeletePs.setString(1, userEntry.getValue().getId().toString());
                userUpdatePs.addBatch();
                ulicDeletePs.addBatch();
                ulicDiffDeletePs.addBatch();
                if (++count % 1000 == 0) {
                    userUpdatePs.executeBatch();
                    userUpdatePs.clearBatch();
                    ulicDeletePs.executeBatch();
                    ulicDeletePs.clearBatch();
                    ulicDiffDeletePs.executeBatch();
                    ulicDiffDeletePs.clearBatch();
                    userStateflag = true;
                    continue;
                }
                userStateflag = false;
            }
            if (!userStateflag) {
                userUpdatePs.executeBatch();
                ulicDeletePs.executeBatch();
                ulicDiffDeletePs.executeBatch();
            }
            long t2 = System.currentTimeMillis();
            ulicInsertPs = conn.prepareStatement(insertUserLicenseSQL);
            ulicDiffInsertPs = conn.prepareStatement(insertDiffSQL);
            Iterator<Map.Entry<String, Map<String, Boolean>>> userGroupEntryItr = userGroupMap.entrySet().iterator();
            count = 0;
            int groupCount = 0;
            HashMap<String, Map<String, Boolean>> userLicMap = new HashMap<String, Map<String, Boolean>>();
            while (userGroupEntryItr.hasNext()) {
                Map.Entry<String, Map<String, Boolean>> userGroupEntry = userGroupEntryItr.next();
                String userNumber = userGroupEntry.getKey();
                UserInfo user = userInfoMap.get(userNumber);
                if (user == null) continue;
                HashMap userGroup = new HashMap();
                String fid = user.getId().toString();
                Map<String, Boolean> groupMap = userGroupEntry.getValue();
                if (StringUtils.isEmpty((String)fid) || groupMap == null || groupMap.size() <= 0) continue;
                String groupStr = "";
                for (Map.Entry<String, Boolean> groupMapEntry : groupMap.entrySet()) {
                    String group = groupMapEntry.getKey();
                    ulicInsertPs.setString(1, fid);
                    ulicInsertPs.setString(2, group);
                    ulicInsertPs.setInt(3, 0);
                    ulicInsertPs.setString(4, BOSUuid.create((String)"94716EDD").toString());
                    isActive = 0;
                    if (groupMapEntry.getValue().booleanValue() && !this.groupOverLoadList.contains(group) && !user.isIsDelete() && !user.isIsForbidden()) {
                        groupStr = groupStr + group + ";";
                        isActive = 1;
                    }
                    groupMap.put(group, isActive == 1);
                    ulicInsertPs.setInt(5, isActive);
                    ulicInsertPs.setString(6, moduleAliasMap.get(group) != null ? moduleAliasMap.get(group).toString() : "");
                    ulicInsertPs.addBatch();
                    if (++groupCount % 1000 == 0) {
                        ulicInsertPs.executeBatch();
                        ulicInsertPs.clearBatch();
                        ulicInsertState = true;
                        continue;
                    }
                    ulicInsertState = false;
                }
                userLicMap.put(user.getNumber(), groupMap);
                ulicDiffInsertPs.setString(1, groupStr);
                ulicDiffInsertPs.setString(2, user.getName());
                ulicDiffInsertPs.setString(3, user.getCell());
                ulicDiffInsertPs.setString(4, user.getEmail());
                ulicDiffInsertPs.setString(5, user.getUid());
                ulicDiffInsertPs.setBoolean(6, user.isIsDelete());
                ulicDiffInsertPs.setBoolean(7, user.isIsForbidden());
                ulicDiffInsertPs.setString(8, userNumber);
                ulicDiffInsertPs.setString(9, fid);
                ulicDiffInsertPs.addBatch();
                if (++count % 1000 == 0) {
                    ulicDiffInsertPs.executeBatch();
                    ulicDiffInsertPs.clearBatch();
                    ulicDiffInsertState = true;
                    continue;
                }
                ulicDiffInsertState = false;
            }
            if (!ulicInsertState) {
                ulicInsertPs.executeBatch();
            }
            if (!ulicDiffInsertState) {
                ulicDiffInsertPs.executeBatch();
            }
            long t3 = System.currentTimeMillis();
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>\u8d85\u51fa\u7684\u5206\u7ec4>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + this.groupOverLoadList));
            logger.error((Object)("=========\u66f4\u65b0\u7528\u6237\u65f6\u95f4=========" + (t2 - t1)));
            logger.error((Object)("=========\u66f4\u65b0\u7528\u6237\u5206\u7ec4\u4fe1\u606f\u65f6\u95f4=========" + (t3 - t2)));
            conn.commit();
            result.put("SUCCESS", true);
            StringBuilder msg = new StringBuilder(EASResource.getString((String)RESOURCE, (String)"importUserMsg", (Locale)ctx.getLocale()) + " \r\n");
            if (result.get("isGroupOverload") != null && Boolean.valueOf(result.get("isGroupOverload").toString()).booleanValue()) {
                msg.append(result.get("overLoadMsg"));
            } else {
                msg.replace(0, msg.length(), EASResource.getString((String)RESOURCE, (String)"importDataSuccess", (Locale)ctx.getLocale()));
            }
            result.put("msg", (Boolean)((Object)msg.toString()));
        }
        catch (Exception e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    result.put("SUCCESS", false);
                    result.put("msg", (Boolean)((Object)EASResource.getString((String)RESOURCE, (String)"UPDATE_USERGROUP_EXCEPTION")));
                    logger.error((Object)("====================\u66f4\u65b0\u7528\u6237\u5206\u7ec4\u56de\u6eda\u5f02\u5e38==================" + e1));
                }
                logger.error((Object)("====================\u66f4\u65b0\u7528\u6237\u5206\u7ec4\u6267\u884csql\u5f02\u5e38==================" + e));
                result.put("SUCCESS", false);
                result.put("msg", (Boolean)((Object)EASResource.getString((String)RESOURCE, (String)"UPDATE_USERGROUP_FAIL")));
                result.put("msgInfo", (Boolean)((Object)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(userUpdatePs);
                SQLUtils.cleanup(ulicDeletePs);
                SQLUtils.cleanup(ulicDiffDeletePs);
                SQLUtils.cleanup(ulicInsertPs);
                SQLUtils.cleanup(ulicDiffInsertPs);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)conn);
            SQLUtils.cleanup((Statement)userUpdatePs);
            SQLUtils.cleanup((Statement)ulicDeletePs);
            SQLUtils.cleanup((Statement)ulicDiffDeletePs);
            SQLUtils.cleanup((Statement)ulicInsertPs);
            SQLUtils.cleanup((Statement)ulicDiffInsertPs);
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)userUpdatePs);
        SQLUtils.cleanup((Statement)ulicDeletePs);
        SQLUtils.cleanup((Statement)ulicDiffDeletePs);
        SQLUtils.cleanup((Statement)ulicInsertPs);
        SQLUtils.cleanup((Statement)ulicDiffInsertPs);
        return new JSONObject(result).toString();
    }

    private Map getOverLoadGroupMap(Context ctx, Map result, Map<String, List<String>> groupRetainMap) throws BOSException, EASBizException {
        this.groupOverLoadList = new ArrayList();
        Map<String, GroupLicenseUseInfo> mpLicenseUseInfo = this.getLicenseUseSev(ctx).getGroupsUseInfos(ctx);
        Iterator<Map.Entry<String, List<String>>> groupRetainMapItr = groupRetainMap.entrySet().iterator();
        StringBuilder overLoadMsg = new StringBuilder("\r\n " + EASResource.getString((String)RESOURCE, (String)"group", (Locale)ctx.getLocale()) + ": \r\n");
        boolean isGroupOverload = false;
        while (groupRetainMapItr.hasNext()) {
            List<String> users;
            Map.Entry<String, List<String>> groupRetainMapEntry = groupRetainMapItr.next();
            String group = groupRetainMapEntry.getKey();
            if (this.checkUsersGroupByTotal(ctx, mpLicenseUseInfo, group, users = groupRetainMapEntry.getValue())) continue;
            this.groupOverLoadList.add(group);
            overLoadMsg.append(group + ";");
            isGroupOverload = true;
        }
        overLoadMsg.append("\r\n " + EASResource.getString((String)RESOURCE, (String)"overLoadMsg", (Locale)ctx.getLocale()) + " \r\n");
        result.put("overLoadMsg", overLoadMsg.toString());
        result.put("isGroupOverload", isGroupOverload);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, UserInfo> getUserMap(Context ctx, List numberList) throws BOSException {
        HashMap<String, UserInfo> userMap = new HashMap<String, UserInfo>();
        Connection conn = null;
        String sql = "Select fid,fnumber,fname_l2,fcell,femail,fuid,fisdelete,fforbidden from t_pm_user where lower(fnumber) in (?)";
        Statement stmt = null;
        int PERSIZE = 1000;
        int totalSize = numberList.size();
        int totalCount = (totalSize - 1) / PERSIZE + 1;
        int begin = 0;
        int end = 0;
        List subList = new ArrayList();
        ResultSet rs = null;
        String id = "";
        String number = "";
        UserInfo user = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            for (int i = 0; i < totalCount; ++i) {
                begin = i * PERSIZE;
                end = (i + 1) * PERSIZE > totalSize ? totalSize : (i + 1) * PERSIZE;
                subList = numberList.subList(begin, end);
                String tempSQL = sql;
                String orgParam = ToolUtils.aryToStr(subList, true);
                tempSQL = tempSQL.replace("?", orgParam);
                rs = stmt.executeQuery(tempSQL);
                while (rs.next()) {
                    user = new UserInfo();
                    number = rs.getString("fnumber") != null ? rs.getString("fnumber").toLowerCase() : null;
                    user.setId(BOSUuid.read((String)rs.getString("fid")));
                    user.setNumber(number);
                    user.setName(rs.getString("fname_l2"));
                    user.setCell(rs.getString("fcell"));
                    user.setEmail(rs.getString("femail"));
                    user.setUid(rs.getString("fuid"));
                    user.setIsDelete(rs.getBoolean("fisdelete"));
                    user.setIsForbidden(rs.getBoolean("fforbidden"));
                    if (id == null || number == null || userMap.containsKey(number)) continue;
                    userMap.put(number, user);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("======================\u6267\u884csql\u5f02\u5e38=================" + e));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            SQLUtils.cleanup((Statement)stmt);
        }
        return userMap;
    }

    public boolean checkUsersGroupByTotal(Context ctx, Map<String, GroupLicenseUseInfo> mpLicenseUseInfo, String group, List<String> users) {
        int totalNum = 0;
        if (mpLicenseUseInfo.get(group) != null) {
            totalNum = mpLicenseUseInfo.get(group).getTotal();
            HashSet<String> userSet = new HashSet<String>(mpLicenseUseInfo.get(group).getRegistedUsers());
            userSet.addAll(users);
            if (totalNum < userSet.size()) {
                return false;
            }
        }
        return true;
    }

    private boolean delUserRoleGroups(Context ctx, String userId, List<String> preDelGroups, String roleId) throws BOSException, EASBizException {
        if (preDelGroups == null || preDelGroups.size() == 0) {
            return true;
        }
        List<String> userGroupStr = this.getUserGroupStr(ctx, userId);
        preDelGroups.retainAll(userGroupStr);
        if (preDelGroups == null || preDelGroups.size() == 0) {
            return true;
        }
        List<String> realUserPerm = this.getUserRoleLicenseGroupByUser(ctx, userId, roleId);
        List<String> realUserGroup = this.getPermitemsGroupStr(ctx, realUserPerm);
        preDelGroups.removeAll(realUserGroup);
        if (preDelGroups.size() == 0) {
            return true;
        }
        UserLicenseGroupsInfo userLicenseGroups = this.getUserLicenseGroups(ctx, userId);
        IUserLicenseGroupHelper ihelper = this.getUserLicenseGroupHelper4Del(ctx, userLicenseGroups, preDelGroups);
        ihelper.exec();
        return true;
    }

    public boolean removeUser(String[] seleteUserLicenseIds, Map userData, String groupNumber, int activeCount) {
        UserLicenseGroupActiveHelper userLicenseGroupActiveHelper = new UserLicenseGroupActiveHelper();
        return userLicenseGroupActiveHelper.removeUserLicenseGroup(context, seleteUserLicenseIds, userData, groupNumber, activeCount);
    }

    public Map<IObjectPK, Boolean> fastBatchSynUserGroups(Context ctx, List<IObjectPK> userPks) {
        Future<Boolean> future;
        HashMap<IObjectPK, Boolean> syncFailUsers = new HashMap<IObjectPK, Boolean>();
        ExecutorService executorService = PermThreadPool.getExecutorService();
        HashMap<IObjectPK, Future<Boolean>> futures = new HashMap<IObjectPK, Future<Boolean>>();
        final Context localctx = ctx;
        for (IObjectPK userPk : userPks) {
            final IObjectPK localUserPk = userPk;
            if (futures.containsKey(localUserPk)) continue;
            future = executorService.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    LicenseUseManager.this.synUserGroups(localctx, localUserPk);
                    return true;
                }
            });
            futures.put(localUserPk, future);
        }
        Iterator iter = futures.keySet().iterator();
        while (iter.hasNext()) {
            boolean success = false;
            IObjectPK userkey = (IObjectPK)iter.next();
            future = (Future<Boolean>)futures.get(userkey);
            try {
                success = future.get(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
            catch (ExecutionException e) {
                logger.error((Object)e);
            }
            catch (TimeoutException e) {
                logger.error((Object)e);
            }
            if (success) continue;
            syncFailUsers.put(userkey, false);
        }
        return syncFailUsers;
    }

    public void batchSynUserGroups(Context ctx, List<IObjectPK> userPks) throws EASBizException, BOSException {
        HashSet<IObjectPK> userPksSet = new HashSet<IObjectPK>(userPks);
        for (IObjectPK userPk : userPksSet) {
            this.synUserGroups(ctx, userPk);
        }
    }

    public void synUserGroups(Context ctx, IObjectPK userPk) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        UserInfo user = iUser.getUserInfo(userPk);
        Map<String, String> moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(ctx);
        IUserLicenseGroup iUserLicenseGroup = UserLicenseGroupFactory.getLocalInstance(ctx);
        ILicenseUseSrv licenseUserSrv = LicenseUseSrvFactory.getLocalInstance(ctx);
        HashSet<String> oldUserLicenseGroups = new HashSet<String>();
        Set<String> userLicenseGroups = this.getUserPermGroups(ctx, userPk);
        Set<String> permItemMapGroups = this.getPermItemMapGroup(ctx);
        iUserLicenseGroup.delete("where user = '" + userPk.toString() + "' and isActive = 0");
        UserLicenseGroupCollection userLicenseGroupCollection = iUserLicenseGroup.getUserLicenseGroupCollection("select * where user = '" + userPk.toString() + "'");
        for (int i = 0; i < userLicenseGroupCollection.size(); ++i) {
            UserLicenseGroupInfo userLicenseGroupInfo = userLicenseGroupCollection.get(i);
            oldUserLicenseGroups.add(userLicenseGroupInfo.getGroupNumber());
        }
        HashSet<String> addGroups = new HashSet<String>(userLicenseGroups);
        addGroups.removeAll(oldUserLicenseGroups);
        HashSet delGroups = new HashSet(oldUserLicenseGroups);
        delGroups.removeAll(userLicenseGroups);
        String userId = userPk.toString();
        for (String groupNumber : delGroups) {
            if (!permItemMapGroups.contains(groupNumber)) continue;
            iUserLicenseGroup.delete("where groupnumber ='" + groupNumber + "' and user ='" + userId + "'");
            licenseUserSrv.disAssignUsersGroup(ctx, groupNumber, 1);
        }
        for (String groupNumber : addGroups) {
            boolean isActive = false;
            if (licenseUserSrv.getGroupRemainNum(ctx, groupNumber) > 0) {
                licenseUserSrv.assignUsersGroup(ctx, groupNumber, 1);
                isActive = true;
            }
            UserLicenseGroupInfo userLicenseGroupInfo = new UserLicenseGroupInfo();
            userLicenseGroupInfo.setUser(user);
            userLicenseGroupInfo.setGroupNumber(groupNumber);
            userLicenseGroupInfo.setSynUser(SynStateEnum.SYN_NO);
            String groupName = moduleAliasMap.get(groupNumber);
            userLicenseGroupInfo.setName(groupName);
            userLicenseGroupInfo.setName(groupName);
            userLicenseGroupInfo.setName(groupName);
            userLicenseGroupInfo.setIsActive(isActive ? ActiveStateEnum.Active_YES : ActiveStateEnum.Active_NO);
            iUserLicenseGroup.addnew(userLicenseGroupInfo);
        }
        if (user.isIsForbidden() || user.isIsDelete()) {
            this.releasUserAllGroups(ctx, userPk);
        }
    }

    public void releasUserAllGroups(Context ctx, IObjectPK userPk) throws BOSException {
        IUserLicenseGroup iUserLicenseGroup = UserLicenseGroupFactory.getLocalInstance(ctx);
        UserLicenseGroupCollection activeUserLicenseGroupCollection = iUserLicenseGroup.getUserLicenseGroupCollection("where user = '" + userPk.toString() + "' and isActive = 1");
        for (int i = 0; i < activeUserLicenseGroupCollection.size(); ++i) {
            UserLicenseGroupInfo userLicenseGroupInfo = activeUserLicenseGroupCollection.get(i);
            DbUtil.execute((Context)ctx, (String)"update T_PM_USERLICENSEGROUP set FISACTIVE=0 where fuserid=? and FGROUPNUMBER=?", (Object[])new Object[]{userPk.toString(), userLicenseGroupInfo.getGroupNumber()});
        }
    }

    public Set<String> getPermItemMapGroup(Context ctx) throws BOSException {
        String permuigroup = UserLicenseGroupTool.getPermUIGroupTableName(ctx);
        StringBuilder sqlBuilder = new StringBuilder();
        HashSet<String> groupNumbers = new HashSet<String>();
        sqlBuilder.append("SELECT distinct gp.FGROUPNUMBER  FROM ").append(permuigroup).append(" gp INNER JOIN T_PM_PERMITEM perm on gp.FPERMITEMID = perm.FID ");
        sqlBuilder.append("where perm.FISLEAF = 1 and gp.FGROUPNUMBER is not null");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
            while (rowSet.next()) {
                groupNumbers.add(rowSet.getString("fgroupnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("query data error!");
        }
        return groupNumbers;
    }

    public Set<String> getUserPermGroups(Context ctx, IObjectPK userPk) throws BOSException {
        String permuigroup = UserLicenseGroupTool.getPermUIGroupTableName(ctx);
        HashSet<String> groupNumbers = new HashSet<String>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select distinct fgroupnumber                                          ");
        sqlBuffer.append("  from " + permuigroup + " gp                                             ");
        sqlBuffer.append(" inner join (SELECT fid                                               ");
        sqlBuffer.append("               FROM T_PM_PermItem permitem                            ");
        sqlBuffer.append("              where permitem.FISLEAF = 1                              ");
        sqlBuffer.append("                and exists                                            ");
        sqlBuffer.append("              (SELECT 1                                               ");
        sqlBuffer.append("                       FROM " + permuigroup + " pp                        ");
        sqlBuffer.append("                      where pp.FPERMITEMID = permitem.fid)            ");
        sqlBuffer.append("                and (exists                                           ");
        sqlBuffer.append("                     (SELECT 1                                        ");
        sqlBuffer.append("                        from t_pm_userorgperm UserOrgPerm             ");
        sqlBuffer.append("                       where UserOrgPerm.Fowner =?                    ");
        sqlBuffer.append("                         and UserOrgPerm.FPERMITEMID = permitem.fid   ");
        sqlBuffer.append("                         and UserOrgPerm.FPermType = 10) or exists    ");
        sqlBuffer.append("                     (SELECT 1                                        ");
        sqlBuffer.append("                        FROM t_pm_role role                           ");
        sqlBuffer.append("                       inner join t_pm_roleperm RolePerm              ");
        sqlBuffer.append("                          on role.FID = RolePerm.FRoleID              ");
        sqlBuffer.append("                       where RolePerm.FPERMITEMID = permitem.fid      ");
        sqlBuffer.append("                         and RolePerm.FPermType = 10                  ");
        sqlBuffer.append("                         and exists                                   ");
        sqlBuffer.append("                       (select 1                                      ");
        sqlBuffer.append("                                from T_PM_UserRoleOrg USERROLEORG     ");
        sqlBuffer.append("                               where USERROLEORG.FUSERID =?           ");
        sqlBuffer.append("                                 and USERROLEORG.FROLEID = role.FID)))");
        sqlBuffer.append("                                                                      ");
        sqlBuffer.append("             ) grperm                                                 ");
        sqlBuffer.append("    on gp.fpermitemid = grperm.fid                                    ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{userPk.toString(), userPk.toString()});
            while (rowSet.next()) {
                groupNumbers.add(rowSet.getString("fgroupnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("query data error!");
        }
        return groupNumbers;
    }

    public Set<String> getUserPermGroupsWithOut(Context ctx, IObjectPK userPk, List<String> excludeOrgIds, List<String> excludeRoleIds) throws BOSException {
        String permuigroup = UserLicenseGroupTool.getPermUIGroupTableName(ctx);
        HashSet<String> groupNumbers = new HashSet<String>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select distinct fgroupnumber                                          ");
        sqlBuffer.append("  from " + permuigroup + " gp                                             ");
        sqlBuffer.append(" inner join (SELECT fid                                               ");
        sqlBuffer.append("               FROM T_PM_PermItem permitem                            ");
        sqlBuffer.append("              where permitem.FISLEAF = 1                              ");
        sqlBuffer.append("                and exists                                            ");
        sqlBuffer.append("              (SELECT 1                                               ");
        sqlBuffer.append("                       FROM " + permuigroup + " pp                        ");
        sqlBuffer.append("                      where pp.FPERMITEMID = permitem.fid)            ");
        sqlBuffer.append("                and (exists                                           ");
        sqlBuffer.append("                     (SELECT 1                                        ");
        sqlBuffer.append("                        from t_pm_userorgperm UserOrgPerm             ");
        sqlBuffer.append("                       where UserOrgPerm.Fowner =?                    ");
        sqlBuffer.append("                         and UserOrgPerm.FPERMITEMID = permitem.fid   ");
        sqlBuffer.append("                         and UserOrgPerm.FPermType = 10               ");
        if (excludeOrgIds != null && !excludeOrgIds.isEmpty()) {
            sqlBuffer.append("and UserOrgPerm.forgid not in (" + ToolUtils.aryToStr(excludeOrgIds) + ")");
        }
        sqlBuffer.append("                                                       ) or exists    ");
        sqlBuffer.append("                     (SELECT 1                                        ");
        sqlBuffer.append("                        FROM t_pm_role role                           ");
        sqlBuffer.append("                       inner join t_pm_roleperm RolePerm              ");
        sqlBuffer.append("                          on role.FID = RolePerm.FRoleID              ");
        sqlBuffer.append("                       where RolePerm.FPERMITEMID = permitem.fid      ");
        sqlBuffer.append("                         and RolePerm.FPermType = 10                  ");
        if (excludeRoleIds != null && !excludeRoleIds.isEmpty()) {
            sqlBuffer.append("and role.fid not in (" + ToolUtils.aryToStr(excludeOrgIds) + ")");
        }
        sqlBuffer.append("                         and exists                                   ");
        sqlBuffer.append("                       (select 1                                      ");
        sqlBuffer.append("                                from T_PM_UserRoleOrg USERROLEORG     ");
        sqlBuffer.append("                               where USERROLEORG.FUSERID =?           ");
        sqlBuffer.append("                                 and USERROLEORG.FROLEID = role.FID)))");
        sqlBuffer.append("                                                                      ");
        sqlBuffer.append("             ) grperm                                                 ");
        sqlBuffer.append("    on gp.fpermitemid = grperm.fid                                    ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{userPk.toString(), userPk.toString()});
            while (rowSet.next()) {
                groupNumbers.add(rowSet.getString("fgroupnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("query data error!");
        }
        return groupNumbers;
    }

    public Map<String, LicenseGroupUsers> getCompareUserLicenseGroups(Context ctx) throws LicenseException {
        HashMap<String, LicenseGroupUsers> licenseGroupUsersMap = new HashMap<String, LicenseGroupUsers>();
        List<LicenseGroupUsers> licenseGroupUsersList = this.initGetLicenseGroupUsers(ctx);
        Map<String, List<CloudRegistUserInfo>> groupRegistors = this.getGroupRegistors(ctx);
        Map<String, Map<String, List<String>>> dbGroupRegistors = this.getAllDbGroupRegistors();
        Iterator<LicenseGroupUsers> iterator = licenseGroupUsersList.iterator();
        while (iterator.hasNext()) {
            LicenseGroupUsers licenseGroupUsers;
            String groupNumber = (licenseGroupUsers = iterator.next()).getGroupNumber();
            licenseGroupUsers.toSetRegistedUsers(groupRegistors.get(groupNumber) == null ? new ArrayList() : groupRegistors.get(groupNumber));
            licenseGroupUsers.setDbRegistedUsers(dbGroupRegistors.get(groupNumber) == null ? new HashMap() : dbGroupRegistors.get(groupNumber));
            licenseGroupUsersMap.put(groupNumber, licenseGroupUsers);
            licenseGroupUsers.refreshDiffCounts();
        }
        return licenseGroupUsersMap;
    }

    private List<LicenseGroupUsers> initGetLicenseGroupUsers(Context ctx) throws LicenseException {
        ArrayList<LicenseGroupUsers> licenseGroupUsersList = new ArrayList<LicenseGroupUsers>();
        Map<String, LicenseUsageInfo> validLicenseUsagesMap = UserLicenseGroupTool.getValidLicenseUsagesMap(ctx);
        for (Map.Entry<String, LicenseUsageInfo> LicenseUsageInfoMap : validLicenseUsagesMap.entrySet()) {
            LicenseUsageInfo LicenseUsageInfo2 = LicenseUsageInfoMap.getValue();
            String moduleName = LicenseUsageInfo2.getModuleName();
            String moduleAlias = LicenseUsageInfo2.getModuleAlias();
            int maxNum = LicenseUsageInfo2.getMaxLicenseNum();
            LicenseGroupUsers UserLicenseGroups = new LicenseGroupUsers();
            UserLicenseGroups.setGroupNumber(moduleName);
            UserLicenseGroups.setAlias(moduleAlias);
            UserLicenseGroups.setTotal(maxNum);
            licenseGroupUsersList.add(UserLicenseGroups);
        }
        return licenseGroupUsersList;
    }

    private Map<String, Map<String, List<String>>> getAllDbGroupRegistors() {
        HashMap<String, Map<String, List<String>>> dbGroupRegistors = new HashMap<String, Map<String, List<String>>>();
        DCRegister dcRegister = new DCRegister();
        ArrayList dcList = null;
        try {
            dcList = dcRegister.getDCList();
            Iterator it = dcList.iterator();
            while (it.hasNext()) {
                String dataSourceAIS = ((DCInfo)it.next()).getNumber();
                Map<String, List<String>> groupRegistors = this.getGroupRegistorsByDb(dataSourceAIS);
                for (Map.Entry<String, List<String>> groupRegistorsiterEntry : groupRegistors.entrySet()) {
                    String group = groupRegistorsiterEntry.getKey();
                    List<String> registors = groupRegistorsiterEntry.getValue();
                    HashMap<String, ArrayList<String>> registorDbs = (HashMap<String, ArrayList<String>>)dbGroupRegistors.get(group);
                    if (registorDbs == null) {
                        registorDbs = new HashMap<String, ArrayList<String>>();
                        dbGroupRegistors.put(group, registorDbs);
                    }
                    for (String registor : registors) {
                        ArrayList<String> list = (ArrayList<String>)registorDbs.get(registor);
                        if (list == null) {
                            list = new ArrayList<String>();
                            registorDbs.put(registor, list);
                        }
                        list.add(dataSourceAIS);
                    }
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        return dbGroupRegistors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getGroupRegistorsByDb(String dataSourceAIS) throws BOSException {
        Connection conn = DbConnector.getConnection((String)dataSourceAIS);
        HashMap<String, List<String>> dbGroupRegistors = new HashMap<String, List<String>>();
        StringBuilder sql = new StringBuilder();
        sql.append("select licGroup.Fuserid fid,licGroup.Fgroupnumber groupnumber ,pmUser.Fnumber userNumber,pmUser.Fuid fuid from t_pm_user pmUser ").append(" inner join T_PM_UserLicenseGroup licGroup  on pmUser.Fid = licGroup.Fuserid where licGroup.fisactive = 1 and fisdelete = 0 and fforbidden = 0 ").append(" and lower(pmuser.Fnumber) not in('administrator','user','authenadmin','sscadmin','auditadmin','virtualuser') and pmuser.ftype not in(10,60,70) ");
        if (conn == null) {
            return dbGroupRegistors;
        }
        Statement sta = null;
        ResultSet rs = null;
        try {
            sta = conn.createStatement();
            sta.setFetchSize(1000);
            rs = sta.executeQuery(sql.toString());
            while (rs.next()) {
                String groupNum = rs.getString("groupnumber");
                String userNumber = rs.getString("userNumber").toLowerCase();
                ArrayList<String> registors = (ArrayList<String>)dbGroupRegistors.get(groupNum);
                if (registors == null) {
                    registors = new ArrayList<String>();
                    dbGroupRegistors.put(groupNum, registors);
                }
                if (registors.contains(userNumber)) continue;
                registors.add(userNumber);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sta, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)sta, (Connection)conn);
        }
        return dbGroupRegistors;
    }

    private Map<String, List<CloudRegistUserInfo>> getGroupRegistors(Context ctx) throws LicenseException {
        HashMap<String, List<CloudRegistUserInfo>> groupToRegistors = new HashMap<String, List<CloudRegistUserInfo>>();
        Map registUserMapGroup = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getRegistUserMapGroup();
        for (Map.Entry cloudRegistUserInfoEntry : registUserMapGroup.entrySet()) {
            CloudRegistUserInfo cloudRegistUserInfo = (CloudRegistUserInfo)cloudRegistUserInfoEntry.getValue();
            HashSet groupsSet = cloudRegistUserInfo.getGroup();
            if (groupsSet == null) {
                groupsSet = new HashSet();
            }
            for (String group : groupsSet) {
                ArrayList<CloudRegistUserInfo> list = (ArrayList<CloudRegistUserInfo>)groupToRegistors.get(group);
                if (list == null) {
                    list = new ArrayList<CloudRegistUserInfo>();
                    groupToRegistors.put(group, list);
                }
                list.add(cloudRegistUserInfo);
            }
        }
        return groupToRegistors;
    }

    class DelUserGroupsThread
    implements Callable<Boolean> {
        String userId;
        List<String> permitemGroupStr;
        Context ctx;
        String roleId;

        public DelUserGroupsThread(Context ctx, String userId, List<String> permitemGroupStr, String roleId) {
            this.ctx = ctx;
            this.userId = userId;
            this.permitemGroupStr = permitemGroupStr;
            this.roleId = roleId;
        }

        @Override
        public Boolean call() throws Exception {
            return LicenseUseManager.this.delUserRoleGroups(this.ctx, this.userId, this.permitemGroupStr, this.roleId);
        }
    }
}

