/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.EASCloudEnum;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUsageInfo;
import com.kingdee.eas.base.license.ModuleLicenseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermException;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLicenseGroupCollection;
import com.kingdee.eas.base.permission.UserLicenseGroupFactory;
import com.kingdee.eas.base.permission.UserLicenseGroupInfo;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseConstantHelper;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupsInfo;
import com.kingdee.eas.base.permission.app.util.interior.db.LicenseResourceHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis.utils.ByteArrayOutputStream;
import org.apache.log4j.Logger;

public class UserLicenseGroupTool {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool");
    private static Map<String, String> permGroupMap = null;
    private static final Map<String, Map<String, String>> permLicGroupMap = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> moduleMultiAliasMap = new HashMap<String, Map<String, String>>();
    private static final Map<String, String> validLicGroupMap = new HashMap<String, String>();
    private static long validLicGroupMapUpdateTime = 0L;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public static UserInfo getUserInfo(Context ctx, String userId) {
        UserInfo user = null;
        try {
            user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return user;
    }

    public static List<LicenseUsageInfo> getUsageInfoList(Context ctx) {
        ArrayList<LicenseUsageInfo> usageInfoList = new ArrayList<LicenseUsageInfo>();
        usageInfoList.addAll(UserLicenseGroupTool.getLicenseUsagesMap(ctx).values());
        return usageInfoList;
    }

    public static List<LicenseUsageInfo> getAllLicenseUsageInfo(Context ctx) {
        ArrayList<LicenseUsageInfo> usageInfoList = new ArrayList<LicenseUsageInfo>();
        usageInfoList.addAll(UserLicenseGroupTool.getMapUsageInfo(ctx).values());
        return usageInfoList;
    }

    public static Map<String, LicenseUsageInfo> getMapUsageInfo(Context ctx) {
        HashMap<String, LicenseUsageInfo> mpUsageInfo = new HashMap<String, LicenseUsageInfo>();
        ILicenseSrvAgent licenseSrv = null;
        UserLicenseGroupTool.getModuleAliasMap(ctx);
        try {
            ModuleLicenseInfo[] moduleLicenseInfos;
            Map<String, LicenseUsageInfo> licenseUsagesMap = UserLicenseGroupTool.getLicenseUsagesMap(ctx);
            licenseSrv = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            for (ModuleLicenseInfo moduleLicenseInfo : moduleLicenseInfos = licenseSrv.getModuleLicenseInfo()) {
                LicenseUsageInfo licenseUsageInfo = new LicenseUsageInfo();
                licenseUsageInfo.setMaxLicenseNum(moduleLicenseInfo.getLicenseNum());
                licenseUsageInfo.setModuleAlias(moduleLicenseInfo.getModuleAlias());
                licenseUsageInfo.setModuleName(moduleLicenseInfo.getModuleName());
                licenseUsageInfo.setSurplusLicenseNum(moduleLicenseInfo.getLicenseNum());
                licenseUsageInfo.setSupliedLicenseNum(0);
                if (moduleMultiAliasMap.get(ctx.getLocale().toString()).get(moduleLicenseInfo.getModuleName()) != null && moduleMultiAliasMap.get(ctx.getLocale().toString()).get(moduleLicenseInfo.getModuleName()) instanceof String) {
                    licenseUsageInfo.setModuleAlias(moduleMultiAliasMap.get(ctx.getLocale().toString()).get(moduleLicenseInfo.getModuleName()));
                }
                if (licenseUsagesMap.get(moduleLicenseInfo.getModuleName()) != null) {
                    licenseUsageInfo.setSupliedLicenseNum(licenseUsagesMap.get(moduleLicenseInfo.getModuleName()).getSupliedLicenseNum());
                }
                mpUsageInfo.put(moduleLicenseInfo.getModuleName(), licenseUsageInfo);
            }
        }
        catch (LicenseException e) {
            logger.error((Object)e);
            throw new RuntimeException("license error");
        }
        logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>mpUsageInfo>>>>>>>>>>>>>>>>>>>>: " + mpUsageInfo));
        return mpUsageInfo;
    }

    public static Map<String, LicenseUsageInfo> getLicenseUsagesMap(Context ctx) {
        HashMap<String, LicenseUsageInfo> licenseUsagesMap = new HashMap<String, LicenseUsageInfo>();
        List licenseUsages = null;
        try {
            licenseUsages = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getUsageInfoList(ctx.getLocale());
        }
        catch (LicenseException e) {
            logger.error((Object)">>>>>>>>>>>>>>>>>license user error>>>>>>>>>>>>>>>>");
        }
        if (licenseUsages != null && !licenseUsages.isEmpty()) {
            for (LicenseUsageInfo licenseUsage : licenseUsages) {
                licenseUsagesMap.put(licenseUsage.getModuleName(), licenseUsage);
            }
        }
        return licenseUsagesMap;
    }

    public static Map<String, LicenseUsageInfo> getValidLicenseUsagesMap(Context ctx) throws LicenseException {
        HashMap<String, LicenseUsageInfo> validUsageInfo = new HashMap<String, LicenseUsageInfo>();
        ILicenseSrvAgent licenseSrv = null;
        try {
            licenseSrv = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
        }
        catch (LicenseException e) {
            logger.error((Object)"----LicenseSrvAgentFactory create error----");
        }
        List validModuleLicenses = licenseSrv.getValidModuleLicenses();
        UserLicenseGroupTool.getModuleAliasMap(ctx);
        Set<String> osSet = UserLicenseGroupTool.getOSSet(ctx);
        for (ModuleLicenseInfo moduleLicenseInfo : validModuleLicenses) {
            String group = moduleLicenseInfo.getModuleName();
            if (osSet.contains(group.toUpperCase())) continue;
            LicenseUsageInfo licenseUsageInfo = new LicenseUsageInfo();
            licenseUsageInfo.setMaxLicenseNum(moduleLicenseInfo.getLicenseNum());
            licenseUsageInfo.setModuleAlias(moduleLicenseInfo.getModuleAlias());
            licenseUsageInfo.setModuleName(group);
            licenseUsageInfo.setSurplusLicenseNum(moduleLicenseInfo.getLicenseNum());
            licenseUsageInfo.setSupliedLicenseNum(0);
            if (moduleMultiAliasMap.get(ctx.getLocale().toString()).get(moduleLicenseInfo.getModuleName()) != null && moduleMultiAliasMap.get(ctx.getLocale().toString()).get(moduleLicenseInfo.getModuleName()) instanceof String) {
                licenseUsageInfo.setModuleAlias(moduleMultiAliasMap.get(ctx.getLocale().toString()).get(moduleLicenseInfo.getModuleName()));
            }
            validUsageInfo.put(moduleLicenseInfo.getModuleName(), licenseUsageInfo);
        }
        return validUsageInfo;
    }

    public static Map<String, String> getValidLicenseMapWithoutFunc(Context ctx) throws LicenseException {
        if (!validLicGroupMap.isEmpty() && !UserLicenseGroupTool.isOld(ctx, validLicGroupMapUpdateTime)) {
            return validLicGroupMap;
        }
        validLicGroupMap.clear();
        UserLicenseGroupTool.getModuleAliasMap(ctx);
        ILicenseSrvAgent licenseSrv = null;
        try {
            licenseSrv = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
        }
        catch (LicenseException e) {
            logger.error((Object)"----LicenseSrvAgentFactory create error----");
        }
        List validModuleLicenses = licenseSrv.getValidModuleLicenses();
        Set<String> osSet = UserLicenseGroupTool.getOSSet(ctx);
        UserLicenseGroupTool.getModuleAliasMap(ctx);
        for (ModuleLicenseInfo moduleLicenseInfo : validModuleLicenses) {
            String group = moduleLicenseInfo.getModuleName();
            if (osSet.contains(group.toUpperCase())) continue;
            validLicGroupMap.put(group, moduleMultiAliasMap.get(ctx.getLocale().toString()).get(group));
        }
        validLicGroupMapUpdateTime = System.currentTimeMillis();
        return validLicGroupMap;
    }

    public static Map<String, UserLicenseGroupsInfo> getUsersLicenseGroupsbyGroupNumber(Context ctx, String groupNumber) throws BOSException {
        UserLicenseGroupCollection userGroups = UserLicenseGroupFactory.getLocalInstance(ctx).getUserLicenseGroupCollection("where groupNumber = '" + groupNumber + "'");
        if (userGroups == null || userGroups.size() == 0) {
            return null;
        }
        HashMap<String, UserLicenseGroupsInfo> mpUsersLicenseGroups = new HashMap<String, UserLicenseGroupsInfo>();
        int size = userGroups.size();
        for (int i = 0; i < size; ++i) {
            String fid;
            UserLicenseGroupInfo userLicGroupInfo = userGroups.get(i);
            String string = fid = userLicGroupInfo.getId() == null ? null : userLicGroupInfo.getId().toString();
            if (fid == null) continue;
            UserLicenseGroupsInfo userLicGroups = (UserLicenseGroupsInfo)mpUsersLicenseGroups.get(userLicGroupInfo.getId().toString());
            if (userLicGroups == null) {
                userLicGroups = new UserLicenseGroupsInfo(userLicGroupInfo.getUser());
            }
            userLicGroups.addLicGroups(userLicGroupInfo);
            mpUsersLicenseGroups.put(fid, userLicGroups);
        }
        return mpUsersLicenseGroups;
    }

    public static UserLicenseGroupsInfo getUserLicenseGroups(Context ctx, String useId) throws BOSException {
        UserLicenseGroupCollection userGroups = UserLicenseGroupFactory.getLocalInstance(ctx).getUserLicenseGroupCollection("where user = '" + useId + "'");
        UserLicenseGroupsInfo userLicGroup = new UserLicenseGroupsInfo(ctx, useId);
        int size = userGroups.size();
        for (int i = 0; i < size; ++i) {
            userLicGroup.addLicGroups(userGroups.get(i));
        }
        return userLicGroup;
    }

    public static List<String> getUserGroupStr(Context ctx, String useId) throws BOSException {
        return UserLicenseGroupTool.getUserGroupStr(ctx, useId, false);
    }

    public static List<String> getUserGroupStr(Context ctx, String useId, boolean isActive) throws BOSException {
        String sql = "select FGroupNumber from T_PM_UserLicenseGroup where FuserId='" + useId + "'";
        if (isActive) {
            sql = sql + " and FIsActive = 1";
        }
        ArrayList<String> groupStr = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String group = rs.getString("FGroupNumber");
                if (group == null || group.trim().length() <= 0) continue;
                groupStr.add(group);
            }
        }
        catch (SQLException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD"));
        }
        catch (BOSException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD"));
        }
        return groupStr;
    }

    public static List<String> getRoleOwnerUsers(Context ctx, String roleId) throws BOSException {
        String sql = "select distinct FuserId from T_PM_UserRoleOrg where FroleId='" + roleId + "'";
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String userId = rs.getString("FuserId");
                if (userId == null || userId.trim().length() <= 0) continue;
                userIds.add(userId);
            }
        }
        catch (SQLException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD"));
        }
        catch (BOSException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD"));
        }
        return userIds;
    }

    @Deprecated
    public static void insUserLicGroupDiff(Context ctx, UserInfo newUserInfo, List<String> userGroupStr) throws BOSException {
        String sql = "insert into t_pm_userLicGroupDiff(FuserId,FgroupStr,Fname,Fnumber,FCell,FEMail,FForbidden,FIsDelete,FUid) values(?,?,?,?,?,?,?,?,?)";
        if (newUserInfo == null || newUserInfo.getId() == null || UserLicenseConstantHelper.IGNORE_SYNTOCLOUD_USERS.contains(newUserInfo.getId().toString())) {
            return;
        }
        String groupStr = "";
        if (userGroupStr == null) {
            userGroupStr = UserLicenseGroupTool.getUserGroupStr(ctx, newUserInfo.getId().toString(), true);
        }
        for (String str : userGroupStr) {
            if (groupStr.trim().length() <= 0) {
                groupStr = str;
                continue;
            }
            groupStr = groupStr + ";" + str;
        }
        try {
            Object[] params = new Object[]{newUserInfo.getId().toString(), groupStr, newUserInfo.getName(), newUserInfo.getNumber(), newUserInfo.getCell(), newUserInfo.getEmail(), newUserInfo.isIsForbidden(), newUserInfo.isIsDelete(), newUserInfo.getUid()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        catch (BOSException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"INSERT_FAILED"));
        }
    }

    public static String getGroupStrbySet(Set<String> groups) {
        if (groups == null) {
            return "";
        }
        String groupStr = "";
        for (String group : groups) {
            if (groupStr.trim().length() <= 0) {
                groupStr = group;
                continue;
            }
            groupStr = groupStr + ";" + group;
        }
        return groupStr;
    }

    public static String getMergeGroupName(List<String> groupName1, String groupName2) {
        String groupName = "";
        if (groupName2 == null || groupName2.trim().length() <= 0) {
            for (int i = 0; i < groupName1.size(); ++i) {
                groupName = i > 0 ? groupName + ";" + groupName1.get(i) : groupName1.get(i);
            }
            return groupName;
        }
        if (groupName1 == null || groupName1.size() == 0) {
            return groupName2;
        }
        String[] spGroup2 = groupName2.split(";");
        for (int i = 0; i < spGroup2.length; ++i) {
            if (groupName1.indexOf(spGroup2[i]) >= 0) continue;
            groupName = groupName + ";" + spGroup2[i];
        }
        return groupName;
    }

    public static String getMergeGroupName(String groupName1, String groupName2) {
        if (groupName2 == null || groupName2.trim().length() <= 0) {
            return groupName1;
        }
        if (groupName1 == null || groupName1.trim().length() == 0) {
            return groupName2;
        }
        String[] spGroup2 = groupName2.split(";");
        for (int i = 0; i < spGroup2.length; ++i) {
            if (groupName1.indexOf(spGroup2[i]) >= 0) continue;
            groupName1 = groupName1 + ";" + spGroup2[i];
        }
        return groupName1;
    }

    public static Object deepClone(Object object) throws IOException, OptionalDataException, ClassNotFoundException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream((OutputStream)bo);
        oo.writeObject(object);
        ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
        ObjectInputStream oi = new ObjectInputStream(bi);
        return oi.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateUserLicGroupDiff(Context ctx, String useId, List<String> newGroupStr) throws BOSException {
        if (newGroupStr == null || newGroupStr.size() == 0 || StringUtils.isEmpty((String)useId)) {
            return 1;
        }
        PreparedStatement pstatement = null;
        Connection conn = null;
        int num = 0;
        String groupStr = "";
        for (String str : newGroupStr) {
            groupStr = groupStr + ";" + str;
        }
        if (groupStr.startsWith(";")) {
            groupStr = groupStr.substring(1);
        }
        String sql = "update t_pm_userLicGroupDiff set FgroupStr='" + groupStr + "' where FuserId='" + useId + "'";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstatement = conn.prepareStatement(sql);
            num = pstatement.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("UserLicenseGroupTool.updateUserLicGroupDiff():executeUpdate error.sql is:" + sql));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, pstatement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(null, (Statement)pstatement, (Connection)conn);
        }
        SQLUtils.cleanup(null, (Statement)pstatement, (Connection)conn);
        return num;
    }

    public static void updateUserToNotSyn(Context ctx, List<String> lsUserId) throws BOSException {
        if (lsUserId == null || lsUserId.size() == 0) {
            return;
        }
        String sql_user = "update t_pm_user set fissyntocloud = 0 where fid = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        paramsList.clear();
        for (String fid : lsUserId) {
            Object[] params = new Object[]{fid};
            paramsList.add(params);
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql_user, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"UPDATE_USER_TABLE_FAILED"));
        }
    }

    public static void delUserLicGroupbyFids(Context ctx, List<String> fids, List<String> lsUserId) throws BOSException {
        Object[] params;
        if (fids == null || lsUserId == null) {
            return;
        }
        String sql = "delete from T_PM_UserLicenseGroup where FId=?";
        String sql_user = "update t_pm_user set fissyntocloud = 0 where fid = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String fid : fids) {
            params = new Object[]{fid};
            paramsList.add(params);
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"DELETE_FAIL"));
        }
        paramsList.clear();
        for (String fid : lsUserId) {
            params = new Object[]{fid};
            paramsList.add(params);
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql_user, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"UPDATE_USER_TABLE_FAILED"));
        }
    }

    public static void delUserLicGroup(Context ctx, String userId, List<String> addGroupStr) throws BOSException {
        if (addGroupStr == null) {
            return;
        }
        String sql = "delete from T_PM_UserLicenseGroup where FuserId=? and FGroupNumber=?";
        String sql_user = "update t_pm_user set fissyntocloud = 0 where fid = '" + userId + "'";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String groupStr : addGroupStr) {
            Object[] params = new Object[]{userId, groupStr};
            paramsList.add(params);
            DbUtil.execute((Context)ctx, (String)sql_user);
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"DELETE_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int updUserLicGroup(Context ctx, UserLicenseGroupInfoEx userLicenseGroupInfo) {
        if (ctx == null || userLicenseGroupInfo == null) {
            return 0;
        }
        PreparedStatement pstatement = null;
        Connection conn = null;
        int num = 0;
        String sql = "update T_PM_UserLicenseGroup set FSynUser='" + userLicenseGroupInfo.getSynUser().getValue() + "' where FuserId='" + userLicenseGroupInfo.getUser().getId().toString() + "' and FGroupNumber='" + userLicenseGroupInfo.getGroupNumber() + "'";
        String sql_user = "update t_pm_user set fissyntocloud = " + userLicenseGroupInfo.getSynUser().getValue() + " where fid = '" + userLicenseGroupInfo.getUser().getId().toString() + "'";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstatement = conn.prepareStatement(sql);
            num = pstatement.executeUpdate(sql);
            DbUtil.execute((Context)ctx, (String)sql_user);
        }
        catch (SQLException e) {
            logger.error((Object)("UserLicenseGroupTool.updUserLicGroup():executeUpdate error.sql is :" + sql));
            SQLUtils.cleanup(null, (Statement)pstatement, (Connection)conn);
        }
        catch (BOSException e2) {
            logger.error((Object)e2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(null, pstatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(null, (Statement)pstatement, (Connection)conn);
        }
        SQLUtils.cleanup(null, (Statement)pstatement, (Connection)conn);
        return num;
    }

    public static int updUserLicGroup(Context ctx, String userId, String groupNumber, SynStateEnum synStatu) {
        UserLicenseGroupInfoEx ulgi = new UserLicenseGroupInfoEx();
        ulgi.setUser(new UserInfo(userId));
        ulgi.setGroupNumber(groupNumber);
        ulgi.setSynUser(synStatu);
        return UserLicenseGroupTool.updUserLicGroup(ctx, ulgi);
    }

    public static void insUserLicGroup(Context ctx, List<UserLicenseGroupInfoEx> addLicenseGroupInfos) {
    }

    public static void insUserLicGroup(Context ctx, String userId, List<String> addGroupStr, int synStatu) throws BOSException {
    }

    public static Map<String, Integer> getUsersGroupNumCount(Context ctx, List<String> useIds) throws BOSException {
        if (useIds == null || useIds.size() == 0) {
            return null;
        }
        HashMap<String, Integer> mpGroupNumCount = new HashMap<String, Integer>();
        String sql = "select FGroupNumber from T_PM_UserLicenseGroup where FuserId in (" + ToolUtils.aryToStr(useIds) + ")";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String group = rs.getString("FGroupNumber");
                if (mpGroupNumCount.get(group) == null) {
                    mpGroupNumCount.put(group, 1);
                    continue;
                }
                if (group.trim() == null || group.trim().length() <= 0) continue;
                mpGroupNumCount.put(group, (Integer)mpGroupNumCount.get(group) + 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD"));
        }
        catch (BOSException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD"));
        }
        return mpGroupNumCount;
    }

    @Deprecated
    public static Map<String, String> getUserGroupDiffInfo(Context ctx, String useId) throws BOSException {
        if (StringUtils.isEmpty((String)useId)) {
            return null;
        }
        String sql = "select FuserId,Fname,Fnumber,FgroupStr,FCell,FEMail,FForbidden,FIsDelete,FUid from t_pm_userLicGroupDiff where FuserId='" + useId + "'";
        HashMap<String, String> mpUserGroupSynInfo = new HashMap<String, String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                mpUserGroupSynInfo.put("FuserId", rs.getString("FuserId"));
                mpUserGroupSynInfo.put("Fname", rs.getString("Fname"));
                mpUserGroupSynInfo.put("Fnumber", rs.getString("Fnumber"));
                mpUserGroupSynInfo.put("FgroupStr", rs.getString("FgroupStr"));
                mpUserGroupSynInfo.put("FCell", rs.getString("FCell"));
                mpUserGroupSynInfo.put("FEMail", rs.getString("FEMail"));
                mpUserGroupSynInfo.put("FForbidden", rs.getString("FForbidden"));
                mpUserGroupSynInfo.put("FIsDelete", rs.getString("FIsDelete"));
                mpUserGroupSynInfo.put("FUid", rs.getString("FUid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD"));
        }
        catch (BOSException e) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SELECT_FAILD"));
        }
        return mpUserGroupSynInfo;
    }

    public static List<UserOrgPermInfo> getPermitemsByUserViaPerm(Context ctx, String userId) throws BOSException {
        ArrayList<UserOrgPermInfo> permitems = new ArrayList<UserOrgPermInfo>();
        if (userId == null || userId.trim().length() == 0) {
            return permitems;
        }
        String sql = "select distinct fpermitemid fpermitemid,fpermtype fpermtype from t_pm_userorgperm where fowner=? ";
        Object[] params = new Object[]{userId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        UserOrgPermInfo userPermInfo = null;
        try {
            while (rowSet.next()) {
                userPermInfo = new UserOrgPermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("fpermitemid")));
                userPermInfo.setPermItem(permItemInfo);
                userPermInfo.setPermType(PermType.getEnum(rowSet.getInt("fpermtype")));
                permitems.add(userPermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return permitems;
    }

    public static List<RolePermInfo> getPermitemsByUserViaRole(Context ctx, String userId) throws BOSException {
        ArrayList<RolePermInfo> permitems = new ArrayList<RolePermInfo>();
        if (userId == null || userId.trim().length() == 0) {
            return permitems;
        }
        String sql = "select distinct rp.fpermitemid fpermitemid,rp.fpermtype fpermtype from t_pm_userroleorg uroleorg  inner join t_pm_role urole on urole.fid = uroleorg.FRoleID  inner join t_pm_roleperm rp on rp.FRoleID = urole.fid  where uroleorg.fuserid = ? ";
        Object[] params = new Object[]{userId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        RolePermInfo rolePermInfo = null;
        try {
            while (rowSet.next()) {
                rolePermInfo = new RolePermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("fpermitemid")));
                rolePermInfo.setPermItem(permItemInfo);
                rolePermInfo.setPermType(PermType.getEnum(rowSet.getInt("fpermtype")));
                permitems.add(rolePermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return permitems;
    }

    public static List<RolePermInfo> getPermitemsByUserWithoutRole(Context ctx, String roleId, String userId) throws BOSException {
        ArrayList<RolePermInfo> permitems = new ArrayList<RolePermInfo>();
        if (userId == null || userId.trim().length() == 0) {
            return permitems;
        }
        String sql = "SELECT fid, 10                                                        FROM T_PM_PermItem permitem                                            where permitem.FISLEAF = 1                                                and exists                                                            (SELECT 1                                                                        FROM " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " pp          where pp.FPERMITEMID = permitem.fid)                              and (exists                                                                  (SELECT 1                                                                  from t_pm_userorgperm UserOrgPerm                                      where UserOrgPerm.FOWNER =  ?                                             AND UserOrgPerm.FPermType = 10                                          and UserOrgPerm.FPERMITEMID = permitem.fid) or exists               (SELECT 1                                                                  FROM t_pm_role urole                                                   inner join t_pm_roleperm RolePerm                                          on urole.FID = RolePerm.FRoleID                                      where RolePerm.FPERMITEMID = permitem.fid                                 and RolePerm.FPermType = 10                                             and urole.fid <> ?                                                      and exists (select 1                                                           from T_PM_UserRoleOrg USERROLEORG                                      where USERROLEORG.FUSERID =  ?                                            and USERROLEORG.FROLEID = urole.FID)))                                                                                      union                                                                   SELECT fid, 20                                                            FROM T_PM_PermItem permitem                                            where permitem.FISLEAF = 1                                                and exists                                                            (SELECT 1                                                                        FROM " + UserLicenseGroupTool.getPermUIGroupTableName(ctx) + " pp          where pp.FPERMITEMID = permitem.fid)                              and (exists                                                                  (SELECT 1                                                                  from t_pm_userorgperm UserOrgPerm                                      where UserOrgPerm.FOWNER =  ?                                             AND UserOrgPerm.FPermType = 20                                          and UserOrgPerm.FPERMITEMID = permitem.fid) or exists               (SELECT 1                                                                  FROM t_pm_role urole                                                   inner join t_pm_roleperm RolePerm                                          on urole.FID = RolePerm.FRoleID                                      where RolePerm.FPERMITEMID = permitem.fid                                 and RolePerm.FPermType = 20                                             and urole.fid <> ?                                                      and exists (select 1                                                           from T_PM_UserRoleOrg USERROLEORG                                      where USERROLEORG.FUSERID =  ?                                            and USERROLEORG.FROLEID = urole.FID)))              ";
        Object[] params = new Object[]{userId, roleId, userId, userId, roleId, userId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        RolePermInfo rolePermInfo = null;
        try {
            while (rowSet.next()) {
                rolePermInfo = new RolePermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString(1)));
                rolePermInfo.setPermItem(permItemInfo);
                rolePermInfo.setPermType(PermType.getEnum(rowSet.getInt(2)));
                permitems.add(rolePermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return permitems;
    }

    public static List<String> getPermitemsGroupStr(Context ctx, List<String> permitemIds) throws BOSException {
        long start = System.currentTimeMillis();
        ArrayList<String> groupStr = new ArrayList<String>();
        if (permitemIds == null || permitemIds.size() == 0) {
            return groupStr;
        }
        UserLicenseGroupTool.getPermGroupMap(ctx);
        try {
            UserLicenseGroupTool.getValidLicenseMapWithoutFunc(ctx);
        }
        catch (LicenseException e) {
            logger.error((Object)"UserLicenseGroupTool.getPermitemsGroupStr.getValidLicenseMapWithoutFunc exception:", (Throwable)e);
        }
        for (int i = 0; i < permitemIds.size(); ++i) {
            String group = permGroupMap.get(permitemIds.get(i));
            if (!validLicGroupMap.containsKey(group) || group == null || groupStr.contains(group)) continue;
            groupStr.add(permGroupMap.get(permitemIds.get(i)));
        }
        return groupStr;
    }

    public static RolePermCollection getRolePerms(Context ctx, String roleId) throws BOSException, EASBizException {
        assert (roleId != null);
        RolePermCollection rps = new RolePermCollection();
        String sql = "SELECT FPermItemID, FPermType FROM T_PM_RolePerm WHERE FRoleID = ? ";
        Object[] params = new Object[]{roleId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        RolePermInfo rolePermInfo = null;
        try {
            while (rowSet.next()) {
                rolePermInfo = new RolePermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                rolePermInfo.setPermItem(permItemInfo);
                rolePermInfo.setPermType(PermType.getEnum(rowSet.getInt("FPermType")));
                rps.add(rolePermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new RolePermException(RolePermException.GET_ROLEPERM_FAIL, e);
        }
        return rps;
    }

    public static List<String> convertLsNumberName2LsNumber(List<String> lsNumberName) {
        ArrayList<String> lsNumber = new ArrayList<String>();
        if (lsNumberName == null) {
            return lsNumber;
        }
        for (String strNumberName : lsNumberName) {
            String[] sa = strNumberName.split(";");
            lsNumber.add(sa[0]);
        }
        return lsNumber;
    }

    public static int updateUserLicGroupDiff(Context ctx, UserInfo newUserInfo) throws BOSException {
        String sql;
        int num = 0;
        if (newUserInfo == null) {
            return num;
        }
        String uuid = newUserInfo.getUid();
        if (uuid == null) {
            sql = "update t_pm_userLicGroupDiff set Fname='" + newUserInfo.getName() + "',Fnumber='" + newUserInfo.getNumber() + "',FCell='" + newUserInfo.getCell() + "',FEMail='" + newUserInfo.getEmail() + "',FForbidden=" + (newUserInfo.isIsForbidden() ? 1 : 0) + ",FIsDelete=" + (newUserInfo.isIsDelete() ? 1 : 0) + " where FuserId='" + newUserInfo.getId() + "'";
        } else {
            Pattern p = Pattern.compile("^[0-9]\\d*$");
            Matcher m = p.matcher(uuid);
            sql = "update t_pm_userLicGroupDiff set Fname='" + newUserInfo.getName() + "',Fnumber='" + newUserInfo.getNumber() + "',FCell='" + newUserInfo.getCell() + "',FEMail='" + newUserInfo.getEmail() + "',FForbidden=" + (newUserInfo.isIsForbidden() ? 1 : 0) + ",FIsDelete=" + (newUserInfo.isIsDelete() ? 1 : 0) + ",FUid='" + (m.matches() ? uuid : "0") + "' where FuserId='" + newUserInfo.getId() + "'";
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            num = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("UserLicenseGroupTool.updateUserLicGroupDiff():executeUpdate error2.sql:" + sql));
                logger.error((Object)e);
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"UPDATE_FAILED"));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        return num;
    }

    public static boolean isChangeKeyInfoIgnoreCloudCommunicationStategy(UserInfo newUserInfo, UserInfo oldUserInfo) {
        if (newUserInfo == null || oldUserInfo == null) {
            return false;
        }
        if (newUserInfo.isIsForbidden() && !oldUserInfo.isIsForbidden()) {
            return true;
        }
        if (!newUserInfo.isIsForbidden() && oldUserInfo.isIsForbidden()) {
            return true;
        }
        if (newUserInfo.isIsDelete() && !oldUserInfo.isIsDelete()) {
            return true;
        }
        if (!newUserInfo.isIsDelete() && oldUserInfo.isIsDelete()) {
            return true;
        }
        if (!UserLicenseGroupTool.compareTwoStringIgnoreCase(newUserInfo.getNumber(), oldUserInfo.getNumber())) {
            return true;
        }
        if (!UserLicenseGroupTool.compareTwoStringIgnoreCase(newUserInfo.getName(), oldUserInfo.getName())) {
            return true;
        }
        if (!UserLicenseGroupTool.compareTwoStringIgnoreCase(newUserInfo.getCell(), oldUserInfo.getCell())) {
            return true;
        }
        return !UserLicenseGroupTool.compareTwoStringIgnoreCase(newUserInfo.getEmail(), oldUserInfo.getEmail());
    }

    public static boolean isChangeKeyInfo(UserInfo newUserInfo, UserInfo oldUserInfo) {
        if (newUserInfo == null || oldUserInfo == null) {
            return false;
        }
        if (newUserInfo.isIsForbidden() && !oldUserInfo.isIsForbidden()) {
            return true;
        }
        if (!newUserInfo.isIsForbidden() && oldUserInfo.isIsForbidden()) {
            return true;
        }
        if (newUserInfo.isIsDelete() && !oldUserInfo.isIsDelete()) {
            return true;
        }
        if (!newUserInfo.isIsDelete() && oldUserInfo.isIsDelete()) {
            return true;
        }
        if (!UserLicenseGroupTool.compareTwoStringIgnoreCase(newUserInfo.getNumber(), oldUserInfo.getNumber())) {
            return true;
        }
        return !UserLicenseGroupTool.compareTwoStringIgnoreCase(newUserInfo.getName(), oldUserInfo.getName());
    }

    private static boolean compareTwoStringIgnoreCase(String stringOne, String stringTwo) {
        if (stringOne == null) {
            stringOne = "";
        }
        if (stringTwo == null) {
            stringTwo = "";
        }
        return stringOne.toLowerCase().equalsIgnoreCase(stringTwo.toLowerCase());
    }

    public static CloudUserInfo castRegistUser2CloudUser(CloudRegistUserInfo crui) {
        if (crui == null) {
            return null;
        }
        CloudUserInfo cloudUserInfo = new CloudUserInfo();
        cloudUserInfo.setName(crui.getCloudName());
        cloudUserInfo.setErp_account(crui.getErpNumber());
        cloudUserInfo.setPhone(crui.getPhone());
        cloudUserInfo.setProd_group(UserLicenseGroupTool.getGroupStrbySet(crui.getGroup()));
        cloudUserInfo.setStatus(1);
        cloudUserInfo.setIs_delete(0);
        String fuid = crui.getCloudUuId();
        if (fuid != null && fuid.trim().length() > 0) {
            try {
                cloudUserInfo.setUid(Integer.parseInt(fuid));
            }
            catch (NumberFormatException e) {
                cloudUserInfo.setUid(0);
            }
        }
        return cloudUserInfo;
    }

    public static List getGroupUsers(Context ctx, String groupNumber) throws BOSException {
        if (StringUtils.isEmpty((String)groupNumber)) {
            return null;
        }
        ArrayList<String> userList = new ArrayList<String>();
        String sql = "Select FUserId from T_PM_UserLicenseGroup where FGroupNumber = '" + groupNumber + "'";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                userList.add(rs.getString("FUserId"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u67e5\u8be2\u5931\u8d25" + (Object)((Object)e)));
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"INSERT_FAILED"));
        }
        catch (SQLException e) {
            logger.error((Object)("\u67e5\u8be2\u5931\u8d25" + e));
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"INSERT_FAILED"));
        }
        return userList;
    }

    public static UserLicenseGroupsInfo getUserLicenseGroups(Context ctx, UserInfo user) {
        if (user == null) {
            return null;
        }
        UserLicenseGroupCollection userGroups = null;
        try {
            userGroups = UserLicenseGroupFactory.getLocalInstance(ctx).getUserLicenseGroupCollection("where user = '" + user.getId().toString() + "'");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        UserLicenseGroupsInfo userLicGroup = new UserLicenseGroupsInfo(user);
        if (userGroups == null) {
            return userLicGroup;
        }
        int size = userGroups.size();
        for (int i = 0; i < size; ++i) {
            userLicGroup.addLicGroups(userGroups.get(i));
        }
        return userLicGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, String> getPermGroupMap(Context ctx) {
        String sql = "";
        EASCloudEnum easCloudEnum = UserLicenseGroupTool.getEASCloudEnum(ctx);
        permGroupMap = permLicGroupMap.get(easCloudEnum.toString());
        sql = "select fpermitemid,fgroupnumber from " + UserLicenseGroupTool.getPermUIGroupTableName(ctx);
        if (permGroupMap != null && !permGroupMap.isEmpty()) {
            return permGroupMap;
        }
        if (permGroupMap == null) {
            permGroupMap = new HashMap<String, String>();
        }
        Connection conn = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stat = conn.prepareStatement(sql);
            rs = stat.executeQuery();
            while (rs.next()) {
                if (rs.getString("fgroupnumber") == null) continue;
                permGroupMap.put(rs.getString("fpermitemid"), rs.getString("fgroupnumber"));
            }
            permLicGroupMap.put(easCloudEnum.toString(), permGroupMap);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>initPermGroupMap error", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stat, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        return permGroupMap;
    }

    public static synchronized Map<String, String> getModuleAliasMap(Context ctx) {
        if (moduleMultiAliasMap.get(ctx.getLocale().toString()) != null && !moduleMultiAliasMap.get(ctx.getLocale().toString()).isEmpty()) {
            return moduleMultiAliasMap.get(ctx.getLocale().toString());
        }
        try {
            moduleMultiAliasMap.put(ctx.getLocale().toString(), new HashMap());
            LicenseResourceHelper.initModuleAliasMap(ctx, moduleMultiAliasMap.get(ctx.getLocale().toString()));
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        return moduleMultiAliasMap.get(ctx.getLocale().toString());
    }

    public static EASCloudEnum getEASCloudEnum(Context ctx) {
        EASCloudEnum easCloudEnum = null;
        try {
            easCloudEnum = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getRemoteEASCloudVersion();
        }
        catch (LicenseException e) {
            logger.error((Object)"com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool.getEASCloudEnum", (Throwable)e);
        }
        if (easCloudEnum == null) {
            easCloudEnum = EASCloudEnum.CLOUD_PRIVATE;
        }
        return easCloudEnum;
    }

    public static synchronized boolean reLoadPermGroupMap(Context ctx) {
        EASCloudEnum easCloudEnum = UserLicenseGroupTool.getEASCloudEnum(ctx);
        switch (easCloudEnum) {
            case CLOUD_PRIVATE: {
                if (permLicGroupMap.get(EASCloudEnum.CLOUD_PRIVATE.toString()) == null) break;
                permLicGroupMap.get(EASCloudEnum.CLOUD_PRIVATE.toString()).clear();
                break;
            }
            case CLOUD_PUBLIC: {
                if (permLicGroupMap.get(EASCloudEnum.CLOUD_PUBLIC.toString()) == null) break;
                permLicGroupMap.get(EASCloudEnum.CLOUD_PUBLIC.toString()).clear();
                break;
            }
            case CLOUD_PUBLIC_SIMPLE: {
                if (permLicGroupMap.get(EASCloudEnum.CLOUD_PUBLIC_SIMPLE.toString()) == null) break;
                permLicGroupMap.get(EASCloudEnum.CLOUD_PUBLIC_SIMPLE.toString()).clear();
                break;
            }
            case CLOUD_HYBRID: {
                if (permLicGroupMap.get(EASCloudEnum.CLOUD_HYBRID.toString()) == null) break;
                permLicGroupMap.get(EASCloudEnum.CLOUD_HYBRID.toString()).clear();
                break;
            }
            case CLOUD_HYBRID_SIMPLE: {
                if (permLicGroupMap.get(EASCloudEnum.CLOUD_HYBRID_SIMPLE.toString()) == null) break;
                permLicGroupMap.get(EASCloudEnum.CLOUD_HYBRID_SIMPLE.toString()).clear();
                break;
            }
            default: {
                if (permLicGroupMap.get(EASCloudEnum.CLOUD_PUBLIC.toString()) == null) break;
                permLicGroupMap.get(EASCloudEnum.CLOUD_PUBLIC.toString()).clear();
            }
        }
        UserLicenseGroupTool.getPermGroupMap(ctx);
        return true;
    }

    public static Set<String> getOSSet(Context ctx) throws LicenseException {
        ILicenseSrvAgent iLicenseSrvAgent = null;
        iLicenseSrvAgent = ctx == null ? LicenseSrvAgentFactory.getRemoteInstance() : LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
        return iLicenseSrvAgent.getAllFunctionSubSystem();
    }

    public static String getPermUIGroupTableName(Context ctx) {
        if (ctx == null && (ctx = ContextUtils.getContextFromSessionNoException()) == null) {
            ctx = new Context();
        }
        EASCloudEnum easCloudEnum = UserLicenseGroupTool.getEASCloudEnum(ctx);
        switch (easCloudEnum) {
            case CLOUD_PRIVATE: {
                return "t_pm_permuigroupMIX";
            }
            case CLOUD_PUBLIC: {
                return "t_pm_permuigroup";
            }
            case CLOUD_PUBLIC_SIMPLE: {
                return "t_pm_permuigroupsimple";
            }
            case CLOUD_HYBRID: {
                return "t_pm_permuigroupMIXX";
            }
            case CLOUD_HYBRID_SIMPLE: {
                return "t_pm_permuigroupMIXXSimple";
            }
        }
        return "t_pm_permuigroup";
    }

    public static boolean isOld(Context ctx, long time) throws LicenseException {
        boolean isOld = true;
        try {
            isOld = LicenseUseSrvFactory.getLocalInstance(ctx).isBeforeLicenseUpdate(ctx, time);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new LicenseException((Throwable)e);
        }
        return isOld;
    }
}

