/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.interior.IUserLog;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupLogRegistryManager;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupLogInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserLog
implements IUserLog {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.interior.UserLog");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static UserLog instance;

    private UserLog() {
    }

    @Override
    public void addUser(Context ctx, UserInfo userInfo) {
        if (userInfo == null || userInfo.getId() == null) {
            return;
        }
        String userId = userInfo.getId().toString();
        String changeContent1 = EASResource.getString((String)RESOURCE, (String)"addUser", (Locale)new Locale("l1")) + "\"" + userInfo.getNumber() + "\"";
        String changeContent2 = EASResource.getString((String)RESOURCE, (String)"addUser", (Locale)new Locale("l2")) + "\"" + userInfo.getNumber() + "\"";
        String changeContent3 = EASResource.getString((String)RESOURCE, (String)"addUser", (Locale)new Locale("l3")) + "\"" + userInfo.getNumber() + "\"";
        this.writeLog(ctx, userId, changeContent1, changeContent2, changeContent3);
    }

    public void callBackUser(Context ctx, UserInfo userInfo) {
        if (userInfo == null || userInfo.getId() == null) {
            return;
        }
        String userId = userInfo.getId().toString();
        String changeContent1 = EASResource.getString((String)RESOURCE, (String)"getUser", (Locale)new Locale("l1")) + "\"" + userInfo.getNumber() + "\"";
        String changeContent2 = EASResource.getString((String)RESOURCE, (String)"getUser", (Locale)new Locale("l2")) + "\"" + userInfo.getNumber() + "\"";
        String changeContent3 = EASResource.getString((String)RESOURCE, (String)"getUser", (Locale)new Locale("l3")) + "\"" + userInfo.getNumber() + "\"";
        this.writeLog(ctx, userId, changeContent1, changeContent2, changeContent3);
    }

    @Override
    public void deleteUser(Context ctx, UserInfo userInfo) {
        if (userInfo == null || userInfo.getId() == null) {
            return;
        }
        String userId = userInfo.getId().toString();
        String changeContent1 = EASResource.getString((String)RESOURCE, (String)"deleteUser", (Locale)new Locale("l1")) + "\"" + userInfo.getNumber() + "\"";
        String changeContent2 = EASResource.getString((String)RESOURCE, (String)"deleteUser", (Locale)new Locale("l2")) + "\"" + userInfo.getNumber() + "\"";
        String changeContent3 = EASResource.getString((String)RESOURCE, (String)"deleteUser", (Locale)new Locale("l3")) + "\"" + userInfo.getNumber() + "\"";
        this.writeLog(ctx, userId, changeContent1, changeContent2, changeContent3);
    }

    @Override
    public void deleteUsers(Context ctx, List<String> usersId) {
        UserInfo userInfo = null;
        Map<String, UserInfo> mpUser = this.getUserMapByFids(ctx, usersId);
        for (String userId : usersId) {
            userInfo = mpUser.get(userId);
            this.deleteUser(ctx, userInfo);
        }
    }

    public void forbidUser(Context ctx, UserInfo userInfo) {
        String changeContent3;
        String changeContent2;
        String changeContent1;
        if (userInfo == null || userInfo.getId() == null) {
            return;
        }
        String userId = userInfo.getId().toString();
        if (userInfo.isIsForbidden()) {
            changeContent1 = EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l1")) + "\"" + userInfo.getNumber() + "\"";
            changeContent2 = EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l2")) + "\"" + userInfo.getNumber() + "\"";
            changeContent3 = EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l3")) + "\"" + userInfo.getNumber() + "\"";
        } else {
            changeContent1 = EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l1")) + "\"" + userInfo.getNumber() + "\"";
            changeContent2 = EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l2")) + "\"" + userInfo.getNumber() + "\"";
            changeContent3 = EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l3")) + "\"" + userInfo.getNumber() + "\"";
        }
        this.writeLog(ctx, userId, changeContent1, changeContent2, changeContent3);
    }

    public void activeGroupFailByOpt(Context ctx, UserInfo userInfo, String group, String opt) {
        if (userInfo == null || userInfo.getId() == null) {
            return;
        }
        String userId = userInfo.getId().toString();
        String changeContent1 = EASResource.getString((String)RESOURCE, (String)"OCCU_GROUP", (Locale)new Locale("l1")) + group + EASResource.getString((String)RESOURCE, (String)"FAILED_REASON_GROUP_NOT_ENOUGH", (Locale)new Locale("l1")) + opt + "\uff09";
        String changeContent2 = EASResource.getString((String)RESOURCE, (String)"OCCU_GROUP", (Locale)new Locale("l2")) + group + EASResource.getString((String)RESOURCE, (String)"FAILED_REASON_GROUP_NOT_ENOUGH", (Locale)new Locale("l2")) + opt + "\uff09";
        String changeContent3 = EASResource.getString((String)RESOURCE, (String)"OCCU_GROUP", (Locale)new Locale("l3")) + group + EASResource.getString((String)RESOURCE, (String)"FAILED_REASON_GROUP_NOT_ENOUGH", (Locale)new Locale("l3")) + opt + "\uff09";
        this.writeLog(ctx, userId, changeContent1, changeContent2, changeContent3);
    }

    Map<String, UserInfo> getUserMapByFids(Context ctx, List<String> usersId) {
        HashMap<String, UserInfo> mpUser = new HashMap<String, UserInfo>();
        String userSql = "select fid,fnumber,fname_l2,fisdelete,fislocked,FForbidden,FCell,FEMail from t_pm_user  where fid in (" + ToolUtils.aryToStr(usersId) + ")";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)userSql);
            while (rs.next()) {
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)rs.getString("fid")));
                user.setNumber(rs.getString("fnumber"));
                user.setName(rs.getString("fname_l2"), Locale.CHINA);
                user.setIsDelete(rs.getInt("fisdelete") != 0);
                user.setIsLocked(rs.getInt("fislocked") != 0);
                user.setIsForbidden(rs.getInt("fforbidden") != 0);
                user.setCell(rs.getString("FCell"));
                user.setEmail(rs.getString("FEmail"));
                mpUser.put(user.getId().toString(), user);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"LicenseUseManager.getUserMapByFids error1. ");
        }
        catch (BOSException e) {
            logger.error((Object)"LicenseUseManager.getUserMapByFids error2. ");
        }
        return mpUser;
    }

    public void forbidUsers(Context ctx, List<String> usersId) {
        UserInfo userInfo = null;
        Map<String, UserInfo> mpUser = this.getUserMapByFids(ctx, usersId);
        for (String userId : usersId) {
            userInfo = mpUser.get(userId);
            this.forbidUser(ctx, userInfo);
        }
    }

    @Override
    public void changeUsersLicenseGroup(Context ctx, List<String> usersId) {
    }

    @Override
    public void changeUserLicenseGroup(Context ctx, String usersId) {
    }

    public void changeUserLicenseGroup(Context ctx, String userId, String newGroupStr, String oldGroupStr) {
        int i;
        String[] newGroup = newGroupStr.split(";");
        String[] oldGroup = oldGroupStr.split(";");
        ArrayList<String> addGroupStr = new ArrayList<String>();
        ArrayList<String> delGroupStr = new ArrayList<String>();
        for (i = 0; i < newGroup.length; ++i) {
            if (oldGroupStr.contains(newGroup[i])) continue;
            addGroupStr.add(newGroup[i]);
        }
        for (i = 0; i < oldGroup.length; ++i) {
            if (newGroupStr.contains(oldGroup[i])) continue;
            delGroupStr.add(oldGroup[i]);
        }
        this.addUserLicenseGroup(ctx, userId, addGroupStr);
        this.delUserLicenseGroup(ctx, userId, delGroupStr);
    }

    public void addUserLicenseGroup(Context ctx, String userId, List<String> addGroupStr) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer changeContent_l1 = new StringBuffer();
        StringBuffer changeContent_l2 = new StringBuffer();
        StringBuffer changeContent_l3 = new StringBuffer();
        for (String addGroup : addGroupStr) {
            changeContent_l1.append(EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l1")) + "\"").append(addGroup).append("\"").append(lineSep);
            changeContent_l2.append(EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l2")) + "\"").append(addGroup).append("\"").append(lineSep);
            changeContent_l3.append(EASResource.getString((String)RESOURCE, (String)"addGroup", (Locale)new Locale("l3")) + "\"").append(addGroup).append("\"").append(lineSep);
        }
        this.writeLog(ctx, userId, changeContent_l1.toString(), changeContent_l2.toString(), changeContent_l3.toString());
    }

    public void delUserLicenseGroup(Context ctx, String userId, List<String> delGroupStr) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer changeContent_l1 = new StringBuffer();
        StringBuffer changeContent_l2 = new StringBuffer();
        StringBuffer changeContent_l3 = new StringBuffer();
        for (String delGroup : delGroupStr) {
            changeContent_l1.append(EASResource.getString((String)RESOURCE, (String)"removeGroup", (Locale)new Locale("l1")) + "\"").append(delGroup).append("\"").append(lineSep);
            changeContent_l2.append(EASResource.getString((String)RESOURCE, (String)"removeGroup", (Locale)new Locale("l2")) + "\"").append(delGroup).append("\"").append(lineSep);
            changeContent_l3.append(EASResource.getString((String)RESOURCE, (String)"removeGroup", (Locale)new Locale("l3")) + "\"").append(delGroup).append("\"").append(lineSep);
        }
        this.writeLog(ctx, userId, changeContent_l1.toString(), changeContent_l2.toString(), changeContent_l3.toString());
    }

    @Override
    public void changeUser(Context ctx, UserInfo newUserInfo, UserInfo oldUserInfo) {
        if (newUserInfo == null || newUserInfo.getId() == null) {
            return;
        }
        String userId = newUserInfo.getId().toString();
        String[] changeContent = this.getChangeContent(newUserInfo, oldUserInfo);
        this.writeLog(ctx, userId, changeContent[0], changeContent[1], changeContent[2]);
    }

    private String[] getChangeContent(UserInfo newUserInfo, UserInfo oldUserInfo) {
        StringBuffer sb_l1 = new StringBuffer();
        StringBuffer sb_l2 = new StringBuffer();
        StringBuffer sb_l3 = new StringBuffer();
        String[] sbs = new String[3];
        String lineSep = System.getProperty("line.separator");
        if (newUserInfo.isIsForbidden() && !oldUserInfo.isIsForbidden()) {
            sb_l1.append(EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l1")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l1.append(lineSep);
            sb_l2.append(EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l2")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l2.append(lineSep);
            sb_l3.append(EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l3")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l3.append(lineSep);
        } else if (!newUserInfo.isIsForbidden() && oldUserInfo.isIsForbidden()) {
            sb_l1.append(EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l1")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l1.append(lineSep);
            sb_l2.append(EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l2")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l2.append(lineSep);
            sb_l3.append(EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l3")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l3.append(lineSep);
        } else if (newUserInfo.isIsDelete() && !oldUserInfo.isIsDelete()) {
            sb_l1.append(EASResource.getString((String)RESOURCE, (String)"deleteUser", (Locale)new Locale("l1")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l1.append(lineSep);
            sb_l2.append(EASResource.getString((String)RESOURCE, (String)"deleteUser", (Locale)new Locale("l2")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l2.append(lineSep);
            sb_l3.append(EASResource.getString((String)RESOURCE, (String)"deleteUser", (Locale)new Locale("l3")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l3.append(lineSep);
        } else if (!newUserInfo.isIsDelete() && oldUserInfo.isIsDelete()) {
            sb_l1.append(EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l1")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l1.append(lineSep);
            sb_l2.append(EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l2")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l2.append(lineSep);
            sb_l3.append(EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l3")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l3.append(lineSep);
        }
        if (!newUserInfo.getNumber().equalsIgnoreCase(oldUserInfo.getNumber())) {
            sb_l1.append(EASResource.getString((String)RESOURCE, (String)"chUserAccount", (Locale)new Locale("l1")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l1.append(lineSep);
            sb_l2.append(EASResource.getString((String)RESOURCE, (String)"chUserAccount", (Locale)new Locale("l2")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l2.append(lineSep);
            sb_l3.append(EASResource.getString((String)RESOURCE, (String)"chUserAccount", (Locale)new Locale("l3")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l3.append(lineSep);
        }
        if (newUserInfo.getName() != null && !newUserInfo.getName().equalsIgnoreCase(oldUserInfo.getName())) {
            sb_l1.append(EASResource.getString((String)RESOURCE, (String)"chUserName", (Locale)new Locale("l1")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l1.append(lineSep);
            sb_l2.append(EASResource.getString((String)RESOURCE, (String)"chUserName", (Locale)new Locale("l2")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l2.append(lineSep);
            sb_l3.append(EASResource.getString((String)RESOURCE, (String)"chUserName", (Locale)new Locale("l3")) + "\"").append(newUserInfo.getNumber()).append("\"");
            sb_l3.append(lineSep);
        }
        if (!(newUserInfo.getCell() == null || newUserInfo.getCell().equalsIgnoreCase(oldUserInfo.getCell()) || oldUserInfo.getCell() == null && "".equals(newUserInfo.getCell()))) {
            sb_l1.append(EASResource.getString((String)RESOURCE, (String)"chUserCell", (Locale)new Locale("l1")) + "\"").append(newUserInfo.getCell()).append("\"");
            sb_l1.append(lineSep);
            sb_l2.append(EASResource.getString((String)RESOURCE, (String)"chUserCell", (Locale)new Locale("l2")) + "\"").append(newUserInfo.getCell()).append("\"");
            sb_l2.append(lineSep);
            sb_l3.append(EASResource.getString((String)RESOURCE, (String)"chUserCell", (Locale)new Locale("l3")) + "\"").append(newUserInfo.getCell()).append("\"");
            sb_l3.append(lineSep);
        }
        if (!(newUserInfo.getEmail() == null || newUserInfo.getEmail().equalsIgnoreCase(oldUserInfo.getEmail()) || oldUserInfo.getEmail() == null && "".equals(newUserInfo.getEmail()))) {
            sb_l1.append(EASResource.getString((String)RESOURCE, (String)"chUserEmail", (Locale)new Locale("l1")) + "\"").append(newUserInfo.getEmail()).append("\"");
            sb_l1.append(lineSep);
            sb_l2.append(EASResource.getString((String)RESOURCE, (String)"chUserEmail", (Locale)new Locale("l2")) + "\"").append(newUserInfo.getEmail()).append("\"");
            sb_l2.append(lineSep);
            sb_l3.append(EASResource.getString((String)RESOURCE, (String)"chUserEmail", (Locale)new Locale("l3")) + "\"").append(newUserInfo.getEmail()).append("\"");
            sb_l3.append(lineSep);
        }
        sbs[0] = sb_l1.toString();
        sbs[1] = sb_l2.toString();
        sbs[2] = sb_l3.toString();
        return sbs;
    }

    @Override
    public void writeLog(Context ctx, List<String> usersId, int type) {
        Timestamp changetime = this.getTime();
        String changeUserId = ctx.getCaller().toString();
        String content_l1 = null;
        String content_l2 = null;
        String content_l3 = null;
        switch (type) {
            case 0: {
                content_l1 = EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l1"));
                content_l2 = EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l2"));
                content_l3 = EASResource.getString((String)RESOURCE, (String)"forbidenUser", (Locale)new Locale("l3"));
                break;
            }
            case 1: {
                content_l1 = EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l1"));
                content_l2 = EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l2"));
                content_l3 = EASResource.getString((String)RESOURCE, (String)"startUser", (Locale)new Locale("l3"));
                break;
            }
            case 2: {
                content_l1 = EASResource.getString((String)RESOURCE, (String)"lockUser", (Locale)new Locale("l1"));
                content_l2 = EASResource.getString((String)RESOURCE, (String)"lockUser", (Locale)new Locale("l2"));
                content_l3 = EASResource.getString((String)RESOURCE, (String)"lockUser", (Locale)new Locale("l3"));
                break;
            }
            case 3: {
                content_l1 = EASResource.getString((String)RESOURCE, (String)"unlockUser", (Locale)new Locale("l1"));
                content_l2 = EASResource.getString((String)RESOURCE, (String)"unlockUser", (Locale)new Locale("l2"));
                content_l3 = EASResource.getString((String)RESOURCE, (String)"unlockUser", (Locale)new Locale("l3"));
                break;
            }
        }
        this.writeLog(ctx, usersId, changeUserId, changetime, content_l1, content_l2, content_l3);
    }

    private void writeLog(Context ctx, List<String> usersId, String changeuserId, Timestamp changetime, String content1, String content2, String content3) {
        for (String userId : usersId) {
            this.writeLog(ctx, userId, changeuserId, changetime, content1, content2, content3);
        }
    }

    public void writeLog(Context ctx, String userId, String content_l1, String content_l2, String content_l3) {
        Timestamp createtime = this.getTime();
        String changeUserId = ctx.getCaller().toString();
        this.writeLog(ctx, userId, changeUserId, createtime, content_l1, content_l2, content_l3);
    }

    public void writeLog(Context ctx, UserLicenseGroupLogInfo logInfo) {
        UserLicenseGroupLogRegistryManager.getInstance().addUserLicenseGroupLog(logInfo);
    }

    private void writeLog(Context ctx, String userId, String changeuserId, Timestamp changetime, String content_l1, String content_l2, String content_l3) {
        UserLicenseGroupLogInfo logInfo = new UserLicenseGroupLogInfo();
        logInfo.setCtx(ctx);
        logInfo.setFUserId(userId);
        logInfo.setFChangeUserId(changeuserId);
        logInfo.setFChangeDate(changetime);
        logInfo.setFContent_l2(content_l2);
        logInfo.setFContent_l1(content_l1);
        logInfo.setFContent_l3(content_l3);
        UserLicenseGroupLogRegistryManager.getInstance().addUserLicenseGroupLog(logInfo);
    }

    public static UserLog getInstance() {
        if (instance == null) {
            instance = new UserLog();
        }
        return instance;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    public void activeLicenseGroup(Context ctx, String userId, String groupStr, int active) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer changeContent_l1 = new StringBuffer();
        StringBuffer changeContent_l2 = new StringBuffer();
        StringBuffer changeContent_l3 = new StringBuffer();
        switch (active) {
            case 1: {
                changeContent_l1.append(EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l1")) + "\"").append(groupStr).append("\"").append(lineSep);
                changeContent_l2.append(EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l2")) + "\"").append(groupStr).append("\"").append(lineSep);
                changeContent_l3.append(EASResource.getString((String)RESOURCE, (String)"activeGroup", (Locale)new Locale("l3")) + "\"").append(groupStr).append("\"").append(lineSep);
                break;
            }
            case 0: {
                changeContent_l1.append(EASResource.getString((String)RESOURCE, (String)"cancelGroup", (Locale)new Locale("l1")) + "\"").append(groupStr).append("\"").append(lineSep);
                changeContent_l2.append(EASResource.getString((String)RESOURCE, (String)"cancelGroup", (Locale)new Locale("l2")) + "\"").append(groupStr).append("\"").append(lineSep);
                changeContent_l3.append(EASResource.getString((String)RESOURCE, (String)"cancelGroup", (Locale)new Locale("l3")) + "\"").append(groupStr).append("\"").append(lineSep);
            }
        }
        this.writeLog(ctx, userId, changeContent_l1.toString(), changeContent_l2.toString(), String.valueOf(changeContent_l3));
    }
}

