/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior.permgroup;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.util.cloud.UserPermGroupsUtil;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractUserPermChangeListener {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.interior.AbstractUserPermChangeListener");
    protected Context ctx = null;
    protected String changeOpt = "";
    protected boolean isDeal = true;
    Map<String, String> validGroups = new HashMap<String, String>();
    protected List<String> userIds = null;
    protected Map<String, Set<String>> beforeUserGroups = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> afterUserGroups = new HashMap<String, Set<String>>();

    public AbstractUserPermChangeListener(Context ctx, List<String> userIds, String changeOpt) {
        this.ctx = ctx;
        this.changeOpt = changeOpt;
        this.userIds = userIds;
    }

    public AbstractUserPermChangeListener(Context ctx, String userId, String changeOpt) {
        this.ctx = ctx;
        this.changeOpt = changeOpt;
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(userId);
        this.userIds = userIds;
    }

    public void before() throws BOSException {
        if (!GroupLicenseUseInfoUtil.isRegister(this.ctx)) {
            this.isDeal = false;
        }
        try {
            this.validGroups = UserLicenseGroupTool.getValidLicenseMapWithoutFunc(this.ctx);
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        this.beforeUserGroups = UserPermGroupsUtil.batchGatherCurUserPermGroupsValid(this.ctx, this.userIds);
    }

    public void after() throws BOSException, EASBizException {
        if (!this.isDeal) {
            return;
        }
        this.afterUserGroups = UserPermGroupsUtil.batchGatherCurUserPermGroupsValid(this.ctx, this.userIds);
        this.dealGroupsChange();
    }

    protected abstract void dealGroupsChange() throws BOSException, EASBizException;
}

