/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.ldap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.ldap.ILdapMapInfoTrans;
import com.kingdee.eas.base.permission.ldap.LdapConfigInfo;
import com.kingdee.eas.base.permission.ldap.LdapMapInfoFactory;
import com.kingdee.eas.base.permission.ldap.LdapProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LdapServiceAdapter
extends AbstractServiceAdapter
implements IServiceAdapter {
    private static Logger logger = Logger.getLogger((String)LdapServiceAdapter.class.getName());

    public int getPriority() {
        return 0;
    }

    public String getName() {
        return "LDAPServiceAdapter";
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        try {
            List idList;
            Context ctx;
            String disableLdap;
            if (serviceContext.getExecutionMode() != 1) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"wellcome to LdapServiceAdapter.execute");
            }
            if (!StringUtils.isEmpty((String)(disableLdap = ParamManager.getParamValue((Context)(ctx = serviceContext.getContext()), null, (String)"DISABLE_LDAP"))) && "true".equalsIgnoreCase(disableLdap)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"set param DISABLE_LDAP is true ,don't deal ldap map");
                }
                return;
            }
            if (LdapConfigInfo.getInstance().getAllNeedAddMethod().isEmpty() && LdapConfigInfo.getInstance().getAllNeedDelMethod().isEmpty() && LdapConfigInfo.getInstance().getAllNeedPwdMethod().isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"not config ldap service enity and method info by ldapconfig.xml");
                }
                return;
            }
            String entityBosType = this.getEnityBosType(serviceContext);
            String methodPK = this.getMethodPK(serviceContext);
            if (StringUtils.isEmpty((String)entityBosType) || StringUtils.isEmpty((String)methodPK)) {
                logger.info((Object)("entity or method is null, entity type is " + StringUtils.cnulls((String)entityBosType) + " method is :" + StringUtils.cnulls((String)methodPK)));
                return;
            }
            String keyStr = entityBosType + ":" + methodPK;
            Map needAddMap = LdapConfigInfo.getInstance().getAllNeedAddMethod();
            if (needAddMap.containsKey(keyStr)) {
                String specialDealStr = (String)needAddMap.get(keyStr);
                List idList2 = this.getIdFromCtx(serviceContext, specialDealStr);
                if (idList2 != null && !idList2.isEmpty()) {
                    this.processLdapAdd(ctx, idList2);
                }
            } else if (LdapConfigInfo.getInstance().getAllNeedDelMethod().containsKey(keyStr) && (idList = this.getIdFromCtx(serviceContext, null)) != null && !idList.isEmpty()) {
                this.processLdapDel(ctx, idList);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
            return;
        }
    }

    private void processLdapAdd(Context ctx, List idList) throws EASBizException, BOSException {
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(idList);
    }

    private void processLdapDel(Context ctx, List idList) throws EASBizException, BOSException {
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.del(idList);
    }

    private void processPwdLdap(Context ctx, String id, String pwd) throws BOSException, EASBizException {
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(id, pwd);
    }

    private String getPwdFromCtx(IServiceContext serviceContext, String userId, int pwdPos) {
        Object[] obj = serviceContext.getOperationParameters();
        Object paramObj = obj[pwdPos];
        try {
            if (paramObj instanceof String) {
                IUser iUser = UserFactory.getLocalInstance(serviceContext.getContext());
                UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectStringPK(userId));
                return PermissionUtil.decrypt(userInfo.getNumber(), paramObj.toString());
            }
            if (paramObj instanceof UserInfo) {
                UserInfo userInfo = (UserInfo)paramObj;
                return PermissionUtil.decrypt(userInfo.getNumber(), userInfo.getPassword());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private List getIdFromCtx(IServiceContext serviceContext, String specialDealStr) {
        ArrayList<String> idList = new ArrayList<String>();
        Object[] obj = serviceContext.getOperationParameters();
        if (obj == null || obj.length == 0) {
            return null;
        }
        BOSObjectType bosType = serviceContext.getBoType();
        block2: for (int i = 0; i < obj.length; ++i) {
            List paramIdList = this.getIdFromParam(serviceContext, bosType, obj[i], specialDealStr);
            if (paramIdList != null && !paramIdList.isEmpty()) {
                idList.addAll(paramIdList);
                continue;
            }
            if (!(obj[i] instanceof Object[])) continue;
            Object[] objAry = (Object[])obj[i];
            for (int j = 0; j < objAry.length; ++j) {
                try {
                    if (!(objAry[j] instanceof IObjectPK) && !(objAry[j] instanceof String) || !BOSUuid.read((String)objAry[j].toString()).getType().toString().equals(bosType.toString())) continue block2;
                    idList.add(objAry[j].toString());
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)"read id error!", (Throwable)e);
                    continue block2;
                }
            }
        }
        return idList;
    }

    private List getIdFromParam(IServiceContext serviceContext, BOSObjectType bosType, Object oneParam, String specialDealStr) {
        CoreBaseInfo iObjectValue;
        Context ctx = serviceContext.getContext();
        ArrayList<String> idList = new ArrayList<String>();
        if (oneParam instanceof IObjectPK && (BOSUuid.read((String)oneParam.toString()).getType().toString().equals(bosType.toString()) || MetaDataTypeList.FACADE == serviceContext.getMetaType()) && StringUtils.isEmpty((String)specialDealStr)) {
            if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)oneParam))) {
                idList.add(StringUtils.cnulls((Object)oneParam));
            }
        } else if (oneParam instanceof CoreBaseInfo && ((iObjectValue = (CoreBaseInfo)oneParam).getBOSType().toString().equals(bosType.toString()) || MetaDataTypeList.FACADE == serviceContext.getMetaType())) {
            if (this.needRelationMap(specialDealStr)) {
                logger.info((Object)(" prepare getValue from iObjectValue, specialDealStr is:" + specialDealStr));
                List tempList = this.getIdFromRelationObj(ctx, iObjectValue, specialDealStr);
                if (tempList != null && !tempList.isEmpty()) {
                    idList.addAll(tempList);
                    logger.info((Object)("get some data, count is:" + tempList.size()));
                } else {
                    logger.info((Object)"prepare getValue from iObjectValue ,no data fetch!");
                }
            } else if (iObjectValue.getId() != null) {
                idList.add(StringUtils.cnulls((Object)iObjectValue.getId()));
            } else {
                Object retObj = serviceContext.getMethodReturnValue();
                if (retObj instanceof IObjectPK) {
                    idList.add(StringUtils.cnulls((Object)retObj));
                }
            }
        }
        return idList;
    }

    private List getIdFromRelationObj(Context ctx, CoreBaseInfo oneParam, String specialDealStr) {
        ILdapMapInfoTrans iLdapMapInfoTrans = LdapMapInfoFactory.createLdapMapInfoImpl(specialDealStr);
        return iLdapMapInfoTrans.getIdFromRelationObj(ctx, oneParam, specialDealStr);
    }

    private boolean needRelationMap(String specialDealStr) {
        if (StringUtils.isEmpty((String)specialDealStr)) {
            return false;
        }
        return specialDealStr.indexOf(":") != -1;
    }

    private String getMethodPK(IServiceContext serviceContext) {
        return StringUtils.cnulls((Object)serviceContext.getOperationPK());
    }

    private String getEnityBosType(IServiceContext serviceContext) {
        return StringUtils.cnulls((Object)serviceContext.getBoType());
    }
}

