/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.comstrategy;

import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.base.permission.service.comstrategy.CommunicationInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ValidateComFileManager {
    private static Logger logger = Logger.getLogger(ValidateComFileManager.class);
    private static final String comFileName = "validateCom.dat";
    private static final String filePath = ValidateComFileManager.getFilePath();

    public static Properties getValidateComFile() {
        Properties p = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            p.load(in);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
        return p;
    }

    private static String getFilePath() {
        String fileSepa = System.getProperty("file.separator");
        String filePath = System.getProperty("EAS_HOME") + fileSepa + "server" + fileSepa + "properties" + fileSepa + "license";
        try {
            File file;
            File LicenseUseInfoDir = new File(filePath);
            if (!LicenseUseInfoDir.exists()) {
                LicenseUseInfoDir.mkdir();
            }
            if (!(file = new File(filePath = filePath + fileSepa + comFileName)).exists()) {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigItem(String itemName) {
        String defaultValue = "com.kingdee.eas.base.permission.service.comstrategy.ValidatePhoneStrategy";
        Properties p = ValidateComFileManager.getValidateComFile();
        String itemValue = defaultValue;
        try {
            itemValue = p.getProperty(itemName);
            if (StringUtil.isEmpty((String)itemValue)) {
                itemValue = defaultValue;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            p.clear();
        }
        return itemValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfigItem(String itemName, String itemValue) {
        Properties p = ValidateComFileManager.getValidateComFile();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            p.setProperty(itemName, itemValue);
            p.store(out, "");
        }
        catch (Exception e) {
        }
        finally {
            if (p != null) {
                p.clear();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAllConfigItem(CommunicationInfo info) {
        Properties p = ValidateComFileManager.getValidateComFile();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filePath);
            p.setProperty("strategy", info.getStrategy());
            p.setProperty("exc_limit", String.valueOf(info.getExc_limit()));
            p.setProperty("exc_count", String.valueOf(info.getExc_count()));
            p.setProperty("ename", info.getEname());
            p.setProperty("country_id", String.valueOf(info.getCountry_id()));
            p.setProperty("need_email", String.valueOf(info.getNeedEmail()));
            p.setProperty("need_phone", String.valueOf(info.getNeedPhone()));
            p.store(new FileOutputStream(filePath), "");
        }
        catch (Exception e) {
        }
        finally {
            p.clear();
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static CommunicationInfo getAllConfigItem() {
        CommunicationInfo info = new CommunicationInfo();
        try {
            Properties p = ValidateComFileManager.getValidateComFile();
            if (p != null) {
                info.setStrategy(p.getProperty("strategy"));
                info.setEname(p.getProperty("ename"));
                if (p.getProperty("country_id") != null) {
                    info.setCountry_id(Integer.parseInt(p.getProperty("country_id")));
                }
                info.setStrategy(p.getProperty("strategy"));
                if (p.getProperty("exc_limit") != null) {
                    info.setExc_limit(Integer.parseInt(p.getProperty("exc_limit")));
                }
                if (p.getProperty("exc_count") != null) {
                    info.setExc_count(Integer.parseInt(p.getProperty("exc_count")));
                }
                if (p.getProperty("need_email") != null) {
                    info.setNeedEmail(Integer.parseInt(p.getProperty("need_email")));
                } else {
                    info.setNeedEmail(2);
                }
                if (p.getProperty("need_phone") != null) {
                    info.setNeedPhone(Integer.parseInt(p.getProperty("need_phone")));
                } else {
                    info.setNeedPhone(2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }
}

