/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.IUsbKeyUserMap;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.USBKeyFactory;
import com.kingdee.eas.base.permission.USBKeyInfo;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.service.helper.IUsbKeyControlExtern;
import com.kingdee.eas.base.permission.service.helper.UsbKey4LoginInfo;
import com.kingdee.eas.base.permission.service.helper.UsbKeyFactory;
import com.kingdee.eas.base.security.PkiSecurityException;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.provider.IPKICommonService;
import com.kingdee.eas.base.security.provider.IPKIServerExtProvider;
import com.kingdee.eas.base.security.provider.PKICommonServiceFactory;
import com.kingdee.eas.base.security.provider.PKIServerAndClientExtFactory;
import com.kingdee.eas.base.security.provider.app.PKISignInfoCache;
import com.kingdee.eas.base.security.provider.client.IPKIClientExt2Provider;
import com.kingdee.eas.base.security.usbkey.USBKeyInitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UsbKey4Login {
    private static Logger logger = Logger.getLogger(UsbKey4Login.class);
    private static final String USBKEY_LOGIN = "USBKEY_LOGIN";
    private static final String USBKE_PIN_VERIFY_RESULT = "usbkeyPinVerifyResult";
    public static String RANDOM_NO_4_LOGIN = "randomNo4login";

    public static void setKeyNumber(LoginContext ctx, String keyNumber) {
        UsbKey4LoginInfo usbKeyInfo = new UsbKey4LoginInfo();
        usbKeyInfo.setUsbKeyNo(keyNumber);
        ctx.put(USBKEY_LOGIN, (Object)usbKeyInfo);
    }

    public static void setLoginInfo(LoginContext ctx, String userName, String pwd) {
        try {
            UsbKey4Login.debugInfo("UsbKey4LoginInfo usbKeyInfo = new UsbKey4LoginInfo();");
            UsbKey4LoginInfo usbKeyInfo = new UsbKey4LoginInfo();
            try {
                UsbKey4Login.debugInfo("IPKIClientExt2Provider ipkiClientExt2Provider = USBKeyFactory.getUsbKey();");
                IPKIClientExt2Provider ipkiClientExt2Provider = USBKeyInitFactory.getUsbKey();
                if (Boolean.getBoolean(USBKeyInitFactory.getUSBkeyConfigInfo().getUsbkeyUseable())) {
                    usbKeyInfo.setLoginOk(false);
                    usbKeyInfo.setUsbKeyExceptionSubCode(UsbKeyException.USB_NOT_START.getCode());
                } else {
                    UsbKey4Login.debugInfo("ipkiClientExt2Provider.checkPasswd()");
                    ipkiClientExt2Provider.checkPasswd(pwd.getBytes("UTF-8"));
                    String des = CryptoTean.encrypt((String)"", (String)userName);
                    String userInputNumber = StringUtils.cnulls((String)des);
                    String usbKeyNumber1 = new String(ipkiClientExt2Provider.getUserID(), "UTF-8");
                    logger.info((Object)("userInputNumber is :" + userInputNumber + " usbKeyNumber is:" + usbKeyNumber1));
                    if (!userInputNumber.equals(usbKeyNumber1) && !userName.equals(usbKeyNumber1)) {
                        usbKeyInfo.setLoginOk(false);
                        usbKeyInfo.setUsbKeyExceptionSubCode(UsbKeyException.USB_NOT_RIGHT.getCode());
                    } else {
                        usbKeyInfo.setLoginOk(true);
                        usbKeyInfo.setUserNumber(userInputNumber);
                        byte[] certificate = ipkiClientExt2Provider.exportCertificate();
                        usbKeyInfo.setCertificate(certificate);
                        usbKeyInfo.setUsbKeyNo(ipkiClientExt2Provider.getKeyID());
                    }
                }
            }
            catch (UsbKeyException ue) {
                usbKeyInfo.setLoginOk(false);
                usbKeyInfo.setUsbKeyExceptionSubCode(ue.getSubCode());
            }
            ctx.put(USBKEY_LOGIN, (Object)usbKeyInfo);
        }
        catch (Exception e) {
            logger.warn((Object)"check to use UsbKey occur exception !", (Throwable)e);
        }
    }

    private static boolean verifySignatureInServer(UserContextCallback userCtxCallback, String username, String randomText4Sign, String usbkeyPinVerifyResult) throws EASBizException {
        Context ctx = userCtxCallback.getUserContext();
        String usbKeyExceptionFromClient = (String)ctx.get((Object)"UsbKeyException");
        if ("USB_PWD_ERROR".equals(usbKeyExceptionFromClient)) {
            throw new UsbKeyException(UsbKeyException.USB_PWD_ERROR);
        }
        IPKIServerExtProvider pkiServerExtProvider = PKIServerAndClientExtFactory.getServerExtProvider((Context)ctx);
        try {
            int res = -1;
            if (SecurityAuthParamManagerFactory.getLocalInstance(null).isGetCertFromRAServe()) {
                UsbKey4LoginInfo usbKeyLoginInfo = (UsbKey4LoginInfo)userCtxCallback.getUserContext().get((Object)USBKEY_LOGIN);
                res = pkiServerExtProvider.verify(randomText4Sign.getBytes("UTF-8"), usbkeyPinVerifyResult.getBytes("UTF-8"), usbKeyLoginInfo == null ? null : usbKeyLoginInfo.getUsbKeyNo(), username, userCtxCallback.getUserContext());
            } else {
                byte[] cert = PKISignInfoCache.getInstance().getCert(ctx, username);
                if (cert == null) {
                    logger.error((Object)"Usbkey signature verify error, getCert: return null");
                }
                res = pkiServerExtProvider.verify(randomText4Sign.getBytes("UTF-8"), usbkeyPinVerifyResult.getBytes("UTF-8"), pkiServerExtProvider.transCert(cert));
            }
            if (res == 0) {
                return true;
            }
            if (res == 204) {
                throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_LOGIN);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Usbkey signature verify error:", (Throwable)e);
            throw new UsbKeyException(PkiSecurityException.VERIFY_FAIL_LOGIN, e);
        }
        catch (Exception e) {
            logger.error((Object)"Usbkey signature verify error:", (Throwable)e);
            throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_LOGIN, (Throwable)e);
        }
        return false;
    }

    public static void wirteUserNumber(String userNumber) throws UsbKeyException, CryptException {
        String des = CryptoTean.encrypt((String)"", (String)userNumber);
        IUsbKeyControlExtern usbKeyControl = UsbKeyFactory.getUsbKey();
        logger.info((Object)("userNumber is:" + userNumber + "des is: " + des + " size is:" + des.length()));
        usbKeyControl.write(des);
    }

    public static boolean verifyPwdInServer(UserContextCallback userCtxCallback, String userNumber, String password) throws Exception {
        boolean validFlag = false;
        boolean isItrusProvider = SecurityAuthParamManagerFactory.getLocalInstance(null).isItrusProvider();
        boolean isVerifySignatureInServer = SecurityAuthParamManagerFactory.getLocalInstance(null).isVerifySignatureInServer();
        String usbkeyPinVerifyResult = (String)userCtxCallback.getUserContext().get((Object)USBKE_PIN_VERIFY_RESULT);
        logger.info((Object)(PermissionResUtil.getResource("res_130") + "usbkey" + PermissionResUtil.getResource("res_55")));
        if (usbkeyPinVerifyResult != null) {
            if (isItrusProvider && isVerifySignatureInServer) {
                String randomNo4login = (String)userCtxCallback.getUserContext().get((Object)RANDOM_NO_4_LOGIN);
                validFlag = UsbKey4Login.verifySignatureInServer(userCtxCallback, userNumber, randomNo4login, usbkeyPinVerifyResult);
                if (!validFlag) {
                    logger.info((Object)("verifySignatureInServer return false, userNumber/randomNo4login/usbkeyPinVerifyResult=" + userNumber + "/" + randomNo4login + "/" + usbkeyPinVerifyResult));
                    throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_LOGIN);
                }
            } else {
                validFlag = UsbKey4Login.verifyUsbKeyNoInServer(userCtxCallback, userNumber, usbkeyPinVerifyResult);
            }
        } else if (isItrusProvider && isVerifySignatureInServer) {
            IPKICommonService iPKICommonService = PKICommonServiceFactory.getLocalInstance();
            String randomNo4login = iPKICommonService.getRandomNo(userCtxCallback.getUserContext(), userNumber);
            validFlag = UsbKey4Login.verifySignatureInServer(userCtxCallback, userNumber, randomNo4login, password);
        } else {
            UsbKey4LoginInfo usbKeyLoginInfo = (UsbKey4LoginInfo)userCtxCallback.getUserContext().get((Object)USBKEY_LOGIN);
            validFlag = UsbKey4Login.verifyUsbKeyNoInServer(userCtxCallback, userNumber, usbKeyLoginInfo.getUsbKeyNo());
            if (validFlag) {
                PKISignInfoCache.getInstance().putSignInfo(userCtxCallback.getUserContext(), userNumber, usbKeyLoginInfo.getCertificate());
            }
        }
        UsbKey4LoginInfo usbKeyInfo = new UsbKey4LoginInfo();
        usbKeyInfo.setLoginOk(validFlag);
        if (!validFlag) {
            logger.info((Object)("portal" + PermissionResUtil.getResource("res_133") + "usbkey" + PermissionResUtil.getResource("res_134")));
            usbKeyInfo.setUsbKeyExceptionSubCode(UsbKeyException.USB_NOT_RIGHT.getCode());
        } else {
            logger.info((Object)("portal" + PermissionResUtil.getResource("res_133") + "usbkey" + PermissionResUtil.getResource("res_135")));
            usbKeyInfo.setUserNumber(userNumber);
        }
        userCtxCallback.getUserContext().put((Object)USBKEY_LOGIN, (Object)usbKeyInfo);
        return validFlag;
    }

    private static boolean verifyUsbKeyNoInServer(UserContextCallback userCtxCallback, String username, String usbKeyNo) throws EASBizException {
        if ("true".equals(usbKeyNo) || "false".equals(usbKeyNo)) {
            logger.error((Object)"VerifyUsbKeyNoInServer: parameter usbKeyNo not right, please upgrade .cab file!");
            return false;
        }
        if ("-1".equals(usbKeyNo) || "-2".equals(usbKeyNo) || "-3".equals(usbKeyNo)) {
            logger.error((Object)("VerifyUsbKeyNoInServer: parameter usbKeyNo=" + usbKeyNo));
            return false;
        }
        Context ctx = userCtxCallback.getUserContext();
        String sql = "SELECT uk.FUsbkeyID, uk.FUserID FROM T_PM_User AS u, T_PM_UsbKeyUserMap AS uk WHERE u.FID = uk.FUserID AND u.FNumber=?";
        Object[] params = new Object[]{username};
        try {
            IRowSet rowSet;
            USBKeyInfo usbKeyInfo = USBKeyFactory.getLocalInstance(ctx).getUsbKeyInfoByNumber(usbKeyNo);
            if (usbKeyInfo == null) {
                logger.error((Object)"VerifyUsbKeyNoInServer: usbKeyInfo is null, please check usbkey initialization.");
                if (StringUtils.isEmpty((String)usbKeyNo)) {
                    logger.error((Object)"VerifyUsbKeyNoInServer: usbKeyInfo is null and usbKeyNo is null.");
                    return false;
                }
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params)).next()) {
                if (usbKeyInfo == null && userCtxCallback.getUserContext().get((Object)USBKE_PIN_VERIFY_RESULT) == null) {
                    String usbkey_fid = BOSUuid.create((String)"0366DBEF").toString();
                    logger.info((Object)("Try to init t_pm_usbkey, fid=" + usbkey_fid + " and keyNO=" + usbKeyNo));
                    DbUtil.execute((Context)ctx, (String)("insert into t_pm_usbkey values('" + usbkey_fid + "', '" + usbKeyNo + "')"));
                    logger.info((Object)("Try to update t_pm_usbkeyusermap, usernumber=" + username));
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_PM_UsbKeyUserMap SET FUsbkeyID='" + usbkey_fid + "' WHERE FUserID=(select FID from t_pm_user where fnumber='" + username + "')"));
                    logger.warn((Object)"VerifyUsbKeyNoInServer: usbKeyInfo is null\uff0c ignore compare");
                    return true;
                }
                if (userCtxCallback.getUserContext().get((Object)USBKE_PIN_VERIFY_RESULT) != null) {
                    logger.warn((Object)"USBKE_PIN_VERIFY_RESULT is not null in userContext, ignore compare serialNo");
                    return true;
                }
                String fusbKeyIdInMapTable = rowSet.getString(1);
                if (fusbKeyIdInMapTable == null || "".equals(fusbKeyIdInMapTable)) {
                    String userId = rowSet.getString(2);
                    logger.info((Object)("VerifyUsbKeyNoInServer: update table column UsbKeyUserMap.FUsbkeyID, FUserID=" + userId));
                    String updateSql = "UPDATE T_PM_UsbKeyUserMap SET FUsbkeyID='" + usbKeyInfo.getId() + "' WHERE FUserID='" + userId + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                    return true;
                }
                if (fusbKeyIdInMapTable.equals(usbKeyInfo.getId().toString())) {
                    return true;
                }
                logger.error((Object)"VerifyUsbKeyNoInServer: not match!");
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean useUsbKey(UserContextCallback userCtxCallback, String userNumber, String password) throws Exception {
        Context ctx = userCtxCallback.getUserContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        IUsbKeyUserMap iUsbKeyUserMap = UsbKeyUserMapFactory.getLocalInstance(ctx);
        boolean usbAuthorWay = false;
        if (LoginAuthorWayEnum.USBKEY == userInfo.getLoginAuthorWay()) {
            usbAuthorWay = true;
        }
        if (usbAuthorWay) {
            if (iUsbKeyUserMap.useUsbKey4User(userInfo.getId().toString())) {
                return true;
            }
            logger.error((Object)(" user loginAuthorWay is use usbkey login ,but usbkey is not started!  userId is:" + userInfo.getId().toString()));
            throw new UsbKeyException(UsbKeyException.USB_NOT_START);
        }
        return false;
    }

    private static void debugInfo(String debugInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)debugInfo);
        }
    }

    static class UsbKeyExceptionSubItem {
        private static Map subItemMap = null;

        UsbKeyExceptionSubItem() {
        }

        public static NumericExceptionSubItem getSubItem(String subCode) {
            UsbKeyExceptionSubItem.initSubItemMap();
            return (NumericExceptionSubItem)subItemMap.get(subCode);
        }

        private static void initSubItemMap() {
            if (subItemMap == null) {
                subItemMap = new HashMap();
                subItemMap.put("000", UsbKeyException.USB_INIT_ERROR);
                subItemMap.put("001", UsbKeyException.CREATE_SERVERFILE_ERROR);
                subItemMap.put("002", UsbKeyException.USB_READ_ERROR);
                subItemMap.put("003", UsbKeyException.USB_WRITE_ERROR);
                subItemMap.put("004", UsbKeyException.USB_OPERATOR_ERROR);
                subItemMap.put("005", UsbKeyException.USBKEY_CHECKPERM_FAIL);
                subItemMap.put("006", UsbKeyException.USB_ERROR);
                subItemMap.put("007", UsbKeyException.USB_PWD_ERROR);
                subItemMap.put("008", UsbKeyException.USB_BE_USED);
                subItemMap.put("009", UsbKeyException.USB_NOT_START);
                subItemMap.put("010", UsbKeyException.USB_NOT_RIGHT);
                subItemMap.put("011", UsbKeyException.USB_DRIVER_NOT_INSTALL);
                subItemMap.put("012", UsbKeyException.NOT_START_USE_USBKEY);
            }
        }
    }
}

