/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper;

import com.itrus.pki.rsa.iTrusUsbKey;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.service.helper.AbstractUsbKeyBaseOperatorExt;
import com.kingdee.eas.base.permission.service.helper.IUsbKeyBaseOperator;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.base.permission.service.helper.ekey.EUsbKeyBaseOperatorImpl;
import com.kingdee.eas.base.permission.service.helper.usbkeyimpl.AbstractUsbKeyBaseOperatorExtAdapter;
import com.kingdee.eas.base.permission.util.LogUtil;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

public class UsbKeyCtxHelper {
    private static Logger logger = Logger.getLogger(UsbKeyCtxHelper.class);
    private static String USBKEY_USEABLE = "USBKEY_USEABLE";
    private static String USBKEYIMP = "USBKEYIMP";

    public static boolean isNeedUsbKeyPerm() {
        return PermissionParameterFactory.getRemoteInstance().isNeedUsbKeyPerm();
    }

    public static String getUsbkeyImp() {
        return PermissionParameterFactory.getRemoteInstance().getUsbkeyImp();
    }

    public static IUsbKeyBaseOperator getUserCustermUsbKeyImpl(String usbKeyImpl) throws UsbKeyException {
        try {
            Class<?> clz = UsbKeyCtxHelper.class.getClassLoader().loadClass(usbKeyImpl);
            if (IUsbKeyBaseOperator.class.isAssignableFrom(clz)) {
                return (IUsbKeyBaseOperator)clz.newInstance();
            }
            if (AbstractUsbKeyBaseOperatorExt.class.isAssignableFrom(clz)) {
                AbstractUsbKeyBaseOperatorExt ext = (AbstractUsbKeyBaseOperatorExt)clz.newInstance();
                return new AbstractUsbKeyBaseOperatorExtAdapter(ext);
            }
            throw new IllegalArgumentException("param set is error!");
        }
        catch (InstantiationException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return new EUsbKeyBaseOperatorImpl();
    }

    public static iTrusUsbKey createItrusUsbKey() throws Exception {
        logger.info((Object)"iTrusUsbKey construction start...");
        String easHome = System.getProperty("easclient.root");
        if (easHome == null || "".equals(easHome)) {
            logger.error((Object)"[CA configPath] EAS_HOME property is null.");
        }
        String configPath = easHome + "/config";
        logger.info((Object)LogUtil.filterLogForging("[CA configPath] configPath is:" + configPath));
        try {
            Constructor con = iTrusUsbKey.class.getConstructor(String.class);
            return (iTrusUsbKey)con.newInstance(configPath);
        }
        catch (NoSuchMethodException e) {
            logger.info((Object)"iTrusUsbKey newInstance() start.");
            try {
                return (iTrusUsbKey)iTrusUsbKey.class.newInstance();
            }
            catch (Exception e1) {
                logger.error((Object)"iTrusUsbKey newInstance() error:", (Throwable)e);
                throw e1;
            }
        }
        catch (Exception e) {
            logger.error((Object)"iTrusUsbKey newInstance(configPath) error:", (Throwable)e);
            throw e;
        }
    }
}

