/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.util.IUserInfoCheckStrategy;
import com.kingdee.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegistLicModeUserCheckStrategy
implements IUserInfoCheckStrategy {
    private boolean isInternation = false;

    public RegistLicModeUserCheckStrategy() {
        try {
            this.isInternation = UserFacadeFactory.getRemoteInstance().isInternation();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    @Override
    public boolean check(UserInfo user) throws UserException {
        if (!this.isInternation) {
            if (!this.checkMobilePhone(user)) {
                throw new UserException(UserException.MOBILE_ERROR);
            }
            if (!StringUtils.isEmpty((String)user.getEmail()) && !this.checkMailAddress(user)) {
                throw new UserException(UserException.EMAIL_ERROR);
            }
        } else {
            if (StringUtils.isEmpty((String)user.getCell()) && StringUtils.isEmpty((String)user.getEmail())) {
                throw new UserException(UserException.CELL_EMAIL_CANT_NULL);
            }
            if (!StringUtils.isEmpty((String)user.getCell()) && !this.checkMobilePhone(user)) {
                throw new UserException(UserException.MOBILE_ERROR);
            }
            if (!StringUtils.isEmpty((String)user.getEmail()) && !this.checkMailAddress(user)) {
                throw new UserException(UserException.EMAIL_ERROR);
            }
        }
        return true;
    }

    protected boolean checkMobilePhone(UserInfo user) throws UserException {
        if (StringUtils.isEmpty((String)user.getCell())) {
            if (user != null && user.getType() != UserType.SYSTEM && user.getType() != UserType.AUTHENTICATEADMIN && user.getType() != UserType.AUDITADMIN) {
                throw new UserException(UserException.CELL_NULL);
            }
            return true;
        }
        Pattern p = Pattern.compile("^[1]\\d{10}$");
        Matcher m = p.matcher(user.getCell());
        return m.matches();
    }

    protected boolean checkMailAddress(UserInfo user) {
        Pattern p = Pattern.compile("\\w+@(\\w+.)+[a-z]{2,3}");
        Matcher m = p.matcher(user.getEmail());
        return m.matches();
    }
}

