/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.file.config.LicenseConfig;
import com.kingdee.eas.base.license.file.config.UIMappingCollection;
import com.kingdee.eas.base.license.file.config.UIMappingInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShrCloud {
    private static final Logger logger = Logger.getLogger(ShrCloud.class);

    public static Map<String, String> readLicenseUIDetailTable(Context ctx) {
        ILicenseSrvAgent licenseSrv = ShrCloud.getLicenseSrvAgent(ctx);
        LicenseConfig licenseConfig = licenseSrv.getLicenseConfig();
        UIMappingCollection uiMappingColl = licenseConfig.getUIMapCol();
        UIMappingInfo uiMappingInfo = null;
        HashMap<String, String> uiGroupMappping = new HashMap<String, String>();
        int size = uiMappingColl.size();
        for (int i = 0; i < size; ++i) {
            uiMappingInfo = uiMappingColl.get(i);
            String uiClassName = uiMappingInfo.getUiName();
            try {
                uiGroupMappping.put(uiClassName, licenseSrv.getSubSystemNameByPackage(uiClassName));
                continue;
            }
            catch (LicenseException e) {
                e.printStackTrace();
            }
        }
        return uiGroupMappping;
    }

    public static ILicenseSrvAgent getLicenseSrvAgent(Context ctx) {
        try {
            ILicenseSrvAgent licenseSrv = ShrCloud.getLicenseSrvAgentInstance(ctx);
            return licenseSrv;
        }
        catch (LicenseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static LicenseBaseInfo getLicenseBaseInfo(Context ctx) {
        LicenseBaseInfo licenseInfo = null;
        try {
            licenseInfo = ShrCloud.getLicenseSrvAgent(ctx).getLicenseBaseInfo();
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        return licenseInfo;
    }

    public static String getProductInstanceID(Context ctx) {
        return ShrCloud.getLicenseBaseInfo(ctx).getProductInstanceID();
    }

    public static ILicenseSrvAgent getLicenseSrvAgentInstance(Context ctx) throws LicenseException {
        try {
            ILicenseSrvAgent licenseSrvAgent = null;
            String className = "com.kingdee.eas.base.license.agent.LicenseSrvAgent";
            licenseSrvAgent = null == ctx ? (ILicenseSrvAgent)BOSObjectFactory.createRemoteBOSObject((String)className, ILicenseSrvAgent.class) : (ILicenseSrvAgent)BOSObjectFactory.createBOSObject((Context)ctx, (String)className, ILicenseSrvAgent.class);
            if (licenseSrvAgent == null) {
                throw new LicenseException("Can not find Class 'com.kingdee.eas.base.license.agent.LicenseSrvAgent',Please make sure this class is in you CLASSPATH");
            }
            return licenseSrvAgent;
        }
        catch (Exception ex) {
            throw new LicenseException((Throwable)ex);
        }
    }
}

