/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.risk.ActionEntryCollection;
import com.kingdee.eas.base.risk.ActionEntryFactory;
import com.kingdee.eas.base.risk.ActionEntryInfo;
import com.kingdee.eas.base.risk.ControlMode;
import com.kingdee.eas.base.risk.IActionEntry;
import com.kingdee.eas.base.risk.PageEntryCollection;
import com.kingdee.eas.base.risk.PageEntryFactory;
import com.kingdee.eas.base.risk.PageEntryInfo;
import com.kingdee.eas.base.risk.ParamEntryCollection;
import com.kingdee.eas.base.risk.ParamEntryInfo;
import com.kingdee.eas.base.risk.RiskDesignerCollection;
import com.kingdee.eas.base.risk.RiskDesignerFactory;
import com.kingdee.eas.base.risk.RiskDesignerInfo;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.app.AbstractRiskDesignerControllerBean;
import com.kingdee.eas.base.risk.cache.RiskConfigUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RiskDesignerControllerBean
extends AbstractRiskDesignerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.app.RiskDesignerControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkReferRelation(ctx, model);
        RiskDesignerInfo riskDesignerInfo = (RiskDesignerInfo)model;
        this.checkNumberDup(ctx, riskDesignerInfo);
        ControlMode controlModel = riskDesignerInfo.getControlModel();
        if (ControlMode.poTips.equals((Object)controlModel)) {
            this.checkPoTipsDup(ctx, riskDesignerInfo);
        } else if (ControlMode.billOper.equals((Object)controlModel)) {
            this.checkBillOperDup(ctx, riskDesignerInfo);
        } else if (ControlMode.funControl.equals((Object)controlModel)) {
            this.checkFunControlDup(ctx, riskDesignerInfo);
        } else if (ControlMode.robot.equals((Object)controlModel)) {
            this.checkRobotDup(ctx, riskDesignerInfo);
        }
        ParamEntryCollection paramEntry = riskDesignerInfo.getParamEntry();
        int size = paramEntry.size();
        for (int i = 0; i < size; ++i) {
            ParamEntryInfo paramEntryInfo = paramEntry.get(i);
            if (paramEntryInfo.isRequiredParam()) continue;
            paramEntryInfo.setConvertScript(null);
        }
        PageEntryCollection pageEntry = riskDesignerInfo.getPageEntry();
        for (int i = 0; i < pageEntry.size(); ++i) {
            PageEntryInfo pageEntryInfo = pageEntry.get(i);
            BOSUuid pageId = pageEntryInfo.getId();
            pageEntryInfo.getActionEntry().clear();
            ActionEntryCollection actionEntry = riskDesignerInfo.getActionEntry();
            for (int j = 0; j < actionEntry.size(); ++j) {
                ActionEntryInfo actionEntryInfo = actionEntry.get(j);
                if (actionEntryInfo.get("id") == null || !pageId.equals((Object)actionEntryInfo.getPageEntry().getId())) continue;
                pageEntryInfo.getActionEntry().add(actionEntryInfo);
            }
        }
        IObjectPK retValue = super._save(ctx, model);
        RiskConfigUtils.clearAdapterCache(ctx);
        return retValue;
    }

    protected void checkRobotDup(Context ctx, RiskDesignerInfo riskDesignerInfo) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("metaBostype = '" + riskDesignerInfo.getMetaBostype() + "'"));
        filterInfo.getFilterItems().add(new FilterItemInfo("methodPK = '" + riskDesignerInfo.getMethodPK() + "'"));
        filterInfo.getFilterItems().add(new FilterItemInfo("controlModel = '" + ControlMode.robot.getValue() + "'"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id <> '" + riskDesignerInfo.getId() + "'"));
        if (RiskDesignerFactory.getLocalInstance(ctx).exists(filterInfo)) {
            Locale locale = ctx.getLocale();
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            selector.add("number");
            viewInfo.setSelector(selector);
            viewInfo.setFilter(filterInfo);
            RiskDesignerCollection riskDesignerCollection = RiskDesignerFactory.getLocalInstance(ctx).getRiskDesignerCollection(viewInfo);
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.risk.RiskWebResource", (String)"RiskDesignerIsExist", (Locale)locale, (Object[])new Object[]{riskDesignerInfo.getName(), riskDesignerCollection.get(0).getName()})));
        }
    }

    protected void checkFunControlDup(Context ctx, RiskDesignerInfo riskDesignerInfo) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("metaBostype = '" + riskDesignerInfo.getMetaBostype() + "'"));
        filterInfo.getFilterItems().add(new FilterItemInfo("methodPK = '" + riskDesignerInfo.getMethodPK() + "'"));
        filterInfo.getFilterItems().add(new FilterItemInfo("controlModel = '" + ControlMode.funControl.getValue() + "'"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id <> '" + riskDesignerInfo.getId() + "'"));
        if (RiskDesignerFactory.getLocalInstance(ctx).exists(filterInfo)) {
            Locale locale = ctx.getLocale();
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            selector.add("number");
            viewInfo.setSelector(selector);
            viewInfo.setFilter(filterInfo);
            RiskDesignerCollection riskDesignerCollection = RiskDesignerFactory.getLocalInstance(ctx).getRiskDesignerCollection(viewInfo);
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.risk.RiskWebResource", (String)"RiskDesignerIsExist", (Locale)locale, (Object[])new Object[]{riskDesignerInfo.getName(), riskDesignerCollection.get(0).getName()})));
        }
    }

    protected void checkPoTipsDup(Context ctx, RiskDesignerInfo riskDesignerInfo) throws BOSException, EASBizException {
        PageEntryCollection pageEntry = riskDesignerInfo.getPageEntry();
        if (pageEntry != null && pageEntry.size() > 0) {
            for (int i = 0; i < pageEntry.size(); ++i) {
                PageEntryInfo pageEntryInfo = pageEntry.get(i);
                String pageUIPK = pageEntryInfo.getPageUIPK();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("pageUIPK = '" + pageUIPK + "'"));
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.id <> '" + riskDesignerInfo.getId() + "'"));
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.controlModel = 'POTIPS'"));
                if (!PageEntryFactory.getLocalInstance(ctx).exists(filterInfo)) continue;
                Locale locale = ctx.getLocale();
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("parent.id");
                selector.add("parent.name");
                selector.add("parent.number");
                viewInfo.setSelector(selector);
                viewInfo.setFilter(filterInfo);
                PageEntryCollection pageEntryCollection = PageEntryFactory.getLocalInstance(ctx).getPageEntryCollection(viewInfo);
                String dName = pageEntryCollection.get(0).getParent().getName();
                String dNumber = pageEntryCollection.get(0).getParent().getNumber();
                throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.risk.RiskWebResource", (String)"RiskDesignerIsExist", (Locale)locale, (Object[])new Object[]{pageUIPK, dName})));
            }
        }
    }

    protected void checkBillOperDup(Context ctx, RiskDesignerInfo riskDesignerInfo) throws BOSException, EASBizException {
        ActionEntryCollection actionEntry = riskDesignerInfo.getActionEntry();
        if (actionEntry != null && actionEntry.size() > 0) {
            for (int i = 0; i < actionEntry.size(); ++i) {
                ActionEntryInfo actionEntryInfo = actionEntry.get(i);
                String actionNumber = actionEntryInfo.getActionNumber();
                PageEntryInfo pageEntry = actionEntryInfo.getPageEntry();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("pageEntry.pageUIPK = '" + pageEntry.getPageUIPK() + "'"));
                filterInfo.getFilterItems().add(new FilterItemInfo("actionNumber = '" + actionNumber + "'"));
                filterInfo.getFilterItems().add(new FilterItemInfo("designer.id <> '" + riskDesignerInfo.getId() + "'"));
                IActionEntry iActionEntry = ActionEntryFactory.getLocalInstance(ctx);
                if (!iActionEntry.exists(filterInfo)) continue;
                Locale locale = ctx.getLocale();
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("designer.id");
                selector.add("designer.name");
                selector.add("designer.number");
                viewInfo.setSelector(selector);
                viewInfo.setFilter(filterInfo);
                ActionEntryCollection actionEntryCollection = iActionEntry.getActionEntryCollection(viewInfo);
                String dName = actionEntryCollection.get(0).getDesigner().getName();
                throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.risk.RiskWebResource", (String)"RiskDesignerIsExist", (Locale)locale, (Object[])new Object[]{pageEntry.getPageUIPK() + "-" + actionNumber, dName})));
            }
        }
    }

    private void checkReferRelation(Context ctx, IObjectValue model) throws BOSException, RiskException {
        String id = model.get("id").toString();
        String sql = "SELECT distinct rm.fnumber FROM t_ris_riskmodel rm inner join T_RIS_DesignerEntry re on rm.fid = re.fparentid inner join t_ris_modelshow ms on rm.fid = ms.friskmodelid where ms.fstatus='enable' and re.fdesignerid = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        HashSet<String> numbers = new HashSet<String>();
        try {
            while (rowSet.next()) {
                numbers.add(rowSet.getString(1));
            }
        }
        catch (Exception e) {
            logger.error((Object)"riskDesigner checkReferRelation failuer", (Throwable)e);
            return;
        }
        if (!numbers.isEmpty()) {
            throw new RiskException(RiskException.LICENSEERROR, new Object[]{"\u5b58\u5728\u542f\u7528\u7684\u5355\u636e\u63a7\u5236\u6a21\u578b'" + String.join((CharSequence)",", numbers) + "\u5f15\u7528\u4e86\u8be5\u63a7\u5236\u8303\u56f4\uff0c\u8bf7\u5148\u7981\u7528\u540e\u518d\u4fee\u6539\u4fdd\u5b58\u8be5\u914d\u7f6e"});
        }
    }
}

