/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.risk.AbstractRiskModelInfo;
import com.kingdee.eas.base.risk.ActionEntryCollection;
import com.kingdee.eas.base.risk.ActionEntryInfo;
import com.kingdee.eas.base.risk.BillTypeFactory;
import com.kingdee.eas.base.risk.BillTypeInfo;
import com.kingdee.eas.base.risk.CheckGroupFactory;
import com.kingdee.eas.base.risk.CheckGroupInfo;
import com.kingdee.eas.base.risk.DesignerEntryCollection;
import com.kingdee.eas.base.risk.DesignerEntryInfo;
import com.kingdee.eas.base.risk.FactorsFilterEntryCollection;
import com.kingdee.eas.base.risk.IRiskDesigner;
import com.kingdee.eas.base.risk.IRiskModel;
import com.kingdee.eas.base.risk.ModelOrgCollection;
import com.kingdee.eas.base.risk.ModelOrgInfo;
import com.kingdee.eas.base.risk.ModelRuleEntryCollection;
import com.kingdee.eas.base.risk.PageEntryCollection;
import com.kingdee.eas.base.risk.PageEntryInfo;
import com.kingdee.eas.base.risk.RiskDesignerCollection;
import com.kingdee.eas.base.risk.RiskDesignerFactory;
import com.kingdee.eas.base.risk.RiskDesignerInfo;
import com.kingdee.eas.base.risk.RiskFactorsCollection;
import com.kingdee.eas.base.risk.RiskFactorsFactory;
import com.kingdee.eas.base.risk.RiskFactorsInfo;
import com.kingdee.eas.base.risk.RiskModelCollection;
import com.kingdee.eas.base.risk.RiskModelFactory;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.app.AbstractRiskModelImportFacadeControllerBean;
import com.kingdee.eas.base.risk.app.paySafe.IOverAmount;
import com.kingdee.eas.base.risk.app.paySafe.IRepeatBill;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountCollection;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountFactory;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountInfo;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillCollection;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillFactory;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillInfo;
import com.kingdee.eas.base.risk.tools.sqlTools.SqlFormatUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RiskModelImportFacadeControllerBean
extends AbstractRiskModelImportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.app.RiskModelImportFacadeControllerBean");
    private UserInfo userInfo = null;
    private Timestamp createtime = null;
    private CtrlUnitInfo ctrlUnitInfo = null;

    @Override
    protected String _riskModelImport(Context ctx, String jsonString) throws BOSException, EASBizException {
        int count = 0;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.userInfo = new UserInfo();
            this.userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            Date date = new Date();
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            this.createtime = new Timestamp(d.getTime().getTime());
            this.ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            List list = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonString, List.class);
            CoreBaseCollection risks = new CoreBaseCollection();
            for (int i = 0; i < list.size(); ++i) {
                String json = JSONUtils.convertObjectToJson((Context)ctx, list.get(i));
                RiskModelInfo riskModelInfo = (RiskModelInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)json, RiskModelInfo.class);
                riskModelInfo.setCU(this.ctrlUnitInfo);
                riskModelInfo.setCreateTime(this.createtime);
                riskModelInfo.setCreator(this.userInfo);
                riskModelInfo.setSimpleName("\u5f15\u5165");
                risks.add((CoreBaseInfo)riskModelInfo);
            }
            if (risks.size() == 0) {
                return "\u6240\u9009\u6587\u4ef6\u65e0\u6cd5\u89e3\u6790\u6210\u98ce\u63a7\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\uff01";
            }
            count = risks.size();
            this.checkGroupProcess(ctx, risks);
            this.riskFactorsProcess(ctx, risks);
            this.billTypeProcess(ctx, risks);
            this.processOverAmount(ctx, risks);
            this.processRepeatBill(ctx, risks);
            this.processModelOrg(ctx, risks);
            this.processRiskDesigner(ctx, risks);
            String repeatMessage = this.excludeRepeatData(ctx, risks);
            int successSize = 0;
            if (!risks.isEmpty()) {
                this.processRiskModels(risks);
                IRiskModel remoteInstance = RiskModelFactory.getRemoteInstance();
                successSize = risks.size();
                for (int i = 0; i < risks.size(); ++i) {
                    try {
                        remoteInstance.save(risks.get(i));
                        continue;
                    }
                    catch (Exception e1) {
                        RiskModelInfo info = (RiskModelInfo)risks.get(i);
                        throw new BOSException(info.getNumber() + "\u5bfc\u5165\u5931\u8d25\uff1a" + e1.getMessage());
                    }
                }
            }
            result.put("repeatMessage", repeatMessage);
            result.put("successMessage", successSize == 0 ? "" : "\u5bfc\u5165\u6210\u529f" + successSize + "\u6761\u6570\u636e;");
            result.put("saveFailMessage", "");
            result.put("failSize", String.valueOf(count - successSize));
        }
        catch (Exception e) {
            logger.error((Object)"import riskModel failure", (Throwable)e);
            result.put("failSize", String.valueOf(count));
            result.put("successMessage", "");
            result.put("repeatMessage", "");
            result.put("saveFailMessage", e.getMessage());
        }
        return JSON.toJSONString(result);
    }

    private void processModelOrg(Context ctx, CoreBaseCollection risks) throws BOSException, EASBizException {
        HashMap<String, String> numberToIds = new HashMap<String, String>();
        HashMap idToNumbers = null;
        for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo info = (RiskModelInfo)risks.get(i);
            if (info.get("orgNumberRelations") == null) continue;
            idToNumbers = (HashMap)info.get("orgNumberRelations");
        }
        if (idToNumbers != null && !idToNumbers.isEmpty()) {
            Object info;
            int i;
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(idToNumbers.values()), CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("number");
            selectorItemCollection.add("id");
            entityViewInfo.setSelector(selectorItemCollection);
            FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(entityViewInfo);
            for (i = 0; i < fullOrgUnitCollection.size(); ++i) {
                info = fullOrgUnitCollection.get(i);
                numberToIds.put(info.getNumber(), info.getId().toString());
            }
            for (i = 0; i < risks.size(); ++i) {
                info = (RiskModelInfo)risks.get(i);
                ModelOrgCollection orgEntry = ((AbstractRiskModelInfo)info).getOrgEntry();
                for (int j = orgEntry.size() - 1; j >= 0; --j) {
                    ModelOrgInfo org = orgEntry.get(j);
                    String orgID = (String)numberToIds.get(idToNumbers.get(org.getOrgId()));
                    if (orgID == null) {
                        orgEntry.remove(org);
                        continue;
                    }
                    org.setOrgId(orgID);
                }
            }
        }
    }

    private String processRiskDesigner(Context ctx, CoreBaseCollection risks) throws BOSException, EASBizException {
        IRiskDesigner instance = RiskDesignerFactory.getLocalInstance(ctx);
        String designerMessage = "";
        for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo info = (RiskModelInfo)risks.get(i);
            DesignerEntryCollection designerEntry = info.getDesignerEntry();
            for (int j = 0; j < designerEntry.size(); ++j) {
                DesignerEntryInfo designerEntryInfo = designerEntry.get(j);
                RiskDesignerInfo designer = designerEntryInfo.getDesigner();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)designer.getNumber()));
                RiskDesignerCollection collection = instance.getRiskDesignerCollection(view);
                if (collection.isEmpty()) {
                    designer.setCU(this.ctrlUnitInfo);
                    designer.setCreator(this.userInfo);
                    designer.setCreateTime(this.createtime);
                    designer.setSimpleName("\u5f15\u5165");
                    ActionEntryCollection actionEntry = designer.getActionEntry();
                    PageEntryCollection pageEntry = designer.getPageEntry();
                    for (int m = 0; m < actionEntry.size(); ++m) {
                        ActionEntryInfo actionEntryInfo = actionEntry.get(m);
                        for (int n = 0; n < pageEntry.size(); ++n) {
                            PageEntryInfo pageEntryInfo = pageEntry.get(n);
                            pageEntryInfo.getActionEntry().clear();
                            if (!actionEntryInfo.getPageEntry().getId().toString().equals(pageEntryInfo.getId().toString())) continue;
                            actionEntryInfo.setPageEntry(pageEntryInfo);
                        }
                    }
                    try {
                        instance.save((CoreBaseInfo)designer);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u98ce\u63a7\u8bbe\u8ba1\u5668\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                        throw new BOSException("\u98ce\u63a7\u6a21\u578b" + info.getNumber() + "\u5bfc\u5165\u51fa\u9519!" + e.getMessage());
                    }
                }
                designerEntryInfo.setDesigner(collection.get(0));
            }
        }
        return designerMessage;
    }

    private void processOverAmount(Context ctx, CoreBaseCollection risks) throws BOSException, EASBizException {
        IOverAmount instance = OverAmountFactory.getLocalInstance(ctx);
        for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo info = (RiskModelInfo)risks.get(i);
            if ("com.kingdee.eas.base.risk.service.paySafe.AvoidExcess".equals(info.getRuleClazz())) {
                OverAmountInfo overAmount = info.getOverAmount();
                if (overAmount == null) continue;
                String srcBostype = overAmount.getSrcBill().getBillBosType();
                String tarBostype = overAmount.getTargetBill().getBillBosType();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("srcBill.billBosType", (Object)srcBostype));
                filter.getFilterItems().add(new FilterItemInfo("targetBill.billBosType", (Object)tarBostype));
                OverAmountCollection overAmountCollection = instance.getOverAmountCollection(view);
                if (overAmountCollection.isEmpty()) {
                    IObjectPK iObjectPK = instance.save(overAmount);
                    continue;
                }
                info.setOverAmount(overAmountCollection.get(0));
                continue;
            }
            info.setOverAmount(null);
        }
    }

    private void processRepeatBill(Context ctx, CoreBaseCollection risks) throws BOSException, EASBizException {
        IRepeatBill localInstance = RepeatBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo info = (RiskModelInfo)risks.get(i);
            if ("com.kingdee.eas.base.risk.service.paySafe.CheckRepeatBill".equals(info.getRuleClazz())) {
                RepeatBillInfo repeatBill = info.getRepeatBill();
                if (repeatBill == null) continue;
                String srcBostype = repeatBill.getSrcBill().getBillBosType();
                String tarBostype = repeatBill.getTargetBill().getBillBosType();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("srcBill.billBosType", (Object)srcBostype));
                filter.getFilterItems().add(new FilterItemInfo("targetBill.billBosType", (Object)tarBostype));
                RepeatBillCollection repeatBillCollection = localInstance.getRepeatBillCollection(view);
                if (repeatBillCollection.isEmpty()) {
                    IObjectPK iObjectPK = localInstance.save(repeatBill);
                    continue;
                }
                info.setRepeatBill(repeatBillCollection.get(0));
                continue;
            }
            info.setRepeatBill(null);
        }
    }

    private String excludeRepeatData(Context ctx, CoreBaseCollection risks) throws BOSException {
        HashSet<String> riskNumbers = new HashSet<String>();
        for (int i = 0; i < risks.size(); ++i) {
            riskNumbers.add(((RiskModelInfo)risks.getObject(i)).getNumber());
        }
        RiskModelCollection collection = RiskModelFactory.getLocalInstance(ctx).getRiskModelCollection("select number where number in" + SqlFormatUtils.set2Sql(riskNumbers));
        String messge = "";
        block1: for (int i = 0; i < collection.size(); ++i) {
            String numberRepeat = collection.get(i).getNumber();
            messge = messge + numberRepeat + ",";
            for (int j = 0; j < risks.size(); ++j) {
                if (!numberRepeat.equals(risks.getObject(j).get("number"))) continue;
                risks.removeObject(j);
                continue block1;
            }
        }
        return messge == "" ? "" : collection.size() + "\u6761\u5bfc\u5165\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u98ce\u63a7\u6a21\u578b\u7f16\u7801\uff1a" + messge;
    }

    private void processRiskModels(CoreBaseCollection risks) {
        for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo baseInfo = (RiskModelInfo)risks.get(i);
            RiskModelInfo riskInfoForId = new RiskModelInfo();
            riskInfoForId.setId(baseInfo.getId());
            baseInfo.getFilterEntry().clear();
            ModelRuleEntryCollection modelRuleEntry = baseInfo.getModelRuleEntry();
            for (int j = 0; j < modelRuleEntry.size(); ++j) {
                FactorsFilterEntryCollection filterEntry = modelRuleEntry.get(j).getFilterEntry();
                for (int k = 0; k < filterEntry.size(); ++k) {
                    filterEntry.get(k).put("riskModel", riskInfoForId);
                }
            }
        }
    }

    private void checkGroupProcess(Context ctx, CoreBaseCollection risks) throws BOSException, SQLException, EASBizException {
        HashSet<String> checkGroups = new HashSet<String>();
        for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo info = (RiskModelInfo)risks.get(i);
            if (info.getCheckGroup() == null) continue;
            checkGroups.add(info.getCheckGroup().getNumber());
        }
        if (checkGroups.isEmpty()) {
            return;
        }
        String sql = "SELECT fid,fnumber FROM t_ris_checkgroup where fnumber in" + SqlFormatUtils.set2Sql(checkGroups);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> numberToId = new HashMap<String, String>();
        while (rowSet.next()) {
            numberToId.put(rowSet.getString(2), rowSet.getString(1));
            checkGroups.remove(rowSet.getString(2));
        }
        CoreBaseCollection groups = null;
        block2: for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo riskModel = (RiskModelInfo)risks.get(i);
            CheckGroupInfo checkGroup = riskModel.getCheckGroup();
            if (checkGroup == null) continue;
            if (numberToId.size() > 0) {
                Set entries = numberToId.entrySet();
                for (Map.Entry entry : entries) {
                    if (!entry.getKey().equals(checkGroup.getNumber())) continue;
                    checkGroups.remove(entry.getKey());
                    CheckGroupInfo checkGroupInfo = new CheckGroupInfo();
                    checkGroupInfo.setId(BOSUuid.read((String)entry.getValue().toString()));
                    riskModel.setCheckGroup(checkGroupInfo);
                    continue block2;
                }
            }
            if (checkGroups.isEmpty()) continue;
            for (String next : checkGroups) {
                if (!next.equals(checkGroup.getNumber())) continue;
                if (groups == null) {
                    groups = new CoreBaseCollection();
                }
                checkGroup.setCreateTime(this.createtime);
                checkGroup.setCU(this.ctrlUnitInfo);
                checkGroup.setCreator(this.userInfo);
                checkGroup.setSimpleName("\u5f15\u5165");
                groups.add((CoreBaseInfo)checkGroup);
                checkGroups.remove(next);
                continue block2;
            }
        }
        if (groups != null) {
            CheckGroupFactory.getRemoteInstance().saveBatchData(groups);
        }
    }

    private void riskFactorsProcess(Context ctx, CoreBaseCollection risks) throws BOSException, SQLException, EASBizException {
        HashSet<String> riskFactors = new HashSet<String>();
        for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo info = (RiskModelInfo)risks.get(i);
            if (info.getRiskFactors() == null) continue;
            riskFactors.add(info.getRiskFactors().getNumber());
        }
        if (riskFactors.isEmpty()) {
            return;
        }
        RiskFactorsCollection riskFactorsCollection = RiskFactorsFactory.getLocalInstance(ctx).getRiskFactorsCollection("SELECT * where number in" + SqlFormatUtils.set2Sql(riskFactors));
        String sql = "SELECT fid,fnumber FROM T_RIS_RiskFactors where fnumber in" + SqlFormatUtils.set2Sql(riskFactors);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> numberToId = new HashMap<String, String>();
        while (rowSet.next()) {
            numberToId.put(rowSet.getString(2), rowSet.getString(1));
            riskFactors.remove(rowSet.getString(2));
        }
        CoreBaseCollection factors = null;
        block2: for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo riskModel = (RiskModelInfo)risks.get(i);
            if (riskModel.getRiskFactors() == null) continue;
            if (!riskFactorsCollection.isEmpty()) {
                for (int j = 0; j < riskFactorsCollection.size(); ++j) {
                    RiskFactorsInfo riskFactorsInfo = riskFactorsCollection.get(j);
                    if (!riskFactorsInfo.getNumber().equals(riskModel.getRiskFactors().getNumber())) continue;
                    riskFactors.remove(riskFactorsInfo.getNumber());
                    riskModel.setRiskFactors(riskFactorsInfo);
                    continue block2;
                }
            }
            if (riskFactors.isEmpty()) continue;
            for (String next : riskFactors) {
                if (!next.equals(riskModel.getRiskFactors().getNumber())) continue;
                if (factors == null) {
                    factors = new CoreBaseCollection();
                }
                factors.add((CoreBaseInfo)riskModel.getRiskFactors());
                riskFactors.remove(next);
                continue block2;
            }
        }
        if (factors != null) {
            HashSet<String> bosTypes = new HashSet<String>();
            for (int i = 0; i < factors.size(); ++i) {
                RiskFactorsInfo info = (RiskFactorsInfo)factors.get(i);
                info.setCU(this.ctrlUnitInfo);
                info.setCreateTime(this.createtime);
                info.setCreator(this.userInfo);
                info.setSimpleName("\u5f15\u5165");
                bosTypes.add(info.getBillType().getBillBosType());
            }
            String sql1 = "SELECT fid,fbostype FROM T_RIS_billtype where fbostype in" + SqlFormatUtils.set2Sql(bosTypes);
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql1);
            while (set.next()) {
                String billTypeId = set.getString(1);
                String bostype = set.getString(2);
                for (int i = 0; i < factors.size(); ++i) {
                    RiskFactorsInfo info = (RiskFactorsInfo)factors.get(i);
                    if (!bostype.equals(info.getBillType().getBillBosType())) continue;
                    BillTypeInfo billTypeInfo = new BillTypeInfo();
                    billTypeInfo.setId(BOSUuid.read((String)billTypeId));
                    info.setBillType(billTypeInfo);
                }
            }
            RiskFactorsFactory.getRemoteInstance().addnewBatchData(factors);
        }
    }

    private void billTypeProcess(Context ctx, CoreBaseCollection risks) throws BOSException, SQLException, EASBizException {
        HashSet<String> bosTypes = new HashSet<String>();
        for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo info = (RiskModelInfo)risks.get(i);
            bosTypes.add(info.getTargetBillType().getBillBosType());
        }
        String sql = "SELECT fid,fbostype FROM T_RIS_billtype where fbostype in" + SqlFormatUtils.set2Sql(bosTypes);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> bosToId = new HashMap<String, String>();
        while (iRowSet.next()) {
            bosToId.put(iRowSet.getString(2), iRowSet.getString(1));
            bosTypes.remove(iRowSet.getString(2));
        }
        CoreBaseCollection billTypes = null;
        block2: for (int i = 0; i < risks.size(); ++i) {
            RiskModelInfo riskModel = (RiskModelInfo)risks.get(i);
            BillTypeInfo billType = riskModel.getTargetBillType();
            if (bosToId.size() > 0) {
                Set entries = bosToId.entrySet();
                for (Map.Entry entry : entries) {
                    if (!entry.getKey().equals(billType.getBOSType())) continue;
                    BillTypeInfo billTypeInfo = new BillTypeInfo();
                    billTypeInfo.setId(BOSUuid.read((String)entry.getValue().toString()));
                    riskModel.setTargetBillType(billTypeInfo);
                    continue block2;
                }
            }
            if (bosTypes.isEmpty()) continue;
            for (String next : bosTypes) {
                if (!next.equals(billType.getBillBosType())) continue;
                if (billTypes == null) {
                    billTypes = new CoreBaseCollection();
                }
                billType.setCreator(this.userInfo);
                billType.setCreateTime(this.createtime);
                billType.setCU(this.ctrlUnitInfo);
                billType.setSimpleName("\u5f15\u5165");
                billTypes.add((CoreBaseInfo)billType);
                bosTypes.remove(next);
                continue block2;
            }
        }
        if (billTypes != null) {
            BillTypeFactory.getRemoteInstance().saveBatchData(billTypes);
        }
    }
}

