/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.engine.exprEngin;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.risk.MetaDataType;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.service.common.ExprConvertUtil;
import com.kingdee.eas.base.risk.service.engine.IEngine;
import com.kingdee.eas.base.risk.service.engine.exprEngin.ProcessingPropListEngine;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class ExprEngine
extends ProcessingPropListEngine
implements IEngine {
    public static String[] functions = new String[]{"SUM", "AVG", "COUNT", "MAX", "MIN"};
    private static Logger logger = Logger.getLogger(ExprEngine.class);

    protected String replaceAllFixed(String expression, Map<String, Object> env) {
        String fixedPattern = "\\[\"(.*?)\"]";
        Matcher matcher = Pattern.compile(fixedPattern).matcher(expression);
        while (matcher.find()) {
            String group = matcher.group();
            expression = expression.replace(group, "'" + group.substring(2, group.length() - 2) + "'");
        }
        return expression;
    }

    @Override
    public Object getRealValue(Context ctx, RiskParam param, IObjectValue objectValue, CoreBaseInfo coreBaseInfo, MetaDataType metaDataType, String compareField, Map map) throws RiskException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        List propMapArr = (List)map.get("propMapArr");
        String expression = map.get("showExpress").toString();
        expression = expression.trim();
        expression = this.convertPression(expression);
        expression = this.replaceAllFixed(expression, env);
        String finalExpr = expression = this.otherProcess(ctx, expression, propMapArr, param, objectValue, coreBaseInfo, env);
        Object returnObj = this.getExprValue(ctx, finalExpr, param, objectValue, coreBaseInfo, propMapArr, env);
        return returnObj;
    }

    protected String otherProcess(Context ctx, String expression, List<Map> propMapArr, RiskParam param, IObjectValue objectValue, CoreBaseInfo coreBaseInfo, Map<String, Object> env) throws RiskException {
        expression = this.replaceAllField(ctx, expression, propMapArr, param, objectValue, coreBaseInfo, env);
        expression = this.processFunction(ctx, expression, propMapArr, param, objectValue, coreBaseInfo, env);
        return expression;
    }

    protected abstract String processFunction(Context var1, String var2, List<Map> var3, RiskParam var4, IObjectValue var5, CoreBaseInfo var6, Map<String, Object> var7) throws RiskException;

    protected String replaceAllField(Context ctx, String expression, List<Map> propMapArr, RiskParam param, IObjectValue objectValue, CoreBaseInfo coreBaseInfo, Map<String, Object> env) throws RiskException {
        for (int i = 0; i < propMapArr.size(); ++i) {
            Map propMap = propMapArr.get(i);
            String number = (String)propMap.get("number");
            String name = (String)propMap.get("name");
            StringBuffer bf = new StringBuffer();
            bf.append("[").append(number).append("|").append(name).append("]");
            Object realValue = this.getPropValue(ctx, param, objectValue, coreBaseInfo, number);
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                number = number.replaceAll("\\.", "__relation__");
            }
            env.put(number, realValue);
            expression = expression.replace(bf.toString(), number);
        }
        return expression;
    }

    protected abstract Object getPropValue(Context var1, RiskParam var2, IObjectValue var3, CoreBaseInfo var4, String var5) throws RiskException;

    protected String convertPression(String expression) {
        return ExprConvertUtil.convertPression(expression);
    }

    protected abstract Object getExprValue(Context var1, String var2, RiskParam var3, IObjectValue var4, CoreBaseInfo var5, List<Map> var6, Map<String, Object> var7) throws RiskException;
}

