/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.riskManage.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.risk.BillTypeInfo;
import com.kingdee.eas.base.risk.ControlMode;
import com.kingdee.eas.base.risk.ModelShowCollection;
import com.kingdee.eas.base.risk.ModelShowFactory;
import com.kingdee.eas.base.risk.RiskExecuteFacadeFactory;
import com.kingdee.eas.base.risk.RiskModelCollection;
import com.kingdee.eas.base.risk.RiskModelFactory;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.cache.RiskConfigUtils;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.base.risk.service.pojo.RiskResult;
import com.kingdee.eas.base.risk.service.riskManage.RiskBizService;
import com.kingdee.eas.base.risk.service.riskManage.RiskServiceEvent;
import com.kingdee.eas.base.risk.tools.commTools.ParamCheck;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RiskBizServiceImpl
extends RiskServiceEvent
implements RiskBizService {
    private static Logger logger = Logger.getLogger(RiskBizServiceImpl.class);

    @Override
    public List<RiskModelInfo> queryRiskModel(Context ctx, String billBostype, String pageUIPK, SelectorItemCollection selector) {
        try {
            ParamCheck.checkParamIsNotNull(ctx, billBostype, pageUIPK);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("targetBillType.billBosType", (Object)billBostype));
            Set<String> idSet = this.getRiskModelIdSet(ctx, billBostype, pageUIPK);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("controlModel", (Object)ControlMode.poTips));
            viewInfo.setFilter(filterInfo);
            selector = this.getRiskItemSelectors(ctx, selector);
            viewInfo.setSelector(selector);
            RiskModelCollection modelCollection = RiskModelFactory.getLocalInstance(ctx).getRiskModelCollection(viewInfo);
            ArrayList<RiskModelInfo> list = new ArrayList<RiskModelInfo>(modelCollection.size());
            for (int i = 0; i < modelCollection.size(); ++i) {
                list.add(modelCollection.get(i));
            }
            return list;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            logger.error((Object)"queryRiskModel error");
            if ("DEFAULT".equals(billBostype)) {
                return this.queryDefRiskModel(ctx);
            }
            return new ArrayList<RiskModelInfo>();
        }
    }

    private List<RiskModelInfo> queryDefRiskModel(Context ctx) {
        ArrayList<RiskModelInfo> list = new ArrayList<RiskModelInfo>();
        for (int i = 0; i < 20; ++i) {
            RiskModelInfo info = new RiskModelInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setNumber("RISK-2021-07-" + i);
            info.setName("\u98ce\u63a7\u6a21\u578b-000" + i);
            info.setControlModel(ControlMode.poTips);
            info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.create((BOSObjectType)billTypeInfo.getBOSType()));
            billTypeInfo.setNumber("com.kingdee.eas.fi.cas.PaymentBill");
            billTypeInfo.setNumber("\u4ed8\u6b3e\u5355");
            info.setTargetBillType(billTypeInfo);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.create((BOSObjectType)userInfo.getBOSType()));
            userInfo.setName("\u6d4b\u8bd5\u7528\u6237");
            info.setCreator(userInfo);
            list.add(info);
        }
        return list;
    }

    private SelectorItemCollection getRiskItemSelectors(Context ctx, SelectorItemCollection selector) {
        if (selector == null) {
            selector = new SelectorItemCollection();
        }
        selector.add("id");
        selector.add("targetBillType.id");
        selector.add("targetBillType.number");
        selector.add("targetBillType.name");
        selector.add("creator.id");
        selector.add("creator.number");
        selector.add("creator.name");
        selector.add("lastUpdateTime");
        return selector;
    }

    protected Set<String> getRiskModelIdSet(Context ctx, String billBostype, String pageUIPK) throws BOSException, SQLException {
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer buffer = new StringBuffer(500);
        buffer.append(" select rm.fid from T_RIS_RISKMODEL rm ");
        buffer.append(" inner join T_RIS_DesignerEntry de on de.fparentid = rm.fid  ");
        buffer.append(" inner join T_RIS_BILLTYPE bt on bt.fid = rm.FTARGETBILLTYPEID ");
        buffer.append(" inner join T_RIS_RiskDesigner rd on de.fdesignerId = rd.fid ");
        buffer.append(" inner join T_RIS_PageEntry pe on pe.FParentId = rd.FId ");
        buffer.append(" WHERE bt.FBosType = ? ");
        buffer.append(" and rd.FControlModel = 'POTIPS' ");
        buffer.append(" and pe.FpageUIPK = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{billBostype, pageUIPK});
        while (rowSet.next()) {
            idSet.add(rowSet.getString(1));
        }
        return idSet;
    }

    @Override
    public RiskResult getModelRisk(Context ctx, String billId, String pageUIPK, List<String> pointRiskModelIds) {
        if (!RiskConfigUtils.existUipk(ctx, pageUIPK)) {
            logger.error((Object)("getModelRisk--notExistUipkCache[pageUIPK:" + pageUIPK + "]"));
            return this.defaultResult(ctx, billId);
        }
        RiskParam riskParam = RiskParam.builder();
        riskParam.getParams().put("__$$pointRiskModelIds", pointRiskModelIds);
        riskParam.setBillId(billId);
        try {
            List designers = RiskExecuteFacadeFactory.getLocalInstance(ctx).getDesignersByUipk(pageUIPK);
            if (designers == null || designers.size() == 0) {
                logger.error((Object)("getModelRisk designers is null or size=0;[billId:" + billId + ",uipk:" + pageUIPK + ",pointRiskModelIds:" + pointRiskModelIds + "]return defalut[allExecSuccess true]"));
                return this.defaultResult(ctx, billId);
            }
            riskParam.setDesignerList(designers);
        }
        catch (Throwable e) {
            logger.error((Object)("getModelRisk exception;[billId:" + billId + ",uipk:" + pageUIPK + ",pointRiskModelIds:" + pointRiskModelIds + "]return defalut[allExecSuccess true]"));
            logger.error((Object)e, e);
            return this.defaultResult(ctx, billId);
        }
        riskParam.setBillId(billId);
        return this.getPoTipsRiskResult(ctx, riskParam);
    }

    public RiskResult getPoTipsRiskResult(Context ctx, RiskParam param) {
        param.setControlMode(ControlMode.poTips);
        return this.doRiskBus(ctx, param);
    }

    @Override
    public RiskResult getModelRiskByRiskOrg(Context ctx, String billId, String pageUIPK, List<String> pointRiskModelOrgIds) {
        List<String> riskModels = this.getRiskModelByModelOrg(ctx, pointRiskModelOrgIds);
        return this.getModelRisk(ctx, billId, pageUIPK, riskModels);
    }

    protected List<String> getRiskModelByModelOrg(Context ctx, List<String> pointRiskModelOrgIds) {
        HashSet<String> ids = new HashSet<String>();
        for (String modelId : pointRiskModelOrgIds) {
            ids.add(modelId);
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("riskModel.id"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        ev.setFilter(filter);
        ArrayList<String> list = new ArrayList<String>();
        try {
            ModelShowCollection coll = ModelShowFactory.getLocalInstance(ctx).getModelShowCollection(ev);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    list.add(coll.get(i).getRiskModel().getId().toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return list;
    }
}

