/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.riskManage.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.risk.ControlMode;
import com.kingdee.eas.base.risk.OutPutType;
import com.kingdee.eas.base.risk.ParamEntryCollection;
import com.kingdee.eas.base.risk.ParamEntryInfo;
import com.kingdee.eas.base.risk.RiskBizException;
import com.kingdee.eas.base.risk.RiskDesignerInfo;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskExecuteFacadeFactory;
import com.kingdee.eas.base.risk.cache.RiskConfigUtils;
import com.kingdee.eas.base.risk.service.common.ArgsProcess;
import com.kingdee.eas.base.risk.service.common.ForcedParamConvertUtil;
import com.kingdee.eas.base.risk.service.pojo.BatchRiskResult;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.base.risk.service.pojo.RiskResult;
import com.kingdee.eas.base.risk.service.pojo.TypeAttr;
import com.kingdee.eas.base.risk.service.pojo.WeakRiskType;
import com.kingdee.eas.base.risk.service.riskManage.RiskForceService;
import com.kingdee.eas.base.risk.service.riskManage.RiskServiceEvent;
import com.kingdee.eas.base.risk.service.wfEngine.RiskNExceptionSubItem;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RiskForceServiceImpl
extends RiskServiceEvent
implements RiskForceService {
    private static Logger logger = Logger.getLogger(RiskForceServiceImpl.class);

    @Override
    public void forcedRisk(Context ctx, BOSObjectType bosType, IMetaDataPK metaDataPK, Object[] args) throws BOSException, EASBizException, RiskBizException {
        try {
            if (!RiskConfigUtils.existFunction(ctx, bosType, metaDataPK)) {
                logger.error((Object)("getModelRisk--existFunction[bosType:" + bosType.toString() + ",metaDataPK:" + metaDataPK.toString() + "]"));
                return;
            }
            args = ArgsProcess.removeArgsContext(ctx, args);
            String billId = null;
            List<String> billIds = null;
            IObjectValue model = null;
            List<IObjectValue> modelList = null;
            List designers = RiskExecuteFacadeFactory.getLocalInstance(ctx).getDesignersByMethodPK(bosType, metaDataPK, args);
            if (designers == null || designers.size() == 0) {
                logger.error((Object)("forcedRisk designers is null or size=0;[bosType:" + bosType + "metaDataPK:" + metaDataPK + "]"));
                return;
            }
            RiskDesignerInfo designerInfo = (RiskDesignerInfo)designers.get(0);
            ParamEntryCollection paramEntry = designerInfo.getParamEntry();
            for (int i = 0; i < paramEntry.size(); ++i) {
                ParamEntryInfo paramEntryInfo = paramEntry.get(i);
                if (!paramEntryInfo.isRequiredParam()) continue;
                OutPutType outPutType = paramEntryInfo.getOutPutType();
                if (OutPutType.BOSUuid.equals((Object)outPutType) || OutPutType.IObjectPK.equals((Object)outPutType) || OutPutType.String.equals((Object)outPutType)) {
                    billId = ForcedParamConvertUtil.convertToBillId(ctx, paramEntryInfo, args[i]);
                    if (BOSUuid.isValid((String)billId, (boolean)false)) break;
                    throw new RiskException(new NumericExceptionSubItem("00", "convertToBillId parameter convert error[billId is IllegalArgument,transform after billId->" + billId + "]"));
                }
                if (OutPutType.String_arr.equals((Object)outPutType) || OutPutType.IObjectPK_arr.equals((Object)outPutType) || OutPutType.List_String.equals((Object)outPutType) || OutPutType.Set_String.equals((Object)outPutType)) {
                    billIds = ForcedParamConvertUtil.convertToBillIds(ctx, paramEntryInfo, args[i]);
                    for (String item : billIds) {
                        if (BOSUuid.isValid((String)item, (boolean)false)) continue;
                        throw new RiskException(new NumericExceptionSubItem("00", "convertToBillIds parameter convert error[billId is IllegalArgument,transform after item->" + item + "]"));
                    }
                    break;
                }
                if (OutPutType.IObjectValue.equals((Object)outPutType)) {
                    model = ForcedParamConvertUtil.convertToModel(ctx, paramEntryInfo, args[i]);
                    break;
                }
                if (OutPutType.List_IObjectValue.equals((Object)outPutType) || OutPutType.Set_IObjectValue.equals((Object)outPutType) || OutPutType.IObjectCollection.equals((Object)outPutType)) {
                    modelList = ForcedParamConvertUtil.convertToModelList(ctx, paramEntryInfo, args[i]);
                    break;
                }
                throw new RiskException(new NumericExceptionSubItem("00", "parameter convert error[not support outPutType" + (Object)((Object)outPutType) + "]"));
            }
            if (StringUtils.isNotEmpty(billId)) {
                this.matchingId(ctx, billId, designers);
            } else if (billIds != null && billIds.size() > 0) {
                this.matchingBillIds(ctx, billIds, designers);
            } else if (model != null) {
                this.matchingModel(ctx, model, designers);
            } else if (modelList != null && modelList.size() > 0) {
                this.matchingModelList(ctx, modelList, designers);
            }
            logger.error((Object)("billId is empty;billIds is empty;model is null;modelList is null; risk over;metaDataPK:[" + metaDataPK + "]"));
            return;
        }
        catch (Throwable e) {
            if (e instanceof RiskBizException) {
                logger.error((Object)e.getMessage(), e);
                throw (RiskBizException)((Object)e);
            }
            logger.error((Object)("forcedRisk exception;Exception is not instanceof RiskBizException;metaDataPK:[" + metaDataPK + "]"));
            logger.error((Object)e, e);
            if (e instanceof BOSException) {
                throw (BOSException)e;
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)e;
            }
            return;
        }
    }

    protected void matchingModelList(Context ctx, List<IObjectValue> modelList, List<RiskDesignerInfo> designers) throws BOSException, EASBizException, RiskBizException {
        BatchRiskResult batch = new BatchRiskResult();
        List<RiskResult> successDetail = batch.getSuccessDetail();
        List<RiskResult> failDetail = batch.getFailDetail();
        for (IObjectValue model : modelList) {
            RiskParam riskParam = RiskParam.builder();
            riskParam.setModel(model).setBillId(model.get("id") == null ? "TEMP" + model.getBOSType() + riskParam.getDataSnapshot().getBatchNumber() : model.get("id").toString()).setControlMode(ControlMode.funControl).setDesignerList(designers);
            RiskResult riskResult = this.doRiskBus(ctx, riskParam);
            if (riskResult.isAllExecSuccess()) {
                batch.addSuccessNum();
                successDetail.add(riskResult);
                continue;
            }
            batch.addFailNum();
            failDetail.add(riskResult);
        }
        if (batch.getFailNum() > 0) {
            StringBuilder builder = this.throwErrorException(ctx, batch, failDetail);
            String risk = JSONObject.toJSONString((Object)batch, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            throw new RiskBizException(new RiskNExceptionSubItem("00", builder.toString(), risk));
        }
    }

    protected StringBuilder throwErrorException(Context ctx, BatchRiskResult batch, List<RiskResult> failDetail) throws RiskBizException {
        StringBuilder message = new StringBuilder(1000);
        message.append("\u6210\u529f\u6761\u6570\uff1a").append(batch.getSuccessNum()).append(",").append("\u5931\u8d25\u6761\u6570\uff1a").append(batch.getFailNum()).append(";").append("\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a\n");
        for (RiskResult rr : failDetail) {
            message.append(rr.getBillNumber()).append("\n").append((CharSequence)this.getRiskErrorMsg(ctx, rr));
        }
        return message;
    }

    protected void matchingModel(Context ctx, IObjectValue model, List<RiskDesignerInfo> designers) throws BOSException, EASBizException, RiskBizException {
        RiskParam riskParam = this.initRiskParam(ctx, RiskParam.builder(), model, ControlMode.funControl, designers);
        RiskResult riskResult = this.doRiskBus(ctx, riskParam);
        if (!riskResult.isAllExecSuccess()) {
            StringBuilder builder = this.getRiskErrorMsg(ctx, riskResult);
            String risk = JSONObject.toJSONString((Object)riskResult, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            throw new RiskBizException(new RiskNExceptionSubItem("00", builder.toString(), risk));
        }
    }

    protected void matchingId(Context ctx, String billId, List<RiskDesignerInfo> designers) throws RiskBizException {
        RiskParam riskParam = this.initRiskParam(ctx, RiskParam.builder(), billId, ControlMode.funControl, designers);
        RiskResult riskResult = this.doRiskBus(ctx, riskParam);
        if (!riskResult.isAllExecSuccess()) {
            StringBuilder builder = this.getRiskErrorMsg(ctx, riskResult);
            String risk = JSONObject.toJSONString((Object)riskResult, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            throw new RiskBizException(new RiskNExceptionSubItem("00", builder.toString(), risk));
        }
    }

    protected void matchingBillIds(Context ctx, List<String> billIds, List<RiskDesignerInfo> designers) throws RiskBizException {
        BatchRiskResult riskBatch = this.getRiskBatch(ctx, billIds, designers, ControlMode.funControl);
        if (riskBatch.getFailNum() > 0) {
            StringBuilder builder = this.throwErrorException(ctx, riskBatch, riskBatch.getFailDetail());
            String risk = JSONObject.toJSONString((Object)riskBatch, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            throw new RiskBizException(new RiskNExceptionSubItem("00", builder.toString(), risk));
        }
    }

    protected StringBuilder getRiskErrorMsg(Context ctx, RiskResult riskResult) {
        int nu = 1;
        StringBuilder builder = new StringBuilder();
        List<WeakRiskType> list = riskResult.getList();
        for (int i = 0; list != null && i < list.size(); ++i) {
            WeakRiskType weakRiskType = list.get(i);
            List<TypeAttr> items = weakRiskType.getList();
            for (int j = 0; items != null && j < items.size(); ++j) {
                if (items.get(j).isRiskResult()) continue;
                TypeAttr typeAttr = items.get(j);
                builder.append(" ").append(nu).append(":").append(typeAttr.getExplains());
                List<Map<String, Object>> billOpts = typeAttr.getBillOpts();
                if (billOpts != null && billOpts.size() > 0) {
                    for (int k = 0; k < billOpts.size(); ++k) {
                        Object fieldName = billOpts.get(k).get("fieldName");
                        Object value = billOpts.get(k).get("fieldValue");
                        if (k == 0) {
                            builder.append("[");
                        }
                        builder.append(fieldName).append(":").append(value);
                        if (k < billOpts.size() - 1) {
                            builder.append(";");
                        }
                        if (k != billOpts.size() - 1) continue;
                        builder.append("]");
                    }
                }
                builder.append("\n");
                ++nu;
            }
        }
        return builder;
    }
}

