/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.riskManage.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.risk.ControlMode;
import com.kingdee.eas.base.risk.RiskExecuteFacadeFactory;
import com.kingdee.eas.base.risk.cache.RiskConfigUtils;
import com.kingdee.eas.base.risk.cache.RiskSysParam;
import com.kingdee.eas.base.risk.service.common.DateFormatUtil;
import com.kingdee.eas.base.risk.service.pojo.BatchRiskResult;
import com.kingdee.eas.base.risk.service.pojo.RiskResult;
import com.kingdee.eas.base.risk.service.riskManage.RiskServiceEvent;
import com.kingdee.eas.base.risk.service.riskManage.RiskUIService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RiskUIServiceImpl
extends RiskServiceEvent
implements RiskUIService {
    private static Logger logger = Logger.getLogger(RiskUIServiceImpl.class);

    protected List getRiskBillOperDesigner(Context ctx, String uipk, String action) {
        try {
            List designers = RiskExecuteFacadeFactory.getLocalInstance(ctx).getDesignersByUipkAction(uipk, action);
            if (designers != null && designers.size() != 0) {
                return designers;
            }
            logger.error((Object)("getRiskBillOperDesigner designers is null or size=0;[uipk:" + uipk + ",action:" + action + "]"));
        }
        catch (Throwable e) {
            logger.error((Object)("getRiskBillOperDesigner exception;[uipk:" + uipk + ",action:" + action + "]"));
            logger.error((Object)e, e);
        }
        return null;
    }

    protected List getRiskPotipsDesigner(Context ctx, String uipk) {
        try {
            List designers = RiskExecuteFacadeFactory.getLocalInstance(ctx).getDesignersByUipk(uipk);
            if (designers == null || designers.size() == 0) {
                logger.error((Object)("getRiskPotipsDesigner designers is null or size=0;[uipk:" + uipk + "]"));
            }
            return designers;
        }
        catch (Throwable e) {
            logger.error((Object)("getRiskPotipsDesigner exception;[uipk:" + uipk + "]"));
            logger.error((Object)e, e);
            return null;
        }
    }

    @Override
    public RiskResult getActionRiskForModel(Context ctx, IObjectValue modelValue, String uipk, String action) {
        Object idObj = modelValue.get("id");
        String billId = null;
        if (idObj != null) {
            billId = idObj.toString();
        }
        if (StringUtils.isEmpty(billId)) {
            billId = System.currentTimeMillis() + (long)Math.round(100.0f) + "";
        }
        if (StringUtils.isNotEmpty((CharSequence)action) && action.contains("$") && action.split("\\$").length == 2) {
            action = action.substring(action.indexOf("$") + 1);
        }
        if (!RiskSysParam.risk_enable(ctx) || !RiskConfigUtils.existUipkAction(ctx, uipk, action)) {
            logger.error((Object)("getActionRisk--existUipkAction[uipk:" + uipk + ",action:" + action + "]"));
            return this.defaultResult(ctx, billId);
        }
        List designers = this.getRiskBillOperDesigner(ctx, uipk, action);
        if (designers == null || designers.size() == 0) {
            logger.error((Object)("getRisk designers is null or size=0;[billId:" + billId + ",uipk:" + uipk + ",action:" + action + "]"));
            return this.defaultResult(ctx, billId);
        }
        String execBatchNumber = DateFormatUtil.getBatchNumber();
        RiskResult risk = this.getRisk(ctx, modelValue, designers, ControlMode.billOper, execBatchNumber);
        risk.setExecBatchNumber(execBatchNumber);
        return risk;
    }

    @Override
    public RiskResult getWeakRiskForModel(Context ctx, IObjectValue modelValue, String uipk) {
        Object pk = modelValue.get("id");
        if (!RiskSysParam.risk_enable(ctx) || !RiskConfigUtils.existUipk(ctx, uipk)) {
            logger.error((Object)("getActionRiskForModel risk_enable is false--existUipk[uipk:" + uipk + "]"));
            Object number = modelValue.get("number");
            if (pk != null) {
                return this.defaultResult(ctx, modelValue.get("id").toString());
            }
            if (number != null) {
                return this.defaultResult(ctx, modelValue.get("number").toString());
            }
            return this.defaultResult(ctx, modelValue.toString());
        }
        List designers = this.getRiskPotipsDesigner(ctx, uipk);
        if (designers == null || designers.size() == 0) {
            logger.error((Object)("getWeakRiskForModel designers is null or size=0;[uipk:" + uipk + "]return defalut[allExecSuccess true]"));
            return this.defaultResult(ctx, pk.toString());
        }
        return this.getRisk(ctx, modelValue, designers, ControlMode.poTips, null);
    }

    @Override
    public RiskResult getWeakRisk(Context ctx, String billId, String uipk) {
        if (!RiskSysParam.risk_enable(ctx)) {
            logger.error((Object)"getActionRiskForModel risk_enable is false");
            return this.defaultResult(ctx, billId);
        }
        if (!RiskConfigUtils.existUipk(ctx, uipk)) {
            logger.error((Object)("getWeakRisk--existUipk[uipk:" + uipk + "]"));
            return this.defaultResult(ctx, billId);
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        List designers = this.getRiskPotipsDesigner(ctx, uipk);
        if (designers == null || designers.size() == 0) {
            logger.error((Object)("getWeakRisk designers is null or size=0;[billId:" + billId + ",uipk:" + uipk + "]return defalut[allExecSuccess true]"));
            return this.defaultResult(ctx, billId);
        }
        return this.getRisk(ctx, billId, designers, ControlMode.poTips, null);
    }

    @Override
    public BatchRiskResult getWeakRiskBatch(Context ctx, List<String> billIds, String uipk) {
        if (!RiskSysParam.risk_enable(ctx)) {
            logger.error((Object)"getWeakRiskBatch risk_enable is false");
            return this.defaultResultBatch(ctx, billIds);
        }
        if (!RiskConfigUtils.existUipk(ctx, uipk)) {
            logger.error((Object)("getWeakRiskBatch--existUipk[uipk:" + uipk + "]"));
            return this.defaultResultBatch(ctx, billIds);
        }
        List riskDesigner = this.getRiskPotipsDesigner(ctx, uipk);
        return this.getRiskBatch(ctx, billIds, riskDesigner, ControlMode.poTips);
    }

    @Override
    public BatchRiskResult getActionRiskBatch(Context ctx, List<String> billIds, String uipk, String action) {
        if (!RiskSysParam.risk_enable(ctx)) {
            logger.error((Object)"getActionRiskBatch risk_enable is false");
            return this.defaultResultBatch(ctx, billIds);
        }
        if (StringUtils.isNotEmpty((CharSequence)action) && action.contains("$") && action.split("\\$").length == 2) {
            action = action.substring(action.indexOf("$") + 1);
        }
        if (!RiskConfigUtils.existUipkAction(ctx, uipk, action)) {
            logger.error((Object)("getActionRiskBatch--existUipkAction[uipk:" + uipk + ",action:" + action + "]"));
            return this.defaultResultBatch(ctx, billIds);
        }
        List riskDesigner = this.getRiskBillOperDesigner(ctx, uipk, action);
        return this.getRiskBatch(ctx, billIds, riskDesigner, ControlMode.billOper);
    }

    @Override
    public RiskResult getActionRisk(Context ctx, String billId, String uipk, String action) {
        if (StringUtils.isEmpty((CharSequence)billId)) {
            billId = System.currentTimeMillis() + (long)Math.round(100.0f) + "";
        }
        if (!RiskSysParam.risk_enable(ctx)) {
            logger.error((Object)"getActionRiskBatch risk_enable is false");
            return this.defaultResult(ctx, billId);
        }
        if (StringUtils.isNotEmpty((CharSequence)action) && action.contains("$") && action.split("\\$").length == 2) {
            action = action.substring(action.indexOf("$") + 1);
        }
        if (!RiskConfigUtils.existUipkAction(ctx, uipk, action)) {
            logger.error((Object)("getActionRisk--existUipkAction[uipk:" + uipk + ",action:" + action + "]"));
            return this.defaultResult(ctx, billId);
        }
        List designers = this.getRiskBillOperDesigner(ctx, uipk, action);
        if (designers == null || designers.size() == 0) {
            logger.error((Object)("getRisk designers is null or size=0;[billId:" + billId + ",uipk:" + uipk + ",action:" + action + "]"));
            return this.defaultResult(ctx, billId);
        }
        String execBatchNumber = DateFormatUtil.getBatchNumber();
        RiskResult risk = this.getRisk(ctx, billId, designers, ControlMode.billOper, execBatchNumber);
        risk.setExecBatchNumber(execBatchNumber);
        return risk;
    }

    @Override
    public List<String> queryActions(Context ctx, String uipk) {
        ArrayList<String> actions = new ArrayList<String>();
        try {
            return RiskConfigUtils.getUipkAction(ctx, uipk);
        }
        catch (Exception e) {
            logger.error((Object)("getActions exception[uipk:" + uipk + "]"));
            logger.error((Object)e, (Throwable)e);
            return actions;
        }
    }
}

