/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.tools.apiconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.risk.SysEnum;
import com.kingdee.eas.base.risk.app.exsystem.ExSystemConfigInfo;
import com.kingdee.eas.base.risk.app.exsystem.api.ApiConfigInfo;
import com.kingdee.eas.base.risk.app.exsystem.api.ApiParamCollection;
import com.kingdee.eas.base.risk.app.exsystem.api.ApiParamInfo;
import com.kingdee.eas.base.risk.app.exsystem.api.DirectionParamEnum;
import com.kingdee.eas.base.risk.app.exsystem.api.execute.Executor;
import com.kingdee.eas.base.risk.app.exsystem.api.execute.handler.AbstractChainHandler;
import com.kingdee.eas.base.risk.app.exsystem.api.execute.handler.impl.LoginNodeHandler;
import com.kingdee.eas.base.risk.app.exsystem.api.execute.handler.impl.daas.ApiGwNodeHandler;
import com.kingdee.eas.base.risk.app.exsystem.api.execute.handler.impl.daas.GetCompanyIdNodeHandler;
import com.kingdee.eas.base.risk.app.exsystem.api.execute.pojo.ApiHttpNode;
import com.kingdee.eas.base.risk.app.exsystem.api.execute.pojo.ExecuteChain;
import com.kingdee.eas.base.risk.cache.ApiConfigCache;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CallUtils {
    private static Logger logger = Logger.getLogger(CallUtils.class);

    public static List<Map<String, Object>> getAPIResult(Context ctx, ApiConfigInfo apiInfo, List<Map<String, Object>> paramIn) throws Exception {
        apiInfo = ApiConfigCache.getApiConfigInfoCache(ctx, apiInfo.getId().toString());
        ExSystemConfigInfo systemConfigInfo = ApiConfigCache.getExSystemInfoCache(ctx, apiInfo.getSystemConfig().getId().toString());
        apiInfo.setSystemConfig(systemConfigInfo);
        final ExecuteChain<ApiHttpNode> chain = new ExecuteChain<ApiHttpNode>();
        chain.add(new LoginNodeHandler());
        if (systemConfigInfo.getSysType().equals((Object)SysEnum.KINGDEE)) {
            chain.add(new GetCompanyIdNodeHandler());
            chain.add(new ApiGwNodeHandler());
        }
        Executor<ApiHttpNode> executor = new Executor<ApiHttpNode>();
        executor.ctx(ctx).chains(new AbstractChainHandler<ApiHttpNode>(){

            @Override
            public void initChains(Context ctx) {
                this.addChains(chain);
            }
        });
        ApiHttpNode apiHttpNode = new ApiHttpNode();
        apiHttpNode.setApiInfo(apiInfo);
        apiHttpNode.setParamIn(paramIn);
        List<ApiHttpNode> execute = executor.execute(apiHttpNode);
        if (execute == null || execute.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ApiHttpNode node = execute.get(0);
        List<String> jsonData = node.getResult();
        List<Map<String, Object>> result = CallUtils.jsonToApiParam(ctx, apiInfo, jsonData);
        return result;
    }

    private static List<Map<String, Object>> jsonToApiParam(Context ctx, ApiConfigInfo apiInfo, List<String> jsonData) {
        ApiParamCollection apiParam = apiInfo.getApiParam();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> outParam = new HashMap<String, Object>();
        for (int i = 0; i < apiParam.size(); ++i) {
            ApiParamInfo pInfo = apiParam.get(i);
            if (!pInfo.getDirection().equals((Object)DirectionParamEnum.OUT) || pInfo.getParent() != null) continue;
            if (pInfo.getType().equals("array")) {
                outParam.put(pInfo.getLongnumber(), new JSONArray());
                continue;
            }
            if (pInfo.getType().equals("obj")) {
                outParam.put(pInfo.getLongnumber(), new JSONObject());
                continue;
            }
            if (pInfo.getType().equals("string")) {
                outParam.put(pInfo.getLongnumber(), "");
                continue;
            }
            if (!pInfo.getType().equals("number") && !pInfo.getType().equals("boolean")) continue;
            outParam.put(pInfo.getLongnumber(), null);
        }
        HashMap map = null;
        for (String apiJson : jsonData) {
            if (StringUtils.isEmpty((String)apiJson)) continue;
            map = new HashMap(outParam);
            JSONObject data = JSONObject.parseObject((String)apiJson);
            if (data.isEmpty()) continue;
            for (Map.Entry entry : data.entrySet()) {
                if (entry.getValue() instanceof JSONObject || entry.getValue() instanceof JSONArray) {
                    map.put(DirectionParamEnum.OUT.getName() + "@P@" + (String)entry.getKey(), entry.getValue());
                    continue;
                }
                map.put(DirectionParamEnum.OUT.getName() + "@P@" + (String)entry.getKey(), entry.getValue() + "");
            }
            result.add(map);
        }
        return result;
    }
}

