/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.rpa.AutoReqBillInfo;
import com.kingdee.eas.base.rpa.RpaScheduleFactory;
import com.kingdee.eas.base.rpa.app.AbstractAutoReqBillControllerBean;
import com.kingdee.eas.base.rpa.app.RpaException;
import com.kingdee.eas.base.rpa.app.RpaReqBillStatus;
import com.kingdee.eas.base.rpa.util.Json;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class AutoReqBillControllerBean
extends AbstractAutoReqBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.rpa.app.AutoReqBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AutoReqBillInfo info = (AutoReqBillInfo)model;
        this.checkBeforeAddNew(ctx, info);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AutoReqBillInfo info = (AutoReqBillInfo)model;
        this.checkBeforeAddNew(ctx, info);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AutoReqBillInfo info = (AutoReqBillInfo)model;
        this.checkBeforeUpdate(ctx, pk, info);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        this.innerUpdatePartial(ctx, model, selector);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AutoReqBillInfo info = (AutoReqBillInfo)model;
        this.checkBeforeSubmit(ctx, info);
        info.setReqUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setReqDate(new Date());
        info.setStatu(RpaReqBillStatus.SUBMIT);
        return super._submit(ctx, (IObjectValue)info);
    }

    private void checkBeforeAddNew(Context ctx, AutoReqBillInfo info) throws EASBizException, BOSException {
        if (this.exists(ctx, "where  number = '" + info.getNumber() + "'")) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
    }

    private void checkBeforeUpdate(Context ctx, IObjectPK pk, AutoReqBillInfo info) throws EASBizException, BOSException {
        AutoReqBillInfo autoReqBillInfo = this.getAutoReqBillInfo(ctx, pk);
        if (autoReqBillInfo.getStatu() != RpaReqBillStatus.DRAFT && autoReqBillInfo.getStatu() != RpaReqBillStatus.CHECKFAILED) {
            throw new RpaException(RpaException.AUTOREQBILLSAVEFAIL, new Object[]{"\u53ea\u8981\u6682\u5b58\u6216\u5ba1\u6838\u5931\u8d25\u72b6\u6001\u624d\u80fd\u4fee\u6539\uff01"});
        }
        if (this.exists(ctx, "where id <> '" + pk.toString() + "' and number = '" + info.getNumber() + "'")) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
    }

    private void checkBeforeSubmit(Context ctx, AutoReqBillInfo info) throws EASBizException, BOSException {
        BOSUuid id = info.getId();
        if (id != null && this.exists(ctx, (IObjectPK)new ObjectStringPK(id.toString()))) {
            AutoReqBillInfo autoReqBillInfo = this.getAutoReqBillInfo(ctx, (IObjectPK)new ObjectStringPK(id.toString()));
            if (autoReqBillInfo.getStatu() == RpaReqBillStatus.SUBMIT) {
                throw new RpaException(RpaException.AUTOREQBILLSUBMITFAIL, new Object[]{"\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\uff01"});
            }
            if (autoReqBillInfo.getStatu() != RpaReqBillStatus.DRAFT && autoReqBillInfo.getStatu() != RpaReqBillStatus.CHECKFAILED) {
                throw new RpaException(RpaException.AUTOREQBILLSUBMITFAIL, new Object[]{"\u53ea\u8981\u6682\u5b58\u6216\u5ba1\u6838\u5931\u8d25\u72b6\u6001\u624d\u80fd\u63d0\u4ea4\uff01"});
            }
        }
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, RpaReqBillStatus.CHECKFAILED);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, RpaReqBillStatus.CHECKING);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        AutoReqBillInfo info = new AutoReqBillInfo();
        info.setId(billId);
        info.setAuditor(new UserInfo(auditorId.toString()));
        info.setAuditDate(new Date());
        info.setStatu(RpaReqBillStatus.CHECKED);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("statu"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        this.updatePartial(ctx, info, sic);
        try {
            this._postProcessAfter(ctx, billId);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void _setSubmitState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, RpaReqBillStatus.SUBMIT);
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, RpaReqBillStatus.DRAFT);
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setStatu(ctx, billId, RpaReqBillStatus.CLOSE);
    }

    @Override
    protected void _setStatu(Context ctx, BOSUuid bilId, RpaReqBillStatus statu) throws BOSException, EASBizException {
        AutoReqBillInfo info = new AutoReqBillInfo();
        info.setId(bilId);
        info.setStatu(statu);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("statu"));
        this.updatePartial(ctx, info, sic);
    }

    @Override
    protected boolean _updateStatus(Context ctx, String billId, int status) throws BOSException, EASBizException {
        AutoReqBillInfo info = new AutoReqBillInfo();
        info.setId(BOSUuid.read((String)billId));
        info.setStatu(RpaReqBillStatus.getEnum(String.valueOf(status)));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("statu"));
        this.updatePartial(ctx, info, sic);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getAttachMentData(Context ctx, String billId) throws BOSException, EASBizException {
        String fileData = "";
        IAttachmentFtpFacade iAttachmentFacade = AttachmentFtpFacadeFactory.getLocalInstance((Context)ctx);
        FileOutputStream fos = null;
        try {
            String attachmentId = this.getAttchIDByBoId(ctx, billId);
            long startPos = 0L;
            AttachmentFtpInfo.init();
            while (true) {
                byte[] content;
                if ((content = iAttachmentFacade.downloadFile(attachmentId, startPos)) == null || content.length == 0) break;
                fileData = new BASE64Encoder().encode(content);
                fileData = fileData.replaceAll("\r|\n", "");
            }
            logger.error((Object)"*****AttachmentDownloadClient*****content is null**************");
            byte[] bytes = new BASE64Decoder().decodeBuffer(fileData);
            File f = new File("C:/reqbill/reqbill" + System.currentTimeMillis() + ".xlsx");
            fos = new FileOutputStream(f);
            fos.write(bytes);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return fileData;
    }

    protected String getAttchIDByBoId(Context ctx, String boID) throws BOSException {
        String attchID = "";
        RowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String sql = "select a.FID from T_BAS_Attachment a inner join T_BAS_BoAttchAsso b on a.FID=b.FAttachmentID where b.FBoID='" + boID + "'";
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            rs.next();
            attchID = rs.getString(1);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return attchID;
    }

    @Override
    protected void _postProcessAfter(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._postRpaScheduler(ctx, billId, null);
    }

    @Override
    protected String _getRpaParams(Context ctx, String billId) throws BOSException, EASBizException {
        HashMap<String, String> parmas = new HashMap<String, String>();
        AutoReqBillInfo autoReqBillInfo = (AutoReqBillInfo)this.getValue(ctx, (IObjectPK)new ObjectStringPK(billId));
        if (autoReqBillInfo != null) {
            parmas.put("billId", billId);
        }
        return Json.toString(parmas);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPKs) throws BOSException, EASBizException {
        this.checkCanDel(ctx, arrayPKs);
        super._delete(ctx, arrayPKs);
    }

    private void checkCanDel(Context ctx, IObjectPK[] arrayPKs) throws EASBizException, BOSException {
        for (IObjectPK pk : arrayPKs) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("statu", (Object)"1", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
            if (this.exists(ctx, filterInfo)) continue;
            throw new RpaException(RpaException.AUTOREQBILLDELFAIL);
        }
    }

    @Override
    protected void _postRpaScheduler(Context ctx, BOSUuid billId, String bizParams) throws BOSException, EASBizException {
        AutoReqBillInfo autoReqBillInfo = (AutoReqBillInfo)this._getValue(ctx, "select rpaBizType.id , statu where id = '" + billId + "'");
        if (autoReqBillInfo.getStatu() != RpaReqBillStatus.CHECKED && autoReqBillInfo.getStatu() != RpaReqBillStatus.POST_SCHEDULER_FAILED) {
            throw new RpaException(RpaException.REQBILLSTATUSNOTEXEERROR, new Object[]{"[" + autoReqBillInfo.getStatu().getAlias() + "]"});
        }
        String bizTypeId = autoReqBillInfo.getRpaBizType().getId().toString();
        if (StringUtils.isEmpty((String)bizParams)) {
            bizParams = this._getRpaParams(ctx, billId.toString());
        }
        boolean addRpaScheduleSuccess = false;
        try {
            addRpaScheduleSuccess = RpaScheduleFactory.getLocalInstance(ctx).addRpaSchedule((IObjectPK)new ObjectStringPK(bizTypeId), bizParams);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (addRpaScheduleSuccess) {
            this.updateStatus(ctx, billId.toString(), Integer.valueOf(RpaReqBillStatus.EXECING.getValue()));
        } else {
            this.updateStatus(ctx, billId.toString(), Integer.valueOf("6"));
        }
    }

    @Override
    protected void _doPassBillAfter(Context ctx, BOSUuid billId, String bizParams, BOSUuid auditorId) throws BOSException, EASBizException {
        this._setPassState(ctx, billId, auditorId);
        this._postRpaScheduler(ctx, billId, bizParams);
    }
}

