/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.app;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.rpa.AutoReqBillCollection;
import com.kingdee.eas.base.rpa.AutoReqBillFactory;
import com.kingdee.eas.base.rpa.BizTypeInfo;
import com.kingdee.eas.base.rpa.IAutoReqBill;
import com.kingdee.eas.base.rpa.app.AbstractBizTypeControllerBean;
import com.kingdee.eas.base.rpa.app.RpaBizTypeStatus;
import com.kingdee.eas.base.rpa.app.RpaException;
import com.kingdee.eas.common.EASBizException;
import java.util.List;
import org.apache.log4j.Logger;

public class BizTypeControllerBean
extends AbstractBizTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.rpa.app.BizTypeControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, (IObjectValue)this.prepareBizTypeInfo(model));
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, (IObjectValue)this.prepareBizTypeInfo(model));
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, (IObjectValue)this.prepareBizTypeInfo(model));
    }

    private BizTypeInfo prepareBizTypeInfo(IObjectValue model) {
        BizTypeInfo info = (BizTypeInfo)model;
        info.setStatus(RpaBizTypeStatus.enable);
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        List fromJson = (List)gson.fromJson(info.getRpaParams(), List.class);
        String json = gson.toJson((Object)fromJson);
        info.setRpaParams(json);
        return info;
    }

    @Override
    protected boolean _unforbidden(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        BizTypeInfo bizTypeInfo = new BizTypeInfo();
        bizTypeInfo.setId(BOSUuid.read((String)id.toString()));
        bizTypeInfo.setStatus(RpaBizTypeStatus.enable);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("status"));
        this.updatePartial(ctx, bizTypeInfo, selectors);
        return true;
    }

    @Override
    protected boolean _forbidden(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        BizTypeInfo bizTypeInfo = new BizTypeInfo();
        bizTypeInfo.setId(BOSUuid.read((String)id.toString()));
        bizTypeInfo.setStatus(RpaBizTypeStatus.disabled);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("status"));
        this.updatePartial(ctx, bizTypeInfo, selectors);
        return true;
    }

    @Override
    public void delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        this.checkDel(ctx, arrayPK);
        super.delete(ctx, arrayPK);
    }

    private void checkDel(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK == null || arrayPK.length < 1) {
            throw new EASBizException(EASBizException.CHECKBLANK);
        }
        IAutoReqBill iAutoReqBill = AutoReqBillFactory.getLocalInstance(ctx);
        String number = null;
        for (IObjectPK objectPK : arrayPK) {
            AutoReqBillCollection autoReqBillCollection = iAutoReqBill.getAutoReqBillCollection("select number where rpaBizType.id = '" + objectPK.toString() + "'");
            if (autoReqBillCollection == null || autoReqBillCollection.isEmpty()) continue;
            number = autoReqBillCollection.get(0).getNumber();
            throw new RpaException(RpaException.BIZTYPEDELFAIL, new Object[]{number, number});
        }
    }
}

