/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.rpa.BizTypeFactory;
import com.kingdee.eas.base.rpa.BizTypeInfo;
import com.kingdee.eas.base.rpa.RpaClientInfo;
import com.kingdee.eas.base.rpa.RpaProcessParamCollection;
import com.kingdee.eas.base.rpa.RpaProcessParamFactory;
import com.kingdee.eas.base.rpa.RpaProcessParamInfo;
import com.kingdee.eas.base.rpa.RpaProcessesInfo;
import com.kingdee.eas.base.rpa.RpaServersInfo;
import com.kingdee.eas.base.rpa.app.AbstractRpaScheduleControllerBean;
import com.kingdee.eas.base.rpa.app.RpaException;
import com.kingdee.eas.base.rpa.app.rpaSrv.YsqRpaServer;
import com.kingdee.eas.base.rpa.util.Json;
import com.kingdee.eas.base.rpa.util.RPAAESUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RpaScheduleControllerBean
extends AbstractRpaScheduleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.rpa.app.RpaScheduleControllerBean");
    private static final String SCH_NAME = "schName";
    private static final String PROC_CODE = "procCode";
    private static final String EXEC_ROBOTS_NO = "execRobotsNo";
    private static final String SCH_PARAM = "schParam";
    private static final String SCHEDULE_EXPRE = "scheduleExpre";
    private static final String PARAM_NAME = "Name";
    private static final String PARAM_TYPE = "Type";
    private static final String PARAM_VALUE = "Value";
    private static final String BIZ_TYPE_PARAMS = "bizTypeParams";
    private static final String BIZ_PARAMS = "bizParams";
    private static final String WORKFLOW_PARAMS = "workflowBizParams";

    @Override
    protected boolean _addRpaSchedule(Context ctx, IObjectPK bizTypeId, String bizParams) throws BOSException, EASBizException {
        BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance(ctx).getBizTypeInfo("select rpaId.rpaServer.* , rpaId.*  , rpaClient.*  , rpaId.entries.*  where id = '" + bizTypeId.toString() + "'");
        RpaProcessesInfo rpaProcess = bizTypeInfo.getRpaId();
        RpaServersInfo rpaServer = rpaProcess.getRpaServer();
        RpaClientInfo rpaClient = bizTypeInfo.getRpaClient();
        return this._addSchedule(ctx, rpaServer, rpaClient, rpaProcess, null, bizParams);
    }

    @Override
    protected boolean _addSchedule(Context ctx, RpaServersInfo rpaServer, RpaClientInfo rpaClient, RpaProcessesInfo rpaProcess, String scheduleExpre, String bizParams) throws BOSException, EASBizException {
        RpaProcessParamCollection rpaProcessParams = rpaProcess.getEntries();
        if (rpaProcessParams == null || rpaProcessParams.isEmpty()) {
            rpaProcessParams = RpaProcessParamFactory.getLocalInstance(ctx).getRpaProcessParamCollection("select * where rpaProcess.id = '" + rpaProcess.getId().toString() + "'");
        }
        String shcParam = this.createShcParam(rpaProcessParams, bizParams);
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put(SCH_NAME, rpaProcess.getProcCode() + new Date().getTime());
        params.put(PROC_CODE, rpaProcess.getProcCode());
        params.put(EXEC_ROBOTS_NO, rpaClient.getAgentNo());
        params.put(SCH_PARAM, shcParam);
        if (StringUtils.isEmpty((String)scheduleExpre)) {
            params.put(SCHEDULE_EXPRE, YsqRpaServer.defaultScheduleExpre());
        }
        try {
            RPAAESUtils.IS_PRIVACY_SECRET.set(false);
            String response = YsqRpaServer.addProcessSchedule(rpaServer.getHttpUrl(), rpaServer.getAppkey(), rpaServer.getAppsecret(), params);
            Json rtJson = new Json(response);
            Integer code = rtJson.getValue("code", Integer.class);
            if ("0".equals(code.toString())) {
                return true;
            }
            throw new RpaException(RpaException.RPASCHEDULEERROR, new Object[]{response});
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String createShcParam(RpaProcessParamCollection paramColl, String bizParams) {
        ArrayList paramsListMap = new ArrayList();
        for (int i = 0; i < paramColl.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            RpaProcessParamInfo rpaProcessParamInfo = paramColl.get(i);
            map.put(PARAM_NAME, rpaProcessParamInfo.getName());
            map.put(PARAM_TYPE, rpaProcessParamInfo.getType().getValue());
            map.put(PARAM_VALUE, rpaProcessParamInfo.getValue());
            paramsListMap.add(map);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PARAM_NAME, BIZ_PARAMS);
        map.put(PARAM_TYPE, "string");
        map.put(PARAM_VALUE, bizParams);
        paramsListMap.add(map);
        return Json.toString(paramsListMap);
    }
}

