/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.eas.base.report.DefaultReportImp;
import com.kingdee.eas.base.report.IReportMove;
import com.kingdee.eas.base.report.IReportServer;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.ReportUtil;
import com.kingdee.eas.base.report.VirtualRowSet;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;

public class DefaultReportMoveImp
extends DefaultReportImp
implements IReportMove {
    private static final int MAXCACHED = 10;
    private int currentPos;
    private IRowSet dataList;
    private HashMap cacheReportData = new HashMap(10);
    private LinkedList reportDataList = new LinkedList();
    private String listDisplayFileName = "";

    public String getListDisplayFileName() {
        return this.listDisplayFileName;
    }

    public void setListDisplayFileName(String listDisplayFileName) {
        this.listDisplayFileName = listDisplayFileName;
    }

    public IRowSet getDataList() {
        return this.dataList;
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    @Override
    public boolean hasData() throws SQLException {
        return this.dataList != null && this.dataList.size() > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.dataList != null) {
            return this.dataList.isFirst();
        }
        return true;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.dataList != null) {
            return this.dataList.isLast();
        }
        return true;
    }

    @Override
    public void moveFirst() throws Exception {
        if (this.dataList != null) {
            this.moveTo(1);
        }
    }

    @Override
    public void moveLast() throws Exception {
        if (this.dataList != null) {
            this.moveTo(this.dataList.size());
        }
    }

    @Override
    public void moveNext() throws Exception {
        if (this.dataList != null) {
            this.moveTo(this.currentPos + 1);
        }
    }

    @Override
    public void movePrev() throws Exception {
        if (this.dataList != null) {
            this.moveTo(this.currentPos - 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void moveTo(int pos) throws Exception {
        ReportData reportData = null;
        if (!this.isExists(pos)) {
            if (!this.getDetailData(pos)) throw new Exception("\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728");
            reportData = this.convertToReportData();
            this.addReportData(pos, reportData);
        } else {
            reportData = (ReportData)this.cacheReportData.get(new Integer(pos));
            this.data = reportData.getData();
            this.reportHeader = reportData.getReportHeader();
            this.reportTitles = reportData.getReportTitles();
            this.reportFormatConditions = reportData.getReportFormatConditions();
            this.tableName = reportData.tableName;
            if (this.dataList != null) {
                this.dataList.absolute(pos);
            }
        }
        this.currentPos = pos;
    }

    protected ReportData convertToReportData() {
        ReportData reportData = new ReportData();
        reportData.setData(this.data);
        reportData.setReportHeader(this.reportHeader);
        reportData.setReportTitles(this.reportTitles);
        reportData.setReportFormatConditions(this.reportFormatConditions);
        reportData.setTableName(this.tableName);
        return reportData;
    }

    private boolean getDetailData(int pos) throws Exception {
        if (this.dataList != null && this.dataList.absolute(pos)) {
            this.filter.setObject("position", (Object)ReportUtil.getOneRowData(this.dataList));
            this.tableName = "";
            this.innerRefresh();
            return true;
        }
        return false;
    }

    private boolean isExists(int pos) {
        return this.cacheReportData.containsKey(new Integer(pos));
    }

    private void addReportData(int pos, ReportData reportData) {
        this.cacheReportData.put(new Integer(pos), reportData);
        this.reportDataList.addLast(reportData);
        this.recyleReportData();
    }

    private void recyleReportData() {
        System.out.print("reportDataList.size()" + this.reportDataList.size());
        if (this.reportDataList.size() >= 10) {
            Object key = this.reportDataList.removeFirst();
            this.cacheReportData.remove(key);
        }
    }

    private void clearReportData() {
        for (ReportData reportData : this.reportDataList) {
            String tableName = reportData.getTableName();
            if (tableName == null || tableName.trim().length() <= 0) continue;
            this.tableName = tableName;
            try {
                this.dropTempTable();
            }
            catch (BaseException baseException) {}
        }
        this.reportDataList.clear();
        this.cacheReportData.clear();
    }

    @Override
    public void closeReport() throws BOSException {
        this.clearReportData();
    }

    @Override
    public void Refresh() throws Exception {
        IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)this.reportProperty.getRptSvrClassName(), IReportServer.class);
        this.clearReportData();
        HashMap map = server.getListAndReportData(this.getReportProperty().getReportID(), this.reportProperty, this.getFilter());
        this.dataList = (IRowSet)map.get("datalist");
        this.setListDisplayFileName((String)map.get("listdisplayfieldname"));
        if (this.dataList == null) {
            this.data = new VirtualRowSet();
            this.dataList = new DynamicRowSet(1);
        }
        this.setReportData(map);
        ReportData reportData = this.convertToReportData();
        this.addReportData(1, reportData);
        this.currentPos = 1;
    }

    private class ReportData
    implements Serializable {
        private static final long serialVersionUID = -3569038960811962949L;
        protected VirtualRowSet data;
        protected ReportHeader reportHeader;
        protected ReportTitles reportTitles;
        protected ReportFormatConditions reportFormatConditions;
        protected String tableName;

        private ReportData() {
        }

        public VirtualRowSet getData() {
            return this.data;
        }

        public void setData(VirtualRowSet data) {
            this.data = data;
        }

        public ReportHeader getReportHeader() {
            return this.reportHeader;
        }

        public void setReportHeader(ReportHeader reportHeader) {
            this.reportHeader = reportHeader;
        }

        public ReportTitles getReportTitles() {
            return this.reportTitles;
        }

        public void setReportTitles(ReportTitles reportTitles) {
            this.reportTitles = reportTitles;
        }

        public ReportFormatConditions getReportFormatConditions() {
            return this.reportFormatConditions;
        }

        public void setReportFormatConditions(ReportFormatConditions reportFormatConditions) {
            this.reportFormatConditions = reportFormatConditions;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }
    }
}

