/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report;

import com.kingdee.eas.base.report.CellEvent;
import com.kingdee.eas.base.report.ReportApplication;
import com.kingdee.eas.base.report.ReportListener;
import javax.swing.event.EventListenerList;

public class ReportEventProxy {
    protected EventListenerList listenerList = new EventListenerList();
    protected ReportApplication reportApplication;

    public ReportEventProxy(ReportApplication reportApplication) {
        this.reportApplication = reportApplication;
    }

    public void addReportListener(ReportListener plugIn) {
        this.listenerList.add(ReportListener.class, plugIn);
        plugIn.setReportApplication(this.reportApplication);
    }

    public ReportListener[] getReportListeners() {
        return (ReportListener[])this.listenerList.getListeners(ReportListener.class);
    }

    public void removeReportListener(ReportListener plugIn) {
        this.listenerList.remove(ReportListener.class, plugIn);
        plugIn.setReportApplication(null);
    }

    public void fireCellFormat(CellEvent event) throws Exception {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).onCellFormat(event);
        }
    }

    public void fireOnInitialize() throws Exception {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).onInitialize();
        }
    }

    public void fireOnMenuClick(String name) throws Exception {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).onMenuClick(name);
        }
    }

    public void fireOnCellClick(CellEvent event) throws Exception {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).onCellClick(event);
        }
    }

    public void fireBeforePrint(boolean isPreview) throws Exception {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).fireBeforePrint(isPreview);
        }
    }

    public void fireAfterPrint() throws Exception {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).fireAfterPrint();
        }
    }

    public void fireTableHeadClick(CellEvent event) throws Exception {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).fireTableHeadClick(event);
        }
    }

    public void fireTableDbClick(CellEvent event) throws Exception {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).fireTableDbClick(event);
        }
    }
}

