/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.test;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class TestKDTable
extends JFrame
implements KDTDataRequestListener {
    private KDTable table = new KDTable();
    private JButton button = new JButton("Add");

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
        TestKDTable test = new TestKDTable();
        test.setVisible(true);
    }

    public TestKDTable() {
        this.setDefaultCloseOperation(3);
        GridLayout layout = new GridLayout(2, 1, 10, 0);
        this.getContentPane().setLayout(layout);
        this.button.setSize(50, 50);
        this.getContentPane().add(this.button);
        this.getContentPane().add((Component)this.table);
        this.table.getDataRequestManager().setDataRequestMode(1);
        this.table.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.buildColumn(this.table, 13);
        this.buildHeader(this.table, 13, 1);
        this.setSize(800, 600);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestKDTable.this.table.addRow(50);
                TestKDTable.this.table.refresh();
            }
        });
    }

    private void testTable(KDTable table) {
        int colCount = 13;
        int headRowCount = 1;
        int rowCount = 100;
        this.buildColumn(table, colCount);
        this.buildHeader(table, colCount, headRowCount);
        for (int i = 0; i < rowCount; ++i) {
            IRow row = table.addRow(i);
            for (int j = 0; j < colCount; ++j) {
                ICell cell = row.getCell(j);
                cell.setValue((Object)("body " + i + " " + j));
            }
        }
    }

    private void buildHeader(KDTable table, int colCount, int headRowCount) {
        for (int i = 0; i < headRowCount; ++i) {
            IRow row = table.addHeadRow(i);
            for (int j = 0; j < colCount; ++j) {
                ICell cell = row.getCell(j);
                cell.setValue((Object)("head " + i + " " + j));
            }
        }
    }

    private void buildColumn(KDTable table, int colCount) {
        for (int i = 0; i < colCount; ++i) {
            table.addColumn(i);
        }
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        System.out.println("Virtual mode started:" + e.getFirstRow() + " end:" + e.getLastRow());
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            IRow row = this.table.addRow();
            for (int j = 0; j < 13; ++j) {
                ICell cell = row.getCell(j);
                cell.setValue((Object)("body " + (e.getFirstRow() + i) + " " + j));
            }
        }
    }
}

