/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.test;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class TestKDTableMerge
extends JFrame {
    private KDTable table = new KDTable();

    public TestKDTableMerge() {
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.table);
        this.testTable(this.table);
        this.setSize(800, 600);
    }

    public static void main(String[] argv) throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
        TestKDTableMerge test = new TestKDTableMerge();
        test.setVisible(true);
    }

    private void testTable(KDTable table) {
        int colCount = 13;
        int headRowCount = 1;
        int rowCount = 100;
        this.buildColumn(table, colCount);
        this.buildHeader(table, colCount, headRowCount);
        for (int i = 0; i < rowCount; ++i) {
            IRow row = table.addRow(i);
            for (int j = 0; j < colCount; ++j) {
                ICell cell = row.getCell(j);
                if (j < 3) {
                    cell.setValue((Object)("body " + j + i / (7 - j)));
                    continue;
                }
                cell.setValue((Object)("body " + i + " " + j));
            }
        }
    }

    private void buildColumn(KDTable table, int colCount) {
        table.getGroupManager().setGroup(true);
        for (int i = 0; i < colCount; ++i) {
            IColumn col = table.addColumn(i);
            if (i >= 3) continue;
            col.setGroup(true);
            col.setMergeable(true);
        }
    }

    private void buildHeader(KDTable table, int colCount, int headRowCount) {
        for (int i = 0; i < headRowCount; ++i) {
            IRow row = table.addHeadRow(i);
            for (int j = 0; j < colCount; ++j) {
                ICell cell = row.getCell(j);
                cell.setValue((Object)("head " + i + " " + j));
            }
        }
    }
}

