/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.security.CertificateStatusEnum;
import com.kingdee.eas.base.security.EASCertificateCollection;
import com.kingdee.eas.base.security.EASCertificateInfo;
import com.kingdee.eas.base.security.app.AbstractEASCertificateControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class EASCertificateControllerBean
extends AbstractEASCertificateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.security.app.EASCertificateControllerBean");

    @Override
    protected void _updateCertificate(Context ctx, byte[] certificate) throws BOSException, EASBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (certificate == null || certificate.length == 0) {
            logger.error((Object)(" \u8bc1\u4e66\u66f4\u65b0\u65f6 \u7528\u6237\uff1a" + currentUserInfo.getNumber() + " \u4f20\u5165\u7684\u8bc1\u4e66\u4e3a\u7a7a "));
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)currentUserInfo.getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"1"));
        evi.setFilter(filterInfo);
        EASCertificateCollection certCol = this.getEASCertificateCollection(ctx, evi);
        boolean isNeedUpdate = true;
        if (certCol.size() > 0) {
            int size = certCol.size();
            for (int index = 0; index < size; ++index) {
                EASCertificateInfo certificateInfo = certCol.get(index);
                if (Arrays.equals(certificateInfo.getCertificate(), certificate)) {
                    isNeedUpdate = false;
                    continue;
                }
                certificateInfo.setStatus(CertificateStatusEnum.EXPIRED);
            }
        }
        if (isNeedUpdate) {
            EASCertificateInfo newCertInfo = new EASCertificateInfo();
            newCertInfo.setUser(currentUserInfo);
            newCertInfo.setCertificate(certificate);
            newCertInfo.setStatus(CertificateStatusEnum.VALID);
            newCertInfo.setNumber("" + System.currentTimeMillis());
            newCertInfo.setValidDate(new Date());
            Calendar invaildDate = Calendar.getInstance();
            invaildDate.set(2099, 11, 31, 0, 0, 0);
            newCertInfo.setInvalidDate(invaildDate.getTime());
            this.addnew(ctx, newCertInfo);
        }
    }
}

