/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.IIDSecondAuthorize;
import com.kingdee.eas.base.permission.SignatureFieldInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.CAIdentityAuthorizeUtil;
import com.kingdee.eas.base.security.BOTPSignConfigInfo;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.EASSignatureInfo;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.PkiSecurityException;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.SignatureStatusEnum;
import com.kingdee.eas.base.security.app.AES;
import com.kingdee.eas.base.security.app.AbstractEASSignatureControllerBean;
import com.kingdee.eas.base.security.app.BOTPSignVerifierManager;
import com.kingdee.eas.base.security.app.IEASBOTPSignVerifier;
import com.kingdee.eas.base.security.app.IServerCASolution;
import com.kingdee.eas.base.security.app.SignatureConfiguration;
import com.kingdee.eas.base.security.app.SmartPayCASolutionFactory;
import com.kingdee.eas.base.security.provider.IPKIServerExtProvider;
import com.kingdee.eas.base.security.provider.PKIServerAndClientExtFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EASSignatureControllerBean
extends AbstractEASSignatureControllerBean {
    public static Map signaturConfigMap = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.security.app.EASSignatureControllerBean");
    private static BOTPSignConfigInfo botpSignConfigInfo;
    private static final String SIGN_SPLITER = "~@!%$BOTP$%!@~";
    private static String PRODUCTNO;

    @Override
    protected com.kingdee.bos.security.framework.SignatureFieldInfo _getSignatureFieldInfo(Context ctx, String bosType) throws BOSException {
        return SignatureConfiguration.getInstance().getSignatureFieldInfo(BOSObjectType.create((String)bosType));
    }

    @Override
    protected void _checkSignature(Context ctx, BOSObjectType bosType, List pks) throws BOSException, EASBizException {
        if (bosType == null || pks == null) {
            logger.info((Object)"_checkSignature parameter bosType is null or pks is null.");
            return;
        }
        for (int i = 0; i < pks.size(); ++i) {
            String sql = "SELECT top 1 ts.FSignature, u.FNumber, ts.FBOTPSign, ts.FSmartPaySign FROM T_SCU_EASSignature ts INNER JOIN T_PM_USER u ON ts.FUserID=u.FID WHERE ts.FObjectID=?  and ts.FBosType=? ORDER BY ts.FCreateTime desc";
            String billId = String.valueOf(pks.get(i));
            BOSUuid uuid = BOSUuid.read((String)billId);
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{uuid.toString(), bosType.toString()});
            if (result.size() < 1) {
                logger.info((Object)("Fetch signature data(EASSignature), return nothing! pk is " + billId));
                continue;
            }
            byte[] plainText = FrameHelperFacadeFactory.getLocalInstance((Context)ctx).getPlainText(bosType, (IObjectPK)new ObjectUuidPK(uuid));
            String signature = null;
            String username = null;
            Boolean botpSign = null;
            Boolean smartPaySign = null;
            try {
                if (result.next()) {
                    signature = result.getString("FSignature");
                    username = result.getString("FNumber");
                    String botpSignStr = result.getString("FBOTPSign");
                    String smartPaySignStr = result.getString("FSmartPaySign");
                    if (!StringUtils.isEmpty((String)botpSignStr)) {
                        botpSign = "1".equals(botpSignStr);
                    }
                    if (!StringUtils.isEmpty((String)smartPaySignStr)) {
                        smartPaySign = "1".equals(smartPaySignStr);
                    }
                }
            }
            catch (SQLException e1) {
                logger.error((Object)("checkSignature get signature record error:" + e1.getMessage()));
                throw new BOSException((Throwable)e1);
            }
            try {
                String targetPlainText = new String(plainText, "UTF-8");
                if (smartPaySign != null && smartPaySign.booleanValue()) {
                    boolean verified = SmartPayCASolutionFactory.getCASolution().verify(targetPlainText, signature);
                    if (!verified) {
                        logger.error((Object)("smartpay sign verified mismatch, please check it.signature: " + signature + ", billId: " + billId + ", plainText: " + targetPlainText + ", bostype: " + bosType.toString()));
                        throw new BOSException("\u667a\u80fd\u652f\u4ed8\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u5355\u636eid\uff1a" + billId + "\uff0c\u660e\u6587\uff1a" + plainText + "\uff0c\u7b7e\u540d\uff1a" + signature);
                    }
                } else if (botpSign != null && botpSign.booleanValue()) {
                    this.checkBOTPSign(ctx, billId);
                } else {
                    IPKIServerExtProvider ipkiServerExtProvider = PKIServerAndClientExtFactory.getServerExtProvider((Context)ctx);
                    int ret = 0;
                    if (signature != null) {
                        ret = ipkiServerExtProvider.verify(ctx, plainText, signature.getBytes("UTF-8"), username);
                    }
                    if (ret != 0) {
                        logger.error((Object)("Check signature data fail, return code:" + ret));
                        logger.error((Object)("plainText:" + targetPlainText));
                        logger.error((Object)("signature:" + signature));
                        logger.error((Object)("username:" + username));
                        logger.error((Object)("pk :" + billId));
                        throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_BIZ, new Object[]{username, new String(plainText), signature, ret});
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            logger.info((Object)("Check signature data successfully, pk=" + uuid.toString()));
        }
    }

    private void realCheckSignature(Context ctx, String plainText, String signature) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        this.realCheckSignature(ctx, plainText, signature, userInfo.getNumber());
    }

    private void realCheckSignature(Context ctx, String plainText, String signature, String userName) throws BOSException, EASBizException {
        IPKIServerExtProvider ipkiServerExtProvider = PKIServerAndClientExtFactory.getServerExtProvider((Context)ctx);
        try {
            int ret;
            if (plainText == null) {
                plainText = "";
            }
            if (signature == null) {
                signature = "";
            }
            if ((ret = ipkiServerExtProvider.verify(ctx, plainText.getBytes("UTF-8"), signature.getBytes("UTF-8"), userName)) != 0) {
                logger.info((Object)("Check signature data fail, return code:" + ret));
                logger.info((Object)("plainText:" + plainText));
                logger.info((Object)("signature:" + signature));
                logger.info((Object)("username:" + userName));
                throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_BIZ, new Object[]{userName, new String(plainText), signature, ret});
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("Check signature data successfully, plainText=" + plainText + " and userName=" + userName));
    }

    @Override
    protected void _checkSignature4Web(Context ctx, List pks, String permItemName) throws BOSException, EASBizException {
        if (!this.isVerifySignatrue(ctx, permItemName)) {
            return;
        }
        if (pks != null && pks.size() > 0) {
            BOSUuid uuid = BOSUuid.read((String)((String)pks.get(0)));
            this._checkSignature(ctx, uuid.getType(), pks);
        }
    }

    @Override
    protected void _checkSignature4Web(Context ctx, String plainText, String signature, String permItemName) throws BOSException, EASBizException {
        if (!this.isVerifySignatrue(ctx, permItemName)) {
            return;
        }
        if (plainText == null || signature == null) {
            logger.error((Object)"plainText or signature is null, ignore check signature.");
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_BIZ, new Object[]{userInfo.getNumber(), plainText, signature, "plaintext or signature is null"});
        }
        this.realCheckSignature(ctx, plainText, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _checkSignature4Web(Context ctx, List pks, List signatures, String permItemName) throws BOSException, EASBizException {
        if (!this.isVerifySignatrue(ctx, permItemName)) {
            return;
        }
        if (pks != null && signatures != null && pks.size() > 0 && signatures.size() > 0) {
            if (pks.size() != signatures.size()) throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_BIZ);
            for (int i = 0; i < pks.size(); ++i) {
                BOSUuid uuid = BOSUuid.read((String)((String)pks.get(i)));
                String signature = (String)signatures.get(i);
                byte[] plainText = FrameHelperFacadeFactory.getLocalInstance((Context)ctx).getPlainText(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
                this.realCheckSignature(ctx, new String(plainText), signature);
            }
            return;
        } else {
            logger.error((Object)"pks or signatures is null, ignore check signature.");
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_BIZ, new Object[]{userInfo.getNumber(), null, null, "plaintext or signature is null"});
        }
    }

    @Override
    protected void _saveSignature4Web(Context ctx, String signature, String plainText, String pk, String permItemName) throws BOSException, EASBizException {
        if (!this.isSaveSignatrue(ctx, permItemName)) {
            return;
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        EASSignatureInfo signatureInfo = new EASSignatureInfo();
        signatureInfo.setBosType(BOSUuid.read((String)pk).getType().toString());
        signatureInfo.setSignature(signature);
        signatureInfo.setUser(currentUserInfo);
        signatureInfo.setPlainText(plainText);
        signatureInfo.setObjectid(pk);
        signatureInfo.setFormatPlainText("FormatPlainText");
        signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
        IEASSignature easSignture = EASSignatureFactory.getLocalInstance(ctx);
        easSignture.addnew((CoreBaseInfo)signatureInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _saveSignature4Web(Context ctx, List signatures, List pks, String permItemName) throws BOSException, EASBizException {
        if (!this.isSaveSignatrue(ctx, permItemName)) {
            return;
        }
        logger.info((Object)("signatures:" + signatures.toArray() + ",pks:" + pks.toArray()));
        try {
            if (pks != null && signatures != null && pks.size() > 0 && signatures.size() > 0) {
                if (pks.size() != signatures.size()) throw new PkiSecurityException(PkiSecurityException.VERIFY_FAIL_BIZ);
                UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                CoreBaseCollection coll = new CoreBaseCollection();
                for (int i = 0; i < pks.size(); ++i) {
                    String pk = (String)pks.get(i);
                    BOSUuid uuid = BOSUuid.read((String)pk);
                    String signature = (String)signatures.get(i);
                    logger.info((Object)("pk:" + pk + ",signature:" + signature + ",uuid:" + uuid));
                    byte[] plainText = FrameHelperFacadeFactory.getLocalInstance((Context)ctx).getPlainText(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
                    EASSignatureInfo signatureInfo = new EASSignatureInfo();
                    signatureInfo.setBosType(BOSUuid.read((String)pk).getType().toString());
                    signatureInfo.setSignature(signature);
                    signatureInfo.setUser(currentUserInfo);
                    signatureInfo.setPlainText(new String(plainText, "UTF-8"));
                    signatureInfo.setObjectid(pk);
                    signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
                    signatureInfo.setFormatPlainText("FormatPlainText");
                    coll.add((CoreBaseInfo)signatureInfo);
                }
                IEASSignature easSignture = EASSignatureFactory.getLocalInstance(ctx);
                easSignture.addnew(coll);
            } else {
                logger.error((Object)"pks or signatures is null, ignore check signature.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)"saveSignature(List) OK");
    }

    private boolean isVerifySignatrue(Context ctx, String permItemName) throws EASBizException, BOSException {
        AuthorizeTypeEnum authorizeType = IDSecondAuthorizeFactory.getLocalInstance((Context)ctx).getAuthorizeType(permItemName);
        if (authorizeType != null) {
            logger.info((Object)("permItemName=" + permItemName + ",it's authorize type " + authorizeType.getValue() + "  " + authorizeType.toString()));
            return CAIdentityAuthorizeUtil.isVerifySignatrue((AuthorizeTypeEnum)authorizeType);
        }
        logger.info((Object)("permItemName=" + permItemName + ",it's authorize type is null, try find by bosType"));
        return this.isBosTypeSignatureWhenApprove(ctx, permItemName);
    }

    private boolean isSaveSignatrue(Context ctx, String permItemName) throws EASBizException, BOSException {
        AuthorizeTypeEnum authorizeType = IDSecondAuthorizeFactory.getLocalInstance((Context)ctx).getAuthorizeType(permItemName);
        if (authorizeType != null) {
            logger.info((Object)("permItemName=" + permItemName + ",it's authorize type " + authorizeType.getValue() + "  " + authorizeType.toString()));
            return CAIdentityAuthorizeUtil.isSaveSignatrue((AuthorizeTypeEnum)authorizeType);
        }
        logger.info((Object)("permItemName=" + permItemName + ",it's authorize type is null, try find by bosType"));
        return this.isBosTypeSignatureWhenApprove(ctx, permItemName);
    }

    private boolean isBosTypeSignatureWhenApprove(Context ctx, String bosType) throws EASBizException, BOSException {
        SignatureFieldInfo info;
        if (signaturConfigMap == null) {
            signaturConfigMap = FrameHelperFacadeFactory.getLocalInstance((Context)ctx).getSignatrueConfig();
        }
        return signaturConfigMap != null && signaturConfigMap.containsKey(bosType.toString()) && (info = (SignatureFieldInfo)signaturConfigMap.get(bosType.toString())).isSignatureNeeded() && info.isSignatureWhenApprove();
    }

    @Override
    protected boolean _checkCaOrgRange(Context ctx, String pk, Map context) throws BOSException {
        if (StringUtils.isEmpty((String)pk)) {
            return true;
        }
        BOSObjectType bosTypeCurrent = BOSUuid.read((String)pk).getType();
        BOSUuid id = null;
        if (bosTypeCurrent.toString().equals("40284E81")) {
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosTypeCurrent);
            entityObjectInfo.getExtendedProperty("OrgType");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            ICoreBase iCoreBase = null;
            CoreBaseInfo objectValue = null;
            try {
                iCoreBase = (ICoreBase)CDOUtils.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)pk).getType());
                objectValue = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(pk), sic);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            logger.error((Object)("getCompany()*********************************" + objectValue.get("company").toString()));
            id = ((CompanyOrgUnitInfo)objectValue.get("company")).getId();
        } else if (bosTypeCurrent.toString().equals("6E41E17C")) {
            String sqlforid = "select top 1 tfs.FCOMPANYID from T_FS_SettlementBill tfs where tfs.fid=? ORDER BY tfs.FCreateTime desc";
            IRowSet resultforid = DbUtil.executeQuery((Context)ctx, (String)sqlforid, (Object[])new Object[]{pk.toString()});
            if (resultforid.size() < 1) {
                logger.error((Object)"SettlementBill id is null");
                throw new BOSException("SettlementBill id is null");
            }
            String billOrgId = null;
            try {
                if (resultforid.next()) {
                    billOrgId = resultforid.getString("FCOMPANYID");
                }
            }
            catch (SQLException e1) {
                logger.error((Object)("checkOrg get FCOMPANYID error:" + e1.getMessage()));
                throw new BOSException("SettlementBill id is null");
            }
            id = BOSUuid.read(billOrgId);
            logger.error((Object)("SettlementBill id:" + id));
        } else {
            return true;
        }
        BOSObjectType approveBosType = (BOSObjectType)context.get("APPROVEBOSTYPE");
        String bosType = approveBosType == null ? "" : approveBosType.toString();
        String permItemName = (String)context.get("PERMISSIONITEM");
        IIDSecondAuthorize idSecondAuthorize = IDSecondAuthorizeFactory.getLocalInstance((Context)ctx);
        Set ret = null;
        if (!StringUtils.isEmpty((String)bosType)) {
            logger.error((Object)"approve*********************************");
            ret = idSecondAuthorize.getCaOrgRangeByBosType(bosType);
        } else if (!StringUtils.isEmpty((String)permItemName)) {
            logger.error((Object)"approve********not2*************************");
            ret = idSecondAuthorize.getCaOrgRangeByPermItemName(permItemName);
        } else {
            logger.error((Object)"approve****not*****************************");
            IMetaDataPK uimetaPK = (IMetaDataPK)context.get("METADATA.PK");
            IMetaDataPK actionPK = (IMetaDataPK)context.get("ACTION.PK");
            ret = idSecondAuthorize.getCaOrgRangeByActionPK(uimetaPK, actionPK);
        }
        if (ret.isEmpty()) {
            return true;
        }
        logger.error((Object)("CAIdentityAuthorize id" + id));
        for (int i = 0; i < ret.size(); ++i) {
            logger.info((Object)("CAIdentityAuthorize id*" + i + " " + ret.toArray()[i].toString()));
        }
        return ret.contains(id.toString());
    }

    @Override
    protected void _genBOTPSign(Context ctx, List targetBillIds, BOSObjectType bosObjectType) throws BOSException {
        BOTPSignConfigInfo signConfigInfo = EASSignatureControllerBean.getBOTPSignConfigInfo(ctx);
        logger.error((Object)("signConfigInfo: " + signConfigInfo.toString()));
        boolean isSupportBOTPSign = signConfigInfo.isOn();
        logger.info((Object)("isSupportBOTPSign: " + isSupportBOTPSign));
        if (!isSupportBOTPSign) {
            logger.error((Object)"isSupportBOTPSign is false, return.");
            return;
        }
        Set<String> botpSignSupportedBOSTypes = signConfigInfo.getTypes();
        Map signatureConfigurations = SignatureConfiguration.getInstance().getSignatureConfiguration();
        if (signatureConfigurations == null || !signatureConfigurations.keySet().contains(bosObjectType.toString())) {
            logger.error((Object)("signatureConfigurations not contains " + bosObjectType.toString() + ", signatureConfigurations: " + signatureConfigurations + ", return."));
        }
        logger.error((Object)("supportBOSTypes: " + botpSignSupportedBOSTypes.toString()));
        if (botpSignSupportedBOSTypes == null || !botpSignSupportedBOSTypes.contains(bosObjectType.toString())) {
            logger.error((Object)("botpSignSupportedBOSTypes not contains " + bosObjectType.toString() + ", return."));
            return;
        }
        if (targetBillIds == null || targetBillIds.size() == 0) {
            logger.error((Object)"targetBillIds is empty or null,no more sign it.");
            return;
        }
        logger.error((Object)("generate botp sign...targetBillIds: " + targetBillIds.toString()));
        try {
            String productNo = EASSignatureControllerBean.getProductNo();
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            String supportVerifier = signConfigInfo.getVerifier();
            IEASBOTPSignVerifier verifier = BOTPSignVerifierManager.getVerifierInUse(supportVerifier);
            String secret = signConfigInfo.getSecret();
            if (secret == null || secret.length() == 0) {
                secret = productNo;
            }
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < targetBillIds.size(); ++i) {
                String billId = ((ObjectUuidPK)targetBillIds.get(i)).toString();
                if (billId == null || billId.length() == 0) {
                    logger.error((Object)"billid is empty or null");
                    throw new BOSException("\u5305\u542b\u5355\u636eid\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0c\u7d22\u5f15\uff1a" + i);
                }
                BOSUuid uuid = BOSUuid.read((String)billId);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FID, FSIGNATURE, FBOSTYPE ,FOBJECTID, FCREATETIME, FBOTPSIGN  from T_SCU_EASSIGNATURE  where FOBJECTID = ? and FBOSTYPE = ? order by FCREATETIME desc", (Object[])new Object[]{billId, uuid.getType().toString()});
                if (rs.size() > 0) {
                    logger.error((Object)("one or more signatures are found, not generate new botp sign any more, objectId: " + billId + ", bostype: " + uuid.getType()));
                    continue;
                }
                byte[] plainTextByte = FrameHelperFacadeFactory.getLocalInstance((Context)ctx).getPlainText(bosObjectType, (IObjectPK)new ObjectUuidPK(uuid));
                String plainText = new String(plainTextByte, "UTF-8");
                String plainTextEncrypted = AES.encrypt2Str(this.getPlainText(plainText, productNo, billId), signConfigInfo.getSecret());
                logger.error((Object)plainTextEncrypted);
                EASSignatureInfo signatureInfo = new EASSignatureInfo();
                signatureInfo.setBosType(bosObjectType.toString());
                signatureInfo.setSignature(verifier.sign(plainTextEncrypted));
                signatureInfo.setUser(userInfo);
                signatureInfo.setPlainText(null);
                signatureInfo.setFormatPlainText(null);
                signatureInfo.setObjectid(billId);
                signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
                signatureInfo.setBotpSign(true);
                coll.add((CoreBaseInfo)signatureInfo);
            }
            this.addnew(ctx, coll);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void checkBOTPSign(Context ctx, String billId) throws BOSException, EASBizException {
        BOTPSignConfigInfo signConfig = EASSignatureControllerBean.getBOTPSignConfigInfo(ctx);
        if (!signConfig.isOn()) {
            logger.error((Object)"checkBOTPSign(), botp sign is not allowed, return");
            return;
        }
        BOSUuid uuid = BOSUuid.read((String)billId);
        if (!signConfig.getTypes().contains(uuid.getType().toString())) {
            logger.error((Object)("checkBOTPSign(), uuid type is not contained in supportedtypes, supportedtypes: " + signConfig.getTypes().toString() + ", uuid bostype: " + uuid.getType()));
            return;
        }
        IRowSet relationRS = DbUtil.executeQuery((Context)ctx, (String)"select count(1) as cnt from T_BOT_RELATION where FDESTOBJECTID = ? and FDESTENTITYID = ?", (Object[])new Object[]{billId, uuid.getType().toString()});
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FID, FSIGNATURE, FBOSTYPE ,FOBJECTID, FCREATETIME, FBOTPSIGN  from T_SCU_EASSIGNATURE  where FOBJECTID = ? and FBOSTYPE = ? order by FCREATETIME desc", (Object[])new Object[]{billId, uuid.getType().toString()});
        boolean botpSignFound = false;
        int mappingSize = 0;
        try {
            while (rs.next()) {
                if (!rs.getBoolean("FBOTPSIGN")) continue;
                if (botpSignFound) {
                    throw new BOSException("\u627e\u5230\u540c\u4e00\u5355\u636e\u591a\u6761\u8f6c\u6362\u7b7e\u540d\uff0c\u8868\u8bb0\u5f55\u53ef\u80fd\u88ab\u7be1\u6539\u3002");
                }
                botpSignFound = true;
            }
            if (relationRS.next()) {
                mappingSize = relationRS.getInt(1);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        if (mappingSize == 0) {
            logger.error((Object)"no botp relation records");
            if (!botpSignFound) {
                logger.error((Object)"no botp sign records");
                return;
            }
            logger.error((Object)"botp sign records are found.");
            throw new BOSException("\u627e\u4e0d\u5230\u8be5\u5355\u636e\u5bf9\u5e94\u7684BOTP\u8f6c\u6362\u5173\u7cfb\u8bb0\u5f55\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002");
        }
        logger.error((Object)"botp relation records are found.");
        if (!botpSignFound) {
            logger.error((Object)"no botp sign records are found.");
            throw new BOSException("\u627e\u4e0d\u5230\u8be5\u5355\u636e\u5bf9\u5e94\u7684BOTP\u7b7e\u540d\u8bb0\u5f55\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002");
        }
        logger.error((Object)"botp sign records are found.");
        try {
            rs.first();
            if (!rs.getBoolean("FBOTPSIGN") && rs.size() > 1) {
                logger.error((Object)"a sign record is found ,but not a botp sign, so skip botpsign check logic.");
                return;
            }
            String signatureId = rs.getString("FID");
            String signature = rs.getString("FSIGNATURE");
            IEASBOTPSignVerifier verifier = BOTPSignVerifierManager.getVerifierInUse(signConfig.getVerifier());
            String srcText = new String(FrameHelperFacadeFactory.getLocalInstance((Context)ctx).getPlainText(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid)), "UTF-8");
            String plainText = this.getPlainText(srcText, EASSignatureControllerBean.getProductNo(), billId);
            String encryptText = AES.encrypt2Str(plainText, signConfig.getSecret());
            logger.error((Object)("botp check, plainText: " + encryptText));
            boolean verify = verifier.verify(encryptText, signature);
            if (!verify) {
                String plainText4ReCheck = this.getPlainText4ReCheck(signatureId, EASSignatureControllerBean.getProductNo(), billId);
                String encryptText4Recheck = AES.encrypt2Str(plainText4ReCheck, signConfig.getSecret());
                logger.error((Object)("botp recheck, plainText: " + encryptText4Recheck));
                verify = verifier.verify(encryptText4Recheck, signature);
                if (!verify) {
                    throw new BOSException("\u65b0\u751f\u6210\u7684\u5355\u636e\u4e0e\u6e90\u5355\u636e\u8f6c\u6362\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u8be5\u5355\u636e\u7684" + this.getSignErrorDescription(ctx, uuid.getType().toString()) + "\u5c5e\u6027\u503c\u4e0e\u6e90\u5355\u636e\u8f6c\u6362\u7ed3\u679c\u662f\u5426\u4e00\u81f4\u3002");
                }
            } else {
                String plainText4ReCheck = this.getPlainText4ReCheck(signatureId, EASSignatureControllerBean.getProductNo(), billId);
                EASSignatureInfo signatureInfo = this.getEASSignatureInfo(ctx, (IObjectPK)new ObjectUuidPK(signatureId));
                String newSign = verifier.sign(AES.encrypt2Str(plainText4ReCheck, signConfig.getSecret()));
                signatureInfo.setSignature(newSign);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(signatureId), (CoreBaseInfo)signatureInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static BOTPSignConfigInfo getBOTPSignConfigInfo(Context ctx) throws BOSException {
        if (botpSignConfigInfo == null) {
            ISecurityAuthParamManager manager = SecurityAuthParamManagerFactory.getLocalInstance(ctx);
            botpSignConfigInfo = manager.getBOTPSignConfigInfo();
        }
        return botpSignConfigInfo;
    }

    private String getPlainText(String srcText, String productNo, String billId) {
        StringBuilder builder = new StringBuilder();
        builder.append(srcText).append(SIGN_SPLITER);
        builder.append(productNo).append(SIGN_SPLITER);
        builder.append(billId);
        return builder.toString();
    }

    private String getPlainText4ReCheck(String signId, String productNo, String billId) {
        StringBuilder builder = new StringBuilder();
        builder.append(signId).append(SIGN_SPLITER);
        builder.append(productNo).append(SIGN_SPLITER);
        builder.append(billId);
        return builder.toString();
    }

    private String getSignErrorDescription(Context ctx, String bosType) throws BOSException {
        logger.error((Object)("get signerror description, bostype: " + bosType));
        String defaultDesc = "";
        com.kingdee.bos.security.framework.SignatureFieldInfo field = this._getSignatureFieldInfo(ctx, bosType);
        if (field != null) {
            Map fields = field.getFields();
            StringBuilder builder = new StringBuilder();
            for (Object key : fields.keySet()) {
                builder.append(fields.get(key)).append("\uff08").append(key.toString()).append("\uff09").append("\u3001");
            }
            defaultDesc = builder.substring(0, builder.length() - 1);
        }
        return defaultDesc;
    }

    private static String getProductNo() throws BOSException {
        if (PRODUCTNO == null) {
            try {
                PRODUCTNO = LicenseSrvFactory.getInstance().getProductNo();
            }
            catch (LicenseException e) {
                e.printStackTrace();
                throw new BOSException("EASSignatureControllerBean...get productNo error");
            }
        }
        return PRODUCTNO;
    }

    @Override
    protected void _genSmartPaySign(Context ctx, List billIds, BOSObjectType bosObjectType, String operatorId) throws BOSException {
        if (!SignatureConfiguration.getCacheInstance().isCanSignature()) {
            logger.error((Object)"genSmartPaySign: signatureconfiguration is disable.");
            return;
        }
        if (!SignatureConfiguration.getCacheInstance().isCansignature(bosObjectType)) {
            logger.error((Object)("genSmartPaySign: bostype '" + bosObjectType + "' in signatureconfiguration is disable."));
            return;
        }
        if (billIds == null || billIds.size() == 0) {
            logger.error((Object)"genSmartPaySign: parameter 'billIds' is empty or null");
            return;
        }
        IServerCASolution solution = SmartPayCASolutionFactory.getCASolution();
        if (solution == null) {
            logger.error((Object)"get smartpay CASolution and return null, smartpaysign is not enabled.");
            return;
        }
        try {
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(operatorId));
            if (userInfo == null) {
                throw new BOSException("genSmartPaySign: invalid operator, id: " + operatorId);
            }
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < billIds.size(); ++i) {
                String billId = (String)billIds.get(i);
                if (billId == null || billId.length() == 0) {
                    logger.error((Object)"billid is empty or null");
                    throw new BOSException("\u5305\u542b\u5355\u636eid\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0c\u7d22\u5f15\uff1a" + i);
                }
                BOSUuid uuid = BOSUuid.read((String)billId);
                byte[] plainTextByte = FrameHelperFacadeFactory.getLocalInstance((Context)ctx).getPlainText(bosObjectType, (IObjectPK)new ObjectUuidPK(uuid));
                byte[] formatPlainTextByte = FrameHelperFacadeFactory.getLocalInstance((Context)ctx).getFormatPlainText(bosObjectType, (IObjectPK)new ObjectUuidPK(uuid));
                String plainText = new String(plainTextByte, "UTF-8");
                String formatPlainText = new String(formatPlainTextByte, "UTF-8");
                logger.error((Object)plainText);
                EASSignatureInfo signatureInfo = new EASSignatureInfo();
                signatureInfo.setBosType(bosObjectType.toString());
                signatureInfo.setSignature(solution.sign(plainText));
                signatureInfo.setUser(userInfo);
                signatureInfo.setPlainText(plainText);
                signatureInfo.setFormatPlainText(formatPlainText);
                signatureInfo.setObjectid(billId);
                signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
                signatureInfo.setSmartPaySign(true);
                coll.add((CoreBaseInfo)signatureInfo);
            }
            IEASSignature easSignture = EASSignatureFactory.getLocalInstance(ctx);
            easSignture.addnew(coll);
        }
        catch (EASBizException e) {
            logger.error((Object)"genSmartPaySign: biz error,", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

