/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.app;

import com.itrus.pki.rsa.server.iTrusServerSignVerify;
import com.itrus.util.Base64;
import com.kingdee.eas.base.security.app.IEASBOTPSignVerifier;
import org.apache.log4j.Logger;

public final class ItrusBOTPSignVerifier
implements IEASBOTPSignVerifier {
    private static Logger logger = Logger.getLogger(ItrusBOTPSignVerifier.class);
    private static iTrusServerSignVerify iTrusServerSign;

    protected ItrusBOTPSignVerifier() {
        logger.error((Object)"ItrusBOTPSignVerifier instance init...");
    }

    @Override
    public String getVerifierName() {
        return "itrus";
    }

    @Override
    public String sign(String plainText) {
        try {
            ItrusBOTPSignVerifier.ensureInit();
            byte[] sign = iTrusServerSign.sign(Base64.decode((String)plainText));
            return Base64.encode((byte[])sign);
        }
        catch (Exception e) {
            logger.error((Object)("sign error, " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean verify(String plainText, String signature) {
        try {
            ItrusBOTPSignVerifier.ensureInit();
            int res = iTrusServerSign.verify(Base64.decode((String)plainText), Base64.decode((String)signature));
            if (res != 201) {
                logger.error((Object)("itrus botp verify mismatch, result code: " + res));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("verify error, " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private static void ensureInit() {
        if (iTrusServerSign == null) {
            iTrusServerSign = new iTrusServerSignVerify();
        }
    }
}

