/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.app;

import com.itrus.pki.rsa.server.iTrusServerSignVerify;
import com.itrus.util.Base64;
import com.kingdee.eas.base.security.app.IServerCASolution;
import com.kingdee.eas.base.security.app.ItrusBOTPSignVerifier;
import org.apache.log4j.Logger;

public class ItrusCASolution
implements IServerCASolution {
    private static Logger logger = Logger.getLogger(ItrusBOTPSignVerifier.class);
    private static iTrusServerSignVerify iTrusServerSign;

    protected ItrusCASolution() {
        logger.error((Object)"itrusca solution init...");
    }

    @Override
    public String sign(String plainText) {
        try {
            ItrusCASolution.ensureInit();
            byte[] sign = iTrusServerSign.sign(plainText.getBytes("UTF-8"));
            return Base64.encode((byte[])sign);
        }
        catch (Exception e) {
            logger.error((Object)("itrus ca sign error, " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean verify(String plainText, String signature) {
        try {
            ItrusCASolution.ensureInit();
            int res = iTrusServerSign.verify(plainText.getBytes("UTF-8"), Base64.decode((String)signature));
            if (res != 201) {
                logger.error((Object)("itrusca solution mismatch, result code: " + res));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("solution verify error, " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private static void ensureInit() {
        if (iTrusServerSign == null) {
            iTrusServerSign = new iTrusServerSignVerify();
        }
    }
}

