/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.dynamiccard.strategy;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.base.security.dynamiccard.ActiveCardConfigInfo;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardConfigInfo;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardServerConfigUtil;
import com.kingdee.eas.base.security.dynamiccard.strategy.DynamicCardStratrgy;
import com.kingdee.eas.base.security.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ActiveCardStratrgy
implements DynamicCardStratrgy {
    private static final String HOST_NAME = "host";
    private static final String SHAREDSECRET_NAME = "sharedSecret";
    private static final String AUTHPORT_NAME = "authPort";
    private static final String ACCTPORT_NAME = "acctPort";
    private static final String TIMEOUT_NAME = "timeOut";
    private static final String RETRIES_NAME = "retries";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_AUTH_PORT = "1812";
    private static final String DEFAULT_ACCT_PORT = "1813";
    private static final String DEFAULT_TIMEOUT = "6000";
    private static final String DEFAULT_SHARED_SECRET = "ActivPack";
    private static final String DEFAULT_RETRIES = "3";
    private Properties props = null;

    @Override
    public DynamicCardConfigInfo getDynamicCardConfigInfo() throws IOException {
        this.getProperties();
        ActiveCardConfigInfo info = new ActiveCardConfigInfo();
        info.setServerIP(this.props.getProperty(HOST_NAME));
        info.setServerPort(this.props.getProperty(AUTHPORT_NAME));
        info.setAcctPort(this.props.getProperty(ACCTPORT_NAME));
        info.setSharedSecret(this.props.getProperty(SHAREDSECRET_NAME));
        info.setTimeOut(this.props.getProperty(TIMEOUT_NAME));
        info.setRetries(this.props.getProperty(RETRIES_NAME));
        return info;
    }

    private void getProperties() throws IOException {
        File configFile = DynamicCardServerConfigUtil.getConifgFile();
        this.props = PropertiesUtil.getProperties(configFile);
        if (this.props.isEmpty() || StringUtils.isEmpty((String)this.props.getProperty(AUTHPORT_NAME))) {
            this.props = this.createDefaultConfig();
        }
    }

    private Properties createDefaultConfig() {
        Properties props = new Properties();
        props.put(HOST_NAME, DEFAULT_HOST);
        props.put(SHAREDSECRET_NAME, DEFAULT_SHARED_SECRET);
        props.put(AUTHPORT_NAME, DEFAULT_AUTH_PORT);
        props.put(ACCTPORT_NAME, DEFAULT_ACCT_PORT);
        props.put(TIMEOUT_NAME, DEFAULT_TIMEOUT);
        props.put(RETRIES_NAME, DEFAULT_RETRIES);
        return props;
    }

    @Override
    public void storeDynamicCardConfigInfo(DynamicCardConfigInfo info) throws IOException {
        ActiveCardConfigInfo configInfo = (ActiveCardConfigInfo)info;
        if (configInfo != null) {
            if (configInfo.getServerIP() != null) {
                this.props.setProperty(HOST_NAME, configInfo.getServerIP());
            }
            if (configInfo.getServerPort() != null) {
                this.props.setProperty(AUTHPORT_NAME, configInfo.getServerPort());
            }
            if (configInfo.getAcctPort() != null) {
                this.props.setProperty(ACCTPORT_NAME, configInfo.getAcctPort());
            }
            if (configInfo.getSharedSecret() != null) {
                this.props.setProperty(SHAREDSECRET_NAME, configInfo.getSharedSecret());
            }
            if (configInfo.getTimeOut() != null) {
                this.props.setProperty(TIMEOUT_NAME, configInfo.getTimeOut());
            }
            if (configInfo.getRetries() != null) {
                this.props.setProperty(RETRIES_NAME, configInfo.getRetries());
            }
            File configFile = DynamicCardServerConfigUtil.getConifgFile();
            PropertiesUtil.storeProperties(this.props, configFile);
        }
    }
}

