/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.dynamiccard.strategy;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardConfigInfo;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardServerConfigUtil;
import com.kingdee.eas.base.security.dynamiccard.strategy.DynamicCardStratrgy;
import com.kingdee.eas.base.security.util.PropertiesUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;

public class HaiYueCardStratrgy
implements DynamicCardStratrgy {
    private static final String SEPARATOR = ",";

    @Override
    public DynamicCardConfigInfo getDynamicCardConfigInfo() throws IOException {
        String[] params;
        DynamicCardConfigInfo info = new DynamicCardConfigInfo();
        info.setServerIP("");
        info.setServerPort("");
        File configFile = DynamicCardServerConfigUtil.getConifgFile();
        String configParam = this.readConfigFromFile(configFile);
        if (!StringUtils.isEmpty((String)configParam) && (params = configParam.split(SEPARATOR)).length > 1) {
            info.setServerIP(params[0]);
            info.setServerPort(params[1]);
        }
        return info;
    }

    @Override
    public void storeDynamicCardConfigInfo(DynamicCardConfigInfo info) throws IOException {
        if (info != null && info.getServerIP() != null && info.getServerPort() != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(info.getServerIP());
            buffer.append(SEPARATOR);
            buffer.append(info.getServerPort());
            buffer.append(SEPARATOR);
            buffer.append("UDP");
            this.writeConfigToFile(buffer.toString());
        }
    }

    private String readConfigFromFile(File file) throws IOException {
        String configParam = null;
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            configParam = reader.readLine();
        }
        return configParam;
    }

    private void writeConfigToFile(String configParam) throws IOException {
        if (configParam != null) {
            File configFile = this.getConfigFile();
            try (BufferedWriter writer = null;){
                writer = new BufferedWriter(new FileWriter(configFile));
                writer.write(configParam);
                writer.flush();
            }
        }
    }

    private File getConfigFile() throws IOException {
        File configFile = DynamicCardServerConfigUtil.getConifgFile();
        Properties props = PropertiesUtil.getProperties(configFile);
        Set<Object> keySet = props.keySet();
        Object[] keyArray = keySet.toArray();
        if (!(keySet.isEmpty() || keyArray.length <= 1 && ((String)keyArray[0]).split(SEPARATOR).length > 1)) {
            configFile.delete();
            configFile = this.createDefaultConfig();
        }
        return configFile;
    }

    private File createDefaultConfig() throws IOException {
        return DynamicCardServerConfigUtil.getConifgFile();
    }
}

