/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.fingerprint;

import com.kingdee.eas.base.security.fingerprint.FingerprintConfigInfo;
import com.kingdee.eas.base.security.fingerprint.FingerprintConfigUtil;
import com.kingdee.eas.base.security.util.PropertiesUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FingerprintClientConfigUtil {
    private static Logger logger = Logger.getLogger(FingerprintConfigUtil.class);
    private static final String FILE_NAME = "TrustLinkSetting_zh_CN.properties";
    public static final String TYPE = "DEFDEV";
    public static final String SERVER_IP = "HOSTNAME";
    public static final String SERVER_PORT = "PORT";
    public static final String PRODUCT_ID = "PRODUCTID";
    public static final String ADMIN_NAME = "ADMIN";
    public static final String ADMIN_PASS = "ADMINPWD";

    public static final void storeFingerprintConfigInfo(FingerprintConfigInfo configInfo) throws IOException {
        if (configInfo != null) {
            Properties props = FingerprintClientConfigUtil.getFingerprintConfig();
            if (!StringUtils.isEmpty((String)configInfo.getAuthType())) {
                props.put(TYPE, "0" + configInfo.getAuthType());
            }
            if (!StringUtils.isEmpty((String)configInfo.getServerIP())) {
                props.put(SERVER_IP, configInfo.getServerIP());
            }
            if (!StringUtils.isEmpty((String)configInfo.getServerPort())) {
                props.put(SERVER_PORT, configInfo.getServerPort());
            }
            if (!StringUtils.isEmpty((String)configInfo.getProductId())) {
                props.put(PRODUCT_ID, configInfo.getProductId());
            }
            if (!StringUtils.isEmpty((String)configInfo.getAdminName())) {
                props.put(ADMIN_NAME, configInfo.getAdminName());
            }
            if (!StringUtils.isEmpty((String)configInfo.getAdminPassword())) {
                props.put(ADMIN_PASS, configInfo.getAdminPassword());
            }
            PropertiesUtil.storeProperties(props, FingerprintClientConfigUtil.getConfigFile());
        }
    }

    public static final Properties getFingerprintConfig() throws IOException {
        return PropertiesUtil.getProperties(FingerprintClientConfigUtil.getConfigFile());
    }

    private static File getConfigFile() throws IOException {
        File file = new File(FingerprintClientConfigUtil.getfilePath());
        if (file != null && !file.exists()) {
            file.createNewFile();
            PropertiesUtil.storeProperties(FingerprintClientConfigUtil.createDefaultConfig(), file);
        }
        return file;
    }

    private static String getfilePath() {
        String easHome = System.getProperty("EAS_HOME");
        StringBuffer filePath = new StringBuffer(easHome);
        filePath.append(File.separator);
        filePath.append("server");
        filePath.append(File.separator);
        filePath.append("deploy");
        filePath.append(File.separator);
        filePath.append("fileserver.ear");
        filePath.append(File.separator);
        filePath.append("easWebClient");
        filePath.append(File.separator);
        filePath.append("deploy");
        filePath.append(File.separator);
        filePath.append("client");
        filePath.append(File.separator);
        filePath.append(FILE_NAME);
        return filePath.toString();
    }

    private static Properties createDefaultConfig() {
        Properties props = new Properties();
        props.put(SERVER_IP, "");
        props.put(SERVER_PORT, "");
        props.put(PRODUCT_ID, "demo");
        props.put(ADMIN_NAME, "sa");
        props.put(ADMIN_PASS, "sa");
        props.put(TYPE, "05");
        props.put("DEVNO", "8");
        props.put("DLLNO", "8");
        props.put("DEV1", "TL-FMS100(ATW100)");
        props.put("DEV2", "TL-FKS200(AES3500)");
        props.put("DEV3", "TL-FRO500(URU4K)");
        props.put("DEV4", "TL-FDS300(LTTS500)");
        props.put("DEV5", "TL-FRO450(WUSB106)");
        props.put("DEV6", "TL-FKS680(LTTSS500_USBest169)");
        props.put("DEV7", "TL-FDS350(LTTSS500_OTi2168)");
        props.put("DEV8", "TL-FRS110(AES1610)");
        props.put("XSDev1", "XSDev01.dll");
        props.put("XSDev2", "XSDev02.dll");
        props.put("XSDev3", "XSDev03.dll");
        props.put("XSDev4", "XSDev04.dll");
        props.put("XSDev5", "XSDev05.dll");
        props.put("XSDev6", "XSDev06.dll");
        props.put("XSDev7", "XSDev07.dll");
        props.put("XSDev8", "XSDev08.dll");
        return props;
    }
}

